SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";
SET foreign_key_checks = 0;

DROP TABLE IF EXISTS `wp_commentmeta`;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_comments`;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_comments` VALUES (1, 1, 'A WordPress Commenter', 'wapuu@wordpress.example', 'https://wordpress.org/', '', '2018-05-16 06:35:15', '2018-05-16 06:35:15', 'Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href="https://gravatar.com">Gravatar</a>.', 0, '1', '', '', 0, 0);


DROP TABLE IF EXISTS `wp_duplicator_packages`;
CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

 
INSERT INTO `wp_duplicator_packages` VALUES (1, '20180621_agura', '231a72b77825cafc3259180621141543', 40, '2018-06-21 14:15:57', 'tyco', 'O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:15:43";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";i:1;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"231a72b77825cafc3259180621141543";s:8:"NameHash";s:47:"20180621_agura_231a72b77825cafc3259180621141543";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:53:"/home/agurainc/public_html/wordpress/wp-snapshots/tmp";s:8:"StoreURL";s:47:"http://www.agurainc.com/wordpress/wp-snapshots/";s:8:"ScanFile";s:57:"20180621_agura_231a72b77825cafc3259180621141543_scan.json";s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";s:4:"tyco";s:7:"Archive";O:11:"DUP_Archive":19:{s:10:"FilterDirs";s:0:"";s:11:"FilterFiles";s:0:"";s:10:"FilterExts";s:0:"";s:13:"FilterDirsAll";a:0:{}s:14:"FilterFilesAll";a:0:{}s:13:"FilterExtsAll";a:0:{}s:8:"FilterOn";i:0;s:12:"ExportOnlyDB";i:0;s:4:"File";s:59:"20180621_agura_231a72b77825cafc3259180621141543_archive.zip";s:6:"Format";s:3:"ZIP";s:7:"PackDir";s:26:"/home/agurainc/public_html";s:4:"Size";i:0;s:4:"Dirs";a:0:{}s:5:"Files";a:0:{}s:10:"FilterInfo";O:23:"DUP_Archive_Filter_Info":8:{s:4:"Dirs";O:34:"DUP_Archive_Filter_Scope_Directory":4:{s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:5:"Files";O:29:"DUP_Archive_Filter_Scope_File":5:{s:4:"Size";a:0:{}s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:4:"Exts";O:29:"DUP_Archive_Filter_Scope_Base":2:{s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:9:"UDirCount";i:0;s:10:"UFileCount";i:0;s:9:"UExtCount";i:0;s:8:"TreeSize";a:0:{}s:11:"TreeWarning";a:0:{}}s:14:"RecursiveLinks";a:0:{}s:10:"\0*\0Package";r:1;s:29:"\0DUP_Archive\0tmpFilterDirsAll";a:0:{}s:24:"\0DUP_Archive\0wpCorePaths";a:6:{i:0;s:35:"/home/agurainc/public_html/wp-admin";i:1;s:45:"/home/agurainc/public_html/wp-content/uploads";i:2;s:47:"/home/agurainc/public_html/wp-content/languages";i:3;s:45:"/home/agurainc/public_html/wp-content/plugins";i:4;s:44:"/home/agurainc/public_html/wp-content/themes";i:5;s:38:"/home/agurainc/public_html/wp-includes";}}s:9:"Installer";O:13:"DUP_Installer":7:{s:4:"File";s:61:"20180621_agura_231a72b77825cafc3259180621141543_installer.php";s:4:"Size";i:0;s:10:"OptsDBHost";s:0:"";s:10:"OptsDBPort";s:0:"";s:10:"OptsDBName";s:0:"";s:10:"OptsDBUser";s:0:"";s:10:"\0*\0Package";O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:15:43";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";N;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"231a72b77825cafc3259180621141543";s:8:"NameHash";s:47:"20180621_agura_231a72b77825cafc3259180621141543";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:43:"/home/agurainc/public_html/wp-snapshots/tmp";s:8:"StoreURL";s:44:"http://agurainc.jet.tyco.co.il/wp-snapshots/";s:8:"ScanFile";N;s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";N;s:7:"Archive";r:22;s:9:"Installer";r:67;s:8:"Database";O:12:"DUP_Database":13:{s:4:"Type";s:5:"MySQL";s:4:"Size";i:42503834;s:4:"File";s:60:"20180621_agura_231a72b77825cafc3259180621141543_database.sql";s:4:"Path";N;s:12:"FilterTables";s:0:"";s:8:"FilterOn";i:0;s:4:"Name";N;s:10:"Compatible";s:0:"";s:8:"Comments";s:28:"MySQL Community Server (GPL)";s:10:"\0*\0Package";r:1;s:25:"\0DUP_Database\0dbStorePath";s:104:"/home/agurainc/public_html/wp-snapshots/tmp/20180621_agura_231a72b77825cafc3259180621141543_database.sql";s:23:"\0DUP_Database\0EOFMarker";s:0:"";s:26:"\0DUP_Database\0networkFlush";b:0;}}}s:8:"Database";r:97;}'),
 (2, '20180621_agura', '23ad69d1f20e51a39509180621141812', 40, '2018-06-21 14:18:35', 'tyco', 'O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:18:12";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";i:2;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"23ad69d1f20e51a39509180621141812";s:8:"NameHash";s:47:"20180621_agura_23ad69d1f20e51a39509180621141812";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:53:"/home/agurainc/public_html/wordpress/wp-snapshots/tmp";s:8:"StoreURL";s:47:"http://www.agurainc.com/wordpress/wp-snapshots/";s:8:"ScanFile";s:57:"20180621_agura_23ad69d1f20e51a39509180621141812_scan.json";s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";s:4:"tyco";s:7:"Archive";O:11:"DUP_Archive":19:{s:10:"FilterDirs";s:0:"";s:11:"FilterFiles";s:0:"";s:10:"FilterExts";s:0:"";s:13:"FilterDirsAll";a:0:{}s:14:"FilterFilesAll";a:0:{}s:13:"FilterExtsAll";a:0:{}s:8:"FilterOn";i:0;s:12:"ExportOnlyDB";i:0;s:4:"File";s:59:"20180621_agura_23ad69d1f20e51a39509180621141812_archive.zip";s:6:"Format";s:3:"ZIP";s:7:"PackDir";s:26:"/home/agurainc/public_html";s:4:"Size";i:0;s:4:"Dirs";a:0:{}s:5:"Files";a:0:{}s:10:"FilterInfo";O:23:"DUP_Archive_Filter_Info":8:{s:4:"Dirs";O:34:"DUP_Archive_Filter_Scope_Directory":4:{s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:5:"Files";O:29:"DUP_Archive_Filter_Scope_File":5:{s:4:"Size";a:0:{}s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:4:"Exts";O:29:"DUP_Archive_Filter_Scope_Base":2:{s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:9:"UDirCount";i:0;s:10:"UFileCount";i:0;s:9:"UExtCount";i:0;s:8:"TreeSize";a:0:{}s:11:"TreeWarning";a:0:{}}s:14:"RecursiveLinks";a:0:{}s:10:"\0*\0Package";r:1;s:29:"\0DUP_Archive\0tmpFilterDirsAll";a:0:{}s:24:"\0DUP_Archive\0wpCorePaths";a:6:{i:0;s:35:"/home/agurainc/public_html/wp-admin";i:1;s:45:"/home/agurainc/public_html/wp-content/uploads";i:2;s:47:"/home/agurainc/public_html/wp-content/languages";i:3;s:45:"/home/agurainc/public_html/wp-content/plugins";i:4;s:44:"/home/agurainc/public_html/wp-content/themes";i:5;s:38:"/home/agurainc/public_html/wp-includes";}}s:9:"Installer";O:13:"DUP_Installer":7:{s:4:"File";s:61:"20180621_agura_23ad69d1f20e51a39509180621141812_installer.php";s:4:"Size";i:0;s:10:"OptsDBHost";s:0:"";s:10:"OptsDBPort";s:0:"";s:10:"OptsDBName";s:0:"";s:10:"OptsDBUser";s:0:"";s:10:"\0*\0Package";O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:18:12";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";N;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"23ad69d1f20e51a39509180621141812";s:8:"NameHash";s:47:"20180621_agura_23ad69d1f20e51a39509180621141812";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:43:"/home/agurainc/public_html/wp-snapshots/tmp";s:8:"StoreURL";s:44:"http://agurainc.jet.tyco.co.il/wp-snapshots/";s:8:"ScanFile";N;s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";N;s:7:"Archive";r:22;s:9:"Installer";r:67;s:8:"Database";O:12:"DUP_Database":13:{s:4:"Type";s:5:"MySQL";s:4:"Size";i:41394176;s:4:"File";s:60:"20180621_agura_23ad69d1f20e51a39509180621141812_database.sql";s:4:"Path";N;s:12:"FilterTables";s:0:"";s:8:"FilterOn";i:0;s:4:"Name";N;s:10:"Compatible";s:0:"";s:8:"Comments";s:28:"MySQL Community Server (GPL)";s:10:"\0*\0Package";r:1;s:25:"\0DUP_Database\0dbStorePath";s:104:"/home/agurainc/public_html/wp-snapshots/tmp/20180621_agura_23ad69d1f20e51a39509180621141812_database.sql";s:23:"\0DUP_Database\0EOFMarker";s:0:"";s:26:"\0DUP_Database\0networkFlush";b:0;}}}s:8:"Database";r:97;}'),
 (3, '20180621_agura', 'b235e645ff2d28802189180621142016', 20, '2018-06-21 14:20:27', 'tyco', 'O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:20:16";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";i:3;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"b235e645ff2d28802189180621142016";s:8:"NameHash";s:47:"20180621_agura_b235e645ff2d28802189180621142016";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:53:"/home/agurainc/public_html/wordpress/wp-snapshots/tmp";s:8:"StoreURL";s:47:"http://www.agurainc.com/wordpress/wp-snapshots/";s:8:"ScanFile";s:57:"20180621_agura_b235e645ff2d28802189180621142016_scan.json";s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";s:4:"tyco";s:7:"Archive";O:11:"DUP_Archive":19:{s:10:"FilterDirs";s:0:"";s:11:"FilterFiles";s:0:"";s:10:"FilterExts";s:0:"";s:13:"FilterDirsAll";a:0:{}s:14:"FilterFilesAll";a:0:{}s:13:"FilterExtsAll";a:0:{}s:8:"FilterOn";i:0;s:12:"ExportOnlyDB";i:0;s:4:"File";s:59:"20180621_agura_b235e645ff2d28802189180621142016_archive.zip";s:6:"Format";s:3:"ZIP";s:7:"PackDir";s:26:"/home/agurainc/public_html";s:4:"Size";i:0;s:4:"Dirs";a:0:{}s:5:"Files";a:0:{}s:10:"FilterInfo";O:23:"DUP_Archive_Filter_Info":8:{s:4:"Dirs";O:34:"DUP_Archive_Filter_Scope_Directory":4:{s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:5:"Files";O:29:"DUP_Archive_Filter_Scope_File":5:{s:4:"Size";a:0:{}s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:4:"Exts";O:29:"DUP_Archive_Filter_Scope_Base":2:{s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:9:"UDirCount";i:0;s:10:"UFileCount";i:0;s:9:"UExtCount";i:0;s:8:"TreeSize";a:0:{}s:11:"TreeWarning";a:0:{}}s:14:"RecursiveLinks";a:0:{}s:10:"\0*\0Package";O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:20:16";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";N;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"b235e645ff2d28802189180621142016";s:8:"NameHash";s:47:"20180621_agura_b235e645ff2d28802189180621142016";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:43:"/home/agurainc/public_html/wp-snapshots/tmp";s:8:"StoreURL";s:44:"http://agurainc.jet.tyco.co.il/wp-snapshots/";s:8:"ScanFile";N;s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";N;s:7:"Archive";r:22;s:9:"Installer";O:13:"DUP_Installer":7:{s:4:"File";s:61:"20180621_agura_b235e645ff2d28802189180621142016_installer.php";s:4:"Size";i:0;s:10:"OptsDBHost";s:0:"";s:10:"OptsDBPort";s:0:"";s:10:"OptsDBName";s:0:"";s:10:"OptsDBUser";s:0:"";s:10:"\0*\0Package";r:58;}s:8:"Database";O:12:"DUP_Database":13:{s:4:"Type";s:5:"MySQL";s:4:"Size";N;s:4:"File";s:60:"20180621_agura_b235e645ff2d28802189180621142016_database.sql";s:4:"Path";N;s:12:"FilterTables";s:0:"";s:8:"FilterOn";i:0;s:4:"Name";N;s:10:"Compatible";s:0:"";s:8:"Comments";s:28:"MySQL Community Server (GPL)";s:10:"\0*\0Package";r:1;s:25:"\0DUP_Database\0dbStorePath";N;s:23:"\0DUP_Database\0EOFMarker";s:0:"";s:26:"\0DUP_Database\0networkFlush";b:0;}}s:29:"\0DUP_Archive\0tmpFilterDirsAll";a:0:{}s:24:"\0DUP_Archive\0wpCorePaths";a:6:{i:0;s:35:"/home/agurainc/public_html/wp-admin";i:1;s:45:"/home/agurainc/public_html/wp-content/uploads";i:2;s:47:"/home/agurainc/public_html/wp-content/languages";i:3;s:45:"/home/agurainc/public_html/wp-content/plugins";i:4;s:44:"/home/agurainc/public_html/wp-content/themes";i:5;s:38:"/home/agurainc/public_html/wp-includes";}}s:9:"Installer";r:80;s:8:"Database";r:88;}');


DROP TABLE IF EXISTS `wp_links`;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_options`;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2463 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_options` VALUES (1, 'siteurl', 'http://www.agurainc.com/wordpress', 'yes'),
 (2, 'home', 'http://www.agurainc.com/wordpress', 'yes'),
 (3, 'blogname', 'AGURA', 'yes'),
 (4, 'blogdescription', 'BLOCKCHAIN ECONOMY', 'yes'),
 (5, 'users_can_register', '0', 'yes'),
 (6, 'admin_email', 'admin@tyco.co.il', 'yes'),
 (7, 'start_of_week', '1', 'yes'),
 (8, 'use_balanceTags', '0', 'yes'),
 (9, 'use_smilies', '1', 'yes'),
 (10, 'require_name_email', '1', 'yes'),
 (11, 'comments_notify', '1', 'yes'),
 (12, 'posts_per_rss', '10', 'yes'),
 (13, 'rss_use_excerpt', '0', 'yes'),
 (14, 'mailserver_url', 'mail.example.com', 'yes'),
 (15, 'mailserver_login', 'login@example.com', 'yes'),
 (16, 'mailserver_pass', 'password', 'yes'),
 (17, 'mailserver_port', '110', 'yes'),
 (18, 'default_category', '1', 'yes'),
 (19, 'default_comment_status', 'open', 'yes'),
 (20, 'default_ping_status', 'open', 'yes'),
 (21, 'default_pingback_flag', '1', 'yes'),
 (22, 'posts_per_page', '10', 'yes'),
 (23, 'date_format', 'F j, Y', 'yes'),
 (24, 'time_format', 'g:i a', 'yes'),
 (25, 'links_updated_date_format', 'F j, Y g:i a', 'yes'),
 (26, 'comment_moderation', '0', 'yes'),
 (27, 'moderation_notify', '1', 'yes'),
 (28, 'permalink_structure', '/%year%/%monthnum%/%day%/%postname%/', 'yes'),
 (29, 'rewrite_rules', 'a:154:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:8:"ufaqs/?$";s:24:"index.php?post_type=ufaq";s:38:"ufaqs/feed/(feed|rdf|rss|rss2|atom)/?$";s:41:"index.php?post_type=ufaq&feed=$matches[1]";s:33:"ufaqs/(feed|rdf|rss|rss2|atom)/?$";s:41:"index.php?post_type=ufaq&feed=$matches[1]";s:25:"ufaqs/page/([0-9]{1,})/?$";s:42:"index.php?post_type=ufaq&paged=$matches[1]";s:8:"faqwd/?$";s:26:"index.php?post_type=faq_wd";s:38:"faqwd/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?post_type=faq_wd&feed=$matches[1]";s:33:"faqwd/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?post_type=faq_wd&feed=$matches[1]";s:25:"faqwd/page/([0-9]{1,})/?$";s:44:"index.php?post_type=faq_wd&paged=$matches[1]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:54:"ufaq-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?ufaq-category=$matches[1]&feed=$matches[2]";s:49:"ufaq-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?ufaq-category=$matches[1]&feed=$matches[2]";s:42:"ufaq-category/([^/]+)/page/?([0-9]{1,})/?$";s:53:"index.php?ufaq-category=$matches[1]&paged=$matches[2]";s:24:"ufaq-category/([^/]+)/?$";s:35:"index.php?ufaq-category=$matches[1]";s:49:"ufaq-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?ufaq-tag=$matches[1]&feed=$matches[2]";s:44:"ufaq-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?ufaq-tag=$matches[1]&feed=$matches[2]";s:37:"ufaq-tag/([^/]+)/page/?([0-9]{1,})/?$";s:48:"index.php?ufaq-tag=$matches[1]&paged=$matches[2]";s:19:"ufaq-tag/([^/]+)/?$";s:30:"index.php?ufaq-tag=$matches[1]";s:53:"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:51:"index.php?faq_category=$matches[1]&feed=$matches[2]";s:48:"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:51:"index.php?faq_category=$matches[1]&feed=$matches[2]";s:41:"faq_category/([^/]+)/page/?([0-9]{1,})/?$";s:52:"index.php?faq_category=$matches[1]&paged=$matches[2]";s:23:"faq_category/([^/]+)/?$";s:34:"index.php?faq_category=$matches[1]";s:43:"elementor-popup/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:53:"elementor-popup/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:73:"elementor-popup/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:68:"elementor-popup/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:68:"elementor-popup/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:36:"elementor-popup/([^/]+)/trackback/?$";s:57:"index.php?post_type=elementor-popup&name=$matches[1]&tb=1";s:44:"elementor-popup/([^/]+)/page/?([0-9]{1,})/?$";s:70:"index.php?post_type=elementor-popup&name=$matches[1]&paged=$matches[2]";s:51:"elementor-popup/([^/]+)/comment-page-([0-9]{1,})/?$";s:70:"index.php?post_type=elementor-popup&name=$matches[1]&cpage=$matches[2]";s:40:"elementor-popup/([^/]+)(?:/([0-9]+))?/?$";s:69:"index.php?post_type=elementor-popup&name=$matches[1]&page=$matches[2]";s:32:"elementor-popup/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:42:"elementor-popup/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:62:"elementor-popup/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:57:"elementor-popup/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:57:"elementor-popup/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:30:"qa/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:40:"qa/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:60:"qa/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:55:"qa/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:55:"qa/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:23:"qa/([^/]+)/trackback/?$";s:29:"index.php?qa=$matches[1]&tb=1";s:31:"qa/([^/]+)/page/?([0-9]{1,})/?$";s:42:"index.php?qa=$matches[1]&paged=$matches[2]";s:38:"qa/([^/]+)/comment-page-([0-9]{1,})/?$";s:42:"index.php?qa=$matches[1]&cpage=$matches[2]";s:27:"qa/([^/]+)(?:/([0-9]+))?/?$";s:41:"index.php?qa=$matches[1]&page=$matches[2]";s:19:"qa/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:29:"qa/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:49:"qa/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:44:"qa/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:44:"qa/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:46:"qatag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:44:"index.php?qatag=$matches[1]&feed=$matches[2]";s:41:"qatag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:44:"index.php?qatag=$matches[1]&feed=$matches[2]";s:34:"qatag/([^/]+)/page/?([0-9]{1,})/?$";s:45:"index.php?qatag=$matches[1]&paged=$matches[2]";s:16:"qatag/([^/]+)/?$";s:27:"index.php?qatag=$matches[1]";s:33:"ufaqs/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:43:"ufaqs/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:63:"ufaqs/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"ufaqs/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:58:"ufaqs/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:26:"ufaqs/([^/]+)/trackback/?$";s:31:"index.php?ufaq=$matches[1]&tb=1";s:46:"ufaqs/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?ufaq=$matches[1]&feed=$matches[2]";s:41:"ufaqs/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?ufaq=$matches[1]&feed=$matches[2]";s:34:"ufaqs/([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?ufaq=$matches[1]&paged=$matches[2]";s:41:"ufaqs/([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?ufaq=$matches[1]&cpage=$matches[2]";s:30:"ufaqs/([^/]+)(?:/([0-9]+))?/?$";s:43:"index.php?ufaq=$matches[1]&page=$matches[2]";s:22:"ufaqs/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:32:"ufaqs/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:52:"ufaqs/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:47:"ufaqs/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:47:"ufaqs/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:31:"faqwd/.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:41:"faqwd/.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:61:"faqwd/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:"faqwd/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:"faqwd/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:24:"faqwd/(.+?)/trackback/?$";s:33:"index.php?faq_wd=$matches[1]&tb=1";s:44:"faqwd/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?faq_wd=$matches[1]&feed=$matches[2]";s:39:"faqwd/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:45:"index.php?faq_wd=$matches[1]&feed=$matches[2]";s:32:"faqwd/(.+?)/page/?([0-9]{1,})/?$";s:46:"index.php?faq_wd=$matches[1]&paged=$matches[2]";s:39:"faqwd/(.+?)/comment-page-([0-9]{1,})/?$";s:46:"index.php?faq_wd=$matches[1]&cpage=$matches[2]";s:28:"faqwd/(.+?)(?:/([0-9]+))?/?$";s:45:"index.php?faq_wd=$matches[1]&page=$matches[2]";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:39:"index.php?&page_id=22&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:58:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:68:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:88:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:83:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$";s:85:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1";s:77:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]";s:65:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]";s:72:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$";s:98:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]";s:61:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$";s:97:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]";s:47:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:57:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:77:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:72:"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]";s:51:"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]";s:38:"([0-9]{4})/comment-page-([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&cpage=$matches[2]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";}', 'yes'),
 (30, 'hack_file', '0', 'yes'),
 (31, 'blog_charset', 'UTF-8', 'yes'),
 (32, 'moderation_keys', '', 'no'),
 (34, 'category_base', '', 'yes'),
 (35, 'ping_sites', 'http://rpc.pingomatic.com/', 'yes'),
 (36, 'comment_max_links', '2', 'yes'),
 (37, 'gmt_offset', '0', 'yes'),
 (38, 'default_email_category', '1', 'yes'),
 (39, 'recently_edited', 'a:5:{i:0;s:83:"/home/agurainc/public_html/wordpress/wordpress/wp-content/themes/oceanwp/header.php";i:1;s:83:"/home/agurainc/public_html/wordpress/wordpress/wp-content/themes/oceanwp/readme.txt";i:2;s:82:"/home/agurainc/public_html/wordpress/wordpress/wp-content/themes/oceanwp/index.php";i:3;s:86:"/home/agurainc/public_html/wordpress/wordpress/wp-content/themes/oceanwp/functions.php";i:4;s:82:"/home/agurainc/public_html/wordpress/wordpress/wp-content/themes/oceanwp/style.css";}', 'no'),
 (42, 'comment_whitelist', '1', 'yes'),
 (43, 'blacklist_keys', '', 'no'),
 (44, 'comment_registration', '0', 'yes'),
 (45, 'html_type', 'text/html', 'yes'),
 (46, 'use_trackback', '0', 'yes'),
 (47, 'default_role', 'subscriber', 'yes'),
 (48, 'db_version', '38590', 'yes'),
 (49, 'uploads_use_yearmonth_folders', '1', 'yes'),
 (50, 'upload_path', '', 'yes'),
 (51, 'blog_public', '1', 'yes'),
 (52, 'default_link_category', '2', 'yes'),
 (53, 'show_on_front', 'page', 'yes'),
 (54, 'tag_base', '', 'yes'),
 (55, 'show_avatars', '1', 'yes'),
 (56, 'avatar_rating', 'G', 'yes'),
 (57, 'upload_url_path', '', 'yes'),
 (58, 'thumbnail_size_w', '150', 'yes'),
 (59, 'thumbnail_size_h', '150', 'yes'),
 (60, 'thumbnail_crop', '1', 'yes'),
 (61, 'medium_size_w', '300', 'yes'),
 (62, 'medium_size_h', '300', 'yes'),
 (63, 'avatar_default', 'mystery', 'yes'),
 (64, 'large_size_w', '1024', 'yes'),
 (65, 'large_size_h', '1024', 'yes'),
 (66, 'image_default_link_type', 'none', 'yes'),
 (67, 'image_default_size', '', 'yes'),
 (68, 'image_default_align', '', 'yes'),
 (69, 'close_comments_for_old_posts', '0', 'yes'),
 (70, 'close_comments_days_old', '14', 'yes'),
 (71, 'thread_comments', '1', 'yes'),
 (72, 'thread_comments_depth', '5', 'yes'),
 (73, 'page_comments', '0', 'yes'),
 (74, 'comments_per_page', '50', 'yes'),
 (75, 'default_comments_page', 'newest', 'yes'),
 (76, 'comment_order', 'asc', 'yes'),
 (77, 'sticky_posts', 'a:0:{}', 'yes'),
 (78, 'widget_categories', 'a:2:{i:2;a:4:{s:5:"title";s:0:"";s:5:"count";i:0;s:12:"hierarchical";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'),
 (79, 'widget_text', 'a:5:{i:2;a:4:{s:5:"title";s:7:"Find Us";s:4:"text";s:168:"<strong>Address</strong>\n123 Main Street\nNew York, NY 10001\n\n<strong>Hours</strong>\nMonday&mdash;Friday: 9:00AM&ndash;5:00PM\nSaturday &amp; Sunday: 11:00AM&ndash;3:00PM";s:6:"filter";b:1;s:6:"visual";b:1;}i:3;a:4:{s:5:"title";s:15:"About This Site";s:4:"text";s:85:"This may be a good place to introduce yourself and your site or include some credits.";s:6:"filter";b:1;s:6:"visual";b:1;}i:4;a:4:{s:5:"title";s:7:"Find Us";s:4:"text";s:168:"<strong>Address</strong>\n123 Main Street\nNew York, NY 10001\n\n<strong>Hours</strong>\nMonday&mdash;Friday: 9:00AM&ndash;5:00PM\nSaturday &amp; Sunday: 11:00AM&ndash;3:00PM";s:6:"filter";b:1;s:6:"visual";b:1;}i:5;a:4:{s:5:"title";s:15:"About This Site";s:4:"text";s:85:"This may be a good place to introduce yourself and your site or include some credits.";s:6:"filter";b:1;s:6:"visual";b:1;}s:12:"_multiwidget";i:1;}', 'yes'),
 (80, 'widget_rss', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
 (81, 'uninstall_plugins', 'a:1:{s:33:"rotatingtweets/rotatingtweets.php";s:24:"rotatingtweets_uninstall";}', 'no'),
 (82, 'timezone_string', '', 'yes'),
 (83, 'page_for_posts', '0', 'yes'),
 (84, 'page_on_front', '22', 'yes'),
 (85, 'default_post_format', '0', 'yes'),
 (86, 'link_manager_enabled', '0', 'yes'),
 (87, 'finished_splitting_shared_terms', '1', 'yes'),
 (88, 'site_icon', '39', 'yes'),
 (89, 'medium_large_size_w', '768', 'yes'),
 (90, 'medium_large_size_h', '0', 'yes'),
 (91, 'initial_db_version', '38590', 'yes'),
 (92, 'wp_user_roles', 'a:8:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:78:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:10:"copy_posts";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:1;s:15:"buwd_job_delete";b:1;s:12:"buwd_job_run";b:1;s:13:"buwd_api_keys";b:1;s:13:"buwd_settings";b:1;s:20:"buwd_settings_import";b:1;s:20:"buwd_settings_export";b:1;s:9:"buwd_logs";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:1;s:17:"buwd_log_download";b:1;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:1;s:21:"buwd_backups_download";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:35:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:10:"copy_posts";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}s:10:"buwd_admin";a:2:{s:4:"name";s:15:"Backup WD Admin";s:12:"capabilities";a:17:{s:4:"read";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:1;s:15:"buwd_job_delete";b:1;s:12:"buwd_job_run";b:1;s:13:"buwd_api_keys";b:1;s:9:"buwd_logs";b:1;s:13:"buwd_settings";b:1;s:20:"buwd_settings_import";b:1;s:20:"buwd_settings_export";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:1;s:17:"buwd_log_download";b:1;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:1;s:21:"buwd_backups_download";b:1;}}s:11:"buwd_helper";a:2:{s:4:"name";s:16:"Backup WD Helper";s:12:"capabilities";a:17:{s:4:"read";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:0;s:15:"buwd_job_delete";b:0;s:12:"buwd_job_run";b:1;s:13:"buwd_api_keys";b:0;s:13:"buwd_settings";b:0;s:20:"buwd_settings_import";b:0;s:20:"buwd_settings_export";b:0;s:9:"buwd_logs";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:0;s:17:"buwd_log_download";b:1;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:0;s:21:"buwd_backups_download";b:1;}}s:12:"buwd_checker";a:2:{s:4:"name";s:17:"Backup WD Checker";s:12:"capabilities";a:17:{s:4:"read";b:1;s:9:"buwd_edit";b:1;s:8:"buwd_job";b:1;s:13:"buwd_job_edit";b:0;s:15:"buwd_job_delete";b:0;s:12:"buwd_job_run";b:0;s:13:"buwd_api_keys";b:0;s:13:"buwd_settings";b:0;s:20:"buwd_settings_import";b:0;s:20:"buwd_settings_export";b:0;s:9:"buwd_logs";b:1;s:13:"buwd_log_view";b:1;s:15:"buwd_log_delete";b:0;s:17:"buwd_log_download";b:0;s:12:"buwd_backups";b:1;s:19:"buwd_backups_delete";b:0;s:21:"buwd_backups_download";b:0;}}}', 'yes'),
 (93, 'fresh_site', '0', 'yes'),
 (94, 'widget_search', 'a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'),
 (95, 'widget_recent-posts', 'a:2:{i:2;a:2:{s:5:"title";s:0:"";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'),
 (96, 'widget_recent-comments', 'a:2:{i:2;a:2:{s:5:"title";s:0:"";s:6:"number";i:5;}s:12:"_multiwidget";i:1;}', 'yes'),
 (97, 'widget_archives', 'a:2:{i:2;a:3:{s:5:"title";s:0:"";s:5:"count";i:0;s:8:"dropdown";i:0;}s:12:"_multiwidget";i:1;}', 'yes'),
 (98, 'widget_meta', 'a:2:{i:2;a:1:{s:5:"title";s:0:"";}s:12:"_multiwidget";i:1;}', 'yes'),
 (99, 'sidebars_widgets', 'a:9:{s:19:"wp_inactive_widgets";a:4:{i:0;s:6:"text-2";i:1;s:6:"text-3";i:2;s:6:"text-4";i:3;s:6:"text-5";}s:7:"sidebar";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:14:"search_sidebar";a:0:{}s:10:"footer-one";a:0:{}s:10:"footer-two";a:0:{}s:12:"footer-three";a:0:{}s:11:"footer-four";a:0:{}s:13:"array_version";i:3;}', 'yes'),
 (100, 'widget_pages', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (101, 'widget_calendar', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (102, 'widget_media_audio', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (103, 'widget_media_image', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (104, 'widget_media_gallery', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (105, 'widget_media_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (106, 'widget_tag_cloud', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (107, 'widget_nav_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (108, 'widget_custom_html', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (109, 'cron', 'a:7:{i:1533542576;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1533551170;a:1:{s:20:"put_do_weekly_action";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1533553498;a:1:{s:23:"rocket_purge_time_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:12:"rocket_purge";s:4:"args";a:0:{}s:8:"interval";i:36000;}}}i:1533580520;a:3:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1533623886;a:2:{s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1533625922;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}s:7:"version";i:2;}', 'yes'),
 (110, 'theme_mods_twentyseventeen', 'a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1526453184;s:4:"data";a:4:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:9:"sidebar-3";a:0:{}}}}', 'yes'),
 (134, 'can_compress_scripts', '0', 'no'),
 (137, 'recently_activated', 'a:0:{}', 'yes'),
 (142, 'current_theme', 'OceanWP Child', 'yes'),
 (143, 'theme_mods_oceanwp', 'a:3:{i:0;b:0;s:18:"nav_menu_locations";a:0:{}s:16:"sidebars_widgets";a:2:{s:4:"time";i:1526453232;s:4:"data";a:8:{s:19:"wp_inactive_widgets";a:4:{i:0;s:6:"text-2";i:1;s:6:"text-3";i:2;s:6:"text-4";i:3;s:6:"text-5";}s:7:"sidebar";a:6:{i:0;s:8:"search-2";i:1;s:14:"recent-posts-2";i:2;s:17:"recent-comments-2";i:3;s:10:"archives-2";i:4;s:12:"categories-2";i:5;s:6:"meta-2";}s:9:"sidebar-2";a:0:{}s:14:"search_sidebar";a:0:{}s:10:"footer-one";a:0:{}s:10:"footer-two";a:0:{}s:12:"footer-three";a:0:{}s:11:"footer-four";a:0:{}}}}', 'yes'),
 (144, 'theme_switched', '', 'yes'),
 (149, 'theme_mods_oceanwp-child-theme-master', 'a:84:{i:0;b:0;s:18:"nav_menu_locations";a:2:{s:9:"main_menu";i:2;s:11:"mobile_menu";i:9;}s:18:"custom_css_post_id";i:113;s:18:"ocean_header_style";s:11:"transparent";s:19:"ocean_header_height";s:3:"100";s:23:"ocean_header_full_width";b:0;s:26:"ocean_header_right_padding";s:3:"100";s:25:"ocean_header_left_padding";s:2:"40";s:11:"custom_logo";i:93;s:23:"ocean_header_background";s:19:"rgba(255,255,255,0)";s:13:"ocean_top_bar";b:0;s:20:"ocean_logo_max_width";s:3:"200";s:21:"ocean_logo_max_height";s:3:"200";s:25:"ocean_custom_nav_template";s:1:"0";s:19:"ocean_primary_color";s:7:"#133352";s:25:"ocean_hover_primary_color";s:7:"#00d8fc";s:26:"ocean_main_container_width";s:4:"1088";s:30:"ocean_has_header_border_bottom";b:0;s:21:"ocean_menu_arrow_down";b:0;s:21:"ocean_menu_arrow_side";b:0;s:30:"ocean_menu_dropdown_top_border";b:0;s:19:"ocean_menu_position";s:10:"right-menu";s:23:"ocean_menu_links_effect";s:5:"three";s:34:"ocean_menu_links_effect_blue_color";s:7:"#00d8fc";s:24:"ocean_menu_items_padding";s:2:"15";s:21:"ocean_menu_link_color";s:7:"#ffffff";s:15:"menu_typography";a:5:{s:11:"font-family";s:10:"Montserrat";s:11:"font-weight";s:3:"500";s:9:"font-size";s:4:"15px";s:10:"font-style";s:6:"normal";s:14:"text-transform";s:4:"none";}s:15:"body_typography";a:2:{s:11:"font-family";s:10:"Montserrat";s:11:"font-weight";s:3:"400";}s:21:"heading_h1_typography";a:2:{s:11:"font-family";s:10:"Montserrat";s:11:"font-weight";s:3:"400";}s:21:"heading_h2_typography";a:2:{s:11:"font-family";s:10:"Montserrat";s:11:"font-weight";s:3:"400";}s:21:"heading_h3_typography";a:2:{s:11:"font-family";s:10:"Montserrat";s:11:"font-weight";s:3:"400";}s:24:"menu_dropdown_typography";a:3:{s:11:"font-family";s:10:"Montserrat";s:11:"font-weight";s:3:"400";s:9:"font-size";s:4:"14px";}s:31:"mobile_menu_dropdown_typography";a:2:{s:11:"font-family";s:10:"Montserrat";s:11:"font-weight";s:3:"400";}s:21:"page_title_typography";a:1:{s:11:"font-family";s:10:"Montserrat";}s:27:"ocean_menu_link_color_hover";s:7:"#ffffff";s:30:"ocean_dropdown_menu_top_border";s:18:"rgba(19,175,240,0)";s:36:"ocean_dropdown_menu_link_color_hover";s:7:"#333333";s:33:"ocean_dropdown_menu_link_hover_bg";s:7:"#f5f5f5";s:27:"ocean_dropdown_menu_borders";s:19:"rgba(241,241,241,0)";s:23:"ocean_menu_search_style";s:8:"disabled";s:33:"ocean_header_tablet_right_padding";s:1:"0";s:32:"ocean_header_tablet_left_padding";s:2:"50";s:38:"ocean_mobile_menu_display_opening_text";b:0;s:32:"ocean_mobile_menu_open_hamburger";s:6:"slider";s:38:"ocean_mobile_menu_open_hamburger_color";s:7:"#ffffff";s:32:"ocean_mobile_menu_close_btn_text";s:0:"";s:24:"ocean_mobile_menu_search";b:0;s:23:"ocean_mobile_menu_style";s:8:"dropdown";s:22:"ocean_mobile_menu_text";s:0:"";s:28:"ocean_mobile_menu_close_text";s:0:"";s:32:"ocean_mobile_menu_sidr_direction";s:5:"right";s:37:"ocean_dropdown_mobile_menu_max_height";s:3:"667";s:33:"ocean_mobile_menu_sidr_background";s:7:"#133352";s:30:"ocean_mobile_menu_sidr_borders";s:20:"rgba(38,91,148,0.56)";s:23:"ocean_mobile_menu_links";s:7:"#ffffff";s:43:"ocean_mobile_menu_sidr_dropdowns_background";s:18:"rgba(19,51,82,0.6)";s:33:"ocean_header_mobile_right_padding";s:2:"20";s:32:"ocean_header_mobile_left_padding";s:2:"20";s:38:"ocean_mobile_menu_sidr_dropdown_target";s:4:"link";s:27:"ocean_logo_max_width_mobile";s:3:"150";s:26:"ocean_mobile_header_height";s:3:"100";s:21:"ocean_responsive_logo";s:72:"http://www.agurainc.com/wordpress/wp-content/uploads/2018/06/logo@3x.png";s:28:"ocean_responsive_logo_height";s:3:"100";s:28:"ocean_logo_max_height_mobile";s:3:"150";s:29:"ocean_mobile_menu_links_hover";s:7:"#00d8fc";s:32:"ocean_mobile_menu_sidr_search_bg";s:0:"";s:26:"ocean_left_container_width";s:3:"100";s:19:"ocean_sidebar_width";s:1:"0";s:19:"ocean_schema_markup";b:0;s:21:"osh_has_sticky_mobile";b:1;s:24:"osh_shrink_header_height";s:2:"80";s:24:"osh_header_right_padding";s:3:"100";s:25:"osh_sticky_header_opacity";s:1:"1";s:20:"osh_background_color";s:7:"#133352";s:8:"osh_logo";s:0:"";s:29:"osh_shrink_header_logo_height";s:3:"200";s:25:"osh_has_full_width_header";b:0;s:23:"osh_sticky_header_style";s:5:"fixed";s:31:"osh_header_tablet_right_padding";s:1:"0";s:30:"osh_header_tablet_left_padding";s:2:"20";s:31:"osh_header_mobile_right_padding";s:2:"20";s:30:"osh_header_mobile_left_padding";s:2:"20";s:16:"ocean_scroll_top";b:0;s:23:"osh_header_left_padding";s:2:"40";}', 'yes'),
 (155, 'elementor_version', '2.1.3', 'yes'),
 (156, '_elementor_installed_time', '1526453383', 'yes'),
 (157, 'elementor_remote_info_library', 'a:2:{s:10:"categories";a:22:{i:0;s:8:"404 page";i:1;s:5:"about";i:2;s:7:"archive";i:3;s:14:"call to action";i:4;s:7:"clients";i:5;s:7:"contact";i:6;s:3:"faq";i:7;s:8:"features";i:8;s:6:"footer";i:9;s:6:"header";i:10;s:4:"hero";i:11;s:9:"portfolio";i:12;s:7:"pricing";i:13;s:15:"product archive";i:14;s:8:"services";i:15;s:11:"single page";i:16;s:11:"single post";i:17;s:14:"single product";i:18;s:5:"stats";i:19;s:9:"subscribe";i:20;s:4:"team";i:21;s:12:"testimonials";}s:9:"templates";a:433:{i:0;a:14:{s:2:"id";s:4:"5525";s:5:"title";s:8:"About 14";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png";s:12:"tmpl_created";s:10:"1520443532";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"28";s:11:"trend_index";s:2:"17";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:1;a:14:{s:2:"id";s:4:"5533";s:5:"title";s:8:"About 15";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png";s:12:"tmpl_created";s:10:"1520443534";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"58";s:11:"trend_index";s:2:"39";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:2;a:14:{s:2:"id";s:4:"5575";s:5:"title";s:5:"CTA 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png";s:12:"tmpl_created";s:10:"1520443543";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"40";s:11:"trend_index";s:2:"18";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:3;a:14:{s:2:"id";s:4:"5615";s:5:"title";s:10:"Features 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png";s:12:"tmpl_created";s:10:"1520443551";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"53";s:11:"trend_index";s:2:"38";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:4;a:14:{s:2:"id";s:4:"5624";s:5:"title";s:10:"Features 5";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png";s:12:"tmpl_created";s:10:"1520443553";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"113";s:11:"trend_index";s:3:"108";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:5;a:14:{s:2:"id";s:4:"5684";s:5:"title";s:5:"FAQ 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png";s:12:"tmpl_created";s:10:"1520443565";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/faq-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"88";s:11:"trend_index";s:3:"100";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:6;a:14:{s:2:"id";s:4:"5693";s:5:"title";s:5:"FAQ 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png";s:12:"tmpl_created";s:10:"1520443567";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/faq-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"232";s:11:"trend_index";s:3:"247";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:7;a:14:{s:2:"id";s:4:"5703";s:5:"title";s:6:"FAQ 13";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png";s:12:"tmpl_created";s:10:"1520443569";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/faq-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"55";s:11:"trend_index";s:2:"44";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:8;a:14:{s:2:"id";s:4:"5711";s:5:"title";s:5:"FAQ 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png";s:12:"tmpl_created";s:10:"1520443571";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/faq-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"236";s:11:"trend_index";s:3:"189";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:9;a:14:{s:2:"id";s:4:"5719";s:5:"title";s:5:"FAQ 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png";s:12:"tmpl_created";s:10:"1520443573";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/faq-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"131";s:11:"trend_index";s:3:"126";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:10;a:14:{s:2:"id";s:4:"5729";s:5:"title";s:5:"FAQ 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png";s:12:"tmpl_created";s:10:"1520443575";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/faq-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"319";s:11:"trend_index";s:3:"298";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:11;a:14:{s:2:"id";s:4:"5737";s:5:"title";s:6:"FAQ 10";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png";s:12:"tmpl_created";s:10:"1520443576";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/faq-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"183";s:11:"trend_index";s:3:"178";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:12;a:14:{s:2:"id";s:4:"5746";s:5:"title";s:6:"FAQ 11";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png";s:12:"tmpl_created";s:10:"1520443578";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/faq-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"204";s:11:"trend_index";s:3:"194";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:13;a:14:{s:2:"id";s:4:"5755";s:5:"title";s:5:"FAQ 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png";s:12:"tmpl_created";s:10:"1520443580";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/faq-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"100";s:11:"trend_index";s:2:"79";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:14;a:14:{s:2:"id";s:4:"5764";s:5:"title";s:5:"FAQ 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png";s:12:"tmpl_created";s:10:"1520443582";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/faq-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["faq"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"313";s:11:"trend_index";s:3:"282";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:15;a:14:{s:2:"id";s:4:"5773";s:5:"title";s:7:"Hero 11";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png";s:12:"tmpl_created";s:10:"1520443584";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/hero-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"49";s:11:"trend_index";s:2:"29";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:16;a:14:{s:2:"id";s:4:"5783";s:5:"title";s:7:"Hero 10";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png";s:12:"tmpl_created";s:10:"1520443586";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/hero-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"316";s:11:"trend_index";s:3:"307";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:17;a:14:{s:2:"id";s:4:"5792";s:5:"title";s:6:"Hero 9";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png";s:12:"tmpl_created";s:10:"1520443588";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"231";s:11:"trend_index";s:3:"187";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:18;a:14:{s:2:"id";s:4:"5801";s:5:"title";s:6:"Hero 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png";s:12:"tmpl_created";s:10:"1520443589";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:10:"["header"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"36";s:11:"trend_index";s:2:"22";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:19;a:14:{s:2:"id";s:4:"5811";s:5:"title";s:6:"Hero 8";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png";s:12:"tmpl_created";s:10:"1520443591";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"108";s:11:"trend_index";s:3:"102";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:20;a:14:{s:2:"id";s:4:"5820";s:5:"title";s:9:"Contact 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png";s:12:"tmpl_created";s:10:"1520443593";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"206";s:11:"trend_index";s:3:"205";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:21;a:14:{s:2:"id";s:4:"5828";s:5:"title";s:9:"Contact 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png";s:12:"tmpl_created";s:10:"1520443595";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"305";s:11:"trend_index";s:3:"227";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:22;a:14:{s:2:"id";s:4:"5836";s:5:"title";s:10:"Contact 10";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png";s:12:"tmpl_created";s:10:"1520443597";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/contact-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"121";s:11:"trend_index";s:3:"103";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:23;a:14:{s:2:"id";s:4:"5844";s:5:"title";s:10:"Contact 11";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png";s:12:"tmpl_created";s:10:"1520443599";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/contact-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"287";s:11:"trend_index";s:3:"280";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:24;a:14:{s:2:"id";s:4:"5852";s:5:"title";s:6:"CTA 34";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png";s:12:"tmpl_created";s:10:"1520443600";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-34/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"page";s:4:"tags";s:8:"["form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"399";s:11:"trend_index";s:3:"355";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:25;a:14:{s:2:"id";s:4:"5947";s:5:"title";s:7:"Stats 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png";s:12:"tmpl_created";s:10:"1520443621";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"340";s:11:"trend_index";s:3:"393";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:26;a:14:{s:2:"id";s:4:"5956";s:5:"title";s:7:"Stats 7";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png";s:12:"tmpl_created";s:10:"1520443623";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"397";s:11:"trend_index";s:3:"417";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:27;a:14:{s:2:"id";s:4:"5963";s:5:"title";s:10:"Features 7";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png";s:12:"tmpl_created";s:10:"1520443626";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"77";s:11:"trend_index";s:2:"91";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:28;a:14:{s:2:"id";s:4:"5974";s:5:"title";s:10:"Features 4";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png";s:12:"tmpl_created";s:10:"1520443629";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"74";s:11:"trend_index";s:2:"71";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:29;a:14:{s:2:"id";s:4:"5983";s:5:"title";s:10:"Features 3";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png";s:12:"tmpl_created";s:10:"1520443630";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:11:"["featues"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"255";s:11:"trend_index";s:3:"292";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:30;a:14:{s:2:"id";s:4:"5991";s:5:"title";s:11:"Features 10";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png";s:12:"tmpl_created";s:10:"1520443632";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/features-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"127";s:11:"trend_index";s:3:"122";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:31;a:14:{s:2:"id";s:4:"5999";s:5:"title";s:7:"Team 14";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png";s:12:"tmpl_created";s:10:"1520443634";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"94";s:11:"trend_index";s:2:"83";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:32;a:14:{s:2:"id";s:4:"6008";s:5:"title";s:6:"Team 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png";s:12:"tmpl_created";s:10:"1520443636";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/team-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"79";s:11:"trend_index";s:3:"112";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:33;a:14:{s:2:"id";s:4:"6027";s:5:"title";s:7:"About 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png";s:12:"tmpl_created";s:10:"1520443639";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/about-5-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"62";s:11:"trend_index";s:2:"50";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:34;a:14:{s:2:"id";s:4:"6036";s:5:"title";s:7:"About 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png";s:12:"tmpl_created";s:10:"1520443641";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/about-6-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"101";s:11:"trend_index";s:2:"99";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:35;a:14:{s:2:"id";s:4:"6044";s:5:"title";s:11:"Features 11";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png";s:12:"tmpl_created";s:10:"1520443643";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/features-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"87";s:11:"trend_index";s:3:"105";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:36;a:14:{s:2:"id";s:4:"6053";s:5:"title";s:10:"Features 1";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png";s:12:"tmpl_created";s:10:"1520443645";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"179";s:11:"trend_index";s:3:"135";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:37;a:14:{s:2:"id";s:4:"6063";s:5:"title";s:7:"Stats 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png";s:12:"tmpl_created";s:10:"1520443647";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"164";s:11:"trend_index";s:3:"183";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:38;a:14:{s:2:"id";s:4:"6071";s:5:"title";s:8:"Stats 13";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png";s:12:"tmpl_created";s:10:"1520443649";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/stats-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"172";s:11:"trend_index";s:3:"146";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:39;a:14:{s:2:"id";s:4:"6079";s:5:"title";s:7:"Stats 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png";s:12:"tmpl_created";s:10:"1520443651";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"294";s:11:"trend_index";s:3:"311";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:40;a:14:{s:2:"id";s:4:"6089";s:5:"title";s:7:"Stats 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png";s:12:"tmpl_created";s:10:"1520443653";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"199";s:11:"trend_index";s:3:"216";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:41;a:14:{s:2:"id";s:4:"6097";s:5:"title";s:7:"Stats 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png";s:12:"tmpl_created";s:10:"1520443655";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"275";s:11:"trend_index";s:3:"236";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:42;a:14:{s:2:"id";s:4:"6106";s:5:"title";s:7:"Stats 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png";s:12:"tmpl_created";s:10:"1520443657";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"331";s:11:"trend_index";s:3:"206";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:43;a:14:{s:2:"id";s:4:"6114";s:5:"title";s:7:"Stats 1";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png";s:12:"tmpl_created";s:10:"1520443659";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"357";s:11:"trend_index";s:3:"338";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:44;a:14:{s:2:"id";s:4:"6122";s:5:"title";s:7:"About 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png";s:12:"tmpl_created";s:10:"1520443661";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/about-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"57";s:11:"trend_index";s:2:"52";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:45;a:14:{s:2:"id";s:4:"6135";s:5:"title";s:8:"About 10";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png";s:12:"tmpl_created";s:10:"1520443663";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"93";s:11:"trend_index";s:2:"88";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:46;a:14:{s:2:"id";s:4:"6144";s:5:"title";s:7:"Team 17";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png";s:12:"tmpl_created";s:10:"1520443664";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"178";s:11:"trend_index";s:3:"123";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:47;a:14:{s:2:"id";s:4:"6152";s:5:"title";s:7:"Stats 9";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png";s:12:"tmpl_created";s:10:"1520443666";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/stats-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"247";s:11:"trend_index";s:3:"270";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:48;a:14:{s:2:"id";s:4:"6162";s:5:"title";s:11:"Services 31";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png";s:12:"tmpl_created";s:10:"1520443668";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"318";s:11:"trend_index";s:3:"363";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:49;a:14:{s:2:"id";s:4:"6170";s:5:"title";s:8:"Stats 11";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png";s:12:"tmpl_created";s:10:"1520443670";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/stats-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"326";s:11:"trend_index";s:3:"289";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:50;a:14:{s:2:"id";s:4:"6178";s:5:"title";s:8:"Stats 10";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png";s:12:"tmpl_created";s:10:"1520443676";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/stats-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"353";s:11:"trend_index";s:3:"406";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:51;a:14:{s:2:"id";s:4:"6186";s:5:"title";s:8:"Stats 12";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png";s:12:"tmpl_created";s:10:"1520443678";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/stats-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"386";s:11:"trend_index";s:3:"349";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:52;a:14:{s:2:"id";s:4:"6196";s:5:"title";s:10:"Features 9";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png";s:12:"tmpl_created";s:10:"1520443680";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"111";s:11:"trend_index";s:3:"137";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:53;a:14:{s:2:"id";s:4:"6204";s:5:"title";s:10:"Features 8";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png";s:12:"tmpl_created";s:10:"1520443681";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"223";s:11:"trend_index";s:3:"191";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:54;a:14:{s:2:"id";s:4:"6212";s:5:"title";s:11:"Features 12";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png";s:12:"tmpl_created";s:10:"1520443684";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/features-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"95";s:11:"trend_index";s:2:"77";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:55;a:14:{s:2:"id";s:4:"6220";s:5:"title";s:10:"Features 2";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png";s:12:"tmpl_created";s:10:"1520443685";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/features-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["features"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"98";s:11:"trend_index";s:3:"115";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:56;a:14:{s:2:"id";s:4:"6230";s:5:"title";s:6:"Hero 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png";s:12:"tmpl_created";s:10:"1520443687";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"342";s:11:"trend_index";s:3:"394";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:57;a:14:{s:2:"id";s:4:"6239";s:5:"title";s:6:"Hero 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png";s:12:"tmpl_created";s:10:"1520443689";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"51";s:11:"trend_index";s:2:"31";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:58;a:14:{s:2:"id";s:4:"6249";s:5:"title";s:6:"Hero 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png";s:12:"tmpl_created";s:10:"1520443691";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"75";s:11:"trend_index";s:2:"69";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:59;a:14:{s:2:"id";s:4:"6258";s:5:"title";s:6:"Hero 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png";s:12:"tmpl_created";s:10:"1520443693";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"356";s:11:"trend_index";s:3:"364";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:60;a:14:{s:2:"id";s:4:"6266";s:5:"title";s:6:"Hero 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png";s:12:"tmpl_created";s:10:"1520443695";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"60";s:11:"trend_index";s:2:"41";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:61;a:14:{s:2:"id";s:4:"6274";s:5:"title";s:6:"Hero 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png";s:12:"tmpl_created";s:10:"1520443698";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/hero-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"104";s:11:"trend_index";s:3:"147";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:62;a:14:{s:2:"id";s:4:"6017";s:5:"title";s:6:"CTA 14";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png";s:12:"tmpl_created";s:10:"1520520331";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"158";s:11:"trend_index";s:3:"153";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:63;a:14:{s:2:"id";s:4:"4826";s:5:"title";s:14:"Testimonial 24";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png";s:12:"tmpl_created";s:10:"1520520544";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"288";s:11:"trend_index";s:3:"212";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:64;a:14:{s:2:"id";s:4:"4835";s:5:"title";s:14:"Testimonial 16";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png";s:12:"tmpl_created";s:10:"1520520546";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"360";s:11:"trend_index";s:3:"360";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:65;a:14:{s:2:"id";s:4:"4843";s:5:"title";s:14:"Testimonial 18";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png";s:12:"tmpl_created";s:10:"1520520548";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"366";s:11:"trend_index";s:3:"346";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:66;a:14:{s:2:"id";s:4:"4854";s:5:"title";s:14:"Testimonial 13";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png";s:12:"tmpl_created";s:10:"1520520549";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"411";s:11:"trend_index";s:3:"382";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:67;a:14:{s:2:"id";s:4:"4863";s:5:"title";s:14:"Testimonial 19";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png";s:12:"tmpl_created";s:10:"1520520551";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"282";s:11:"trend_index";s:3:"291";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:68;a:14:{s:2:"id";s:4:"4871";s:5:"title";s:14:"Testimonial 12";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png";s:12:"tmpl_created";s:10:"1520520552";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"265";s:11:"trend_index";s:3:"225";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:69;a:14:{s:2:"id";s:4:"4880";s:5:"title";s:14:"Testimonial 20";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg";s:12:"tmpl_created";s:10:"1520520554";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"358";s:11:"trend_index";s:3:"332";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:70;a:14:{s:2:"id";s:4:"4889";s:5:"title";s:14:"Testimonial 11";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg";s:12:"tmpl_created";s:10:"1520520556";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"387";s:11:"trend_index";s:3:"425";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:71;a:14:{s:2:"id";s:4:"4897";s:5:"title";s:14:"Testimonial 21";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png";s:12:"tmpl_created";s:10:"1520520557";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"107";s:11:"trend_index";s:2:"87";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:72;a:14:{s:2:"id";s:4:"4905";s:5:"title";s:14:"Testimonial 22";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png";s:12:"tmpl_created";s:10:"1520520559";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"134";s:11:"trend_index";s:3:"127";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:73;a:14:{s:2:"id";s:4:"4913";s:5:"title";s:14:"Testimonial 23";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png";s:12:"tmpl_created";s:10:"1520520561";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"268";s:11:"trend_index";s:3:"264";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:74;a:14:{s:2:"id";s:4:"4921";s:5:"title";s:14:"Testimonial 10";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png";s:12:"tmpl_created";s:10:"1520520562";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"249";s:11:"trend_index";s:3:"170";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:75;a:14:{s:2:"id";s:4:"4929";s:5:"title";s:14:"Testimonial 24";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png";s:12:"tmpl_created";s:10:"1520520564";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"67";s:11:"trend_index";s:2:"51";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:76;a:14:{s:2:"id";s:4:"4939";s:5:"title";s:13:"Testimonial 9";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png";s:12:"tmpl_created";s:10:"1520520565";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/testimonial-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"105";s:11:"trend_index";s:2:"96";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:77;a:14:{s:2:"id";s:4:"4947";s:5:"title";s:14:"Testimonial 27";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png";s:12:"tmpl_created";s:10:"1520520567";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"202";s:11:"trend_index";s:3:"157";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:78;a:14:{s:2:"id";s:4:"4955";s:5:"title";s:14:"Testimonial 29";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png";s:12:"tmpl_created";s:10:"1520520569";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"320";s:11:"trend_index";s:3:"252";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:79;a:14:{s:2:"id";s:4:"4963";s:5:"title";s:14:"Testimonial 25";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png";s:12:"tmpl_created";s:10:"1520520570";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"363";s:11:"trend_index";s:3:"329";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:80;a:14:{s:2:"id";s:4:"4971";s:5:"title";s:14:"Testimonial 26";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png";s:12:"tmpl_created";s:10:"1520520572";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"417";s:11:"trend_index";s:3:"386";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:81;a:14:{s:2:"id";s:4:"4979";s:5:"title";s:14:"Testimonial 15";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png";s:12:"tmpl_created";s:10:"1520520573";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"398";s:11:"trend_index";s:3:"335";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:82;a:14:{s:2:"id";s:4:"4987";s:5:"title";s:14:"Testimonial 17";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png";s:12:"tmpl_created";s:10:"1520520575";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"167";s:11:"trend_index";s:3:"118";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:83;a:14:{s:2:"id";s:4:"4995";s:5:"title";s:14:"Testimonial 14";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png";s:12:"tmpl_created";s:10:"1520520577";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/testimonial-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"348";s:11:"trend_index";s:3:"353";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:84;a:14:{s:2:"id";s:4:"5007";s:5:"title";s:11:"Portfolio 7";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png";s:12:"tmpl_created";s:10:"1520520578";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"66";s:11:"trend_index";s:2:"53";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:85;a:14:{s:2:"id";s:4:"5019";s:5:"title";s:11:"Portfolio 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png";s:12:"tmpl_created";s:10:"1520520580";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"173";s:11:"trend_index";s:3:"171";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:86;a:14:{s:2:"id";s:4:"5027";s:5:"title";s:12:"Portfolio 11";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png";s:12:"tmpl_created";s:10:"1520520581";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"322";s:11:"trend_index";s:3:"244";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:87;a:14:{s:2:"id";s:4:"5037";s:5:"title";s:12:"Portfolio 12";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png";s:12:"tmpl_created";s:10:"1520520583";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"273";s:11:"trend_index";s:3:"326";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:88;a:14:{s:2:"id";s:4:"5057";s:5:"title";s:12:"Portfolio 13";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png";s:12:"tmpl_created";s:10:"1520520586";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"253";s:11:"trend_index";s:3:"215";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:89;a:14:{s:2:"id";s:4:"5071";s:5:"title";s:12:"Portfolio 14";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png";s:12:"tmpl_created";s:10:"1520520588";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"277";s:11:"trend_index";s:3:"330";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:90;a:14:{s:2:"id";s:4:"5082";s:5:"title";s:11:"Portfolio 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png";s:12:"tmpl_created";s:10:"1520520589";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"376";s:11:"trend_index";s:3:"410";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:91;a:14:{s:2:"id";s:4:"5090";s:5:"title";s:12:"Portfolio 15";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png";s:12:"tmpl_created";s:10:"1520520591";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"240";s:11:"trend_index";s:3:"239";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:92;a:14:{s:2:"id";s:4:"5098";s:5:"title";s:12:"Portfolio 16";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png";s:12:"tmpl_created";s:10:"1520520593";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"176";s:11:"trend_index";s:3:"192";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:93;a:14:{s:2:"id";s:4:"5107";s:5:"title";s:11:"Portfolio 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png";s:12:"tmpl_created";s:10:"1520520594";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"350";s:11:"trend_index";s:3:"413";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:94;a:14:{s:2:"id";s:4:"5115";s:5:"title";s:12:"Portfolio 17";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png";s:12:"tmpl_created";s:10:"1520520596";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"47";s:11:"trend_index";s:2:"34";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:95;a:14:{s:2:"id";s:4:"5125";s:5:"title";s:11:"Portfolio 6";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png";s:12:"tmpl_created";s:10:"1520520597";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"254";s:11:"trend_index";s:3:"284";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:96;a:14:{s:2:"id";s:4:"5133";s:5:"title";s:12:"Portfolio 18";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png";s:12:"tmpl_created";s:10:"1520520599";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"189";s:11:"trend_index";s:3:"200";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:97;a:14:{s:2:"id";s:4:"5141";s:5:"title";s:12:"Portfolio 10";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png";s:12:"tmpl_created";s:10:"1520520601";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/portfolio-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"140";s:11:"trend_index";s:3:"164";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:98;a:14:{s:2:"id";s:4:"5149";s:5:"title";s:11:"Portfolio 2";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png";s:12:"tmpl_created";s:10:"1520520602";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"132";s:11:"trend_index";s:3:"136";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:99;a:14:{s:2:"id";s:4:"5542";s:5:"title";s:6:"CTA 19";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png";s:12:"tmpl_created";s:10:"1520520681";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"166";s:11:"trend_index";s:3:"185";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:100;a:14:{s:2:"id";s:4:"5550";s:5:"title";s:6:"CTA 33";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png";s:12:"tmpl_created";s:10:"1520520682";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-33/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"300";s:11:"trend_index";s:3:"276";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:101;a:14:{s:2:"id";s:4:"5558";s:5:"title";s:5:"CTA 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png";s:12:"tmpl_created";s:10:"1520520684";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"124";s:11:"trend_index";s:3:"132";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:102;a:14:{s:2:"id";s:4:"5567";s:5:"title";s:5:"CTA 2";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png";s:12:"tmpl_created";s:10:"1520520685";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"181";s:11:"trend_index";s:3:"129";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:103;a:14:{s:2:"id";s:4:"5583";s:5:"title";s:6:"CTA 26";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png";s:12:"tmpl_created";s:10:"1520520689";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"258";s:11:"trend_index";s:3:"172";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:104;a:14:{s:2:"id";s:4:"5591";s:5:"title";s:5:"CTA 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png";s:12:"tmpl_created";s:10:"1520520691";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"110";s:11:"trend_index";s:3:"116";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:105;a:14:{s:2:"id";s:4:"5599";s:5:"title";s:5:"CTA 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png";s:12:"tmpl_created";s:10:"1520520693";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"274";s:11:"trend_index";s:3:"125";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:106;a:14:{s:2:"id";s:4:"5607";s:5:"title";s:6:"CTA 13";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png";s:12:"tmpl_created";s:10:"1520520695";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"163";s:11:"trend_index";s:3:"142";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:107;a:14:{s:2:"id";s:4:"5634";s:5:"title";s:6:"CTA 24";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png";s:12:"tmpl_created";s:10:"1520520699";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"180";s:11:"trend_index";s:3:"166";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:108;a:14:{s:2:"id";s:4:"5642";s:5:"title";s:6:"CTA 25";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png";s:12:"tmpl_created";s:10:"1520520701";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"251";s:11:"trend_index";s:3:"257";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:109;a:14:{s:2:"id";s:4:"5650";s:5:"title";s:5:"CTA 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png";s:12:"tmpl_created";s:10:"1520520702";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"123";s:11:"trend_index";s:3:"114";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:110;a:14:{s:2:"id";s:4:"5658";s:5:"title";s:5:"CTA 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png";s:12:"tmpl_created";s:10:"1520520704";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"239";s:11:"trend_index";s:3:"210";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:111;a:14:{s:2:"id";s:4:"5667";s:5:"title";s:5:"CTA 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png";s:12:"tmpl_created";s:10:"1520520705";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"135";s:11:"trend_index";s:2:"89";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:112;a:14:{s:2:"id";s:4:"5675";s:5:"title";s:5:"CTA 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png";s:12:"tmpl_created";s:10:"1520520707";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/blocks/cta-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"355";s:11:"trend_index";s:3:"395";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:113;a:14:{s:2:"id";s:4:"5860";s:5:"title";s:6:"CTA 17";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png";s:12:"tmpl_created";s:10:"1520520746";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"141";s:11:"trend_index";s:2:"70";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:114;a:14:{s:2:"id";s:4:"5869";s:5:"title";s:6:"CTA 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png";s:12:"tmpl_created";s:10:"1520520747";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"296";s:11:"trend_index";s:3:"198";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:115;a:14:{s:2:"id";s:4:"5877";s:5:"title";s:6:"CTA 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png";s:12:"tmpl_created";s:10:"1520520749";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"391";s:11:"trend_index";s:3:"381";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:116;a:14:{s:2:"id";s:4:"5885";s:5:"title";s:6:"CTA 15";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png";s:12:"tmpl_created";s:10:"1520520751";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"324";s:11:"trend_index";s:3:"288";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:117;a:14:{s:2:"id";s:4:"5893";s:5:"title";s:6:"CTA 21";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png";s:12:"tmpl_created";s:10:"1520520752";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"257";s:11:"trend_index";s:3:"188";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:118;a:14:{s:2:"id";s:4:"5904";s:5:"title";s:6:"CTA 27";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png";s:12:"tmpl_created";s:10:"1520520754";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"372";s:11:"trend_index";s:3:"316";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:119;a:14:{s:2:"id";s:4:"5912";s:5:"title";s:6:"CTA 28";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png";s:12:"tmpl_created";s:10:"1520520755";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"419";s:11:"trend_index";s:3:"424";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:120;a:14:{s:2:"id";s:4:"5921";s:5:"title";s:6:"CTA 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png";s:12:"tmpl_created";s:10:"1520520757";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"266";s:11:"trend_index";s:3:"299";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:121;a:14:{s:2:"id";s:4:"5930";s:5:"title";s:6:"CTA 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png";s:12:"tmpl_created";s:10:"1520520758";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"73";s:11:"trend_index";s:2:"66";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:122;a:14:{s:2:"id";s:4:"5939";s:5:"title";s:6:"CTA 10";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png";s:12:"tmpl_created";s:10:"1520520760";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"196";s:11:"trend_index";s:3:"180";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:123;a:14:{s:2:"id";s:4:"7596";s:5:"title";s:8:"Header 1";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg";s:12:"tmpl_created";s:10:"1521546999";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:10:"["header"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"50";s:11:"trend_index";s:2:"45";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:124;a:14:{s:2:"id";s:4:"7615";s:5:"title";s:8:"Header 2";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg";s:12:"tmpl_created";s:10:"1521547237";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:10:"["header"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"44";s:11:"trend_index";s:2:"27";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:125;a:14:{s:2:"id";s:4:"7627";s:5:"title";s:8:"Footer 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png";s:12:"tmpl_created";s:10:"1521547332";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/footer-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["footer"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"129";s:11:"trend_index";s:3:"113";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:126;a:14:{s:2:"id";s:4:"7638";s:5:"title";s:8:"Footer 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png";s:12:"tmpl_created";s:10:"1521547502";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/footer-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["footer"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"119";s:11:"trend_index";s:3:"133";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:127;a:14:{s:2:"id";s:4:"7663";s:5:"title";s:13:"Single Post 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2.png";s:12:"tmpl_created";s:10:"1521547761";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-post-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"single";s:4:"tags";s:24:"["Blog","Post","Single"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"83";s:11:"trend_index";s:3:"283";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:128;a:14:{s:2:"id";s:4:"7650";s:5:"title";s:13:"Single Post 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1.png";s:12:"tmpl_created";s:10:"1521557736";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-post-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"single";s:4:"tags";s:24:"["Blog","Post","Single"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"92";s:11:"trend_index";s:3:"240";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:129;a:14:{s:2:"id";s:4:"7686";s:5:"title";s:12:"Blog Posts 1";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png";s:12:"tmpl_created";s:10:"1521558047";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/blog-posts-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"page";s:4:"tags";s:26:"["archive","Blog","posts"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"61";s:11:"trend_index";s:3:"155";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:130;a:14:{s:2:"id";s:4:"4676";s:5:"title";s:8:"Footer 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png";s:12:"tmpl_created";s:10:"1522014215";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/footer_7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["footer"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"195";s:11:"trend_index";s:3:"150";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:131;a:14:{s:2:"id";s:4:"7997";s:5:"title";s:10:"footer 014";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg";s:12:"tmpl_created";s:10:"1524582343";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/footer-014/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"157";s:11:"trend_index";s:2:"92";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:132;a:14:{s:2:"id";s:4:"7982";s:5:"title";s:10:"footer 013";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg";s:12:"tmpl_created";s:10:"1524582468";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/footer-013/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"321";s:11:"trend_index";s:3:"271";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:133;a:14:{s:2:"id";s:4:"7959";s:5:"title";s:10:"footer 012";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg";s:12:"tmpl_created";s:10:"1524582605";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/footer-012/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"250";s:11:"trend_index";s:3:"213";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:134;a:14:{s:2:"id";s:4:"7950";s:5:"title";s:10:"footer 011";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg";s:12:"tmpl_created";s:10:"1524582631";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/footer-011/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"301";s:11:"trend_index";s:3:"269";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:135;a:14:{s:2:"id";s:4:"7937";s:5:"title";s:10:"footer 010";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg";s:12:"tmpl_created";s:10:"1524582665";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/footer-010/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"279";s:11:"trend_index";s:3:"241";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:136;a:14:{s:2:"id";s:4:"7927";s:5:"title";s:9:"footer 09";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg";s:12:"tmpl_created";s:10:"1524582691";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"235";s:11:"trend_index";s:3:"218";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:137;a:14:{s:2:"id";s:4:"7917";s:5:"title";s:9:"footer 08";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg";s:12:"tmpl_created";s:10:"1524582788";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"147";s:11:"trend_index";s:3:"111";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:138;a:14:{s:2:"id";s:4:"7904";s:5:"title";s:9:"footer 07";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg";s:12:"tmpl_created";s:10:"1524582814";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"286";s:11:"trend_index";s:3:"177";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:139;a:14:{s:2:"id";s:4:"7837";s:5:"title";s:9:"footer 01";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg";s:12:"tmpl_created";s:10:"1524582852";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"396";s:11:"trend_index";s:3:"305";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:140;a:14:{s:2:"id";s:4:"7852";s:5:"title";s:9:"footer 02";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg";s:12:"tmpl_created";s:10:"1524582875";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"290";s:11:"trend_index";s:3:"144";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:141;a:14:{s:2:"id";s:4:"7862";s:5:"title";s:9:"footer 03";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg";s:12:"tmpl_created";s:10:"1524582903";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"186";s:11:"trend_index";s:3:"130";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:142;a:14:{s:2:"id";s:4:"7871";s:5:"title";s:9:"footer 04";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg";s:12:"tmpl_created";s:10:"1524582927";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"151";s:11:"trend_index";s:2:"82";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:143;a:14:{s:2:"id";s:4:"7884";s:5:"title";s:9:"footer 05";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg";s:12:"tmpl_created";s:10:"1524582944";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"37";s:11:"trend_index";s:2:"12";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:144;a:14:{s:2:"id";s:4:"7892";s:5:"title";s:9:"footer 06";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg";s:12:"tmpl_created";s:10:"1524583015";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/footer-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"187";s:11:"trend_index";s:3:"160";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:145;a:14:{s:2:"id";s:4:"4212";s:5:"title";s:11:"Services 23";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png";s:12:"tmpl_created";s:10:"1520443248";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"137";s:11:"trend_index";s:3:"131";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:146;a:14:{s:2:"id";s:4:"7825";s:5:"title";s:9:"header 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg";s:12:"tmpl_created";s:10:"1524583273";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/header-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"97";s:11:"trend_index";s:2:"49";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:147;a:14:{s:2:"id";s:4:"4227";s:5:"title";s:11:"Services 30";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png";s:12:"tmpl_created";s:10:"1520443250";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"327";s:11:"trend_index";s:3:"340";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:148;a:14:{s:2:"id";s:4:"7812";s:5:"title";s:9:"header 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg";s:12:"tmpl_created";s:10:"1524583298";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/header-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"125";s:11:"trend_index";s:3:"104";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:149;a:14:{s:2:"id";s:4:"4235";s:5:"title";s:11:"Services 18";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png";s:12:"tmpl_created";s:10:"1520443251";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"311";s:11:"trend_index";s:3:"211";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:150;a:14:{s:2:"id";s:4:"7724";s:5:"title";s:8:"header 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg";s:12:"tmpl_created";s:10:"1524583367";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"65";s:11:"trend_index";s:2:"47";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:151;a:14:{s:2:"id";s:4:"4244";s:5:"title";s:11:"Services 26";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png";s:12:"tmpl_created";s:10:"1520443253";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-26/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"381";s:11:"trend_index";s:1:"0";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:152;a:14:{s:2:"id";s:4:"7734";s:5:"title";s:8:"header 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg";s:12:"tmpl_created";s:10:"1524583436";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"63";s:11:"trend_index";s:2:"37";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:153;a:14:{s:2:"id";s:4:"4252";s:5:"title";s:10:"Services 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png";s:12:"tmpl_created";s:10:"1520443255";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/services-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"64";s:11:"trend_index";s:2:"61";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:154;a:14:{s:2:"id";s:4:"7771";s:5:"title";s:8:"header 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg";s:12:"tmpl_created";s:10:"1524583540";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"126";s:11:"trend_index";s:2:"86";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:155;a:14:{s:2:"id";s:4:"4260";s:5:"title";s:11:"Services 25";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png";s:12:"tmpl_created";s:10:"1520443257";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-25/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"217";s:11:"trend_index";s:3:"197";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:156;a:14:{s:2:"id";s:4:"7787";s:5:"title";s:8:"header 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg";s:12:"tmpl_created";s:10:"1524583598";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"161";s:11:"trend_index";s:2:"73";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:157;a:14:{s:2:"id";s:4:"4268";s:5:"title";s:10:"Services 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png";s:12:"tmpl_created";s:10:"1520443259";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/services-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"152";s:11:"trend_index";s:3:"222";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:158;a:14:{s:2:"id";s:4:"7801";s:5:"title";s:9:"header 10";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg";s:12:"tmpl_created";s:10:"1524583659";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/header-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"86";s:11:"trend_index";s:2:"68";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:159;a:14:{s:2:"id";s:4:"4276";s:5:"title";s:11:"Services 24";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png";s:12:"tmpl_created";s:10:"1520443261";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-24/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"328";s:11:"trend_index";s:3:"287";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:160;a:14:{s:2:"id";s:4:"7754";s:5:"title";s:8:"header 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg";s:12:"tmpl_created";s:10:"1524583712";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"39";s:11:"trend_index";s:2:"25";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:161;a:14:{s:2:"id";s:4:"4284";s:5:"title";s:10:"Services 7";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png";s:12:"tmpl_created";s:10:"1520443263";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/services-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"80";s:11:"trend_index";s:2:"72";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:162;a:14:{s:2:"id";s:4:"7713";s:5:"title";s:8:"header 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg";s:12:"tmpl_created";s:10:"1524584780";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"70";s:11:"trend_index";s:2:"35";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:163;a:14:{s:2:"id";s:4:"4293";s:5:"title";s:10:"Services 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png";s:12:"tmpl_created";s:10:"1520443265";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/services-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"292";s:11:"trend_index";s:3:"255";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:164;a:14:{s:2:"id";s:4:"7744";s:5:"title";s:8:"header 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg";s:12:"tmpl_created";s:10:"1524584784";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/header-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"103";s:11:"trend_index";s:2:"62";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:165;a:14:{s:2:"id";s:4:"4302";s:5:"title";s:10:"Services 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png";s:12:"tmpl_created";s:10:"1520443266";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/services-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"85";s:11:"trend_index";s:2:"78";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:166;a:14:{s:2:"id";s:4:"8489";s:5:"title";s:13:"Single Post 2";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2018/05/single_post_2_full.jpg";s:12:"tmpl_created";s:10:"1526227514";s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/single-post-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single post";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"56";s:11:"trend_index";s:2:"20";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:167;a:14:{s:2:"id";s:4:"4313";s:5:"title";s:11:"Services 13";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png";s:12:"tmpl_created";s:10:"1520443268";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"143";s:11:"trend_index";s:3:"143";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:168;a:14:{s:2:"id";s:4:"8523";s:5:"title";s:11:"404 page 06";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg";s:12:"tmpl_created";s:10:"1526415291";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-06/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"370";s:11:"trend_index";s:3:"358";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:169;a:14:{s:2:"id";s:4:"4324";s:5:"title";s:11:"Services 14";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png";s:12:"tmpl_created";s:10:"1520443270";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"308";s:11:"trend_index";s:3:"320";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:170;a:14:{s:2:"id";s:4:"8524";s:5:"title";s:11:"404 page 07";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg";s:12:"tmpl_created";s:10:"1526415337";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-07/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"341";s:11:"trend_index";s:3:"286";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:171;a:14:{s:2:"id";s:4:"4332";s:5:"title";s:11:"Services 22";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png";s:12:"tmpl_created";s:10:"1520443272";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"142";s:11:"trend_index";s:3:"128";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:172;a:14:{s:2:"id";s:4:"8525";s:5:"title";s:11:"404 page 08";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg";s:12:"tmpl_created";s:10:"1526415374";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-08/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"401";s:11:"trend_index";s:3:"361";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:173;a:14:{s:2:"id";s:4:"4341";s:5:"title";s:11:"Services 21";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png";s:12:"tmpl_created";s:10:"1520443274";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"145";s:11:"trend_index";s:3:"169";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:174;a:14:{s:2:"id";s:4:"8513";s:5:"title";s:11:"404 page 04";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg";s:12:"tmpl_created";s:10:"1526415417";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"379";s:11:"trend_index";s:3:"427";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:175;a:14:{s:2:"id";s:4:"4349";s:5:"title";s:11:"Services 29";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png";s:12:"tmpl_created";s:10:"1520443275";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"310";s:11:"trend_index";s:3:"377";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:176;a:14:{s:2:"id";s:4:"8512";s:5:"title";s:11:"404 page 03";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg";s:12:"tmpl_created";s:10:"1526415449";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"410";s:11:"trend_index";s:3:"336";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:177;a:14:{s:2:"id";s:4:"4357";s:5:"title";s:11:"Services 20";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png";s:12:"tmpl_created";s:10:"1520443277";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"59";s:11:"trend_index";s:2:"46";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:178;a:14:{s:2:"id";s:4:"8526";s:5:"title";s:11:"404 page 09";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg";s:12:"tmpl_created";s:10:"1526415474";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-09/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"415";s:11:"trend_index";s:3:"421";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:179;a:14:{s:2:"id";s:4:"4368";s:5:"title";s:11:"Services 16";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png";s:12:"tmpl_created";s:10:"1520443279";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"81";s:11:"trend_index";s:2:"60";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:180;a:14:{s:2:"id";s:4:"8505";s:5:"title";s:11:"404 page 01";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg";s:12:"tmpl_created";s:10:"1526415501";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"421";s:11:"trend_index";s:3:"385";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:181;a:14:{s:2:"id";s:4:"4376";s:5:"title";s:11:"Services 28";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png";s:12:"tmpl_created";s:10:"1520443281";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-28/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"144";s:11:"trend_index";s:3:"158";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:182;a:14:{s:2:"id";s:4:"8511";s:5:"title";s:11:"404 page 02";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg";s:12:"tmpl_created";s:10:"1526415528";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"362";s:11:"trend_index";s:3:"372";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:183;a:14:{s:2:"id";s:4:"4391";s:5:"title";s:11:"Services 17";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png";s:12:"tmpl_created";s:10:"1520443283";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"146";s:11:"trend_index";s:3:"184";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:184;a:14:{s:2:"id";s:4:"8514";s:5:"title";s:11:"404 Page 05";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg";s:12:"tmpl_created";s:10:"1526415558";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/404-page-05/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"393";s:11:"trend_index";s:3:"414";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:185;a:14:{s:2:"id";s:4:"4400";s:5:"title";s:11:"Services 27";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png";s:12:"tmpl_created";s:10:"1520443285";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/services-27/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["services"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"260";s:11:"trend_index";s:3:"226";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:186;a:14:{s:2:"id";s:4:"8676";s:5:"title";s:13:"single page 1";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg";s:12:"tmpl_created";s:10:"1527682423";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-page-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"382";s:11:"trend_index";s:3:"312";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"1";}i:187;a:14:{s:2:"id";s:4:"4411";s:5:"title";s:9:"Contact 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png";s:12:"tmpl_created";s:10:"1520443287";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/contact-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"102";s:11:"trend_index";s:3:"110";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:188;a:14:{s:2:"id";s:4:"8678";s:5:"title";s:13:"single page 2";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg";s:12:"tmpl_created";s:10:"1527682780";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"280";s:11:"trend_index";s:2:"97";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:189;a:14:{s:2:"id";s:4:"4420";s:5:"title";s:9:"Contact 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png";s:12:"tmpl_created";s:10:"1520443289";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/contact-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"169";s:11:"trend_index";s:3:"238";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:190;a:14:{s:2:"id";s:4:"8679";s:5:"title";s:13:"single page 3";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg";s:12:"tmpl_created";s:10:"1527682847";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-page-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"332";s:11:"trend_index";s:3:"237";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:191;a:14:{s:2:"id";s:4:"4428";s:5:"title";s:9:"Contact 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png";s:12:"tmpl_created";s:10:"1520443291";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"99";s:11:"trend_index";s:2:"98";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:192;a:14:{s:2:"id";s:4:"8680";s:5:"title";s:13:"single page 4";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg";s:12:"tmpl_created";s:10:"1527682896";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-page-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"412";s:11:"trend_index";s:3:"319";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:193;a:14:{s:2:"id";s:4:"4436";s:5:"title";s:11:"Contact  16";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png";s:12:"tmpl_created";s:10:"1520443293";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/contact-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"175";s:11:"trend_index";s:3:"230";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:194;a:14:{s:2:"id";s:4:"8681";s:5:"title";s:13:"single page 5";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg";s:12:"tmpl_created";s:10:"1527682969";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-page-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"352";s:11:"trend_index";s:3:"352";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:195;a:14:{s:2:"id";s:4:"4444";s:5:"title";s:9:"Contact 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png";s:12:"tmpl_created";s:10:"1520443295";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"109";s:11:"trend_index";s:2:"74";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:196;a:14:{s:2:"id";s:4:"8682";s:5:"title";s:13:"single page 6";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg";s:12:"tmpl_created";s:10:"1527683026";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-page-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"413";s:11:"trend_index";s:3:"411";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:197;a:14:{s:2:"id";s:4:"4452";s:5:"title";s:9:"Contact 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png";s:12:"tmpl_created";s:10:"1520443296";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"177";s:11:"trend_index";s:3:"134";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:198;a:14:{s:2:"id";s:4:"8703";s:5:"title";s:13:"single page 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg";s:12:"tmpl_created";s:10:"1527683072";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/single-page-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"388";s:11:"trend_index";s:3:"265";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"1";}i:199;a:14:{s:2:"id";s:4:"4460";s:5:"title";s:9:"Contact 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png";s:12:"tmpl_created";s:10:"1520443298";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"136";s:11:"trend_index";s:3:"119";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:200;a:14:{s:2:"id";s:4:"8961";s:5:"title";s:9:"archive 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg";s:12:"tmpl_created";s:10:"1528639909";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"214";s:11:"trend_index";s:2:"64";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:201;a:14:{s:2:"id";s:4:"4468";s:5:"title";s:9:"Contact 7";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png";s:12:"tmpl_created";s:10:"1520443301";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["contact","form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"160";s:11:"trend_index";s:3:"173";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:202;a:14:{s:2:"id";s:4:"8969";s:5:"title";s:9:"archive 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg";s:12:"tmpl_created";s:10:"1528700014";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"339";s:11:"trend_index";s:3:"199";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:203;a:14:{s:2:"id";s:4:"4476";s:5:"title";s:10:"Contact 15";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png";s:12:"tmpl_created";s:10:"1520443303";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/contact-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["contact","form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"272";s:11:"trend_index";s:3:"251";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:204;a:14:{s:2:"id";s:4:"8973";s:5:"title";s:9:"archive 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg";s:12:"tmpl_created";s:10:"1528700205";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"317";s:11:"trend_index";s:3:"141";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:205;a:14:{s:2:"id";s:4:"4484";s:5:"title";s:9:"Contact 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png";s:12:"tmpl_created";s:10:"1520443305";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/contact-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["contact","form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"336";s:11:"trend_index";s:3:"383";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:206;a:14:{s:2:"id";s:4:"8977";s:5:"title";s:9:"archive 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg";s:12:"tmpl_created";s:10:"1528700326";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"402";s:11:"trend_index";s:3:"250";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:207;a:14:{s:2:"id";s:4:"4492";s:5:"title";s:9:"Contact 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png";s:12:"tmpl_created";s:10:"1520443307";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/contact-5-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["contact"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"69";s:11:"trend_index";s:2:"48";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:208;a:14:{s:2:"id";s:4:"8981";s:5:"title";s:9:"archive 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg";s:12:"tmpl_created";s:10:"1528700484";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"377";s:11:"trend_index";s:3:"254";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:209;a:14:{s:2:"id";s:4:"4500";s:5:"title";s:9:"Pricing 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png";s:12:"tmpl_created";s:10:"1520443308";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"384";s:11:"trend_index";s:3:"370";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:210;a:14:{s:2:"id";s:4:"8985";s:5:"title";s:9:"archive 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg";s:12:"tmpl_created";s:10:"1528700612";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"346";s:11:"trend_index";s:3:"174";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:211;a:14:{s:2:"id";s:4:"4509";s:5:"title";s:9:"Pricing 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png";s:12:"tmpl_created";s:10:"1520443310";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"427";s:11:"trend_index";s:3:"426";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:212;a:14:{s:2:"id";s:4:"8989";s:5:"title";s:9:"archive 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg";s:12:"tmpl_created";s:10:"1528701063";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"335";s:11:"trend_index";s:3:"161";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"1";}i:213;a:14:{s:2:"id";s:4:"4521";s:5:"title";s:9:"Pricing 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png";s:12:"tmpl_created";s:10:"1520443312";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"329";s:11:"trend_index";s:3:"279";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:214;a:14:{s:2:"id";s:4:"8996";s:5:"title";s:9:"archive 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg";s:12:"tmpl_created";s:10:"1528701290";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"315";s:11:"trend_index";s:3:"207";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:215;a:14:{s:2:"id";s:4:"4529";s:5:"title";s:9:"Pricing 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png";s:12:"tmpl_created";s:10:"1520443314";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"416";s:11:"trend_index";s:3:"390";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:216;a:14:{s:2:"id";s:4:"9001";s:5:"title";s:9:"archive 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg";s:12:"tmpl_created";s:10:"1528701433";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/archive-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"351";s:11:"trend_index";s:3:"193";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:217;a:14:{s:2:"id";s:4:"4537";s:5:"title";s:9:"Pricing 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png";s:12:"tmpl_created";s:10:"1520443315";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"409";s:11:"trend_index";s:3:"416";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:218;a:14:{s:2:"id";s:4:"9119";s:5:"title";s:10:"footer 015";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png";s:12:"tmpl_created";s:10:"1532428138";s:6:"author";s:9:"Elementor";s:3:"url";s:101:"https://library.elementor.com/blocks/demo/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"420";s:11:"trend_index";s:3:"219";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:219;a:14:{s:2:"id";s:4:"4545";s:5:"title";s:9:"Pricing 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png";s:12:"tmpl_created";s:10:"1520443317";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"424";s:11:"trend_index";s:3:"343";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:220;a:14:{s:2:"id";s:4:"9127";s:5:"title";s:9:"header 13";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png";s:12:"tmpl_created";s:10:"1532428699";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/header-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"200";s:11:"trend_index";s:1:"8";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:221;a:14:{s:2:"id";s:4:"4553";s:5:"title";s:10:"Pricing 10";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png";s:12:"tmpl_created";s:10:"1520443319";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/pricing-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"392";s:11:"trend_index";s:3:"379";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:222;a:14:{s:2:"id";s:4:"4562";s:5:"title";s:9:"Pricing 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png";s:12:"tmpl_created";s:10:"1520443322";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"422";s:11:"trend_index";s:3:"420";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:223;a:14:{s:2:"id";s:4:"4572";s:5:"title";s:10:"Pricing 11";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png";s:12:"tmpl_created";s:10:"1520443324";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/pricing-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"312";s:11:"trend_index";s:3:"327";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:224;a:14:{s:2:"id";s:4:"9174";s:5:"title";s:17:"single product 01";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png";s:12:"tmpl_created";s:10:"1532950125";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/single-product-01/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"425";s:11:"trend_index";s:3:"120";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:225;a:14:{s:2:"id";s:4:"4580";s:5:"title";s:10:"Pricing 12";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png";s:12:"tmpl_created";s:10:"1520443326";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/pricing-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"404";s:11:"trend_index";s:3:"366";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:226;a:14:{s:2:"id";s:4:"9178";s:5:"title";s:17:"single product 02";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350.png";s:12:"tmpl_created";s:10:"1532951997";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/single-product-02/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"431";s:11:"trend_index";s:3:"145";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:227;a:14:{s:2:"id";s:4:"4589";s:5:"title";s:9:"Pricing 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png";s:12:"tmpl_created";s:10:"1520443327";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"423";s:11:"trend_index";s:1:"0";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:228;a:14:{s:2:"id";s:4:"9180";s:5:"title";s:17:"single product 03";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png";s:12:"tmpl_created";s:10:"1532952302";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/single-product-03/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"429";s:11:"trend_index";s:3:"235";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:229;a:14:{s:2:"id";s:4:"4597";s:5:"title";s:10:"Pricing 13";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png";s:12:"tmpl_created";s:10:"1520443330";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/pricing-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"414";s:11:"trend_index";s:1:"0";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:230;a:14:{s:2:"id";s:4:"9182";s:5:"title";s:17:"single product 04";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png";s:12:"tmpl_created";s:10:"1532952606";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/single-product-04/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"433";s:11:"trend_index";s:3:"274";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:231;a:14:{s:2:"id";s:4:"4605";s:5:"title";s:9:"Pricing 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png";s:12:"tmpl_created";s:10:"1520443332";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/pricing-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"426";s:11:"trend_index";s:1:"0";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:232;a:14:{s:2:"id";s:4:"9239";s:5:"title";s:17:"product archive 1";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png";s:12:"tmpl_created";s:10:"1532953482";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/product-archive-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:15:"product archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"430";s:11:"trend_index";s:3:"256";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:233;a:14:{s:2:"id";s:4:"4613";s:5:"title";s:10:"Pricing 14";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png";s:12:"tmpl_created";s:10:"1520443334";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/pricing-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["pricing"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"400";s:11:"trend_index";s:1:"0";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:234;a:14:{s:2:"id";s:4:"9247";s:5:"title";s:17:"product archive 2";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png";s:12:"tmpl_created";s:10:"1532953793";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/product-archive-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:15:"product archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"428";s:11:"trend_index";s:3:"151";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:235;a:14:{s:2:"id";s:4:"9254";s:5:"title";s:17:"product archive 3";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png";s:12:"tmpl_created";s:10:"1532954032";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/product-archive-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:15:"product archive";s:4:"tags";s:2:"[]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"432";s:11:"trend_index";s:3:"278";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:236;a:14:{s:2:"id";s:4:"4690";s:5:"title";s:6:"Team 7";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png";s:12:"tmpl_created";s:10:"1520443348";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/team-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"259";s:11:"trend_index";s:3:"190";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:237;a:14:{s:2:"id";s:4:"4698";s:5:"title";s:7:"Team 15";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png";s:12:"tmpl_created";s:10:"1520443350";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"367";s:11:"trend_index";s:3:"337";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:238;a:14:{s:2:"id";s:4:"4706";s:5:"title";s:6:"Team 5";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png";s:12:"tmpl_created";s:10:"1520443352";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/team-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"155";s:11:"trend_index";s:3:"140";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:239;a:14:{s:2:"id";s:4:"4718";s:5:"title";s:6:"Team 4";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png";s:12:"tmpl_created";s:10:"1520443354";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/team-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"188";s:11:"trend_index";s:3:"195";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:240;a:14:{s:2:"id";s:4:"4727";s:5:"title";s:7:"Team 13";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png";s:12:"tmpl_created";s:10:"1520443356";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"347";s:11:"trend_index";s:3:"242";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:241;a:14:{s:2:"id";s:4:"4736";s:5:"title";s:7:"Team 20";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png";s:12:"tmpl_created";s:10:"1520443358";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"156";s:11:"trend_index";s:2:"81";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:242;a:14:{s:2:"id";s:4:"4746";s:5:"title";s:7:"Team 23";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png";s:12:"tmpl_created";s:10:"1520443360";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-23/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"267";s:11:"trend_index";s:3:"156";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:243;a:14:{s:2:"id";s:4:"4759";s:5:"title";s:7:"Team 22";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png";s:12:"tmpl_created";s:10:"1520443362";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-22/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"281";s:11:"trend_index";s:3:"214";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:244;a:14:{s:2:"id";s:4:"4770";s:5:"title";s:7:"Team 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png";s:12:"tmpl_created";s:10:"1520443364";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/team-12-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"334";s:11:"trend_index";s:3:"313";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:245;a:14:{s:2:"id";s:4:"4781";s:5:"title";s:7:"Team 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png";s:12:"tmpl_created";s:10:"1520443365";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"238";s:11:"trend_index";s:3:"203";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:246;a:14:{s:2:"id";s:4:"4793";s:5:"title";s:7:"Team 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png";s:12:"tmpl_created";s:10:"1520443367";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"224";s:11:"trend_index";s:3:"159";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:247;a:14:{s:2:"id";s:4:"4801";s:5:"title";s:7:"Team 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png";s:12:"tmpl_created";s:10:"1520443369";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"323";s:11:"trend_index";s:3:"228";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:248;a:14:{s:2:"id";s:4:"4809";s:5:"title";s:7:"Team 19";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png";s:12:"tmpl_created";s:10:"1520443371";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"276";s:11:"trend_index";s:3:"217";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:249;a:14:{s:2:"id";s:4:"4818";s:5:"title";s:7:"Team 21";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png";s:12:"tmpl_created";s:10:"1520443373";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/team-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["team"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"378";s:11:"trend_index";s:3:"322";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:250;a:14:{s:2:"id";s:4:"5045";s:5:"title";s:11:"Portfolio 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png";s:12:"tmpl_created";s:10:"1520443423";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["portfolio"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"405";s:11:"trend_index";s:3:"403";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:251;a:14:{s:2:"id";s:4:"5157";s:5:"title";s:11:"Subscribe 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png";s:12:"tmpl_created";s:10:"1520443448";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/subscribe-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["form","subscribe"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"349";s:11:"trend_index";s:3:"294";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:252;a:14:{s:2:"id";s:4:"5165";s:5:"title";s:11:"Subscribe 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png";s:12:"tmpl_created";s:10:"1520443450";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/subscribe-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["form","subscribe"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"403";s:11:"trend_index";s:3:"367";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:253;a:14:{s:2:"id";s:4:"5173";s:5:"title";s:11:"Subscribe 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png";s:12:"tmpl_created";s:10:"1520443452";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/subscribe-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["form","subscribe"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"293";s:11:"trend_index";s:3:"371";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:254;a:14:{s:2:"id";s:4:"5181";s:5:"title";s:11:"Subscribe 2";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png";s:12:"tmpl_created";s:10:"1520443454";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["form","subscribe"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"374";s:11:"trend_index";s:3:"351";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:255;a:14:{s:2:"id";s:4:"5189";s:5:"title";s:6:"CTA 29";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png";s:12:"tmpl_created";s:10:"1520443456";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-29/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"365";s:11:"trend_index";s:3:"374";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:256;a:14:{s:2:"id";s:4:"5198";s:5:"title";s:6:"CTA 30";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png";s:12:"tmpl_created";s:10:"1520443458";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-30/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"394";s:11:"trend_index";s:3:"391";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:257;a:14:{s:2:"id";s:4:"5206";s:5:"title";s:6:"CTA 31";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png";s:12:"tmpl_created";s:10:"1520443459";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-31/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"406";s:11:"trend_index";s:3:"376";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:258;a:14:{s:2:"id";s:4:"5214";s:5:"title";s:10:"Contact 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png";s:12:"tmpl_created";s:10:"1520443462";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/contact-16-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["contact","form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"219";s:11:"trend_index";s:3:"149";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:259;a:14:{s:2:"id";s:4:"5222";s:5:"title";s:11:"Subscribe 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png";s:12:"tmpl_created";s:10:"1520443464";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/subscribe-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["form","subscribe"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"371";s:11:"trend_index";s:3:"347";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:260;a:14:{s:2:"id";s:4:"5230";s:5:"title";s:10:"Contact 17";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png";s:12:"tmpl_created";s:10:"1520443466";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/contact-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["contact","form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"333";s:11:"trend_index";s:3:"308";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:261;a:14:{s:2:"id";s:4:"5238";s:5:"title";s:7:"Hero 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png";s:12:"tmpl_created";s:10:"1520443468";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/hero-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"408";s:11:"trend_index";s:3:"422";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:262;a:14:{s:2:"id";s:4:"5249";s:5:"title";s:6:"CTA 32";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png";s:12:"tmpl_created";s:10:"1520443470";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/blocks/cta-32/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"383";s:11:"trend_index";s:3:"384";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:263;a:14:{s:2:"id";s:4:"5257";s:5:"title";s:10:"Contact 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png";s:12:"tmpl_created";s:10:"1520443472";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/contact-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"contact";s:4:"tags";s:8:"["form"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"368";s:11:"trend_index";s:3:"387";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:264;a:14:{s:2:"id";s:4:"5266";s:5:"title";s:9:"Clients 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png";s:12:"tmpl_created";s:10:"1520443474";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/clients-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"133";s:11:"trend_index";s:3:"152";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:265;a:14:{s:2:"id";s:4:"5275";s:5:"title";s:9:"Clients 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png";s:12:"tmpl_created";s:10:"1520443476";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/clients-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"330";s:11:"trend_index";s:3:"321";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:266;a:14:{s:2:"id";s:4:"5283";s:5:"title";s:9:"Clients 1";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png";s:12:"tmpl_created";s:10:"1520443478";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/clients-1-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"307";s:11:"trend_index";s:3:"209";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:267;a:14:{s:2:"id";s:4:"5290";s:5:"title";s:9:"Clients 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png";s:12:"tmpl_created";s:10:"1520443480";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/clients-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"395";s:11:"trend_index";s:3:"415";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:268;a:14:{s:2:"id";s:4:"5298";s:5:"title";s:10:"Clients 15";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png";s:12:"tmpl_created";s:10:"1520443482";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/clients-15/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"373";s:11:"trend_index";s:3:"359";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:269;a:14:{s:2:"id";s:4:"5306";s:5:"title";s:10:"Clients 10";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png";s:12:"tmpl_created";s:10:"1520443484";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/clients-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"418";s:11:"trend_index";s:3:"419";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:270;a:14:{s:2:"id";s:4:"5315";s:5:"title";s:10:"Clients 12";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png";s:12:"tmpl_created";s:10:"1520443486";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/clients-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"385";s:11:"trend_index";s:3:"380";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:271;a:14:{s:2:"id";s:4:"5324";s:5:"title";s:9:"Clients 8";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png";s:12:"tmpl_created";s:10:"1520443488";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/clients-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"390";s:11:"trend_index";s:1:"0";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:272;a:14:{s:2:"id";s:4:"5333";s:5:"title";s:10:"Clients 13";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png";s:12:"tmpl_created";s:10:"1520443489";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/clients-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"252";s:11:"trend_index";s:3:"249";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:273;a:14:{s:2:"id";s:4:"5341";s:5:"title";s:10:"Clients 11";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png";s:12:"tmpl_created";s:10:"1520443491";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/clients-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"407";s:11:"trend_index";s:3:"423";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:274;a:14:{s:2:"id";s:4:"5349";s:5:"title";s:9:"Clients 7";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png";s:12:"tmpl_created";s:10:"1520443493";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/clients-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"243";s:11:"trend_index";s:3:"204";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:275;a:14:{s:2:"id";s:4:"5357";s:5:"title";s:9:"Clients 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png";s:12:"tmpl_created";s:10:"1520443495";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/clients-2-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"304";s:11:"trend_index";s:3:"297";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:276;a:14:{s:2:"id";s:4:"5368";s:5:"title";s:9:"Clients 9";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png";s:12:"tmpl_created";s:10:"1520443497";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/clients-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"248";s:11:"trend_index";s:3:"139";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:277;a:14:{s:2:"id";s:4:"5381";s:5:"title";s:10:"Clients 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png";s:12:"tmpl_created";s:10:"1520443499";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/clients-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"210";s:11:"trend_index";s:3:"154";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:278;a:14:{s:2:"id";s:4:"5389";s:5:"title";s:10:"Clients 14";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png";s:12:"tmpl_created";s:10:"1520443501";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/blocks/clients-14/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["clients"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"361";s:11:"trend_index";s:3:"263";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:279;a:14:{s:2:"id";s:4:"5397";s:5:"title";s:8:"About 11";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png";s:12:"tmpl_created";s:10:"1520443503";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-11/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"139";s:11:"trend_index";s:2:"85";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:280;a:14:{s:2:"id";s:4:"5405";s:5:"title";s:8:"About 12";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png";s:12:"tmpl_created";s:10:"1520443505";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-12/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"228";s:11:"trend_index";s:3:"182";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:281;a:14:{s:2:"id";s:4:"5413";s:5:"title";s:8:"About 21";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png";s:12:"tmpl_created";s:10:"1520443507";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-21/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"138";s:11:"trend_index";s:2:"90";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:282;a:14:{s:2:"id";s:4:"5421";s:5:"title";s:8:"About 13";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png";s:12:"tmpl_created";s:10:"1520443509";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-13/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"256";s:11:"trend_index";s:3:"223";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:283;a:14:{s:2:"id";s:4:"5429";s:5:"title";s:8:"About 16";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png";s:12:"tmpl_created";s:10:"1520443510";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-16/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"117";s:11:"trend_index";s:3:"106";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:284;a:14:{s:2:"id";s:4:"5438";s:5:"title";s:7:"About 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png";s:12:"tmpl_created";s:10:"1520443512";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/about-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"237";s:11:"trend_index";s:3:"202";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:285;a:14:{s:2:"id";s:4:"5447";s:5:"title";s:7:"About 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png";s:12:"tmpl_created";s:10:"1520443514";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/about-3-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"78";s:11:"trend_index";s:2:"55";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:286;a:14:{s:2:"id";s:4:"5455";s:5:"title";s:8:"About 20";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png";s:12:"tmpl_created";s:10:"1520443516";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-20/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"130";s:11:"trend_index";s:3:"148";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:287;a:14:{s:2:"id";s:4:"5464";s:5:"title";s:8:"About 17";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png";s:12:"tmpl_created";s:10:"1520443518";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-17/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"233";s:11:"trend_index";s:3:"162";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:288;a:14:{s:2:"id";s:4:"5472";s:5:"title";s:7:"About 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png";s:12:"tmpl_created";s:10:"1520443520";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/about-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"208";s:11:"trend_index";s:3:"208";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:289;a:14:{s:2:"id";s:4:"5480";s:5:"title";s:7:"About 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png";s:12:"tmpl_created";s:10:"1520443522";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blocks/about-4-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"359";s:11:"trend_index";s:3:"302";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:290;a:14:{s:2:"id";s:4:"5488";s:5:"title";s:7:"About 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png";s:12:"tmpl_created";s:10:"1520443524";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/about-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"298";s:11:"trend_index";s:3:"267";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:291;a:14:{s:2:"id";s:4:"5496";s:5:"title";s:7:"About 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png";s:12:"tmpl_created";s:10:"1520443526";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/blocks/about-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"389";s:11:"trend_index";s:3:"396";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:292;a:14:{s:2:"id";s:4:"5504";s:5:"title";s:8:"About 18";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png";s:12:"tmpl_created";s:10:"1520443528";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-18/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:2:"91";s:11:"trend_index";s:2:"67";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:293;a:14:{s:2:"id";s:4:"5515";s:5:"title";s:8:"About 19";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png";s:12:"tmpl_created";s:10:"1520443530";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/blocks/about-19/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";s:1:"0";s:16:"popularity_index";s:3:"262";s:11:"trend_index";s:3:"233";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:294;a:14:{s:2:"id";s:4:"9139";s:5:"title";s:25:"Homepage &#8211; Business";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/07/Get_Started_250.png";s:12:"tmpl_created";s:10:"1532949924";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/homepage-business/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:167:"["Agency","bootstrap","business","corporate","Landing Page","marketing campaign","marketing landing page","product launch","software","Startup","startup landing page"]";s:10:"menu_order";s:2:"14";s:16:"popularity_index";s:2:"72";s:11:"trend_index";s:1:"2";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:295;a:14:{s:2:"id";s:3:"147";s:5:"title";s:20:"Homepage &#8211; App";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0004.png";s:12:"tmpl_created";s:10:"1470829868";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/homepage-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["App","Homepage"]";s:10:"menu_order";s:2:"15";s:16:"popularity_index";s:1:"1";s:11:"trend_index";s:1:"1";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:296;a:14:{s:2:"id";s:4:"2402";s:5:"title";s:32:"Homepage &#8211; Interior Design";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2017/09/Interior.png";s:12:"tmpl_created";s:10:"1506441447";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/homepage-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:193:"["Architecture","building","business","Creative","exterior design","furniture design","Gallery","garden design","house","interior design","landscape design","multipurpose","portfolio","studio"]";s:10:"menu_order";s:2:"16";s:16:"popularity_index";s:2:"42";s:11:"trend_index";s:2:"40";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:297;a:14:{s:2:"id";s:3:"777";s:5:"title";s:28:"Homepage &#8211; Coffee Shop";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/01/rest-home.jpg";s:12:"tmpl_created";s:10:"1485273092";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/homepage-coffee-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:41:"["Coffee","Homepage","Restaurant","Shop"]";s:10:"menu_order";s:2:"17";s:16:"popularity_index";s:2:"46";s:11:"trend_index";s:3:"101";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:298;a:14:{s:2:"id";s:4:"2404";s:5:"title";s:24:"Homepage &#8211; Product";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2017/09/product.png";s:12:"tmpl_created";s:10:"1506441452";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/homepage-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:103:"["business","colorful","ecommerce","flat","mobile","modern","responsive","retina","Shop","woocommerce"]";s:10:"menu_order";s:2:"18";s:16:"popularity_index";s:2:"54";s:11:"trend_index";s:3:"121";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:299;a:14:{s:2:"id";s:3:"492";s:5:"title";s:25:"Homepage &#8211; Law firm";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/10/0024.png";s:12:"tmpl_created";s:10:"1477388365";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/homepage-law-firm/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:25:"["Firm","Homepage","Law"]";s:10:"menu_order";s:2:"19";s:16:"popularity_index";s:1:"7";s:11:"trend_index";s:1:"7";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:300;a:14:{s:2:"id";s:3:"225";s:5:"title";s:27:"Homepage &#8211; Restaurant";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0016.png";s:12:"tmpl_created";s:10:"1470829872";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/homepage-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Homepage","Restaurant"]";s:10:"menu_order";s:2:"20";s:16:"popularity_index";s:1:"2";s:11:"trend_index";s:1:"4";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:301;a:14:{s:2:"id";s:4:"3451";s:5:"title";s:39:"Homepage &#8211; Goodness meal services";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2017/11/goodness-featured-image.png";s:12:"tmpl_created";s:10:"1512054116";s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/homepage-goodness-meal-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"21";s:16:"popularity_index";s:2:"89";s:11:"trend_index";s:3:"201";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:302;a:14:{s:2:"id";s:4:"2152";s:5:"title";s:26:"Homepage &#8211; Cake Shop";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/07/cake-home.png";s:12:"tmpl_created";s:10:"1499774132";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/homepage-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Cake","Homepage","Restaurant","Shop"]";s:10:"menu_order";s:2:"22";s:16:"popularity_index";s:3:"150";s:11:"trend_index";s:3:"261";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:303;a:14:{s:2:"id";s:4:"1068";s:5:"title";s:27:"Homepage &#8211; Copywriter";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2017/03/copywriter.png";s:12:"tmpl_created";s:10:"1488805928";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/homepage-copywriter/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:25:"["Copywriter","Homepage"]";s:10:"menu_order";s:2:"23";s:16:"popularity_index";s:2:"68";s:11:"trend_index";s:3:"117";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:304;a:14:{s:2:"id";s:3:"181";s:5:"title";s:23:"Homepage &#8211; Agency";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0019.png";s:12:"tmpl_created";s:10:"1470826567";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/homepage-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Agency","Creative","Homepage"]";s:10:"menu_order";s:2:"24";s:16:"popularity_index";s:1:"3";s:11:"trend_index";s:1:"6";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:305;a:14:{s:2:"id";s:3:"463";s:5:"title";s:22:"Homepage &#8211; Study";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/10/0022.png";s:12:"tmpl_created";s:10:"1477388340";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/homepage-study/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Education","Homepage","Study"]";s:10:"menu_order";s:2:"25";s:16:"popularity_index";s:1:"5";s:11:"trend_index";s:1:"3";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:306;a:14:{s:2:"id";s:4:"2813";s:5:"title";s:32:"Homepage &#8211; Creative Agency";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2017/11/Creative-Agency-–-Home-Page.png";s:12:"tmpl_created";s:10:"1509615049";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/homepage-creative-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Agency","Creative","Homepage"]";s:10:"menu_order";s:2:"26";s:16:"popularity_index";s:2:"48";s:11:"trend_index";s:2:"58";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:307;a:14:{s:2:"id";s:3:"728";s:5:"title";s:33:"Homepage &#8211; Delivery Company";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2017/01/delivery-company-home-page.jpg";s:12:"tmpl_created";s:10:"1485269993";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/homepage-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Delivery","Homepage"]";s:10:"menu_order";s:2:"27";s:16:"popularity_index";s:2:"82";s:11:"trend_index";s:3:"167";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:308;a:14:{s:2:"id";s:4:"2403";s:5:"title";s:29:"Homepage &#8211; Luxury Hotel";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2017/09/Hotel.png";s:12:"tmpl_created";s:10:"1506441428";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/homepage-luxury-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"28";s:16:"popularity_index";s:3:"112";s:11:"trend_index";s:3:"186";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:309;a:14:{s:2:"id";s:3:"519";s:5:"title";s:24:"Homepage &#8211; Fitness";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/10/0023.png";s:12:"tmpl_created";s:10:"1477388808";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/homepage-fitness/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:45:"["Fitness","Gym","Health","Homepage","Sport"]";s:10:"menu_order";s:2:"29";s:16:"popularity_index";s:1:"6";s:11:"trend_index";s:2:"15";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:310;a:14:{s:2:"id";s:4:"1903";s:5:"title";s:20:"One Page &#8211; Spa";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2017/06/spa.png";s:12:"tmpl_created";s:10:"1496822325";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/one-page-spa/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:132:"["beauty","care","girly","hair","Health","hospitality","massage","medical","parlor","physiotherapy","salon","spa","wellness","yoga"]";s:10:"menu_order";s:2:"30";s:16:"popularity_index";s:2:"71";s:11:"trend_index";s:2:"93";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:311;a:14:{s:2:"id";s:4:"2123";s:5:"title";s:33:"One Page &#8211; Architect Office";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/06/architect.png";s:12:"tmpl_created";s:10:"1499772989";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/one-page-architect-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"31";s:16:"popularity_index";s:1:"8";s:11:"trend_index";s:1:"9";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:312;a:14:{s:2:"id";s:4:"1888";s:5:"title";s:32:"One Page &#8211; Creative Meetup";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2017/06/creative-meetup.png";s:12:"tmpl_created";s:10:"1496822319";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/one-page-creative-meetup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"32";s:16:"popularity_index";s:2:"90";s:11:"trend_index";s:3:"224";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:313;a:14:{s:2:"id";s:4:"1880";s:5:"title";s:24:"One Page &#8211; Wedding";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2017/06/wedding.png";s:12:"tmpl_created";s:10:"1496822317";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/one-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:82:"["bride","ceremony","cute","event","fancy","girly","groom","guestbook","marriage"]";s:10:"menu_order";s:2:"33";s:16:"popularity_index";s:3:"264";s:11:"trend_index";s:3:"325";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:314;a:14:{s:2:"id";s:4:"1891";s:5:"title";s:35:"One Page &#8211; Textile Convention";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2017/06/textile-meetup.png";s:12:"tmpl_created";s:10:"1496822323";s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/one-page-textile-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"34";s:16:"popularity_index";s:3:"216";s:11:"trend_index";s:3:"273";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:315;a:14:{s:2:"id";s:4:"1885";s:5:"title";s:29:"One Page &#8211; Yacht Rental";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2017/06/yacht-home.png";s:12:"tmpl_created";s:10:"1496822321";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/one-page-yacht-rental/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"35";s:16:"popularity_index";s:2:"76";s:11:"trend_index";s:3:"124";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:316;a:14:{s:2:"id";s:4:"2723";s:5:"title";s:34:"Portfolio &#8211; Graphic Designer";s:9:"thumbnail";s:91:"https://library.elementor.com/wp-content/uploads/2017/11/Graphic-Designer-–-Portfolio.png";s:12:"tmpl_created";s:10:"1509633883";s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/portfolio-graphic-designer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"36";s:16:"popularity_index";s:2:"84";s:11:"trend_index";s:2:"94";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:317;a:14:{s:2:"id";s:4:"2145";s:5:"title";s:30:"About &#8211; Delivery Company";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2017/07/delivery-about.png";s:12:"tmpl_created";s:10:"1499774125";s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/about-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:10:"["moving"]";s:10:"menu_order";s:2:"37";s:16:"popularity_index";s:3:"171";s:11:"trend_index";s:3:"275";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:318;a:14:{s:2:"id";s:4:"2155";s:5:"title";s:23:"About &#8211; Cake Shop";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2017/07/cake-about.png";s:12:"tmpl_created";s:10:"1499774130";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/about-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:8:"["Food"]";s:10:"menu_order";s:2:"38";s:16:"popularity_index";s:3:"242";s:11:"trend_index";s:3:"281";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:319;a:14:{s:2:"id";s:4:"1085";s:5:"title";s:21:"About &#8211; Startup";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2017/03/Startup.png";s:12:"tmpl_created";s:10:"1488810874";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/about-startup/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:19:"["About","Startup"]";s:10:"menu_order";s:2:"39";s:16:"popularity_index";s:1:"4";s:11:"trend_index";s:1:"5";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:320;a:14:{s:2:"id";s:3:"143";s:5:"title";s:22:"About &#8211; Personal";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0010.png";s:12:"tmpl_created";s:10:"1470820447";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/about-personal/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:20:"["About","Personal"]";s:10:"menu_order";s:2:"40";s:16:"popularity_index";s:2:"15";s:11:"trend_index";s:2:"19";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:321;a:14:{s:2:"id";s:3:"101";s:5:"title";s:16:"About &#8211; CV";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0018.png";s:12:"tmpl_created";s:10:"1470829785";s:6:"author";s:9:"Elementor";s:3:"url";s:98:"https://library.elementor.com/about-cv/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:77:"["creative portfolio","Personal","portfolio","professional","resume","vcard"]";s:10:"menu_order";s:2:"41";s:16:"popularity_index";s:2:"21";s:11:"trend_index";s:2:"42";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:322;a:14:{s:2:"id";s:3:"140";s:5:"title";s:25:"About &#8211; Art Gallery";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0009.png";s:12:"tmpl_created";s:10:"1470820463";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/about-art-gallery/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:25:"["About","Art","Gallery"]";s:10:"menu_order";s:2:"42";s:16:"popularity_index";s:2:"11";s:11:"trend_index";s:2:"16";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:323;a:14:{s:2:"id";s:3:"213";s:5:"title";s:26:"About &#8211; Architecture";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0008.png";s:12:"tmpl_created";s:10:"1470829766";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/about-architecture/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:24:"["About","Architecture"]";s:10:"menu_order";s:2:"43";s:16:"popularity_index";s:2:"13";s:11:"trend_index";s:2:"13";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:324;a:14:{s:2:"id";s:4:"2802";s:5:"title";s:38:"Portfolio &#8211; Fashion Photographer";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2017/11/Fashion-photographer-–-Portfolio.png";s:12:"tmpl_created";s:10:"1509615440";s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/portfolio-fashion-photographer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"44";s:16:"popularity_index";s:3:"114";s:11:"trend_index";s:3:"176";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:325;a:14:{s:2:"id";s:4:"2828";s:5:"title";s:35:"Landing Page &#8211; Law Convention";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2017/11/Law-Convention-–-Landing-Page.png";s:12:"tmpl_created";s:10:"1509631636";s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/landing-page-law-convention/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:35:"["Convention","Landing Page","Law"]";s:10:"menu_order";s:2:"45";s:16:"popularity_index";s:3:"198";s:11:"trend_index";s:3:"341";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:326;a:14:{s:2:"id";s:4:"1461";s:5:"title";s:28:"Landing Page &#8211; Ebook 1";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-1.png";s:12:"tmpl_created";s:10:"1494352121";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-ebook-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:127:"["App","author","book","brochure","download","e-book","ebook","marketing","product","publisher","sell online","seo","showcase"]";s:10:"menu_order";s:2:"46";s:16:"popularity_index";s:3:"165";s:11:"trend_index";s:3:"328";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:327;a:14:{s:2:"id";s:4:"1460";s:5:"title";s:28:"Landing Page &#8211; Ebook 2";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-2.png";s:12:"tmpl_created";s:10:"1494352124";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-ebook-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"47";s:16:"popularity_index";s:3:"162";s:11:"trend_index";s:3:"290";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:328;a:14:{s:2:"id";s:4:"1459";s:5:"title";s:28:"Landing Page &#8211; Ebook 3";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Ebook-3.png";s:12:"tmpl_created";s:10:"1494352125";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-ebook-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"48";s:16:"popularity_index";s:3:"115";s:11:"trend_index";s:3:"245";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:329;a:14:{s:2:"id";s:4:"1052";s:5:"title";s:33:"Landing Page &#8211; Mobile App 1";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2017/03/app.png";s:12:"tmpl_created";s:10:"1488810873";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/landing-page-mobile-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"49";s:16:"popularity_index";s:2:"19";s:11:"trend_index";s:2:"21";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:330;a:14:{s:2:"id";s:4:"1503";s:5:"title";s:33:"Landing Page &#8211; Mobile App 2";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app1.png";s:12:"tmpl_created";s:10:"1494352113";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-mobile-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"50";s:16:"popularity_index";s:3:"120";s:11:"trend_index";s:3:"165";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:331;a:14:{s:2:"id";s:4:"1504";s:5:"title";s:33:"Landing Page &#8211; Mobile App 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app2.png";s:12:"tmpl_created";s:10:"1494352112";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-mobile-app-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"51";s:16:"popularity_index";s:3:"128";s:11:"trend_index";s:3:"175";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:332;a:14:{s:2:"id";s:4:"1505";s:5:"title";s:33:"Landing Page &#8211; Mobile App 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-app3.png";s:12:"tmpl_created";s:10:"1494352110";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-mobile-app-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"52";s:16:"popularity_index";s:3:"212";s:11:"trend_index";s:3:"258";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:333;a:14:{s:2:"id";s:3:"726";s:5:"title";s:33:"Landing Page &#8211; Conference 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2017/01/convention-landing-page.jpg";s:12:"tmpl_created";s:10:"1485270062";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/landing-page-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"53";s:16:"popularity_index";s:3:"230";s:11:"trend_index";s:3:"373";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:334;a:14:{s:2:"id";s:4:"1613";s:5:"title";s:33:"Landing Page &#8211; Conference 2";s:9:"thumbnail";s:109:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-International-Womens-Day-Conference.png";s:12:"tmpl_created";s:10:"1494352129";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-conference-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"54";s:16:"popularity_index";s:3:"261";s:11:"trend_index";s:3:"317";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:335;a:14:{s:2:"id";s:4:"1612";s:5:"title";s:33:"Landing Page &#8211; Conference 3";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Tech-Conference.png";s:12:"tmpl_created";s:10:"1494352127";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-conference-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"55";s:16:"popularity_index";s:3:"271";s:11:"trend_index";s:3:"295";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:336;a:14:{s:2:"id";s:4:"1614";s:5:"title";s:33:"Landing Page &#8211; Conference 4";s:9:"thumbnail";s:99:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Sustainability-Conference.png";s:12:"tmpl_created";s:10:"1494352131";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-conference-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"56";s:16:"popularity_index";s:3:"182";s:11:"trend_index";s:3:"334";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:337;a:14:{s:2:"id";s:3:"906";s:5:"title";s:29:"Landing Page &#8211;  Coacher";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2017/02/Landin-Page-Coacher.png";s:12:"tmpl_created";s:10:"1494352066";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-coacher/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"57";s:16:"popularity_index";s:2:"96";s:11:"trend_index";s:3:"181";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:338;a:14:{s:2:"id";s:3:"955";s:5:"title";s:31:"Landing Page &#8211; Law Office";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Law-Office.png";s:12:"tmpl_created";s:10:"1494352069";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/landing-page-law-office/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:31:"["Landing Page","Law","Office"]";s:10:"menu_order";s:2:"58";s:16:"popularity_index";s:3:"106";s:11:"trend_index";s:3:"285";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:339;a:14:{s:2:"id";s:3:"879";s:5:"title";s:41:"Landing Page &#8211; Financial Consultant";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Financial-consultant.png";s:12:"tmpl_created";s:10:"1494352064";s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/landing-page-financial-consultant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"59";s:16:"popularity_index";s:3:"116";s:11:"trend_index";s:3:"168";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:340;a:14:{s:2:"id";s:3:"926";s:5:"title";s:33:"Landing Page &#8211; Private Chef";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Private-Chef.png";s:12:"tmpl_created";s:10:"1494352068";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-private-chef/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"60";s:16:"popularity_index";s:3:"213";s:11:"trend_index";s:3:"304";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:341;a:14:{s:2:"id";s:3:"855";s:5:"title";s:37:"Landing Page &#8211; Personal Trainer";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2017/02/Landing-Page-Personal-Trainer.png";s:12:"tmpl_created";s:10:"1494352061";s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/landing-page-personal-trainer/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"61";s:16:"popularity_index";s:3:"192";s:11:"trend_index";s:3:"277";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:342;a:14:{s:2:"id";s:3:"974";s:5:"title";s:28:"Landing Page &#8211; Stylist";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2017/03/Landing-Page-Stylist.png";s:12:"tmpl_created";s:10:"1494352071";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-stylist/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:146:"["cosmetics","fashion","girly","hairdresser","lifestyle","makeup","manicure","pedicure","products","salon","Shop","skincare","stylist","wellness"]";s:10:"menu_order";s:2:"62";s:16:"popularity_index";s:3:"229";s:11:"trend_index";s:3:"306";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:343;a:14:{s:2:"id";s:4:"1032";s:5:"title";s:27:"Landing Page &#8211; Agency";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2017/03/Agency.png";s:12:"tmpl_created";s:10:"1488810866";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/landing-page-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"63";s:16:"popularity_index";s:3:"190";s:11:"trend_index";s:3:"248";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:344;a:14:{s:2:"id";s:4:"1634";s:5:"title";s:33:"Landing Page &#8211; Chiropractor";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Chiropractor.png";s:12:"tmpl_created";s:10:"1494352119";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/landing-page-chiropractor/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"64";s:16:"popularity_index";s:3:"194";s:11:"trend_index";s:3:"179";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:345;a:14:{s:2:"id";s:3:"730";s:5:"title";s:24:"Landing Page &#8211; App";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2017/01/app.-landing-page.jpg";s:12:"tmpl_created";s:10:"1485273430";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/landing-page-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"65";s:16:"popularity_index";s:3:"174";s:11:"trend_index";s:3:"262";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:346;a:14:{s:2:"id";s:3:"643";s:5:"title";s:29:"Landing Page &#8211; Festival";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2016/12/festival.jpg";s:12:"tmpl_created";s:10:"1481549290";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/landing-page-festival/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"66";s:16:"popularity_index";s:3:"191";s:11:"trend_index";s:3:"315";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:347;a:14:{s:2:"id";s:3:"487";s:5:"title";s:29:"Landing Page &#8211; Vacation";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/10/0021.png";s:12:"tmpl_created";s:10:"1477388357";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/landing-page-vacation/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"67";s:16:"popularity_index";s:2:"22";s:11:"trend_index";s:2:"26";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:348;a:14:{s:2:"id";s:3:"542";s:5:"title";s:28:"Landing Page &#8211; Wedding";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/10/0025.png";s:12:"tmpl_created";s:10:"1477388484";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-wedding/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"68";s:16:"popularity_index";s:2:"32";s:11:"trend_index";s:2:"65";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:349;a:14:{s:2:"id";s:4:"1187";s:5:"title";s:32:"Landing Page &#8211; Photography";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2017/03/lp1-l.png";s:12:"tmpl_created";s:10:"1490707385";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/landing-page-photography/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"69";s:16:"popularity_index";s:2:"24";s:11:"trend_index";s:2:"59";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:350;a:14:{s:2:"id";s:3:"641";s:5:"title";s:28:"Landing Page &#8211; Fashion";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2016/12/fashion-landing-page.jpg";s:12:"tmpl_created";s:10:"1481549264";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-fashion/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"70";s:16:"popularity_index";s:3:"118";s:11:"trend_index";s:3:"253";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:351;a:14:{s:2:"id";s:3:"189";s:5:"title";s:30:"Landing Page &#8211; Tourism 1";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0005.png";s:12:"tmpl_created";s:10:"1470820715";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-tourism/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"71";s:16:"popularity_index";s:1:"9";s:11:"trend_index";s:2:"11";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:352;a:14:{s:2:"id";s:4:"1547";s:5:"title";s:30:"Landing Page &#8211; Tourism 2";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-1.png";s:12:"tmpl_created";s:10:"1494352115";s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/landing-page-tourism-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"72";s:16:"popularity_index";s:3:"184";s:11:"trend_index";s:3:"220";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:353;a:14:{s:2:"id";s:4:"1546";s:5:"title";s:30:"Landing Page &#8211; Tourism 3";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-2.png";s:12:"tmpl_created";s:10:"1494352116";s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/landing-page-tourism-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"73";s:16:"popularity_index";s:3:"269";s:11:"trend_index";s:3:"389";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:354;a:14:{s:2:"id";s:4:"1545";s:5:"title";s:30:"Landing Page &#8211; Tourism 4";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Truism-3.png";s:12:"tmpl_created";s:10:"1494352118";s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/landing-page-tourism-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"74";s:16:"popularity_index";s:3:"221";s:11:"trend_index";s:3:"260";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:355;a:14:{s:2:"id";s:4:"2714";s:5:"title";s:30:"Landing Page &#8211; Tourism 5";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2017/11/Vacation-–-Landing-Page.png";s:12:"tmpl_created";s:10:"1509631782";s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/landing-page-tourism-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"75";s:16:"popularity_index";s:3:"241";s:11:"trend_index";s:3:"365";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:356;a:14:{s:2:"id";s:4:"1190";s:5:"title";s:26:"Landing Page &#8211; Hotel";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2017/03/lp2-l.png";s:12:"tmpl_created";s:10:"1490707391";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/landing-page-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"76";s:16:"popularity_index";s:2:"20";s:11:"trend_index";s:2:"28";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:357;a:14:{s:2:"id";s:3:"195";s:5:"title";s:28:"Landing Page &#8211; Product";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0006.png";s:12:"tmpl_created";s:10:"1470820765";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-product/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"77";s:16:"popularity_index";s:2:"23";s:11:"trend_index";s:2:"36";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:358;a:14:{s:2:"id";s:3:"197";s:5:"title";s:34:"Landing Page &#8211; Real Estate 1";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0007.png";s:12:"tmpl_created";s:10:"1470825711";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/landing-page-real-estate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"78";s:16:"popularity_index";s:2:"41";s:11:"trend_index";s:3:"196";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:359;a:14:{s:2:"id";s:4:"1193";s:5:"title";s:34:"Landing Page &#8211; Real Estate 2";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png";s:12:"tmpl_created";s:10:"1490707422";s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/landing-page-real-estate-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"79";s:16:"popularity_index";s:2:"29";s:11:"trend_index";s:2:"80";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:360;a:14:{s:2:"id";s:4:"1415";s:5:"title";s:34:"Landing Page &#8211; Real Estate 3";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-1.png";s:12:"tmpl_created";s:10:"1494352106";s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/landing-page-real-estate-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"80";s:16:"popularity_index";s:3:"211";s:11:"trend_index";s:3:"345";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:361;a:14:{s:2:"id";s:4:"1414";s:5:"title";s:34:"Landing Page &#8211; Real Estate 4";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-2.png";s:12:"tmpl_created";s:10:"1494352107";s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/landing-page-real-estate-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"81";s:16:"popularity_index";s:3:"325";s:11:"trend_index";s:3:"342";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:362;a:14:{s:2:"id";s:4:"1413";s:5:"title";s:34:"Landing Page &#8211; Real Estate 5";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2017/05/Landing-Page-Real-Estate-3.png";s:12:"tmpl_created";s:10:"1494352109";s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/landing-page-real-estate-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:134:"["Agent","business","clean","corporate","flat","google maps","homes","listing","modern","real estate","realestate","realtor","realty"]";s:10:"menu_order";s:2:"82";s:16:"popularity_index";s:3:"285";s:11:"trend_index";s:3:"163";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:363;a:14:{s:2:"id";s:4:"1573";s:5:"title";s:29:"Landing Page &#8211; Coupon 1";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-02.png";s:12:"tmpl_created";s:10:"1494352133";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/landing-page-coupon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"83";s:16:"popularity_index";s:3:"309";s:11:"trend_index";s:3:"404";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:364;a:14:{s:2:"id";s:4:"1572";s:5:"title";s:29:"Landing Page &#8211; Coupon 2";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-03.png";s:12:"tmpl_created";s:10:"1494352134";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/landing-page-coupon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"84";s:16:"popularity_index";s:3:"337";s:11:"trend_index";s:3:"400";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:365;a:14:{s:2:"id";s:4:"1570";s:5:"title";s:29:"Landing Page &#8211; Coupon 3";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-01.png";s:12:"tmpl_created";s:10:"1494352136";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/landing-page-coupon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"85";s:16:"popularity_index";s:3:"375";s:11:"trend_index";s:3:"418";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:366;a:14:{s:2:"id";s:4:"1571";s:5:"title";s:29:"Landing Page &#8211; Coupon 4";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/05/Coupon-04.png";s:12:"tmpl_created";s:10:"1494352138";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/landing-page-coupon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"86";s:16:"popularity_index";s:3:"338";s:11:"trend_index";s:3:"398";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:367;a:14:{s:2:"id";s:3:"192";s:5:"title";s:28:"Landing Page &#8211; Webinar";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0015.png";s:12:"tmpl_created";s:10:"1470820734";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/landing-page-webinar/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"87";s:16:"popularity_index";s:2:"34";s:11:"trend_index";s:2:"84";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:368;a:14:{s:2:"id";s:4:"2141";s:5:"title";s:32:"Contact &#8211; Delivery Company";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2017/07/delivery-contact.png";s:12:"tmpl_created";s:10:"1499774122";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/contact-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"88";s:16:"popularity_index";s:3:"170";s:11:"trend_index";s:3:"296";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:369;a:14:{s:2:"id";s:3:"137";s:5:"title";s:22:"Contact &#8211; Modern";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0013.png";s:12:"tmpl_created";s:10:"1470829828";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/contact-modern/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"89";s:16:"popularity_index";s:2:"25";s:11:"trend_index";s:2:"63";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:370;a:14:{s:2:"id";s:3:"256";s:5:"title";s:26:"Contact &#8211; Restaurant";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0011.png";s:12:"tmpl_created";s:10:"1470829796";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/contact-restaurant/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"90";s:16:"popularity_index";s:2:"45";s:11:"trend_index";s:3:"109";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:371;a:14:{s:2:"id";s:4:"2150";s:5:"title";s:25:"Contact &#8211; Cake Shop";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2017/07/cake-contact.png";s:12:"tmpl_created";s:10:"1499774127";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/contact-cake-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"91";s:16:"popularity_index";s:2:"38";s:11:"trend_index";s:2:"43";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:372;a:14:{s:2:"id";s:3:"223";s:5:"title";s:21:"Contact &#8211; Hotel";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0002.png";s:12:"tmpl_created";s:10:"1470820471";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/contact-hotel/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"92";s:16:"popularity_index";s:2:"43";s:11:"trend_index";s:2:"75";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:373;a:14:{s:2:"id";s:2:"24";s:5:"title";s:25:"Contact &#8211; Corporate";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0012.png";s:12:"tmpl_created";s:10:"1470248619";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/contact-corporate/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"93";s:16:"popularity_index";s:2:"10";s:11:"trend_index";s:2:"10";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:374;a:14:{s:2:"id";s:3:"184";s:5:"title";s:23:"Services &#8211; Moving";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0017.png";s:12:"tmpl_created";s:10:"1470829889";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/services-moving/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"94";s:16:"popularity_index";s:2:"17";s:11:"trend_index";s:2:"23";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:375;a:14:{s:2:"id";s:3:"625";s:5:"title";s:31:"Services &#8211; Cake Shop Menu";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2016/12/cake-shop-menu.jpg";s:12:"tmpl_created";s:10:"1481549196";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/services-cake-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"95";s:16:"popularity_index";s:3:"302";s:11:"trend_index";s:3:"401";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:376;a:14:{s:2:"id";s:3:"187";s:5:"title";s:20:"Services &#8211; Fun";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0001.png";s:12:"tmpl_created";s:10:"1470829892";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/services-fun/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"96";s:16:"popularity_index";s:2:"27";s:11:"trend_index";s:2:"56";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:377;a:14:{s:2:"id";s:3:"238";s:5:"title";s:27:"Services &#8211; Consulting";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0014.png";s:12:"tmpl_created";s:10:"1470829865";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/services-consulting/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"97";s:16:"popularity_index";s:2:"14";s:11:"trend_index";s:2:"24";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:378;a:14:{s:2:"id";s:3:"647";s:5:"title";s:33:"Services &#8211; Coffee Shop Menu";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2016/12/restaurant-menu.jpg";s:12:"tmpl_created";s:10:"1481549320";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/services-coffee-shop-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"98";s:16:"popularity_index";s:3:"263";s:11:"trend_index";s:3:"409";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:379;a:14:{s:2:"id";s:4:"2138";s:5:"title";s:33:"Services &#8211; Delivery Company";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2017/07/delivery-services.png";s:12:"tmpl_created";s:10:"1499774119";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/services-delivery-company/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:2:"99";s:16:"popularity_index";s:3:"246";s:11:"trend_index";s:3:"314";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:380;a:14:{s:2:"id";s:3:"823";s:5:"title";s:19:"Pricing &#8211; App";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2017/01/pricing-app.jpg";s:12:"tmpl_created";s:10:"1485272966";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/pricing-app-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"100";s:16:"popularity_index";s:3:"185";s:11:"trend_index";s:3:"293";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:381;a:14:{s:2:"id";s:3:"824";s:5:"title";s:24:"Pricing &#8211; Software";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2017/01/pricing-software.png";s:12:"tmpl_created";s:10:"1485272900";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/pricing-software-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"101";s:16:"popularity_index";s:3:"203";s:11:"trend_index";s:3:"331";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:382;a:14:{s:2:"id";s:3:"825";s:5:"title";s:24:"Product &#8211; Speakers";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2017/01/product-page.jpg";s:12:"tmpl_created";s:10:"1485272513";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/product-speakers/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"102";s:16:"popularity_index";s:3:"220";s:11:"trend_index";s:3:"369";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:383;a:14:{s:2:"id";s:3:"245";s:5:"title";s:21:"Product &#8211; Clean";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0020.png";s:12:"tmpl_created";s:10:"1470829876";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/product-clean/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:48:"["fast","minimal","minimalistic","seo","simple"]";s:10:"menu_order";s:3:"103";s:16:"popularity_index";s:2:"31";s:11:"trend_index";s:3:"107";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:384;a:14:{s:2:"id";s:3:"150";s:5:"title";s:19:"Product &#8211; App";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2016/08/0003.png";s:12:"tmpl_created";s:10:"1470829879";s:6:"author";s:9:"Elementor";s:3:"url";s:101:"https://library.elementor.com/product-app/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"104";s:16:"popularity_index";s:2:"18";s:11:"trend_index";s:2:"33";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:385;a:14:{s:2:"id";s:3:"751";s:5:"title";s:25:"Homepage &#8211; Interior";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/01/interior-home.png";s:12:"tmpl_created";s:10:"1485269743";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/homepage-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"105";s:16:"popularity_index";s:3:"159";s:11:"trend_index";s:3:"303";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:386;a:14:{s:2:"id";s:3:"753";s:5:"title";s:22:"About &#8211; Interior";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2017/01/Interior-About.png";s:12:"tmpl_created";s:10:"1485269710";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/about-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"106";s:16:"popularity_index";s:3:"197";s:11:"trend_index";s:3:"344";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:387;a:14:{s:2:"id";s:3:"754";s:5:"title";s:25:"Services &#8211; Interior";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2017/01/Interior-Services.png";s:12:"tmpl_created";s:10:"1485269691";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/services-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"107";s:16:"popularity_index";s:3:"226";s:11:"trend_index";s:3:"399";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:388;a:14:{s:2:"id";s:3:"752";s:5:"title";s:24:"Contact &#8211; Interior";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2017/01/interior-contact.png";s:12:"tmpl_created";s:10:"1485269737";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/contact-interior/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"108";s:16:"popularity_index";s:3:"201";s:11:"trend_index";s:3:"268";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:389;a:14:{s:2:"id";s:4:"1075";s:5:"title";s:19:"Shop &#8211; Sweets";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2017/03/Sweets.png";s:12:"tmpl_created";s:10:"1488810871";s:6:"author";s:9:"Elementor";s:3:"url";s:101:"https://library.elementor.com/shop-sweets/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:154:"["bakery","beverage","business","cafe","candy bar","catering","delivery service","Food","online shop","pastry","Restaurant","store","sweet shop","sweets"]";s:10:"menu_order";s:3:"109";s:16:"popularity_index";s:2:"30";s:11:"trend_index";s:2:"76";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:390;a:14:{s:2:"id";s:4:"1051";s:5:"title";s:24:"Blog Post &#8211; Launch";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2017/03/post-cloud.png";s:12:"tmpl_created";s:10:"1488810869";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/blog-post-launch/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:210:"["Agency","bootstrap","business","corporate","Landing Page","launch","marketing campaign","marketing landing page","marketing template landing page","product launch","software","Startup","startup landing page"]";s:10:"menu_order";s:3:"110";s:16:"popularity_index";s:2:"16";s:11:"trend_index";s:2:"14";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:391;a:14:{s:2:"id";s:4:"1245";s:5:"title";s:13:"Coming Soon 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-1.png";s:12:"tmpl_created";s:10:"1491207184";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-1/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"111";s:16:"popularity_index";s:3:"148";s:11:"trend_index";s:3:"243";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:392;a:14:{s:2:"id";s:4:"1247";s:5:"title";s:13:"Coming Soon 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-2.png";s:12:"tmpl_created";s:10:"1491207138";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"112";s:16:"popularity_index";s:2:"26";s:11:"trend_index";s:2:"32";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:393;a:14:{s:2:"id";s:4:"1248";s:5:"title";s:13:"Coming Soon 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-3.png";s:12:"tmpl_created";s:10:"1491207050";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-3/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"113";s:16:"popularity_index";s:3:"245";s:11:"trend_index";s:3:"309";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:394;a:14:{s:2:"id";s:4:"1249";s:5:"title";s:13:"Coming Soon 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-4.png";s:12:"tmpl_created";s:10:"1491207380";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-4/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"114";s:16:"popularity_index";s:3:"299";s:11:"trend_index";s:3:"405";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:395;a:14:{s:2:"id";s:4:"1250";s:5:"title";s:13:"Coming Soon 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-5.png";s:12:"tmpl_created";s:10:"1491207450";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-5/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"115";s:16:"popularity_index";s:2:"33";s:11:"trend_index";s:2:"54";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:396;a:14:{s:2:"id";s:4:"1260";s:5:"title";s:13:"Coming Soon 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-6.png";s:12:"tmpl_created";s:10:"1491207507";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-6/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"116";s:16:"popularity_index";s:3:"297";s:11:"trend_index";s:3:"350";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:397;a:14:{s:2:"id";s:4:"1261";s:5:"title";s:13:"Coming Soon 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/04/Coming-Soon-7.png";s:12:"tmpl_created";s:10:"1491207584";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-7/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"117";s:16:"popularity_index";s:2:"35";s:11:"trend_index";s:2:"95";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:398;a:14:{s:2:"id";s:4:"1272";s:5:"title";s:13:"Coming Soon 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-8.png";s:12:"tmpl_created";s:10:"1491207674";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-8/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"118";s:16:"popularity_index";s:3:"149";s:11:"trend_index";s:3:"300";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:399;a:14:{s:2:"id";s:4:"1279";s:5:"title";s:13:"Coming Soon 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/03/Coming-Soon-9.png";s:12:"tmpl_created";s:10:"1491207756";s:6:"author";s:9:"Elementor";s:3:"url";s:103:"https://library.elementor.com/coming-soon-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"119";s:16:"popularity_index";s:2:"52";s:11:"trend_index";s:3:"229";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}i:400;a:14:{s:2:"id";s:4:"1745";s:5:"title";s:14:"Coming Soon 10";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/05/login-002.png";s:12:"tmpl_created";s:10:"1494849745";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/coming-soon-10/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"120";s:16:"popularity_index";s:3:"154";s:11:"trend_index";s:3:"354";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:401;a:14:{s:2:"id";s:4:"1742";s:5:"title";s:12:"Login Page 1";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/05/login-003.png";s:12:"tmpl_created";s:10:"1494849744";s:6:"author";s:9:"Elementor";s:3:"url";s:100:"https://library.elementor.com/login-page/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"121";s:16:"popularity_index";s:3:"270";s:11:"trend_index";s:3:"375";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:402;a:14:{s:2:"id";s:4:"1748";s:5:"title";s:12:"Login Page 2";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/05/login-001.png";s:12:"tmpl_created";s:10:"1494849742";s:6:"author";s:9:"Elementor";s:3:"url";s:102:"https://library.elementor.com/login-page-2/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"122";s:16:"popularity_index";s:3:"153";s:11:"trend_index";s:3:"323";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:403;a:14:{s:2:"id";s:4:"3963";s:5:"title";s:32:"Restaurant Site &#8211; Homepage";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/01/R.HomepageThumb.png";s:12:"tmpl_created";s:10:"1516284821";s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/restaurant-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:109:"["bar","cafe","cooking","drink","events","fast food","Food","menu","modern","reservation","Shop","snack bar"]";s:10:"menu_order";s:3:"123";s:16:"popularity_index";s:3:"168";s:11:"trend_index";s:3:"310";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:404;a:14:{s:2:"id";s:4:"3969";s:5:"title";s:28:"Restaurant Site &#8211; Menu";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/01/R.MenuThumb.png";s:12:"tmpl_created";s:10:"1516284829";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/restaurant-site-menu/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:109:"["bar","cafe","cooking","drink","events","fast food","Food","menu","modern","reservation","Shop","snack bar"]";s:10:"menu_order";s:3:"124";s:16:"popularity_index";s:3:"314";s:11:"trend_index";s:3:"408";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:405;a:14:{s:2:"id";s:4:"3966";s:5:"title";s:29:"Restaurant Site &#8211; About";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/01/R.AboutThumb.png.png";s:12:"tmpl_created";s:10:"1516284839";s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/restaurant-site-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:109:"["bar","cafe","cooking","drink","events","fast food","Food","menu","modern","reservation","Shop","snack bar"]";s:10:"menu_order";s:3:"125";s:16:"popularity_index";s:3:"215";s:11:"trend_index";s:2:"57";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:406;a:14:{s:2:"id";s:4:"3972";s:5:"title";s:31:"Restaurant Site &#8211; Contact";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/01/R.ContactThumb.png";s:12:"tmpl_created";s:10:"1516284847";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/restaurant-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:109:"["bar","cafe","cooking","drink","events","fast food","Food","menu","modern","reservation","Shop","snack bar"]";s:10:"menu_order";s:3:"126";s:16:"popularity_index";s:3:"278";s:11:"trend_index";s:3:"333";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:407;a:14:{s:2:"id";s:4:"2080";s:5:"title";s:27:"Ski Resort &#8211; Homepage";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Home-Page.png";s:12:"tmpl_created";s:10:"1508161124";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/ski-resort-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"127";s:16:"popularity_index";s:3:"205";s:11:"trend_index";s:3:"318";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:408;a:14:{s:2:"id";s:4:"2088";s:5:"title";s:24:"Ski Resort &#8211; About";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-About.png";s:12:"tmpl_created";s:10:"1508161129";s:6:"author";s:9:"Elementor";s:3:"url";s:106:"https://library.elementor.com/ski-resort-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"128";s:16:"popularity_index";s:3:"306";s:11:"trend_index";s:3:"339";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:409;a:14:{s:2:"id";s:4:"2085";s:5:"title";s:27:"Ski Resort &#8211; Services";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2017/10/Ski-Resort-Services.png";s:12:"tmpl_created";s:10:"1508161134";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/ski-resort-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"129";s:16:"popularity_index";s:3:"354";s:11:"trend_index";s:3:"388";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:410;a:14:{s:2:"id";s:4:"2462";s:5:"title";s:23:"Architect &#8211; About";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2017/10/architect-–-about.png";s:12:"tmpl_created";s:10:"1508243317";s:6:"author";s:9:"Elementor";s:3:"url";s:105:"https://library.elementor.com/architect-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"130";s:16:"popularity_index";s:3:"244";s:11:"trend_index";s:3:"272";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:411;a:14:{s:2:"id";s:4:"2362";s:5:"title";s:26:"Architect &#8211; Projects";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2017/10/Architect-Projects.png";s:12:"tmpl_created";s:10:"1508243335";s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/architect-projects/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"131";s:16:"popularity_index";s:3:"295";s:11:"trend_index";s:3:"357";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:412;a:14:{s:2:"id";s:3:"614";s:5:"title";s:25:"Architect &#8211; Contact";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2016/12/architect-contact.jpg";s:12:"tmpl_created";s:10:"1481549169";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/architect-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"132";s:16:"popularity_index";s:3:"122";s:11:"trend_index";s:3:"232";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:413;a:14:{s:2:"id";s:4:"2126";s:5:"title";s:37:"Construction Company &#8211; Homepage";s:9:"thumbnail";s:91:"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Home-Page.png";s:12:"tmpl_created";s:10:"1508325849";s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/construction-company-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"133";s:16:"popularity_index";s:3:"193";s:11:"trend_index";s:3:"231";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:414;a:14:{s:2:"id";s:4:"2129";s:5:"title";s:34:"Construction Company &#8211; About";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-About.png";s:12:"tmpl_created";s:10:"1508325881";s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/construction-company-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"134";s:16:"popularity_index";s:3:"222";s:11:"trend_index";s:3:"246";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:415;a:14:{s:2:"id";s:4:"2135";s:5:"title";s:36:"Construction Company &#8211; Contact";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2017/10/Construction-Company-Contact.png";s:12:"tmpl_created";s:10:"1508325922";s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/construction-company-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"135";s:16:"popularity_index";s:3:"234";s:11:"trend_index";s:3:"234";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:416;a:14:{s:2:"id";s:4:"2094";s:5:"title";s:28:"Plants Shop &#8211; Homepage";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-Home.png";s:12:"tmpl_created";s:10:"1509621053";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/plants-shop-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"136";s:16:"popularity_index";s:3:"218";s:11:"trend_index";s:3:"412";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:417;a:14:{s:2:"id";s:4:"2120";s:5:"title";s:25:"Plants Shop &#8211; About";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2017/11/Plants-Shop-About.png";s:12:"tmpl_created";s:10:"1509631820";s:6:"author";s:9:"Elementor";s:3:"url";s:107:"https://library.elementor.com/plants-shop-about/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"137";s:16:"popularity_index";s:3:"225";s:11:"trend_index";s:3:"266";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"1";}i:418;a:14:{s:2:"id";s:4:"3619";s:5:"title";s:31:"Snowboard Site &#8211; Homepage";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2017/12/home.png";s:12:"tmpl_created";s:10:"1513513137";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/snowboard-site-homepage/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"138";s:16:"popularity_index";s:3:"227";s:11:"trend_index";s:3:"138";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:419;a:14:{s:2:"id";s:4:"3632";s:5:"title";s:31:"Snowboard Site &#8211; Services";s:9:"thumbnail";s:62:"https://library.elementor.com/wp-content/uploads/2017/12/2.png";s:12:"tmpl_created";s:10:"1513513171";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/snowboard-site-services/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"139";s:16:"popularity_index";s:3:"207";s:11:"trend_index";s:3:"301";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:420;a:14:{s:2:"id";s:4:"3626";s:5:"title";s:30:"Snowboard Site &#8211; Contact";s:9:"thumbnail";s:62:"https://library.elementor.com/wp-content/uploads/2017/12/3.png";s:12:"tmpl_created";s:10:"1513513193";s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/snowboard-site-contact/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"140";s:16:"popularity_index";s:3:"209";s:11:"trend_index";s:3:"259";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:421;a:14:{s:2:"id";s:4:"3153";s:5:"title";s:14:"Halloween Pack";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/10/halloween.png";s:12:"tmpl_created";s:10:"1508950132";s:6:"author";s:9:"Elementor";s:3:"url";s:104:"https://library.elementor.com/halloween-pack/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"141";s:16:"popularity_index";s:3:"364";s:11:"trend_index";s:3:"392";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:422;a:14:{s:2:"id";s:4:"3338";s:5:"title";s:31:"Black Friday &#8211; Nature Set";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-1.png";s:12:"tmpl_created";s:10:"1511203351";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/black-friday-nature-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"142";s:16:"popularity_index";s:3:"343";s:11:"trend_index";s:3:"397";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:423;a:14:{s:2:"id";s:4:"3339";s:5:"title";s:35:"Black Friday &#8211; Pop-Styled Set";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-2.png";s:12:"tmpl_created";s:10:"1511203636";s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/black-friday-pop-styled-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"143";s:16:"popularity_index";s:3:"291";s:11:"trend_index";s:3:"362";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"1";}i:424;a:14:{s:2:"id";s:4:"3335";s:5:"title";s:31:"Black Friday &#8211; Retail Set";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-4.png";s:12:"tmpl_created";s:10:"1511203246";s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/black-friday-retail-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"144";s:16:"popularity_index";s:3:"283";s:11:"trend_index";s:3:"221";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:425;a:14:{s:2:"id";s:4:"3340";s:5:"title";s:41:"Black Friday &#8211; Software Product Set";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2017/11/black-friday-3.png";s:12:"tmpl_created";s:10:"1511203713";s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/black-friday-software-product-set/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"145";s:16:"popularity_index";s:3:"284";s:11:"trend_index";s:3:"402";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:426;a:14:{s:2:"id";s:4:"3517";s:5:"title";s:27:"Christmas &#8211; Gift Shop";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2017/12/XmasThumb.png";s:12:"tmpl_created";s:10:"1513877937";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/christmas-gift-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"146";s:16:"popularity_index";s:3:"380";s:11:"trend_index";s:3:"407";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:427;a:14:{s:2:"id";s:4:"3734";s:5:"title";s:28:"Christmas &#8211; Car Agency";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v3.png";s:12:"tmpl_created";s:10:"1514197794";s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/christmas-car-agency/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"147";s:16:"popularity_index";s:3:"369";s:11:"trend_index";s:3:"356";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:428;a:14:{s:2:"id";s:4:"3764";s:5:"title";s:33:"Christmas &#8211; Interior Design";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v6.png";s:12:"tmpl_created";s:10:"1514198234";s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/christmas-interior-design/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"148";s:16:"popularity_index";s:3:"345";s:11:"trend_index";s:3:"324";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:429;a:14:{s:2:"id";s:4:"3565";s:5:"title";s:27:"Christmas &#8211; Tree Shop";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2017/12/XmasTreeThumb.png";s:12:"tmpl_created";s:10:"1514204382";s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/christmas-tree-shop/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"149";s:16:"popularity_index";s:3:"344";s:11:"trend_index";s:3:"368";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:430;a:14:{s:2:"id";s:4:"3862";s:5:"title";s:35:"Christmas &#8211; Design Conference";s:9:"thumbnail";s:63:"https://library.elementor.com/wp-content/uploads/2017/12/q1.png";s:12:"tmpl_created";s:10:"1514206745";s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/christmas-design-conference/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"150";s:16:"popularity_index";s:3:"289";s:11:"trend_index";s:3:"348";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:431;a:14:{s:2:"id";s:4:"3777";s:5:"title";s:39:"Christmas &#8211; Snowboard Competition";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2017/12/cover-lib-v7.png";s:12:"tmpl_created";s:10:"1514205420";s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/christmas-snowboard-competition/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"151";s:16:"popularity_index";s:3:"303";s:11:"trend_index";s:3:"378";s:6:"is_pro";s:1:"1";s:17:"has_page_settings";s:1:"0";}i:432;a:14:{s:2:"id";s:3:"420";s:5:"title";s:11:"Hero UI Kit";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2016/09/library-ui-kit-cover.png";s:12:"tmpl_created";s:10:"1475067229";s:6:"author";s:9:"Elementor";s:3:"url";s:101:"https://library.elementor.com/hero-ui-kit/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";s:3:"152";s:16:"popularity_index";s:2:"12";s:11:"trend_index";s:2:"30";s:6:"is_pro";s:1:"0";s:17:"has_page_settings";s:1:"0";}}}', 'no'),
 (158, 'elementor_remote_info_feed_data', 'a:3:{i:0;a:5:{s:5:"title";s:40:"Introducing Filter Effects & Blend Modes";s:7:"excerpt";s:168:"Today, I am eager to show you a brand new set of capabilities that will allow you to create a wide range of visual effects, all using Filter Effects and Blend modes.​";s:7:"created";s:10:"1531911170";s:5:"badge";s:3:"New";s:3:"url";s:124:"https://elementor.com/introducing-filter-blend-mode/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}i:1;a:5:{s:5:"title";s:58:"New Features: Revamped Video Features & Custom Breakpoints";s:7:"excerpt";s:181:"This week, you’ll have the chance to discover other helpful features that were introduced: Video enhancements, custom breakpoints, Gutenberg compatibility, and WP-CLI integration.";s:7:"created";s:10:"1531227695";s:5:"badge";s:0:"";s:3:"url";s:111:"https://elementor.com/2-1-new-features/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}i:2;a:5:{s:5:"title";s:35:"Introducing Copy Style & Copy Paste";s:7:"excerpt";s:190:"We\'re excited to release one of the most requested features: Copy Style & Copy Paste. This will save you hours of work, allowing you to quickly copy any style or element with a single click.";s:7:"created";s:10:"1530613662";s:5:"badge";s:0:"";s:3:"url";s:117:"https://elementor.com/introducing-copy-paste/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}}', 'no'),
 (167, 'wpcf7', 'a:2:{s:7:"version";s:5:"5.0.3";s:13:"bulk_validate";a:4:{s:9:"timestamp";i:1526454386;s:7:"version";s:5:"5.0.1";s:11:"count_valid";i:1;s:13:"count_invalid";i:0;}}', 'yes'),
 (170, 'duplicate_post_copytitle', '1', 'yes'),
 (171, 'duplicate_post_copydate', '0', 'yes'),
 (172, 'duplicate_post_copystatus', '0', 'yes'),
 (173, 'duplicate_post_copyslug', '0', 'yes'),
 (174, 'duplicate_post_copyexcerpt', '1', 'yes'),
 (175, 'duplicate_post_copycontent', '1', 'yes'),
 (176, 'duplicate_post_copythumbnail', '1', 'yes'),
 (177, 'duplicate_post_copytemplate', '1', 'yes'),
 (178, 'duplicate_post_copyformat', '1', 'yes'),
 (179, 'duplicate_post_copyauthor', '0', 'yes'),
 (180, 'duplicate_post_copypassword', '0', 'yes'),
 (181, 'duplicate_post_copyattachments', '0', 'yes'),
 (182, 'duplicate_post_copychildren', '0', 'yes'),
 (183, 'duplicate_post_copycomments', '0', 'yes'),
 (184, 'duplicate_post_copymenuorder', '1', 'yes'),
 (185, 'duplicate_post_taxonomies_blacklist', 'a:0:{}', 'yes'),
 (186, 'duplicate_post_blacklist', '', 'yes'),
 (187, 'duplicate_post_types_enabled', 'a:2:{i:0;s:4:"post";i:1;s:4:"page";}', 'yes'),
 (188, 'duplicate_post_show_row', '1', 'yes'),
 (189, 'duplicate_post_show_adminbar', '1', 'yes'),
 (190, 'duplicate_post_show_submitbox', '1', 'yes'),
 (191, 'duplicate_post_show_bulkactions', '1', 'yes'),
 (192, 'duplicate_post_version', '3.2.2', 'yes'),
 (193, 'duplicate_post_show_notice', '0', 'no'),
 (200, 'ocean-custom-sidebar-version', '1.0.3', 'yes'),
 (201, 'ocean-extra-version', '1.4.14', 'yes'),
 (202, 'widget_ocean_about_me', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (203, 'widget_ocean_contact_info', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (204, 'widget_ocean_custom_links', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (205, 'widget_ocean_custom_menu', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (206, 'widget_ocean_facebook', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (207, 'widget_ocean_flickr', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (208, 'widget_ocean_instagram', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (209, 'widget_ocean_mailchimp', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (210, 'widget_ocean_recent_posts', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (211, 'widget_ocean_social', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (212, 'widget_ocean_tags', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (213, 'widget_ocean_twitter', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (214, 'widget_ocean_video', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (215, 'widget_ocean_custom_header_logo', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (216, 'widget_ocean_custom_header_nav', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (217, 'bodhi_svgs_plugin_version', '2.3.15', 'yes'),
 (218, 'ocean_extra_installed_time', '1526455182', 'yes'),
 (221, 'ai1wm_secret_key', 'TRWkQStSvB8C', 'yes'),
 (222, 'elementor_scheme_color', 'a:4:{i:1;s:7:"#6ec1e4";i:2;s:7:"#54595f";i:3;s:7:"#7a7a7a";i:4;s:7:"#61ce70";}', 'yes'),
 (223, 'elementor_scheme_typography', 'a:4:{i:1;a:2:{s:11:"font_family";s:10:"Montserrat";s:11:"font_weight";s:3:"400";}i:2;a:2:{s:11:"font_family";s:11:"Roboto Slab";s:11:"font_weight";s:3:"400";}i:3;a:2:{s:11:"font_family";s:6:"Roboto";s:11:"font_weight";s:3:"400";}i:4;a:2:{s:11:"font_family";s:6:"Roboto";s:11:"font_weight";s:3:"500";}}', 'yes'),
 (224, 'elementor_scheme_color-picker', 'a:8:{i:1;s:7:"#00b6e0";i:2;s:7:"#007cbf";i:3;s:7:"#ef3c70";i:4;s:7:"#2e3133";i:5;s:7:"#80ecff";i:6;s:7:"#999999";i:7;s:7:"#00d8fc";i:8;s:7:"#f2f5f5";}', 'yes'),
 (227, 'ai1wm_updater', 'a:0:{}', 'yes'),
 (236, 'widget_elementor-library', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (237, 'elementor_pro_version', '2.0.16', 'yes'),
 (238, '_elementor_pro_installed_time', '1526456478', 'yes'),
 (239, 'ocean-elementor-widgets-version', '1.0.14', 'yes'),
 (240, 'ocean-footer-callout-version', '1.0.10', 'yes'),
 (241, 'WPGMZA_OTHER_SETTINGS', 'a:15:{s:41:"wpgmza_settings_carousel_markerlist_image";s:0:"";s:40:"wpgmza_settings_carousel_markerlist_icon";s:0:"";s:41:"wpgmza_settings_carousel_markerlist_title";s:0:"";s:47:"wpgmza_settings_carousel_markerlist_description";s:3:"yes";s:43:"wpgmza_settings_carousel_markerlist_address";s:0:"";s:46:"wpgmza_settings_carousel_markerlist_directions";s:0:"";s:40:"wpgmza_settings_carousel_markerlist_link";s:0:"";s:30:"wpgmza_settings_image_resizing";s:3:"yes";s:28:"wpgmza_settings_use_timthumb";s:3:"yes";s:14:"carousel_items";s:1:"5";s:17:"carousel_lazyload";s:3:"yes";s:17:"carousel_autoplay";s:4:"5000";s:19:"carousel_pagination";s:0:"";s:19:"carousel_navigation";s:3:"yes";s:19:"carousel_autoheight";s:3:"yes";}', 'yes'),
 (242, 'WPGMZA_PRO', 'a:2:{s:7:"version";s:4:"6.26";s:14:"version_string";s:3:"pro";}', 'yes'),
 (244, 'wp_rocket_settings', 'a:78:{s:12:"consumer_key";s:8:"e1d088fd";s:14:"consumer_email";s:27:"pluginsandmodules@gmail.com";s:10:"secret_key";s:8:"9660af65";s:7:"license";i:1526456495;s:16:"secret_cache_key";s:22:"5afbe0af43e8f659356884";s:12:"cache_mobile";i:1;s:23:"do_caching_mobile_files";i:0;s:17:"cache_logged_user";i:0;s:9:"cache_ssl";i:0;s:5:"emoji";i:1;s:6:"embeds";i:1;s:16:"cache_reject_uri";a:0:{}s:20:"cache_reject_cookies";a:0:{}s:15:"cache_reject_ua";a:0:{}s:19:"cache_query_strings";a:0:{}s:17:"cache_purge_pages";a:0:{}s:19:"purge_cron_interval";i:10;s:15:"purge_cron_unit";s:15:"HOUR_IN_SECONDS";s:11:"exclude_css";a:0:{}s:10:"exclude_js";a:0:{}s:12:"defer_all_js";i:0;s:17:"defer_all_js_safe";i:1;s:9:"async_css";i:0;s:12:"critical_css";s:0:"";s:8:"lazyload";i:0;s:16:"lazyload_iframes";i:0;s:16:"lazyload_youtube";i:0;s:10:"minify_css";i:0;s:14:"minify_css_key";s:22:"5b3844b1dce55660996299";s:22:"minify_concatenate_css";i:0;s:9:"minify_js";i:0;s:13:"minify_js_key";s:22:"5b3844b1dce62018537153";s:21:"minify_concatenate_js";i:0;s:19:"minify_google_fonts";i:0;s:11:"minify_html";i:0;s:14:"manual_preload";i:0;s:17:"automatic_preload";i:0;s:15:"sitemap_preload";i:0;s:25:"sitemap_preload_url_crawl";s:6:"500000";s:8:"sitemaps";a:0:{}s:20:"remove_query_strings";i:0;s:12:"dns_prefetch";a:0:{}s:18:"database_revisions";i:0;s:20:"database_auto_drafts";i:0;s:22:"database_trashed_posts";i:0;s:22:"database_spam_comments";i:0;s:25:"database_trashed_comments";i:0;s:27:"database_expired_transients";i:0;s:23:"database_all_transients";i:0;s:24:"database_optimize_tables";i:0;s:26:"schedule_automatic_cleanup";i:0;s:3:"cdn";i:0;s:10:"cdn_cnames";a:0:{}s:8:"cdn_zone";a:0:{}s:7:"cdn_ssl";i:0;s:16:"cdn_reject_files";a:0:{}s:13:"do_cloudflare";i:0;s:16:"cloudflare_email";s:0:"";s:18:"cloudflare_api_key";s:0:"";s:17:"cloudflare_domain";s:0:"";s:18:"cloudflare_zone_id";s:0:"";s:18:"cloudflare_devmode";i:0;s:27:"cloudflare_protocol_rewrite";i:0;s:24:"cloudflare_auto_settings";i:0;s:23:"cloudflare_old_settings";s:0:"";s:18:"varnish_auto_purge";i:0;s:7:"do_beta";i:0;s:17:"analytics_enabled";i:0;s:14:"wl_plugin_name";s:9:"WP Rocket";s:14:"wl_plugin_slug";s:8:"wprocket";s:13:"wl_plugin_URI";s:20:"https://wp-rocket.me";s:14:"wl_description";a:1:{i:0;s:38:"The best WordPress performance plugin.";}s:9:"wl_author";s:8:"WP Media";s:13:"wl_author_URI";s:19:"https://wp-media.me";s:7:"version";s:7:"3.0.5.1";s:6:"ignore";b:1;s:16:"exclude_defer_js";a:0:{}s:27:"automatic_cleanup_frequency";s:0:"";}', 'yes'),
 (252, 'elementor_fonts_manager_font_types', 'a:0:{}', 'yes'),
 (253, 'elementor_fonts_manager_fonts', 'a:0:{}', 'yes'),
 (274, 'elementor_pro_upgrades', 'a:1:{s:5:"2.0.3";b:1;}', 'yes'),
 (280, 'jetpack_active_modules', 'a:0:{}', 'yes'),
 (315, 'elementor_pro_theme_builder_conditions', 'a:2:{s:6:"footer";a:1:{i:438;a:1:{i:0;s:15:"include/general";}}s:6:"header";a:2:{i:335;a:2:{i:0;s:15:"include/general";i:1;s:27:"exclude/singular/front_page";}i:327;a:1:{i:0;s:27:"include/singular/front_page";}}}', 'yes'),
 (317, 'elementor_pro_tracker_notice', '1', 'yes'),
 (318, 'elementor_allow_tracking', 'no', 'yes'),
 (319, 'elementor_tracker_notice', '1', 'yes'),
 (320, 'ocean_extra_dismiss_notice', '1', 'yes'),
 (321, 'elementor_pro_license_key', 'c66bfd89645ea5d2f685b012bc73bf9a', 'yes'),
 (359, 'nav_menu_options', 'a:1:{s:8:"auto_add";a:0:{}}', 'yes'),
 (360, '_elementor_scheme_last_updated', '1529311725', 'yes'),
 (377, 'ocean-sticky-header-version', '1.1.6', 'yes'),
 (380, 'elementor_debug_log', 'a:10:{i:0;a:8:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1529509082";s:7:"message";s:42:"Cannot read property \\\'html\\\' of undefined";s:3:"url";s:97:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/js/editor.min.js?ver=2.0.16";s:4:"line";s:1:"2";s:6:"column";s:5:"79514";s:12:"customFields";a:0:{}s:5:"times";i:2;}i:1;a:7:{s:4:"type";s:18:"ViewDestroyedError";s:9:"timestamp";s:10:"1529567272";s:7:"message";s:71:"View (cid: \\"view1355\\") has already been destroyed and cannot be used.";s:3:"url";s:119:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5";s:4:"line";s:2:"22";s:6:"column";s:5:"19954";s:12:"customFields";a:0:{}}i:2;a:8:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1529578723";s:7:"message";s:42:"Cannot read property \\\'html\\\' of undefined";s:3:"url";s:97:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/js/editor.min.js?ver=2.0.16";s:4:"line";s:1:"2";s:6:"column";s:5:"79514";s:12:"customFields";a:0:{}s:5:"times";i:3;}i:3;a:7:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1529582371";s:7:"message";s:43:"Cannot read property \\\'style\\\' of undefined";s:3:"url";s:69:"http://www.agurainc.com/wordpress/wp-admin/js/editor.min.js?ver=4.9.6";s:4:"line";s:1:"1";s:6:"column";s:3:"694";s:12:"customFields";a:0:{}}i:4;a:7:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1529582371";s:7:"message";s:35:"Cannot read property \\\'on\\\' of null";s:3:"url";s:97:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/js/editor.min.js?ver=2.0.16";s:4:"line";s:1:"2";s:6:"column";s:5:"82365";s:12:"customFields";a:0:{}}i:5;a:7:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1529582384";s:7:"message";s:43:"Cannot read property \\\'style\\\' of undefined";s:3:"url";s:69:"http://www.agurainc.com/wordpress/wp-admin/js/editor.min.js?ver=4.9.6";s:4:"line";s:1:"1";s:6:"column";s:3:"694";s:12:"customFields";a:0:{}}i:6;a:7:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1529582384";s:7:"message";s:35:"Cannot read property \\\'on\\\' of null";s:3:"url";s:97:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/js/editor.min.js?ver=2.0.16";s:4:"line";s:1:"2";s:6:"column";s:5:"82365";s:12:"customFields";a:0:{}}i:7;a:8:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1529691697";s:7:"message";s:41:"Cannot read property \\\'get\\\' of undefined";s:3:"url";s:97:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/js/editor.min.js?ver=2.0.16";s:4:"line";s:1:"2";s:6:"column";s:6:"120138";s:12:"customFields";a:0:{}s:5:"times";i:6;}i:8;a:8:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1530016046";s:7:"message";s:63:"undefined is not an object (evaluating \\\'this._parent.errors\\\')";s:3:"url";s:97:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/js/editor.min.js?ver=2.0.16";s:4:"line";s:1:"2";s:6:"column";s:6:"132677";s:12:"customFields";a:0:{}s:5:"times";i:2;}i:9;a:8:{s:4:"type";s:9:"TypeError";s:9:"timestamp";s:10:"1531745510";s:7:"message";s:44:"Cannot read property \\\'errors\\\' of undefined";s:3:"url";s:96:"http://www.agurainc.com/wordpress/wp-content/plugins/elementor/assets/js/editor.min.js?ver=2.1.3";s:4:"line";s:1:"2";s:6:"column";s:6:"138568";s:12:"customFields";a:0:{}s:5:"times";i:10;}}', 'yes'),
 (393, 'elementor_addon_widgets_install', '1529317468', 'yes'),
 (414, 'wisdom_block_notice', 'a:2:{s:25:"essential_adons_elementor";s:25:"essential_adons_elementor";s:18:"twitter-cards-meta";s:18:"twitter-cards-meta";}', 'yes'),
 (460, 'faqwd_version', '1.0.36', 'yes'),
 (461, 'faqwd_do_activation_set_up_redirect', '0', 'yes'),
 (462, 'faqwd_scripts_key', '5b278d7b88951', 'yes'),
 (463, 'faqwd_upgrade_has_run', 'a:8:{s:13:"save_settings";i:1;s:28:"single_display_share_buttons";i:1;s:23:"single_display_comments";i:1;s:19:"single_display_date";i:1;s:20:"single_display_views";i:1;s:15:"enable_comments";i:1;s:19:"display_more_button";i:1;s:21:"single_display_author";i:1;}', 'yes'),
 (464, 'faqwd_settings_general', 'a:8:{s:13:"save_settings";i:1;s:28:"single_display_share_buttons";i:1;s:23:"single_display_comments";i:1;s:19:"single_display_date";i:1;s:20:"single_display_views";i:1;s:15:"enable_comments";i:1;s:19:"display_more_button";i:1;s:21:"single_display_author";i:1;}', 'yes'),
 (465, 'faqwd_admin_notice', 'a:1:{s:15:"two_week_review";a:3:{s:5:"start";s:9:"7/30/2018";s:3:"int";i:14;s:9:"dismissed";i:0;}}', 'yes'),
 (466, 'faqwd_subscribe_done', '1', 'yes'),
 (473, 'faqwd_categories_order', '[3]', 'yes'),
 (476, 'buwd_version', '1.0.16', 'no'),
 (477, 'buwd_hash', '3bb53b', 'no'),
 (478, 'buwd_settings', 'a:14:{s:11:"show_on_bar";a:1:{i:0;s:1:"1";}s:10:"log_folder";s:44:"wp-content/uploads/backup-wd-logs-{hash_key}";s:12:"job_step_max";i:3;s:11:"auth_method";s:4:"none";s:13:"max_exec_time";i:300;s:13:"job_start_key";s:7:"48ec66d";s:15:"red_server_load";s:8:"disabled";s:13:"max_log_files";i:15;s:9:"log_level";s:17:"normal_translated";s:8:"hash_key";s:6:"3bb53b";s:9:"recipient";s:16:"admin@tyco.co.il";s:10:"email_from";s:16:"admin@tyco.co.il";s:4:"from";s:5:"AGURA";s:7:"subject";s:10:"Backup log";}', 'no'),
 (479, 'buwd_jobs', 'a:5:{i:1;a:94:{s:4:"name";s:15:"Database Backup";s:4:"type";a:1:{i:0;s:2:"db";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:7:"archive";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:13:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:18:"wp_wpgmza_datasets";s:18:"wp_wpgmza_datasets";}s:10:"dbfilename";s:11:"agurainc_wp";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";s:0:"";s:11:"bup_content";s:0:"";s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";s:1:"1";s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:1:"1";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-3bb53b";i:1;s:21:"backup-wd-temp-3bb53b";i:2;s:16:"backup-wd-3bb53b";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:43:"wp-content/uploads/backup-wd-db-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:6:"AGURA/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:6:"AGURA/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:6:"AGURA/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:6:"AGURA/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:6:"AGURA/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:6:"AGURA/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:6:"AGURA/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:103:"http://www.agurainc.com/wordpress/wp-cron.php?jobid=1&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=48ec66d";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";}i:2;a:94:{s:4:"name";s:12:"Files Backup";s:4:"type";a:1:{i:0;s:5:"files";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:7:"archive";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:13:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:18:"wp_wpgmza_datasets";s:18:"wp_wpgmza_datasets";}s:10:"dbfilename";s:11:"agurainc_wp";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";a:1:{i:0;s:1:"1";}s:11:"bup_content";a:1:{i:0;s:1:"1";}s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";a:1:{i:0;s:1:"1";}s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:1:"1";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-3bb53b";i:1;s:21:"backup-wd-temp-3bb53b";i:2;s:16:"backup-wd-3bb53b";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:46:"wp-content/uploads/backup-wd-files-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:6:"AGURA/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:6:"AGURA/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:6:"AGURA/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:6:"AGURA/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:6:"AGURA/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:6:"AGURA/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:6:"AGURA/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:103:"http://www.agurainc.com/wordpress/wp-cron.php?jobid=2&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=48ec66d";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";}i:3;a:94:{s:4:"name";s:25:"Plugins and Themes Backup";s:4:"type";a:1:{i:0;s:5:"files";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:4:"sync";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:13:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:18:"wp_wpgmza_datasets";s:18:"wp_wpgmza_datasets";}s:10:"dbfilename";s:11:"agurainc_wp";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";s:0:"";s:11:"bup_content";s:0:"";s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";a:1:{i:0;s:1:"1";}s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:0:"";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-3bb53b";i:1;s:21:"backup-wd-temp-3bb53b";i:2;s:16:"backup-wd-3bb53b";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:55:"wp-content/uploads/backup-wd-plugins-themes-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:6:"AGURA/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:6:"AGURA/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:6:"AGURA/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:6:"AGURA/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:6:"AGURA/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:6:"AGURA/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:6:"AGURA/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:103:"http://www.agurainc.com/wordpress/wp-cron.php?jobid=3&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=48ec66d";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";}i:4;a:94:{s:4:"name";s:25:"Files and Database Backup";s:4:"type";a:2:{i:0;s:2:"db";i:1;s:5:"files";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:4:"sync";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:12:"dbtables_all";a:0:{}s:8:"dbtables";a:13:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:18:"wp_wpgmza_datasets";s:18:"wp_wpgmza_datasets";}s:10:"dbfilename";s:11:"agurainc_wp";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:0:"";s:8:"bup_root";s:0:"";s:11:"bup_content";s:1:"1";s:19:"bup_content_exclude";s:0:"";s:11:"bup_plugins";a:1:{i:0;s:1:"1";}s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:0:"";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:3:{i:0;s:21:"backup-wd-logs-3bb53b";i:1;s:21:"backup-wd-temp-3bb53b";i:2;s:16:"backup-wd-3bb53b";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:49:"wp-content/uploads/backup-wd-files-db-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:12:"gdrivefolder";s:6:"AGURA/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:6:"AGURA/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:9:"dboxtoken";s:0:"";s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:6:"AGURA/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:6:"AGURA/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:7:"rscuser";s:0:"";s:6:"rsckey";s:0:"";s:9:"rscregion";s:3:"DFW";s:12:"rsccontainer";s:0:"";s:10:"rscnewcont";s:0:"";s:9:"rscfolder";s:6:"AGURA/";s:13:"rscfiledelete";i:15;s:17:"rscfiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:6:"AGURA/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"sugartoken";s:0:"";s:9:"sugaruser";s:0:"";s:15:"sugarsyncfolder";s:0:"";s:11:"sugarfolder";s:6:"AGURA/";s:15:"sugarfiledelete";i:15;s:14:"glacier_region";s:9:"us-east-1";s:17:"glacier_accesskey";s:0:"";s:18:"glacier_privatekey";s:0:"";s:16:"glacier_newvault";s:0:"";s:18:"glacier_filedelete";i:15;s:10:"send_email";s:0:"";s:6:"job_id";i:6;s:15:"cron_expression";s:9:"0 0 * * *";s:12:"schedulelink";s:103:"http://www.agurainc.com/wordpress/wp-cron.php?jobid=4&amp;buwd_cron=1&amp;type=run&amp;_wpnonce=48ec66d";s:3:"day";s:0:"";s:11:"scheduleday";s:0:"";s:12:"schedulehour";s:2:"00";s:14:"scheduleminute";s:2:"00";}i:5;a:71:{s:4:"name";s:7:"New Job";s:4:"type";a:2:{i:0;s:2:"db";i:1;s:5:"files";}s:11:"destination";a:1:{i:0;s:6:"folder";}s:11:"backup_type";s:7:"archive";s:12:"archive_name";s:37:"backupwd_{hash_key}_%Y-%m-%d_%H-%i-%s";s:14:"archive_format";s:3:"zip";s:8:"schedule";s:8:"manually";s:12:"scheduletype";s:5:"basic";s:13:"schedulemonth";a:13:{i:0;s:3:"any";i:1;s:1:"1";i:2;s:1:"2";i:3;s:1:"3";i:4;s:1:"4";i:5;s:1:"5";i:6;s:1:"6";i:7;s:1:"7";i:8;s:1:"8";i:9;s:1:"9";i:10;s:2:"10";i:11;s:2:"11";i:12;s:2:"12";}s:12:"scheduleweek";a:1:{i:0;s:1:"1";}s:8:"dbtables";a:19:{s:14:"wp_commentmeta";s:14:"wp_commentmeta";s:11:"wp_comments";s:11:"wp_comments";s:22:"wp_duplicator_packages";s:22:"wp_duplicator_packages";s:8:"wp_links";s:8:"wp_links";s:10:"wp_options";s:10:"wp_options";s:21:"wp_post_right_content";s:21:"wp_post_right_content";s:11:"wp_postmeta";s:11:"wp_postmeta";s:8:"wp_posts";s:8:"wp_posts";s:22:"wp_spider_faq_category";s:22:"wp_spider_faq_category";s:17:"wp_spider_faq_faq";s:17:"wp_spider_faq_faq";s:22:"wp_spider_faq_question";s:22:"wp_spider_faq_question";s:19:"wp_spider_faq_theme";s:19:"wp_spider_faq_theme";s:21:"wp_term_relationships";s:21:"wp_term_relationships";s:16:"wp_term_taxonomy";s:16:"wp_term_taxonomy";s:11:"wp_termmeta";s:11:"wp_termmeta";s:8:"wp_terms";s:8:"wp_terms";s:11:"wp_usermeta";s:11:"wp_usermeta";s:8:"wp_users";s:8:"wp_users";s:18:"wp_wpgmza_datasets";s:18:"wp_wpgmza_datasets";}s:10:"dbfilename";s:18:"agurainc_wordpress";s:17:"use_wp_connection";s:1:"1";s:10:"dbfilecomp";s:4:"none";s:7:"db_host";s:0:"";s:7:"db_user";s:0:"";s:11:"db_password";s:0:"";s:7:"db_name";s:18:"agurainc_wordpress";s:8:"bup_root";s:0:"";s:11:"bup_content";s:0:"";s:19:"bup_content_exclude";a:2:{i:0;s:5:"cache";i:1;s:7:"upgrade";}s:11:"bup_plugins";s:1:"1";s:19:"bup_plugins_exclude";a:1:{i:0;s:9:"backup-wd";}s:10:"bup_themes";s:1:"1";s:11:"bup_uploads";s:1:"1";s:17:"bup_extra_folders";s:0:"";s:19:"bup_uploads_exclude";a:7:{i:0;s:21:"backup-wd-logs-3bb53b";i:1;s:21:"backup-wd-temp-3bb53b";i:2;s:19:"backup-wd-db-3bb53b";i:3;s:22:"backup-wd-files-3bb53b";i:4;s:31:"backup-wd-plugins-themes-3bb53b";i:5;s:25:"backup-wd-files-db-3bb53b";i:6;s:16:"backup-wd-3bb53b";}s:20:"bup_include_specials";s:1:"1";s:13:"exclude_types";s:51:".tmp,.svn,.git,desktop.ini,.DS_Store,/node_modules/";s:16:"use_folder_as_wp";s:1:"0";s:10:"folderpath";s:40:"wp-content/uploads/backup-wd-{hash_key}/";s:12:"folderdelete";i:15;s:16:"folderdeletesync";s:1:"1";s:9:"s3service";s:9:"us-east-1";s:11:"s3accesskey";s:0:"";s:12:"s3privatekey";s:0:"";s:8:"s3bucket";s:0:"";s:11:"s3newbucket";s:0:"";s:14:"s3bucketfolder";s:6:"AGURA/";s:12:"s3filedelete";i:15;s:16:"s3filedeletesync";s:1:"1";s:13:"s3multiupload";s:1:"1";s:14:"s3storageclass";s:8:"standard";s:18:"s3serverencryption";s:1:"1";s:12:"gdrivefolder";s:6:"AGURA/";s:16:"gdrivefiledelete";i:15;s:20:"gdrivefiledeletesync";s:1:"1";s:9:"dboxtoken";a:0:{}s:8:"dboxtype";s:7:"sandbox";s:10:"dboxfolder";s:6:"AGURA/";s:14:"dboxfiledelete";i:15;s:18:"dboxfiledeletesync";s:1:"1";s:9:"azurename";s:0:"";s:8:"azurekey";s:0:"";s:12:"azurenewcont";s:0:"";s:11:"azurefolder";s:6:"AGURA/";s:15:"azurefiledelete";i:15;s:19:"azurefiledeletesync";s:1:"1";s:9:"ftpserver";s:0:"";s:7:"ftpport";i:21;s:7:"ftpuser";s:0:"";s:7:"ftppass";s:0:"";s:9:"ftpfolder";s:6:"AGURA/";s:13:"ftpfiledelete";i:15;s:10:"ftptimeout";i:90;s:6:"ftpssl";s:0:"";s:8:"ftppmode";s:1:"1";s:10:"send_email";s:0:"";s:6:"job_id";i:5;s:7:"lastrun";i:1533540193;s:13:"last_log_file";s:44:"backupwd_log_3bb53b_2018-08-06_07-23-13.html";}}', 'no'),
 (480, 'buwd_job_maxid', '5', 'no'),
 (481, '_transient_buwd_overview_visited', '1', 'yes'),
 (482, 'buwd_admin_notice', 'a:1:{s:15:"two_week_review";a:3:{s:5:"start";s:9:"7/30/2018";s:3:"int";i:14;s:9:"dismissed";i:0;}}', 'yes'),
 (483, 'buwd_subscribe_done', '1', 'yes'),
 (484, '_site_transient_jobs_per_page', '20', 'no'),
 (503, 'lae_option_dismissed_notices', 'a:1:{s:4:"rate";b:1;}', 'yes'),
 (524, 'EWD_UFAQ_Version', '1.7.2', 'yes'),
 (525, 'EWD_UFAQ_Toggle', 'Yes', 'yes'),
 (526, 'EWD_UFAQ_Category_Toggle', 'No', 'yes'),
 (527, 'EWD_UFAQ_Category_Accordion', 'No', 'yes'),
 (528, 'EWD_UFAQ_Expand_Collapse_All', 'No', 'yes'),
 (529, 'EWD_UFAQ_FAQ_Accordion', 'No', 'yes'),
 (530, 'EWD_UFAQ_Hide_Categories', 'No', 'yes'),
 (531, 'EWD_UFAQ_Hide_Tags', 'No', 'yes'),
 (532, 'EWD_UFAQ_Scroll_To_Top', 'Yes', 'yes'),
 (533, 'EWD_UFAQ_Display_All_Answers', 'No', 'yes'),
 (534, 'EWD_UFAQ_Display_Author', 'Yes', 'yes'),
 (535, 'EWD_UFAQ_Display_Date', 'Yes', 'yes'),
 (536, 'EWD_UFAQ_Display_Back_To_Top', 'No', 'yes'),
 (537, 'EWD_UFAQ_Include_Permalink', 'Yes', 'yes'),
 (538, 'EWD_UFAQ_Permalink_Type', 'SamePage', 'yes'),
 (539, 'EWD_UFAQ_Show_TinyMCE', 'Yes', 'yes'),
 (540, 'EWD_UFAQ_Comments_On', 'Yes', 'yes'),
 (541, 'EWD_UFAQ_Access_Role', 'edit_posts', 'yes'),
 (542, 'EWD_UFAQ_Display_Style', 'Default', 'yes'),
 (543, 'EWD_UFAQ_Color_Block_Shape', 'Square', 'yes'),
 (544, 'EWD_UFAQ_FAQ_Ratings', 'No', 'yes'),
 (545, 'EWD_UFAQ_WooCommerce_FAQs', 'No', 'yes'),
 (546, 'EWD_UFAQ_Use_Product', 'Yes', 'yes'),
 (547, 'EWD_UFAQ_Reveal_Effect', 'none', 'yes'),
 (548, 'EWD_UFAQ_Pretty_Permalinks', 'No', 'yes'),
 (549, 'EWD_UFAQ_Allow_Proposed_Answer', 'No', 'yes'),
 (550, 'EWD_UFAQ_Submit_Custom_Fields', 'No', 'yes'),
 (551, 'EWD_UFAQ_Submit_Question_Captcha', 'No', 'yes'),
 (552, 'EWD_UFAQ_Admin_Question_Notification', 'No', 'yes'),
 (553, 'EWD_UFAQ_Submit_FAQ_Email', '0', 'yes'),
 (554, 'EWD_UFAQ_Auto_Complete_Titles', 'Yes', 'yes'),
 (555, 'EWD_UFAQ_Slug_Base', 'ufaqs', 'yes'),
 (556, 'EWD_UFAQ_FAQ_Elements', 'a:10:{i:0;s:11:"Author_Date";i:1;s:4:"Body";i:2;s:13:"Custom_Fields";i:3;s:10:"Categories";i:4;s:4:"Tags";i:5;s:7:"Ratings";i:6;s:12:"Social_Media";i:7;s:9:"Permalink";i:8;s:8:"Comments";i:9;s:11:"Back_To_Top";}', 'yes'),
 (557, 'EWD_UFAQ_Group_By_Category', 'No', 'yes'),
 (558, 'EWD_UFAQ_Group_By_Category_Count', 'No', 'yes'),
 (559, 'EWD_UFAQ_Group_By_Order_By', 'name', 'yes'),
 (560, 'EWD_UFAQ_Group_By_Order', 'ASC', 'yes'),
 (561, 'EWD_UFAQ_Order_By', 'date', 'yes'),
 (562, 'EWD_UFAQ_Order', 'DESC', 'yes'),
 (563, 'EWD_UFAQ_Hide_Blank_Fields', 'Yes', 'yes'),
 (564, 'EWD_UFAQ_Styling_Category_Heading_Type', 'h4', 'yes'),
 (565, 'EWD_UFAQ_Styling_FAQ_Heading_Type', 'h4', 'yes'),
 (566, 'EWD_UFAQ_Toggle_Symbol', 'A', 'yes'),
 (567, 'EWD_UFAQ_Full_Version', 'No', 'yes'),
 (568, 'EWD_UFAQ_Update_Flag', 'Yes', 'yes'),
 (569, 'EWD_UFAQ_Install_Flag', 'Yes', 'yes'),
 (570, 'EWD_UFAQ_Install_Version', '1.6', 'yes'),
 (571, 'EWD_UFAQ_Install_Time', '1529320010', 'yes'),
 (572, 'UFAQ_Run_Tutorial', 'Yes', 'yes'),
 (573, 'widget_ewd_ufaq_display_faq_post_list', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (574, 'widget_ewd_ufaq_display_recent_faqs', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (575, 'widget_ewd_ufaq_display_popular_faqs', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (576, 'widget_ewd_ufaq_display_random_faq', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (577, 'widget_ewd_ufaq_display_faq_categories', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (614, 'widget_eaw-recent-posts-plus', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
 (615, 'widget_eaw-recent-posts', 'a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}', 'yes'),
 (637, 'aptf_settings', 'a:15:{s:12:"consumer_key";s:0:"";s:15:"consumer_secret";s:0:"";s:12:"access_token";s:0:"";s:19:"access_token_secret";s:0:"";s:16:"twitter_username";s:0:"";s:20:"twitter_account_name";s:0:"";s:12:"cache_period";s:0:"";s:10:"total_feed";s:2:"10";s:13:"feed_template";s:10:"template-3";s:11:"time_format";s:9:"full_date";s:16:"display_username";i:1;s:23:"display_twitter_actions";i:1;s:16:"fallback_message";s:0:"";s:21:"display_follow_button";i:0;s:13:"disable_cache";i:0;}', 'yes'),
 (638, 'widget_aptf_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (639, 'widget_aptf_slider_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (640, 'widget_tf_static_tweets', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (641, 'twitter_feed_log', 'a:0:{}', 'yes'),
 (659, 'sw_twitter_plugin_options', 'a:7:{s:12:"sidebarImage";s:16:"twitter-icon.png";s:9:"marginTop";i:100;s:7:"pageURL";s:11:"BarackObama";s:4:"page";s:21:"115922316096420379836";s:5:"width";s:3:"292";s:6:"height";s:3:"400";s:9:"alignment";s:4:"left";}', 'yes'),
 (668, 'kebo_twitter_version', '1.5.12', 'yes'),
 (669, 'kebo_twitter_errors', 'a:0:{}', 'no'),
 (696, 'widget_rotatingtweets_widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (697, 'rotatingtweets-api-settings', 'a:10:{s:3:"key";s:25:"1nscl5O5iAzWYgr43tlNYfM8F";s:6:"secret";s:50:"LGNmZQShM84DkeLipoSNRIA55qhHw0N2Jp4wmp8v9YwRCp2wux";s:5:"token";s:50:"1008969182199865344-3ecpIdo6ytuRjf7CjhKQ1y59zAWWW9";s:12:"token_secret";s:45:"3DQtWTjJu8pknOLbZ5xJu99JZ17EaCD8LgfBfA7S6EhY0";s:14:"ssl_verify_off";b:0;s:7:"timeout";i:3;s:11:"cache_delay";i:120;s:20:"jquery_cycle_version";i:1;s:12:"js_in_footer";b:0;s:8:"hide_css";b:0;}', 'yes'),
 (713, 'rotatingtweets-twitter-languages', 'a:2:{s:9:"languages";a:33:{i:0;s:2:"fr";i:1;s:2:"en";i:2;s:2:"ar";i:3;s:2:"ja";i:4;s:2:"es";i:5;s:2:"de";i:6;s:2:"it";i:7;s:2:"id";i:8;s:2:"pt";i:9;s:2:"ko";i:10;s:2:"tr";i:11;s:2:"ru";i:12;s:2:"nl";i:13;s:3:"fil";i:14;s:3:"msa";i:15;s:5:"zh-tw";i:16;s:5:"zh-cn";i:17;s:2:"hi";i:18;s:2:"no";i:19;s:2:"sv";i:20;s:2:"fi";i:21;s:2:"da";i:22;s:2:"pl";i:23;s:2:"hu";i:24;s:2:"fa";i:25;s:2:"he";i:26;s:2:"th";i:27;s:2:"uk";i:28;s:2:"cs";i:29;s:2:"ro";i:30;s:5:"en-gb";i:31;s:2:"vi";i:32;s:2:"bn";}s:8:"datetime";i:1529392482;}', 'yes'),
 (2428, '_site_transient_update_themes', 'O:8:"stdClass":4:{s:12:"last_checked";i:1533539817;s:7:"checked";a:2:{s:26:"oceanwp-child-theme-master";s:3:"1.0";s:7:"oceanwp";s:6:"1.5.20";}s:8:"response";a:1:{s:7:"oceanwp";a:4:{s:5:"theme";s:7:"oceanwp";s:11:"new_version";s:6:"1.5.22";s:3:"url";s:37:"https://wordpress.org/themes/oceanwp/";s:7:"package";s:56:"https://downloads.wordpress.org/theme/oceanwp.1.5.22.zip";}}s:12:"translations";a:0:{}}', 'no'),
 (2430, '_site_transient_update_plugins', 'O:8:"stdClass":5:{s:12:"last_checked";i:1533539818;s:7:"checked";a:37:{s:53:"accesspress-twitter-feed/accesspress-twitter-feed.php";s:5:"1.5.7";s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:4:"6.71";s:23:"backup-wd/backup-wd.php";s:6:"1.0.17";s:36:"contact-form-7/wp-contact-form-7.php";s:5:"5.0.3";s:33:"duplicate-post/duplicate-post.php";s:5:"3.2.2";s:25:"duplicator/duplicator.php";s:6:"1.2.40";s:23:"elementor/elementor.php";s:5:"2.1.3";s:70:"addon-elements-for-elementor-page-builder/elementor-addon-elements.php";s:3:"1.1";s:51:"elementor-addon-widgets/elementor-addon-widgets.php";s:5:"1.2.3";s:60:"extended-buttons-for-elementor/elementor-button-extended.php";s:5:"1.0.2";s:31:"elementor-pro/elementor-pro.php";s:6:"2.0.16";s:65:"essential-addons-for-elementor-lite/essential_adons_elementor.php";s:5:"2.7.2";s:17:"faq-wd/faq_wd.php";s:6:"1.0.36";s:21:"flamingo/flamingo.php";s:3:"1.8";s:53:"flexible-elementor-panel/flexible-elementor-panel.php";s:5:"1.6.0";s:27:"icon-widget/icon-widget.php";s:5:"1.0.8";s:29:"jet-elements/jet-elements.php";s:6:"1.10.4";s:39:"kebo-twitter-feed/kebo-twitter-feed.php";s:6:"1.5.12";s:45:"addons-for-elementor/addons-for-elementor.php";s:3:"2.2";s:45:"ocean-custom-sidebar/ocean-custom-sidebar.php";s:5:"1.0.4";s:51:"ocean-elementor-widgets/ocean-elementor-widgets.php";s:6:"1.0.14";s:27:"ocean-extra/ocean-extra.php";s:6:"1.4.18";s:45:"ocean-footer-callout/ocean-footer-callout.php";s:6:"1.0.10";s:43:"ocean-sticky-header/ocean-sticky-header.php";s:5:"1.1.6";s:43:"modal-for-elementor/modal-for-elementor.php";s:5:"1.0.7";s:33:"rotatingtweets/rotatingtweets.php";s:5:"1.9.7";s:23:"simple-qa/qa-plugin.php";s:3:"2.1";s:18:"spider-faq/faq.php";s:3:"1.3";s:27:"svg-support/svg-support.php";s:6:"2.3.15";s:26:"tweet-slide/tweetslide.php";s:3:"1.0";s:41:"twitter-cards-meta/twitter-cards-meta.php";s:5:"2.9.0";s:29:"wd-twitter-feed/bootstrap.php";s:5:"3.0.8";s:47:"twitter-widget-slider/twitter-widget-slider.php";s:3:"1.0";s:22:"ultimate-faqs/Main.php";s:5:"1.7.2";s:51:"widgetkit-for-elementor/widgetkit-for-elementor.php";s:5:"1.1.2";s:41:"wp-google-maps-pro/wp-google-maps-pro.php";s:4:"6.27";s:23:"wp-rocket/wp-rocket.php";s:7:"3.0.5.1";}s:8:"response";a:9:{s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";O:8:"stdClass":12:{s:2:"id";s:37:"w.org/plugins/all-in-one-wp-migration";s:4:"slug";s:23:"all-in-one-wp-migration";s:6:"plugin";s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";s:11:"new_version";s:4:"6.73";s:3:"url";s:54:"https://wordpress.org/plugins/all-in-one-wp-migration/";s:7:"package";s:71:"https://downloads.wordpress.org/plugin/all-in-one-wp-migration.6.73.zip";s:5:"icons";a:2:{s:2:"2x";s:76:"https://ps.w.org/all-in-one-wp-migration/assets/icon-256x256.png?rev=1268186";s:2:"1x";s:76:"https://ps.w.org/all-in-one-wp-migration/assets/icon-128x128.png?rev=1268186";}s:7:"banners";a:2:{s:2:"2x";s:79:"https://ps.w.org/all-in-one-wp-migration/assets/banner-1544x500.png?rev=1876524";s:2:"1x";s:78:"https://ps.w.org/all-in-one-wp-migration/assets/banner-772x250.png?rev=1876524";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"4.9.7";s:12:"requires_php";s:6:"5.2.17";s:13:"compatibility";O:8:"stdClass":0:{}}s:23:"elementor/elementor.php";O:8:"stdClass":12:{s:2:"id";s:23:"w.org/plugins/elementor";s:4:"slug";s:9:"elementor";s:6:"plugin";s:23:"elementor/elementor.php";s:11:"new_version";s:5:"2.1.6";s:3:"url";s:40:"https://wordpress.org/plugins/elementor/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/elementor.2.1.6.zip";s:5:"icons";a:3:{s:2:"2x";s:62:"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768";s:2:"1x";s:54:"https://ps.w.org/elementor/assets/icon.svg?rev=1426809";s:3:"svg";s:54:"https://ps.w.org/elementor/assets/icon.svg?rev=1426809";}s:7:"banners";a:2:{s:2:"2x";s:65:"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479";s:2:"1x";s:64:"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"4.9.7";s:12:"requires_php";s:3:"5.4";s:13:"compatibility";O:8:"stdClass":0:{}}s:51:"elementor-addon-widgets/elementor-addon-widgets.php";O:8:"stdClass":12:{s:2:"id";s:37:"w.org/plugins/elementor-addon-widgets";s:4:"slug";s:23:"elementor-addon-widgets";s:6:"plugin";s:51:"elementor-addon-widgets/elementor-addon-widgets.php";s:11:"new_version";s:5:"1.2.5";s:3:"url";s:54:"https://wordpress.org/plugins/elementor-addon-widgets/";s:7:"package";s:66:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.zip";s:5:"icons";a:2:{s:2:"2x";s:76:"https://ps.w.org/elementor-addon-widgets/assets/icon-256x256.png?rev=1493594";s:2:"1x";s:76:"https://ps.w.org/elementor-addon-widgets/assets/icon-256x256.png?rev=1493594";}s:7:"banners";a:1:{s:2:"1x";s:78:"https://ps.w.org/elementor-addon-widgets/assets/banner-772x250.png?rev=1493594";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"4.9.7";s:12:"requires_php";b:0;s:13:"compatibility";O:8:"stdClass":0:{}}s:65:"essential-addons-for-elementor-lite/essential_adons_elementor.php";O:8:"stdClass":13:{s:2:"id";s:49:"w.org/plugins/essential-addons-for-elementor-lite";s:4:"slug";s:35:"essential-addons-for-elementor-lite";s:6:"plugin";s:65:"essential-addons-for-elementor-lite/essential_adons_elementor.php";s:11:"new_version";s:5:"2.7.5";s:3:"url";s:66:"https://wordpress.org/plugins/essential-addons-for-elementor-lite/";s:7:"package";s:78:"https://downloads.wordpress.org/plugin/essential-addons-for-elementor-lite.zip";s:5:"icons";a:2:{s:2:"2x";s:88:"https://ps.w.org/essential-addons-for-elementor-lite/assets/icon-256x256.png?rev=1906168";s:2:"1x";s:88:"https://ps.w.org/essential-addons-for-elementor-lite/assets/icon-128x128.png?rev=1906168";}s:7:"banners";a:2:{s:2:"2x";s:91:"https://ps.w.org/essential-addons-for-elementor-lite/assets/banner-1544x500.png?rev=1890267";s:2:"1x";s:90:"https://ps.w.org/essential-addons-for-elementor-lite/assets/banner-772x250.png?rev=1890267";}s:11:"banners_rtl";a:0:{}s:14:"upgrade_notice";s:169:"<ul>\n<li>Post elements improved and optimized</li>\n<li>Info Box element improved</li>\n<li>Flip Box element improved</li>\n<li>Few minor bugfix and improvements</li>\n</ul>";s:6:"tested";s:5:"4.9.7";s:12:"requires_php";s:3:"5.6";s:13:"compatibility";O:8:"stdClass":0:{}}s:53:"flexible-elementor-panel/flexible-elementor-panel.php";O:8:"stdClass":12:{s:2:"id";s:38:"w.org/plugins/flexible-elementor-panel";s:4:"slug";s:24:"flexible-elementor-panel";s:6:"plugin";s:53:"flexible-elementor-panel/flexible-elementor-panel.php";s:11:"new_version";s:5:"1.7.0";s:3:"url";s:55:"https://wordpress.org/plugins/flexible-elementor-panel/";s:7:"package";s:73:"https://downloads.wordpress.org/plugin/flexible-elementor-panel.1.7.0.zip";s:5:"icons";a:2:{s:2:"2x";s:77:"https://ps.w.org/flexible-elementor-panel/assets/icon-256x256.png?rev=1803032";s:2:"1x";s:77:"https://ps.w.org/flexible-elementor-panel/assets/icon-128x128.png?rev=1803032";}s:7:"banners";a:1:{s:2:"1x";s:79:"https://ps.w.org/flexible-elementor-panel/assets/banner-772x250.png?rev=1803075";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"4.9.7";s:12:"requires_php";s:3:"5.6";s:13:"compatibility";O:8:"stdClass":0:{}}s:45:"addons-for-elementor/addons-for-elementor.php";O:8:"stdClass":12:{s:2:"id";s:34:"w.org/plugins/addons-for-elementor";s:4:"slug";s:20:"addons-for-elementor";s:6:"plugin";s:45:"addons-for-elementor/addons-for-elementor.php";s:11:"new_version";s:5:"2.3.3";s:3:"url";s:51:"https://wordpress.org/plugins/addons-for-elementor/";s:7:"package";s:69:"https://downloads.wordpress.org/plugin/addons-for-elementor.2.3.3.zip";s:5:"icons";a:2:{s:2:"2x";s:73:"https://ps.w.org/addons-for-elementor/assets/icon-256x256.png?rev=1902466";s:2:"1x";s:73:"https://ps.w.org/addons-for-elementor/assets/icon-128x128.png?rev=1902466";}s:7:"banners";a:2:{s:2:"2x";s:76:"https://ps.w.org/addons-for-elementor/assets/banner-1544x500.jpg?rev=1687159";s:2:"1x";s:75:"https://ps.w.org/addons-for-elementor/assets/banner-772x250.jpg?rev=1687159";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"4.9.7";s:12:"requires_php";b:0;s:13:"compatibility";O:8:"stdClass":0:{}}s:27:"ocean-extra/ocean-extra.php";O:8:"stdClass":12:{s:2:"id";s:25:"w.org/plugins/ocean-extra";s:4:"slug";s:11:"ocean-extra";s:6:"plugin";s:27:"ocean-extra/ocean-extra.php";s:11:"new_version";s:6:"1.4.20";s:3:"url";s:42:"https://wordpress.org/plugins/ocean-extra/";s:7:"package";s:61:"https://downloads.wordpress.org/plugin/ocean-extra.1.4.20.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/ocean-extra/assets/icon-256x256.png?rev=1520440";s:2:"1x";s:64:"https://ps.w.org/ocean-extra/assets/icon-128x128.png?rev=1520440";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/ocean-extra/assets/banner-1544x500.png?rev=1583113";s:2:"1x";s:66:"https://ps.w.org/ocean-extra/assets/banner-772x250.png?rev=1583113";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"4.9.7";s:12:"requires_php";b:0;s:13:"compatibility";O:8:"stdClass":0:{}}s:22:"ultimate-faqs/Main.php";O:8:"stdClass":12:{s:2:"id";s:27:"w.org/plugins/ultimate-faqs";s:4:"slug";s:13:"ultimate-faqs";s:6:"plugin";s:22:"ultimate-faqs/Main.php";s:11:"new_version";s:5:"1.7.3";s:3:"url";s:44:"https://wordpress.org/plugins/ultimate-faqs/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/ultimate-faqs.zip";s:5:"icons";a:1:{s:2:"1x";s:66:"https://ps.w.org/ultimate-faqs/assets/icon-128x128.png?rev=1803957";}s:7:"banners";a:1:{s:2:"1x";s:68:"https://ps.w.org/ultimate-faqs/assets/banner-772x250.png?rev=1805913";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"4.9.8";s:12:"requires_php";b:0;s:13:"compatibility";O:8:"stdClass":0:{}}s:41:"wp-google-maps-pro/wp-google-maps-pro.php";O:8:"stdClass":13:{s:7:"version";s:4:"6.28";s:4:"date";s:10:"2018-07-18";s:6:"author";s:14:"WP Google Maps";s:8:"requires";s:3:"3.5";s:6:"tested";s:5:"4.9.6";s:8:"homepage";s:18:"http://wpgmaps.com";s:10:"downloaded";s:6:"162039";s:8:"external";s:0:"";s:7:"package";s:91:"http://ccplugins.co/api-wpgmaps-version-6/download.php?key=537f993c3dfe9a73d0c41c6d05d6cf56";s:9:"file_name";s:22:"wp-google-maps-pro.zip";s:8:"sections";a:6:{s:11:"description";s:252:"This is the Pro add-on for WP Google Maps. The Pro add-on enables you to add descriptions, pictures, links and custom icons to your markers as well as allows you to download your markers to a CSV file for quick editing and re-upload them when complete.";s:12:"installation";s:30:"Update and activate the plugin";s:12:"screen shots";s:12:"Screen Shots";s:9:"changelog";s:39:"Please see our website for more details";s:3:"faq";s:3:"FAQ";s:11:"other notes";s:11:"Other Notes";}s:4:"slug";s:18:"wp-google-maps-pro";s:11:"new_version";s:4:"6.28";}}s:12:"translations";a:0:{}s:9:"no_update";a:22:{s:53:"accesspress-twitter-feed/accesspress-twitter-feed.php";O:8:"stdClass":9:{s:2:"id";s:38:"w.org/plugins/accesspress-twitter-feed";s:4:"slug";s:24:"accesspress-twitter-feed";s:6:"plugin";s:53:"accesspress-twitter-feed/accesspress-twitter-feed.php";s:11:"new_version";s:5:"1.5.7";s:3:"url";s:55:"https://wordpress.org/plugins/accesspress-twitter-feed/";s:7:"package";s:73:"https://downloads.wordpress.org/plugin/accesspress-twitter-feed.1.5.7.zip";s:5:"icons";a:2:{s:2:"2x";s:77:"https://ps.w.org/accesspress-twitter-feed/assets/icon-256x256.jpg?rev=1111823";s:2:"1x";s:77:"https://ps.w.org/accesspress-twitter-feed/assets/icon-128x128.jpg?rev=1111823";}s:7:"banners";a:2:{s:2:"2x";s:80:"https://ps.w.org/accesspress-twitter-feed/assets/banner-1544x500.jpg?rev=1111870";s:2:"1x";s:79:"https://ps.w.org/accesspress-twitter-feed/assets/banner-772x250.jpg?rev=1111870";}s:11:"banners_rtl";a:0:{}}s:23:"backup-wd/backup-wd.php";O:8:"stdClass":9:{s:2:"id";s:23:"w.org/plugins/backup-wd";s:4:"slug";s:9:"backup-wd";s:6:"plugin";s:23:"backup-wd/backup-wd.php";s:11:"new_version";s:6:"1.0.17";s:3:"url";s:40:"https://wordpress.org/plugins/backup-wd/";s:7:"package";s:59:"https://downloads.wordpress.org/plugin/backup-wd.1.0.17.zip";s:5:"icons";a:1:{s:2:"1x";s:62:"https://ps.w.org/backup-wd/assets/icon-128x128.png?rev=1722460";}s:7:"banners";a:1:{s:2:"1x";s:64:"https://ps.w.org/backup-wd/assets/banner-772x250.png?rev=1722460";}s:11:"banners_rtl";a:0:{}}s:36:"contact-form-7/wp-contact-form-7.php";O:8:"stdClass":9:{s:2:"id";s:28:"w.org/plugins/contact-form-7";s:4:"slug";s:14:"contact-form-7";s:6:"plugin";s:36:"contact-form-7/wp-contact-form-7.php";s:11:"new_version";s:5:"5.0.3";s:3:"url";s:45:"https://wordpress.org/plugins/contact-form-7/";s:7:"package";s:63:"https://downloads.wordpress.org/plugin/contact-form-7.5.0.3.zip";s:5:"icons";a:2:{s:2:"2x";s:66:"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007";s:2:"1x";s:66:"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007";}s:7:"banners";a:2:{s:2:"2x";s:69:"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901";s:2:"1x";s:68:"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427";}s:11:"banners_rtl";a:0:{}}s:33:"duplicate-post/duplicate-post.php";O:8:"stdClass":9:{s:2:"id";s:28:"w.org/plugins/duplicate-post";s:4:"slug";s:14:"duplicate-post";s:6:"plugin";s:33:"duplicate-post/duplicate-post.php";s:11:"new_version";s:5:"3.2.2";s:3:"url";s:45:"https://wordpress.org/plugins/duplicate-post/";s:7:"package";s:63:"https://downloads.wordpress.org/plugin/duplicate-post.3.2.2.zip";s:5:"icons";a:2:{s:2:"2x";s:67:"https://ps.w.org/duplicate-post/assets/icon-256x256.png?rev=1612753";s:2:"1x";s:67:"https://ps.w.org/duplicate-post/assets/icon-128x128.png?rev=1612753";}s:7:"banners";a:1:{s:2:"1x";s:69:"https://ps.w.org/duplicate-post/assets/banner-772x250.png?rev=1612986";}s:11:"banners_rtl";a:0:{}}s:25:"duplicator/duplicator.php";O:8:"stdClass":9:{s:2:"id";s:24:"w.org/plugins/duplicator";s:4:"slug";s:10:"duplicator";s:6:"plugin";s:25:"duplicator/duplicator.php";s:11:"new_version";s:6:"1.2.40";s:3:"url";s:41:"https://wordpress.org/plugins/duplicator/";s:7:"package";s:60:"https://downloads.wordpress.org/plugin/duplicator.1.2.40.zip";s:5:"icons";a:2:{s:2:"2x";s:63:"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=1298463";s:2:"1x";s:63:"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=1298463";}s:7:"banners";a:1:{s:2:"1x";s:65:"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=1645055";}s:11:"banners_rtl";a:0:{}}s:70:"addon-elements-for-elementor-page-builder/elementor-addon-elements.php";O:8:"stdClass":9:{s:2:"id";s:55:"w.org/plugins/addon-elements-for-elementor-page-builder";s:4:"slug";s:41:"addon-elements-for-elementor-page-builder";s:6:"plugin";s:70:"addon-elements-for-elementor-page-builder/elementor-addon-elements.php";s:11:"new_version";s:3:"1.1";s:3:"url";s:72:"https://wordpress.org/plugins/addon-elements-for-elementor-page-builder/";s:7:"package";s:84:"https://downloads.wordpress.org/plugin/addon-elements-for-elementor-page-builder.zip";s:5:"icons";a:1:{s:2:"1x";s:94:"https://ps.w.org/addon-elements-for-elementor-page-builder/assets/icon-128x128.jpg?rev=1515290";}s:7:"banners";a:1:{s:2:"1x";s:96:"https://ps.w.org/addon-elements-for-elementor-page-builder/assets/banner-772x250.jpg?rev=1515290";}s:11:"banners_rtl";a:0:{}}s:60:"extended-buttons-for-elementor/elementor-button-extended.php";O:8:"stdClass":9:{s:2:"id";s:44:"w.org/plugins/extended-buttons-for-elementor";s:4:"slug";s:30:"extended-buttons-for-elementor";s:6:"plugin";s:60:"extended-buttons-for-elementor/elementor-button-extended.php";s:11:"new_version";s:5:"1.0.2";s:3:"url";s:61:"https://wordpress.org/plugins/extended-buttons-for-elementor/";s:7:"package";s:73:"https://downloads.wordpress.org/plugin/extended-buttons-for-elementor.zip";s:5:"icons";a:2:{s:2:"2x";s:83:"https://ps.w.org/extended-buttons-for-elementor/assets/icon-256x256.png?rev=1826588";s:2:"1x";s:83:"https://ps.w.org/extended-buttons-for-elementor/assets/icon-128x128.png?rev=1826588";}s:7:"banners";a:2:{s:2:"2x";s:86:"https://ps.w.org/extended-buttons-for-elementor/assets/banner-1544x500.png?rev=1826588";s:2:"1x";s:85:"https://ps.w.org/extended-buttons-for-elementor/assets/banner-772x250.png?rev=1826588";}s:11:"banners_rtl";a:0:{}}s:17:"faq-wd/faq_wd.php";O:8:"stdClass":9:{s:2:"id";s:20:"w.org/plugins/faq-wd";s:4:"slug";s:6:"faq-wd";s:6:"plugin";s:17:"faq-wd/faq_wd.php";s:11:"new_version";s:6:"1.0.36";s:3:"url";s:37:"https://wordpress.org/plugins/faq-wd/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/faq-wd.1.0.36.zip";s:5:"icons";a:1:{s:2:"1x";s:59:"https://ps.w.org/faq-wd/assets/icon-128x128.png?rev=1524001";}s:7:"banners";a:1:{s:2:"1x";s:61:"https://ps.w.org/faq-wd/assets/banner-772x250.jpg?rev=1524001";}s:11:"banners_rtl";a:0:{}}s:21:"flamingo/flamingo.php";O:8:"stdClass":9:{s:2:"id";s:22:"w.org/plugins/flamingo";s:4:"slug";s:8:"flamingo";s:6:"plugin";s:21:"flamingo/flamingo.php";s:11:"new_version";s:3:"1.8";s:3:"url";s:39:"https://wordpress.org/plugins/flamingo/";s:7:"package";s:55:"https://downloads.wordpress.org/plugin/flamingo.1.8.zip";s:5:"icons";a:1:{s:2:"1x";s:61:"https://ps.w.org/flamingo/assets/icon-128x128.png?rev=1540977";}s:7:"banners";a:1:{s:2:"1x";s:62:"https://ps.w.org/flamingo/assets/banner-772x250.png?rev=544829";}s:11:"banners_rtl";a:0:{}}s:27:"icon-widget/icon-widget.php";O:8:"stdClass":9:{s:2:"id";s:25:"w.org/plugins/icon-widget";s:4:"slug";s:11:"icon-widget";s:6:"plugin";s:27:"icon-widget/icon-widget.php";s:11:"new_version";s:5:"1.0.8";s:3:"url";s:42:"https://wordpress.org/plugins/icon-widget/";s:7:"package";s:54:"https://downloads.wordpress.org/plugin/icon-widget.zip";s:5:"icons";a:2:{s:2:"2x";s:64:"https://ps.w.org/icon-widget/assets/icon-256x256.png?rev=1729008";s:2:"1x";s:64:"https://ps.w.org/icon-widget/assets/icon-128x128.png?rev=1729008";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/icon-widget/assets/banner-1544x500.png?rev=1729009";s:2:"1x";s:66:"https://ps.w.org/icon-widget/assets/banner-772x250.png?rev=1729009";}s:11:"banners_rtl";a:0:{}}s:39:"kebo-twitter-feed/kebo-twitter-feed.php";O:8:"stdClass":9:{s:2:"id";s:31:"w.org/plugins/kebo-twitter-feed";s:4:"slug";s:17:"kebo-twitter-feed";s:6:"plugin";s:39:"kebo-twitter-feed/kebo-twitter-feed.php";s:11:"new_version";s:6:"1.5.12";s:3:"url";s:48:"https://wordpress.org/plugins/kebo-twitter-feed/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/kebo-twitter-feed.1.5.12.zip";s:5:"icons";a:1:{s:7:"default";s:68:"https://s.w.org/plugins/geopattern-icon/kebo-twitter-feed_20a6cf.svg";}s:7:"banners";a:1:{s:2:"1x";s:71:"https://ps.w.org/kebo-twitter-feed/assets/banner-772x250.png?rev=878973";}s:11:"banners_rtl";a:0:{}}s:45:"ocean-custom-sidebar/ocean-custom-sidebar.php";O:8:"stdClass":9:{s:2:"id";s:34:"w.org/plugins/ocean-custom-sidebar";s:4:"slug";s:20:"ocean-custom-sidebar";s:6:"plugin";s:45:"ocean-custom-sidebar/ocean-custom-sidebar.php";s:11:"new_version";s:5:"1.0.4";s:3:"url";s:51:"https://wordpress.org/plugins/ocean-custom-sidebar/";s:7:"package";s:69:"https://downloads.wordpress.org/plugin/ocean-custom-sidebar.1.0.4.zip";s:5:"icons";a:2:{s:2:"2x";s:73:"https://ps.w.org/ocean-custom-sidebar/assets/icon-256x256.png?rev=1526385";s:2:"1x";s:73:"https://ps.w.org/ocean-custom-sidebar/assets/icon-128x128.png?rev=1526385";}s:7:"banners";a:2:{s:2:"2x";s:76:"https://ps.w.org/ocean-custom-sidebar/assets/banner-1544x500.png?rev=1583109";s:2:"1x";s:75:"https://ps.w.org/ocean-custom-sidebar/assets/banner-772x250.png?rev=1583109";}s:11:"banners_rtl";a:0:{}}s:43:"modal-for-elementor/modal-for-elementor.php";O:8:"stdClass":9:{s:2:"id";s:33:"w.org/plugins/modal-for-elementor";s:4:"slug";s:19:"modal-for-elementor";s:6:"plugin";s:43:"modal-for-elementor/modal-for-elementor.php";s:11:"new_version";s:5:"1.0.7";s:3:"url";s:50:"https://wordpress.org/plugins/modal-for-elementor/";s:7:"package";s:68:"https://downloads.wordpress.org/plugin/modal-for-elementor.1.0.7.zip";s:5:"icons";a:2:{s:2:"2x";s:72:"https://ps.w.org/modal-for-elementor/assets/icon-256x256.png?rev=1772412";s:2:"1x";s:72:"https://ps.w.org/modal-for-elementor/assets/icon-256x256.png?rev=1772412";}s:7:"banners";a:1:{s:2:"1x";s:74:"https://ps.w.org/modal-for-elementor/assets/banner-772x250.png?rev=1772412";}s:11:"banners_rtl";a:0:{}}s:33:"rotatingtweets/rotatingtweets.php";O:8:"stdClass":9:{s:2:"id";s:28:"w.org/plugins/rotatingtweets";s:4:"slug";s:14:"rotatingtweets";s:6:"plugin";s:33:"rotatingtweets/rotatingtweets.php";s:11:"new_version";s:5:"1.9.7";s:3:"url";s:45:"https://wordpress.org/plugins/rotatingtweets/";s:7:"package";s:63:"https://downloads.wordpress.org/plugin/rotatingtweets.1.9.7.zip";s:5:"icons";a:1:{s:7:"default";s:58:"https://s.w.org/plugins/geopattern-icon/rotatingtweets.svg";}s:7:"banners";a:0:{}s:11:"banners_rtl";a:0:{}}s:23:"simple-qa/qa-plugin.php";O:8:"stdClass":9:{s:2:"id";s:23:"w.org/plugins/simple-qa";s:4:"slug";s:9:"simple-qa";s:6:"plugin";s:23:"simple-qa/qa-plugin.php";s:11:"new_version";s:3:"2.1";s:3:"url";s:40:"https://wordpress.org/plugins/simple-qa/";s:7:"package";s:56:"https://downloads.wordpress.org/plugin/simple-qa.2.1.zip";s:5:"icons";a:2:{s:2:"2x";s:62:"https://ps.w.org/simple-qa/assets/icon-256x256.png?rev=1359670";s:2:"1x";s:62:"https://ps.w.org/simple-qa/assets/icon-128x128.png?rev=1359670";}s:7:"banners";a:1:{s:2:"1x";s:64:"https://ps.w.org/simple-qa/assets/banner-772x250.png?rev=1359670";}s:11:"banners_rtl";a:0:{}}s:18:"spider-faq/faq.php";O:8:"stdClass":9:{s:2:"id";s:24:"w.org/plugins/spider-faq";s:4:"slug";s:10:"spider-faq";s:6:"plugin";s:18:"spider-faq/faq.php";s:11:"new_version";s:3:"1.3";s:3:"url";s:41:"https://wordpress.org/plugins/spider-faq/";s:7:"package";s:57:"https://downloads.wordpress.org/plugin/spider-faq.1.3.zip";s:5:"icons";a:1:{s:2:"1x";s:63:"https://ps.w.org/spider-faq/assets/icon-128x128.png?rev=1523992";}s:7:"banners";a:1:{s:2:"1x";s:65:"https://ps.w.org/spider-faq/assets/banner-772x250.jpg?rev=1523992";}s:11:"banners_rtl";a:0:{}}s:27:"svg-support/svg-support.php";O:8:"stdClass":9:{s:2:"id";s:25:"w.org/plugins/svg-support";s:4:"slug";s:11:"svg-support";s:6:"plugin";s:27:"svg-support/svg-support.php";s:11:"new_version";s:6:"2.3.15";s:3:"url";s:42:"https://wordpress.org/plugins/svg-support/";s:7:"package";s:61:"https://downloads.wordpress.org/plugin/svg-support.2.3.15.zip";s:5:"icons";a:3:{s:2:"2x";s:64:"https://ps.w.org/svg-support/assets/icon-256x256.png?rev=1417738";s:2:"1x";s:56:"https://ps.w.org/svg-support/assets/icon.svg?rev=1417738";s:3:"svg";s:56:"https://ps.w.org/svg-support/assets/icon.svg?rev=1417738";}s:7:"banners";a:2:{s:2:"2x";s:67:"https://ps.w.org/svg-support/assets/banner-1544x500.jpg?rev=1215377";s:2:"1x";s:66:"https://ps.w.org/svg-support/assets/banner-772x250.jpg?rev=1215377";}s:11:"banners_rtl";a:0:{}}s:26:"tweet-slide/tweetslide.php";O:8:"stdClass":9:{s:2:"id";s:25:"w.org/plugins/tweet-slide";s:4:"slug";s:11:"tweet-slide";s:6:"plugin";s:26:"tweet-slide/tweetslide.php";s:11:"new_version";s:3:"1.0";s:3:"url";s:42:"https://wordpress.org/plugins/tweet-slide/";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/tweet-slide.1.0.zip";s:5:"icons";a:1:{s:2:"1x";s:64:"https://ps.w.org/tweet-slide/assets/icon-128x128.png?rev=1271271";}s:7:"banners";a:1:{s:2:"1x";s:66:"https://ps.w.org/tweet-slide/assets/banner-772x250.png?rev=1271271";}s:11:"banners_rtl";a:0:{}}s:41:"twitter-cards-meta/twitter-cards-meta.php";O:8:"stdClass":9:{s:2:"id";s:32:"w.org/plugins/twitter-cards-meta";s:4:"slug";s:18:"twitter-cards-meta";s:6:"plugin";s:41:"twitter-cards-meta/twitter-cards-meta.php";s:11:"new_version";s:5:"2.9.0";s:3:"url";s:49:"https://wordpress.org/plugins/twitter-cards-meta/";s:7:"package";s:67:"https://downloads.wordpress.org/plugin/twitter-cards-meta.2.9.0.zip";s:5:"icons";a:2:{s:2:"2x";s:71:"https://ps.w.org/twitter-cards-meta/assets/icon-256x256.png?rev=1163732";s:2:"1x";s:71:"https://ps.w.org/twitter-cards-meta/assets/icon-128x128.png?rev=1163732";}s:7:"banners";a:2:{s:2:"2x";s:74:"https://ps.w.org/twitter-cards-meta/assets/banner-1544x500.png?rev=1163130";s:2:"1x";s:73:"https://ps.w.org/twitter-cards-meta/assets/banner-772x250.png?rev=1163130";}s:11:"banners_rtl";a:0:{}}s:29:"wd-twitter-feed/bootstrap.php";O:8:"stdClass":9:{s:2:"id";s:29:"w.org/plugins/wd-twitter-feed";s:4:"slug";s:15:"wd-twitter-feed";s:6:"plugin";s:29:"wd-twitter-feed/bootstrap.php";s:11:"new_version";s:5:"3.0.8";s:3:"url";s:46:"https://wordpress.org/plugins/wd-twitter-feed/";s:7:"package";s:64:"https://downloads.wordpress.org/plugin/wd-twitter-feed.3.0.8.zip";s:5:"icons";a:2:{s:2:"2x";s:68:"https://ps.w.org/wd-twitter-feed/assets/icon-256x256.png?rev=1368808";s:2:"1x";s:68:"https://ps.w.org/wd-twitter-feed/assets/icon-128x128.png?rev=1368808";}s:7:"banners";a:1:{s:2:"1x";s:70:"https://ps.w.org/wd-twitter-feed/assets/banner-772x250.png?rev=1368808";}s:11:"banners_rtl";a:0:{}}s:47:"twitter-widget-slider/twitter-widget-slider.php";O:8:"stdClass":9:{s:2:"id";s:35:"w.org/plugins/twitter-widget-slider";s:4:"slug";s:21:"twitter-widget-slider";s:6:"plugin";s:47:"twitter-widget-slider/twitter-widget-slider.php";s:11:"new_version";s:3:"1.0";s:3:"url";s:52:"https://wordpress.org/plugins/twitter-widget-slider/";s:7:"package";s:64:"https://downloads.wordpress.org/plugin/twitter-widget-slider.zip";s:5:"icons";a:1:{s:7:"default";s:65:"https://s.w.org/plugins/geopattern-icon/twitter-widget-slider.svg";}s:7:"banners";a:0:{}s:11:"banners_rtl";a:0:{}}s:51:"widgetkit-for-elementor/widgetkit-for-elementor.php";O:8:"stdClass":9:{s:2:"id";s:37:"w.org/plugins/widgetkit-for-elementor";s:4:"slug";s:23:"widgetkit-for-elementor";s:6:"plugin";s:51:"widgetkit-for-elementor/widgetkit-for-elementor.php";s:11:"new_version";s:5:"1.1.2";s:3:"url";s:54:"https://wordpress.org/plugins/widgetkit-for-elementor/";s:7:"package";s:72:"https://downloads.wordpress.org/plugin/widgetkit-for-elementor.1.1.2.zip";s:5:"icons";a:1:{s:2:"1x";s:76:"https://ps.w.org/widgetkit-for-elementor/assets/icon-128x128.jpg?rev=1900912";}s:7:"banners";a:1:{s:2:"1x";s:78:"https://ps.w.org/widgetkit-for-elementor/assets/banner-772x250.jpg?rev=1900057";}s:11:"banners_rtl";a:0:{}}}}', 'no'),
 (2432, '_site_transient_update_wprocket', '1533579424', 'no'),
 (2260, '_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9', '1532876682', 'no'),
 (2357, '_site_transient_timeout_browser_38c22bb012519835757bde70ce6c2767', '1533825065', 'no'),
 (2358, '_site_transient_browser_38c22bb012519835757bde70ce6c2767', 'a:10:{s:4:"name";s:6:"Chrome";s:7:"version";s:12:"67.0.3396.99";s:8:"platform";s:9:"Macintosh";s:10:"update_url";s:29:"https://www.google.com/chrome";s:7:"img_src";s:43:"http://s.w.org/images/browsers/chrome.png?1";s:11:"img_src_ssl";s:44:"https://s.w.org/images/browsers/chrome.png?1";s:15:"current_version";s:2:"18";s:7:"upgrade";b:0;s:8:"insecure";b:0;s:6:"mobile";b:0;}', 'no'),
 (2435, '_transient_timeout_elementor_remote_info_api_data_2.1.3', '1533583319', 'no'),
 (2436, '_transient_elementor_remote_info_api_data_2.1.3', 'a:2:{s:9:"timestamp";i:1533540118;s:14:"upgrade_notice";a:2:{s:7:"version";s:5:"1.5.0";s:7:"message";s:0:"";}}', 'no'),
 (2437, '_transient_timeout_elementor_pro_license_data', '1533583322', 'no'),
 (2438, '_transient_elementor_pro_license_data', 'a:12:{s:7:"success";b:1;s:7:"license";s:5:"valid";s:9:"item_name";s:13:"Elementor Pro";s:8:"checksum";s:32:"bddbfe02934cee2a9e5a321f2e0f9117";s:7:"expires";s:19:"2019-05-24 23:59:59";s:10:"payment_id";s:6:"587339";s:13:"customer_name";s:16:"Tyco Interactive";s:14:"customer_email";s:14:"tal@tyco.co.il";s:13:"license_limit";i:0;s:10:"site_count";i:11;s:16:"activations_left";s:9:"unlimited";s:8:"price_id";s:1:"3";}', 'no'),
 (2446, '_transient_timeout_feed_mod_9437e8e02ec5af9028df4e5061705e72', '1533583325', 'no'),
 (2447, '_transient_feed_mod_9437e8e02ec5af9028df4e5061705e72', '1533540125', 'no'),
 (2448, '_transient_timeout_feed_9bc1b9ec726e1f508c5207949084454a', '1533583327', 'no'),
 (2449, '_transient_feed_9bc1b9ec726e1f508c5207949084454a', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"ThemeIsle Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://themeisle.com/blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:58:"WordPress Tutorials and Reviews for Beginners and Advanced";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 02 Aug 2018 11:28:29 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:30:"https://wordpress.org/?v=4.9.7";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:75:"https://themeisle.com/blog/wp-content/uploads/2018/03/logo_demo_bar_new.png";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:14:"ThemeIsle Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:26:"https://themeisle.com/blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:39:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:77:"Link Optimization: Why It Matters, Plus 3 Ways to Optimize Links on WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:45:"https://themeisle.com/blog/link-optimization/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:53:"https://themeisle.com/blog/link-optimization/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 02 Aug 2018 09:31:32 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Featured";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:17:"WordPress Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=16234";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1084:"<p>In theory, links are one of your WordPress site’s most basic elements. And while many webmasters just insert basic links and forget about them, there’s actually a lot you can do to improve their effectiveness through link optimization. After all, links aren’t much use if no one clicks on them. By putting some thought into how your links appear and function, you can improve their chances of attracting attention from visitors. What’s more, many of the most beneficial strategies for doing this are quite easy...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/link-optimization/" class="more-link">Continue Reading <span class="screen-reader-text">"Link Optimization: Why It Matters, Plus 3 Ways to Optimize Links on WordPress"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/link-optimization/">Link Optimization: Why It Matters, Plus 3 Ways to Optimize Links on WordPress</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"John Hughes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:50:"https://themeisle.com/blog/link-optimization/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:39:"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"How to Create Great-Looking WordPress Opt-in Forms, 100% Free";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"https://themeisle.com/blog/create-wordpress-opt-in-forms/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:65:"https://themeisle.com/blog/create-wordpress-opt-in-forms/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 01 Aug 2018 09:40:50 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:8:"Featured";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:17:"WordPress Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=14927";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1094:"<p>Displaying stylish and eye-catching WordPress opt-in forms on your website is an effective way to get more email subscribers and grow your following. However, many of the opt-in form solutions currently available are premium tools, with high price tags that may not be affordable for many blogs and smaller businesses. In this article, you&#8217;ll learn how to create WordPress opt-in forms using a totally free plugin called Optin Forms. By the end, you&#8217;ll know… Why the Optin Forms plugin makes a good free option Beyond its...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/create-wordpress-opt-in-forms/" class="more-link">Continue Reading <span class="screen-reader-text">"How to Create Great-Looking WordPress Opt-in Forms, 100% Free"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/create-wordpress-opt-in-forms/">How to Create Great-Looking WordPress Opt-in Forms, 100% Free</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Megan Jones";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:62:"https://themeisle.com/blog/create-wordpress-opt-in-forms/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:63:"GetResponse vs AWeber: A Comparison, Plus Which Is Best for You";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:49:"https://themeisle.com/blog/getresponse-vs-aweber/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:57:"https://themeisle.com/blog/getresponse-vs-aweber/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 31 Jul 2018 09:45:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:15:"WordPress Tools";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=14439";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1078:"<p>Struggling to choose between GetResponse vs AWeber to run your email marketing campaigns? The key to running a successful email marketing campaign is choosing the right tool. But with so many quality options, it can be tough to choose between services like GetResponse and AWeber. Both services offer tools that can help you build an email list and improve conversions. What’s more, each can be integrated with your WordPress website. However, there are enough distinctions between the two that it is possible to make an informed...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/getresponse-vs-aweber/" class="more-link">Continue Reading <span class="screen-reader-text">"GetResponse vs AWeber: A Comparison, Plus Which Is Best for You"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/getresponse-vs-aweber/">GetResponse vs AWeber: A Comparison, Plus Which Is Best for You</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"John Hughes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:54:"https://themeisle.com/blog/getresponse-vs-aweber/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:81:"Need WordPress Training Videos? Here Are 8 of the Best Places to Get Them in 2018";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"https://themeisle.com/blog/wordpress-training-videos/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:61:"https://themeisle.com/blog/wordpress-training-videos/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 30 Jul 2018 09:17:23 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=14854";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1106:"<p>High-quality WordPress tutorials are released into the world all the time. However, not all WordPress training videos are good. To help you find the ones that are, we decided to weed through the good, the bad, and the ugly to bring you our 8 favorite WordPress training videos (and courses) currently out there. Our 8 favorite spots for WordPress training videos Whether you’re an advanced WordPress user or you’re just starting out, these 8 outlets will enrich your mind with knowledge to knock your competition...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/wordpress-training-videos/" class="more-link">Continue Reading <span class="screen-reader-text">"Need WordPress Training Videos? Here Are 8 of the Best Places to Get Them in 2018"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/wordpress-training-videos/">Need WordPress Training Videos? Here Are 8 of the Best Places to Get Them in 2018</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"Bill Widmer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:58:"https://themeisle.com/blog/wordpress-training-videos/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:58:"5 Ways to Increase Your Blog Revenue and Traffic This Week";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:54:"https://themeisle.com/blog/increase-your-blog-revenue/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:63:"https://themeisle.com/blog/increase-your-blog-revenue/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 26 Jul 2018 08:18:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=17184";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1065:"<p>The internet is loaded with content. In fact, there are now more than a billion active sites on the internet today &#8211; all of which are creating new content and flooding the internet. With so much content already out there, it&#8217;s important to understand what is really working (and what isn&#8217;t) in reference to creating content and getting more traffic and customers to your brand. Content is always going to be important, but what&#8217;s even more important is content promotion. We all know that anyone...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/increase-your-blog-revenue/" class="more-link">Continue Reading <span class="screen-reader-text">"5 Ways to Increase Your Blog Revenue and Traffic This Week"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/increase-your-blog-revenue/">5 Ways to Increase Your Blog Revenue and Traffic This Week</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:19:"ThemeIsle Editorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:59:"https://themeisle.com/blog/increase-your-blog-revenue/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:61:"How to Build Your Own WordPress Auction Site With WooCommerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"https://themeisle.com/blog/wordpress-auction-site-how-to/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:65:"https://themeisle.com/blog/wordpress-auction-site-how-to/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 25 Jul 2018 09:29:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=14639";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1084:"<p>Want to build your own WordPress auction site like eBay? Thanks to WooCommerce and some add-ons, it&#8217;s surprisingly easy to start running WordPress auctions. What you need to build your WordPress auction site Depending on where you&#8217;re starting from in the process, you might need some of these elements listed below. First of all, you&#8217;ll need to find a WordPress hosting account and a domain name. Quite often you find a hosting provider with free domain names provided. In addition, it&#8217;s not a bad idea...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/wordpress-auction-site-how-to/" class="more-link">Continue Reading <span class="screen-reader-text">"How to Build Your Own WordPress Auction Site With WooCommerce"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/wordpress-auction-site-how-to/">How to Build Your Own WordPress Auction Site With WooCommerce</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Joe Warnimont";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:62:"https://themeisle.com/blog/wordpress-auction-site-how-to/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:86:"Morten Rand-Hendriksen Interview – On Bringing Ethics Into Web Design (#WCEU Series)";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:60:"https://themeisle.com/blog/morten-rand-hendriksen-interview/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:68:"https://themeisle.com/blog/morten-rand-hendriksen-interview/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 24 Jul 2018 10:32:13 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:17:"Pirate interviews";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=16834";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1148:"<p>Heya, everyone! It’s time for the second interview from our #WCEU series. If you missed our first interview with Hajj Flemings, be sure to check it out when you get a chance. Today, we’re sharing an insightful interview with Morten Rand-Hendriksen about ethics in web design. If you missed our other interviews, you can catch them all in their dedicated category. Morten Rand-Hendriksen interview: The ethics of web design What do you mean by ethical web design and how is it different from user-centered design? What is...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/morten-rand-hendriksen-interview/" class="more-link">Continue Reading <span class="screen-reader-text">"Morten Rand-Hendriksen Interview &#8211; On Bringing Ethics Into Web Design (#WCEU Series)"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/morten-rand-hendriksen-interview/">Morten Rand-Hendriksen Interview &#8211; On Bringing Ethics Into Web Design (#WCEU Series)</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:16:"Chris Fitzgerald";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:65:"https://themeisle.com/blog/morten-rand-hendriksen-interview/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:70:"3 Actionable Ways to Improve WordPress Accessibility for Your Visitors";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:51:"https://themeisle.com/blog/wordpress-accessibility/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:59:"https://themeisle.com/blog/wordpress-accessibility/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 23 Jul 2018 08:35:03 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=14641";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1074:"<p>When designing any website, it’s important to remember that not all of your potential visitors are the same. Simple capabilities many of us take for granted – such as the ability to see web pages or use a mouse – aren’t an option for everyone. This means optimizing for WordPress accessibility is essential. Fortunately, there are plenty of ways to make your site more user-friendly, even for those with special challenges. All it takes is understanding what those visitors need, and taking a hard look...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/wordpress-accessibility/" class="more-link">Continue Reading <span class="screen-reader-text">"3 Actionable Ways to Improve WordPress Accessibility for Your Visitors"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/wordpress-accessibility/">3 Actionable Ways to Improve WordPress Accessibility for Your Visitors</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:11:"John Hughes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:56:"https://themeisle.com/blog/wordpress-accessibility/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"15 Meta Description Examples, Plus How to Write a Perfect Meta Description";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"https://themeisle.com/blog/meta-description-examples/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:61:"https://themeisle.com/blog/meta-description-examples/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 19 Jul 2018 09:00:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:18:"Beginner Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=16295";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1126:"<p>If you&#8217;re confused about how to write your meta descriptions, you&#8217;re not the only one. To help remove that confusion, I&#8217;m going to dig into what makes a great meta description and share 15 killer meta description examples. So what is a meta description? A meta description is the brief snippet you see underneath a site&#8217;s title in Google&#8217;s organic search results. Here&#8217;s an example of what it usually looks like: Why is your content&#8217;s meta description important? Back in September 2009, Google announced that...<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/meta-description-examples/" class="more-link">Continue Reading <span class="screen-reader-text">"15 Meta Description Examples, Plus How to Write a Perfect Meta Description"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/meta-description-examples/">15 Meta Description Examples, Plus How to Write a Perfect Meta Description</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:7:"Raelene";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:58:"https://themeisle.com/blog/meta-description-examples/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:36:"\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:83:"Using Print-on-Demand to Sell Your Own Merchandise on WordPress: Beginner’s Guide";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:56:"https://themeisle.com/blog/print-on-demand-on-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:64:"https://themeisle.com/blog/print-on-demand-on-wordpress/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 18 Jul 2018 08:23:05 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:15:"WordPress Tools";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:35:"https://themeisle.com/blog/?p=17113";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1113:"<p>The topic of website monetization is one of the most common and also one of the more mysterious ones out there. We&#8217;ve been talking a lot about monetization in other places, and there are lots of methods to make your time worthwhile with a site. However, how about looking into something that might not be that obvious at first? This is where custom merchandise comes into play and the idea of print-on-demand on WordPress. This is a contribution by Fionn Concannon: E-commerce is a thriving sector....<span class="clearfix clearfix-post"></span><a href="https://themeisle.com/blog/print-on-demand-on-wordpress/" class="more-link">Continue Reading <span class="screen-reader-text">"Using Print-on-Demand to Sell Your Own Merchandise on WordPress: Beginner&#8217;s Guide"</span> <span class="meta-nav">&#8594;</span></a></p>\n<p>The post <a rel="nofollow" href="https://themeisle.com/blog/print-on-demand-on-wordpress/">Using Print-on-Demand to Sell Your Own Merchandise on WordPress: Beginner&#8217;s Guide</a> appeared first on <a rel="nofollow" href="https://themeisle.com/blog">ThemeIsle Blog</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:19:"ThemeIsle Editorial";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:61:"https://themeisle.com/blog/print-on-demand-on-wordpress/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:32:"https://themeisle.com/blog/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:"\0*\0data";a:10:{s:4:"date";s:29:"Mon, 06 Aug 2018 07:22:07 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:6:"server";s:17:"Pagely-ARES/1.3.4";s:13:"last-modified";s:29:"Thu, 02 Aug 2018 11:28:29 GMT";s:4:"etag";s:34:""0573fd710273d01cf3ee77e519575741"";s:12:"x-robots-tag";s:15:"noindex, follow";s:4:"link";s:63:"<https://themeisle.com/blog/wp-json/>; rel="https://api.w.org/"";s:19:"x-gateway-cache-key";s:43:"0|standard|https|themeisle.com||/blog/feed/";s:22:"x-gateway-cache-status";s:3:"HIT";s:20:"x-gateway-skip-cache";s:1:"0";}}s:5:"build";s:14:"20180621115444";}', 'no'),
 (2450, '_transient_timeout_feed_mod_9bc1b9ec726e1f508c5207949084454a', '1533583327', 'no'),
 (2451, '_transient_feed_mod_9bc1b9ec726e1f508c5207949084454a', '1533540127', 'no'),
 (2452, '_transient_timeout_themeisle_sdk_feed_items', '1533712927', 'no'),
 (2453, '_transient_themeisle_sdk_feed_items', 'a:5:{i:0;a:3:{s:5:"title";s:77:"Link Optimization: Why It Matters, Plus 3 Ways to Optimize Links on WordPress";s:4:"date";i:1533202292;s:4:"link";s:45:"https://themeisle.com/blog/link-optimization/";}i:1;a:3:{s:5:"title";s:61:"How to Create Great-Looking WordPress Opt-in Forms, 100% Free";s:4:"date";i:1533116450;s:4:"link";s:57:"https://themeisle.com/blog/create-wordpress-opt-in-forms/";}i:2;a:3:{s:5:"title";s:63:"GetResponse vs AWeber: A Comparison, Plus Which Is Best for You";s:4:"date";i:1533030344;s:4:"link";s:49:"https://themeisle.com/blog/getresponse-vs-aweber/";}i:3;a:3:{s:5:"title";s:81:"Need WordPress Training Videos? Here Are 8 of the Best Places to Get Them in 2018";s:4:"date";i:1532942243;s:4:"link";s:53:"https://themeisle.com/blog/wordpress-training-videos/";}i:4;a:3:{s:5:"title";s:58:"5 Ways to Increase Your Blog Revenue and Traffic This Week";s:4:"date";i:1532593093;s:4:"link";s:54:"https://themeisle.com/blog/increase-your-blog-revenue/";}}', 'no'),
 (2454, '_transient_timeout_themeisle_sdk_products', '1533561730', 'no'),
 (2455, '_transient_themeisle_sdk_products', 'a:41:{i:0;a:4:{s:4:"name";s:5:"Orfeo";s:4:"type";s:5:"theme";s:4:"slug";s:5:"orfeo";s:8:"installs";i:10000;}i:1;a:4:{s:4:"name";s:6:"Hestia";s:4:"type";s:5:"theme";s:4:"slug";s:6:"hestia";s:8:"installs";i:100000;}i:2;a:4:{s:4:"name";s:15:"Llorix One Lite";s:4:"type";s:5:"theme";s:4:"slug";s:15:"llorix-one-lite";s:8:"installs";i:20000;}i:3;a:4:{s:4:"name";s:14:"ResponsiveBoat";s:4:"type";s:5:"theme";s:4:"slug";s:14:"responsiveboat";s:8:"installs";i:10000;}i:4;a:4:{s:4:"name";s:4:"Oria";s:4:"type";s:5:"theme";s:4:"slug";s:4:"oria";s:8:"installs";i:10000;}i:5;a:4:{s:4:"name";s:7:"Oblique";s:4:"type";s:5:"theme";s:4:"slug";s:7:"oblique";s:8:"installs";i:30000;}i:6;a:4:{s:4:"name";s:7:"Amadeus";s:4:"type";s:5:"theme";s:4:"slug";s:7:"amadeus";s:8:"installs";i:10000;}i:7;a:4:{s:4:"name";s:14:"RokoPhoto Lite";s:4:"type";s:5:"theme";s:4:"slug";s:14:"rokophoto-lite";s:8:"installs";i:6000;}i:8;a:4:{s:4:"name";s:6:"FlyMag";s:4:"type";s:5:"theme";s:4:"slug";s:6:"flymag";s:8:"installs";i:8000;}i:9;a:4:{s:4:"name";s:11:"ZBlackbeard";s:4:"type";s:5:"theme";s:4:"slug";s:11:"zblackbeard";s:8:"installs";i:5000;}i:10;a:4:{s:4:"name";s:9:"Shop Isle";s:4:"type";s:5:"theme";s:4:"slug";s:9:"shop-isle";s:8:"installs";i:40000;}i:11;a:4:{s:4:"name";s:7:"islemag";s:4:"type";s:5:"theme";s:4:"slug";s:7:"islemag";s:8:"installs";i:10000;}i:12;a:4:{s:4:"name";s:10:"Azera Shop";s:4:"type";s:5:"theme";s:4:"slug";s:10:"azera-shop";s:8:"installs";i:8000;}i:13;a:4:{s:4:"name";s:19:"Advanced CSS Editor";s:4:"type";s:6:"plugin";s:4:"slug";s:19:"advanced-css-editor";s:8:"installs";i:10000;}i:14;a:4:{s:4:"name";s:59:"Contact Form &amp; SMTP Plugin for WordPress by PirateForms";s:4:"type";s:6:"plugin";s:4:"slug";s:12:"pirate-forms";s:8:"installs";i:300000;}i:15;a:4:{s:4:"name";s:28:"Custom Login Page Customizer";s:4:"type";s:6:"plugin";s:4:"slug";s:16:"login-customizer";s:8:"installs";i:80000;}i:16;a:4:{s:4:"name";s:53:"Elementor Addons &amp; Templates &#8211; Sizzify Lite";s:4:"type";s:6:"plugin";s:4:"slug";s:23:"elementor-addon-widgets";s:8:"installs";i:40000;}i:17;a:4:{s:4:"name";s:21:"FEEDZY RSS Feeds Lite";s:4:"type";s:6:"plugin";s:4:"slug";s:16:"feedzy-rss-feeds";s:8:"installs";i:20000;}i:18;a:4:{s:4:"name";s:30:"Google Maps Plugin by Intergeo";s:4:"type";s:6:"plugin";s:4:"slug";s:13:"intergeo-maps";s:8:"installs";i:60000;}i:19;a:4:{s:4:"name";s:20:"Llorix One Companion";s:4:"type";s:6:"plugin";s:4:"slug";s:20:"llorix-one-companion";s:8:"installs";i:20000;}i:20;a:4:{s:4:"name";s:23:"Menu Icons by ThemeIsle";s:4:"type";s:6:"plugin";s:4:"slug";s:10:"menu-icons";s:8:"installs";i:100000;}i:21;a:4:{s:4:"name";s:27:"NavMenu Addon For Elementor";s:4:"type";s:6:"plugin";s:4:"slug";s:27:"navmenu-addon-for-elementor";s:8:"installs";i:30000;}i:22;a:4:{s:4:"name";s:22:"Orbit Fox by ThemeIsle";s:4:"type";s:6:"plugin";s:4:"slug";s:19:"themeisle-companion";s:8:"installs";i:200000;}i:23;a:4:{s:4:"name";s:28:"Page Templater For Elementor";s:4:"type";s:6:"plugin";s:4:"slug";s:19:"elementor-templater";s:8:"installs";i:30000;}i:24;a:4:{s:4:"name";s:50:"Revive Old Posts &#8211; Auto Post to Social Media";s:4:"type";s:6:"plugin";s:4:"slug";s:14:"tweet-old-post";s:8:"installs";i:60000;}i:25;a:4:{s:4:"name";s:56:"Slider by Nivo &#8211; Responsive WordPress Image Slider";s:4:"type";s:6:"plugin";s:4:"slug";s:16:"nivo-slider-lite";s:8:"installs";i:40000;}i:26;a:4:{s:4:"name";s:32:"WordPress Charts and Graphs Lite";s:4:"type";s:6:"plugin";s:4:"slug";s:10:"visualizer";s:8:"installs";i:30000;}i:27;a:4:{s:4:"name";s:19:"Advanced CSS Editor";s:4:"type";s:6:"plugin";s:4:"slug";s:19:"advanced-css-editor";s:8:"installs";i:10000;}i:28;a:4:{s:4:"name";s:59:"Contact Form &amp; SMTP Plugin for WordPress by PirateForms";s:4:"type";s:6:"plugin";s:4:"slug";s:12:"pirate-forms";s:8:"installs";i:300000;}i:29;a:4:{s:4:"name";s:28:"Custom Login Page Customizer";s:4:"type";s:6:"plugin";s:4:"slug";s:16:"login-customizer";s:8:"installs";i:80000;}i:30;a:4:{s:4:"name";s:53:"Elementor Addons &amp; Templates &#8211; Sizzify Lite";s:4:"type";s:6:"plugin";s:4:"slug";s:23:"elementor-addon-widgets";s:8:"installs";i:40000;}i:31;a:4:{s:4:"name";s:21:"FEEDZY RSS Feeds Lite";s:4:"type";s:6:"plugin";s:4:"slug";s:16:"feedzy-rss-feeds";s:8:"installs";i:20000;}i:32;a:4:{s:4:"name";s:30:"Google Maps Plugin by Intergeo";s:4:"type";s:6:"plugin";s:4:"slug";s:13:"intergeo-maps";s:8:"installs";i:60000;}i:33;a:4:{s:4:"name";s:20:"Llorix One Companion";s:4:"type";s:6:"plugin";s:4:"slug";s:20:"llorix-one-companion";s:8:"installs";i:20000;}i:34;a:4:{s:4:"name";s:23:"Menu Icons by ThemeIsle";s:4:"type";s:6:"plugin";s:4:"slug";s:10:"menu-icons";s:8:"installs";i:100000;}i:35;a:4:{s:4:"name";s:27:"NavMenu Addon For Elementor";s:4:"type";s:6:"plugin";s:4:"slug";s:27:"navmenu-addon-for-elementor";s:8:"installs";i:30000;}i:36;a:4:{s:4:"name";s:22:"Orbit Fox by ThemeIsle";s:4:"type";s:6:"plugin";s:4:"slug";s:19:"themeisle-companion";s:8:"installs";i:200000;}i:37;a:4:{s:4:"name";s:28:"Page Templater For Elementor";s:4:"type";s:6:"plugin";s:4:"slug";s:19:"elementor-templater";s:8:"installs";i:30000;}i:38;a:4:{s:4:"name";s:50:"Revive Old Posts &#8211; Auto Post to Social Media";s:4:"type";s:6:"plugin";s:4:"slug";s:14:"tweet-old-post";s:8:"installs";i:60000;}i:39;a:4:{s:4:"name";s:56:"Slider by Nivo &#8211; Responsive WordPress Image Slider";s:4:"type";s:6:"plugin";s:4:"slug";s:16:"nivo-slider-lite";s:8:"installs";i:40000;}i:40;a:4:{s:4:"name";s:32:"WordPress Charts and Graphs Lite";s:4:"type";s:6:"plugin";s:4:"slug";s:10:"visualizer";s:8:"installs";i:30000;}}', 'no'),
 (2456, '_transient_timeout_plugin_slugs', '1533626530', 'no'),
 (2457, '_transient_plugin_slugs', 'a:37:{i:0;s:53:"accesspress-twitter-feed/accesspress-twitter-feed.php";i:1;s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";i:2;s:23:"backup-wd/backup-wd.php";i:3;s:36:"contact-form-7/wp-contact-form-7.php";i:4;s:33:"duplicate-post/duplicate-post.php";i:5;s:25:"duplicator/duplicator.php";i:6;s:23:"elementor/elementor.php";i:7;s:70:"addon-elements-for-elementor-page-builder/elementor-addon-elements.php";i:8;s:51:"elementor-addon-widgets/elementor-addon-widgets.php";i:9;s:60:"extended-buttons-for-elementor/elementor-button-extended.php";i:10;s:31:"elementor-pro/elementor-pro.php";i:11;s:65:"essential-addons-for-elementor-lite/essential_adons_elementor.php";i:12;s:17:"faq-wd/faq_wd.php";i:13;s:21:"flamingo/flamingo.php";i:14;s:53:"flexible-elementor-panel/flexible-elementor-panel.php";i:15;s:27:"icon-widget/icon-widget.php";i:16;s:29:"jet-elements/jet-elements.php";i:17;s:39:"kebo-twitter-feed/kebo-twitter-feed.php";i:18;s:45:"addons-for-elementor/addons-for-elementor.php";i:19;s:45:"ocean-custom-sidebar/ocean-custom-sidebar.php";i:20;s:51:"ocean-elementor-widgets/ocean-elementor-widgets.php";i:21;s:27:"ocean-extra/ocean-extra.php";i:22;s:45:"ocean-footer-callout/ocean-footer-callout.php";i:23;s:43:"ocean-sticky-header/ocean-sticky-header.php";i:24;s:43:"modal-for-elementor/modal-for-elementor.php";i:25;s:33:"rotatingtweets/rotatingtweets.php";i:26;s:23:"simple-qa/qa-plugin.php";i:27;s:18:"spider-faq/faq.php";i:28;s:27:"svg-support/svg-support.php";i:29;s:26:"tweet-slide/tweetslide.php";i:30;s:41:"twitter-cards-meta/twitter-cards-meta.php";i:31;s:29:"wd-twitter-feed/bootstrap.php";i:32;s:47:"twitter-widget-slider/twitter-widget-slider.php";i:33;s:22:"ultimate-faqs/Main.php";i:34;s:51:"widgetkit-for-elementor/widgetkit-for-elementor.php";i:35;s:41:"wp-google-maps-pro/wp-google-maps-pro.php";i:36;s:23:"wp-rocket/wp-rocket.php";}', 'no'),
 (2433, '_transient_timeout_jet_elements_categories_1.10.4', '1534144919', 'no'),
 (2434, '_transient_jet_elements_categories_1.10.4', 'a:24:{i:0;s:21:"jet advanced carousel";i:1;s:16:"jet advanced map";i:2;s:16:"jet animated box";i:3;s:17:"jet animated text";i:4;s:10:"jet banner";i:5;s:10:"jet brands";i:6;s:10:"jet button";i:7;s:19:"jet circle progress";i:8;s:19:"jet countdown timer";i:9;s:12:"jet headline";i:10;s:20:"jet image comparison";i:11;s:22:"jet images grid layout";i:12;s:25:"jet images justify layout";i:13;s:25:"jet images masonry layout";i:14;s:17:"jet post carousel";i:15;s:15:"jet post slider";i:16;s:14:"jet posts grid";i:17;s:17:"jet pricing table";i:18;s:16:"jet progress bar";i:19;s:12:"jet services";i:20;s:10:"jet slider";i:21;s:18:"jet subscribe form";i:22;s:16:"jet team members";i:23;s:16:"jet testimonials";}', 'no'),
 (2386, '_site_transient_update_core', 'O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:59:"https://downloads.wordpress.org/release/wordpress-4.9.8.zip";s:6:"locale";s:5:"en_US";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:59:"https://downloads.wordpress.org/release/wordpress-4.9.8.zip";s:10:"no_content";s:70:"https://downloads.wordpress.org/release/wordpress-4.9.8-no-content.zip";s:11:"new_bundled";s:71:"https://downloads.wordpress.org/release/wordpress-4.9.8-new-bundled.zip";s:7:"partial";b:0;s:8:"rollback";b:0;}s:7:"current";s:5:"4.9.8";s:7:"version";s:5:"4.9.8";s:11:"php_version";s:5:"5.2.4";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"4.7";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1533539816;s:15:"version_checked";s:5:"4.9.8";s:12:"translations";a:0:{}}', 'no'),
 (1991, 'category_children', 'a:0:{}', 'yes'),
 (2460, 'buwd_job_running', '1', 'no'),
 (2461, 'buwd_user_id', '2', 'no'),
 (2462, 'buwd_progress', 'a:6:{s:8:"progress";d:17;s:12:"current_step";s:22:"Creating database file";s:3:"log";s:84:"[06-Aug-2018 07:23:13] <span class="logline">1. Attempted to backup database.</span>";s:5:"error";b:0;s:4:"stop";b:0;s:3:"end";b:0;}', 'no'),
 (762, 'twcm_options', 'a:8:{s:21:"site_twitter_username";s:8:"GalGadot";s:27:"use_authors_twitter_account";s:0:"";s:14:"use_image_from";s:11:"first_image";s:18:"image_custom_field";s:5:"image";s:13:"default_image";s:0:"";s:21:"home_page_description";s:0:"";s:17:"default_card_type";s:7:"summary";s:30:"use_default_card_type_sitewide";s:0:"";}', 'yes'),
 (783, 'widgetkit_save_settings', 'a:26:{s:23:"widget-slider-animation";i:1;s:31:"widget-slider-content-animation";i:1;s:27:"widget-slider-box-animation";i:1;s:16:"widget-portfolio";i:1;s:18:"widget-feature-box";i:1;s:21:"widget-animation-text";i:1;s:16:"widget-countdown";i:1;s:21:"widget-pricing-single";i:1;s:19:"widget-pricing-icon";i:1;s:18:"widget-pricing-tab";i:1;s:17:"widget-team-round";i:1;s:21:"widget-team-animation";i:1;s:25:"widget-team-verticle-icon";i:1;s:19:"widget-team-overlay";i:1;s:13:"widget-button";i:1;s:18:"widget-hover-image";i:1;s:20:"widget-post-carousel";i:1;s:18:"widget-blog-revert";i:1;s:27:"widget-blog-hover-animation";i:1;s:17:"widget-blog-image";i:1;s:20:"widget-blog-carousel";i:1;s:19:"widget-blog-sidebar";i:1;s:25:"widget-testimonial-single";i:1;s:25:"widget-testimonial-center";i:1;s:29:"widget-social-share-animation";i:1;s:28:"widget-social-share-collapse";i:1;}', 'yes'),
 (784, 'lae_settings', 'a:17:{s:15:"lae_theme_color";s:7:"#f94213";s:21:"lae_theme_hover_color";s:7:"#888888";s:31:"lae_deactivate_element_carousel";s:4:"true";s:30:"lae_deactivate_element_clients";s:4:"true";s:30:"lae_deactivate_element_heading";s:4:"true";s:32:"lae_deactivate_element_odometers";s:4:"true";s:32:"lae_deactivate_element_piecharts";s:4:"true";s:32:"lae_deactivate_element_portfolio";s:4:"true";s:37:"lae_deactivate_element_posts_carousel";s:4:"true";s:36:"lae_deactivate_element_pricing_table";s:4:"true";s:31:"lae_deactivate_element_services";s:4:"true";s:32:"lae_deactivate_element_stats_bar";s:4:"true";s:27:"lae_deactivate_element_team";s:4:"true";s:35:"lae_deactivate_element_testimonials";s:4:"true";s:42:"lae_deactivate_element_testimonials_slider";s:4:"true";s:14:"lae_custom_css";s:0:"";s:16:"lae_enable_debug";s:0:"";}', 'yes'),
 (810, 'jet_elements_templates', 'a:141:{i:0;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #1";s:9:"thumbnail";s:73:"http://jetelements.zemez.io/wp-content/uploads/2018/03/progress-bar-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-1/";}i:1;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Button #4";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/button-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/button-4/";}i:2;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Button #3";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/button-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/button-3/";}i:3;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Button #2";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/button-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/button-2/";}i:4;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Button #1";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/button-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/button-1/";}i:5;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #1";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-1/";}i:6;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Testimonials #6";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/testimonials-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/testimonials-6/";}i:7;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Testimonials #5";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/testimonials-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/testimonials-5/";}i:8;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Testimonials #4";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/testimonials-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/testimonials-4/";}i:9;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Testimonials #3";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/testimonials-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/testimonials-3/";}i:10;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Testimonials #2";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/testimonials-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/testimonials-2/";}i:11;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Testimonials #1";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/testimonials-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/testimonials-1/";}i:12;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Team Members #6";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/team-members-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/team-members-6/";}i:13;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Team Members #5";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/team-members-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/team-members-5/";}i:14;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Team Members #4";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/team-members-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/team-members-4/";}i:15;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Team Members #3";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/team-members-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/team-members-3/";}i:16;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Team Members #2";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/team-members-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/team-members-2/";}i:17;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Team Members #1";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/team-members-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/team-members-1/";}i:18;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:17:"Subscribe Form #3";s:9:"thumbnail";s:78:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/subscribe-form-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:52:"http://jetelements.zemez.io/blocks/subscribe-form-3/";}i:19;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:17:"Subscribe Form #2";s:9:"thumbnail";s:78:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/subscribe-form-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:52:"http://jetelements.zemez.io/blocks/subscribe-form-2/";}i:20;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:17:"Subscribe Form #1";s:9:"thumbnail";s:78:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/subscribe-form-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:52:"http://jetelements.zemez.io/blocks/subscribe-form-1/";}i:21;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Slider #5";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/slider-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/slider-5/";}i:22;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Slider #4";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/slider-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/slider-4/";}i:23;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Slider #3";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/slider-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/slider-3/";}i:24;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Slider #2";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/slider-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/slider-2/";}i:25;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Slider #1";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/slider-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/slider-1/";}i:26;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Services #7";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/services-7.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/services-7/";}i:27;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Services #6";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/services-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/services-6/";}i:28;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Services #5";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/services-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/services-5/";}i:29;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Services #4";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/services-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/services-4/";}i:30;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Services #3";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/services-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/services-3/";}i:31;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Services #2";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/services-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/services-2/";}i:32;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Services #1";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/services-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/services-1/";}i:33;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #8";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/progress-bar-8.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-8/";}i:34;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #7";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/progress-bar-7.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-7/";}i:35;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #6";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/progress-bar-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-6/";}i:36;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #5";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/progress-bar-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-5/";}i:37;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #4";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/progress-bar-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-4/";}i:38;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #3";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/progress-bar-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-3/";}i:39;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Progress Bar #2";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/progress-bar-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/progress-bar-2/";}i:40;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Pricing Table #7";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/pricing-table-7.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/pricing-table-7/";}i:41;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Pricing Table #6";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/pricing-table-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/pricing-table-6/";}i:42;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Pricing Table #5";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/pricing-table-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/pricing-table-5/";}i:43;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Pricing Table #4";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/pricing-table-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/pricing-table-4/";}i:44;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Pricing Table #3";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/pricing-table-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/pricing-table-3/";}i:45;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Pricing Table #2";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/pricing-table-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/pricing-table-2/";}i:46;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Pricing Table #1";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/pricing-table-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/pricing-table-1/";}i:47;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:13:"Posts Grid #5";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/posts-grid-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:48:"http://jetelements.zemez.io/blocks/posts-grid-5/";}i:48;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:13:"Posts Grid #4";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/posts-grid-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:48:"http://jetelements.zemez.io/blocks/posts-grid-4/";}i:49;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:13:"Posts Grid #3";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/posts-grid-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:48:"http://jetelements.zemez.io/blocks/posts-grid-3/";}i:50;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:13:"Posts Grid #2";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/posts-grid-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:48:"http://jetelements.zemez.io/blocks/posts-grid-2/";}i:51;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:13:"Posts Grid #1";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/posts-grid-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:48:"http://jetelements.zemez.io/blocks/posts-grid-1/";}i:52;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:14:"Post Slider #5";s:9:"thumbnail";s:75:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-slider-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/blocks/post-slider-5/";}i:53;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:14:"Post Slider #4";s:9:"thumbnail";s:75:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-slider-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/blocks/post-slider-4/";}i:54;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:14:"Post Slider #3";s:9:"thumbnail";s:75:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-slider-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/blocks/post-slider-3/";}i:55;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:14:"Post Slider #2";s:9:"thumbnail";s:75:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-slider-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/blocks/post-slider-2/";}i:56;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:14:"Post Slider #1";s:9:"thumbnail";s:75:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-slider-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/blocks/post-slider-1/";}i:57;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Post Carousel #5";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-carousel-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/post-carousel-5/";}i:58;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Post Carousel #4";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-carousel-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/post-carousel-4/";}i:59;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Post Carousel #3";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-carousel-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/post-carousel-3/";}i:60;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Post Carousel #2";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-carousel-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/post-carousel-2/";}i:61;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Post Carousel #1";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/post-carousel-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/post-carousel-1/";}i:62;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Masonry Layout #5";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-masonry-layout-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-masonry-layout-5/";}i:63;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Masonry Layout #4";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-masonry-layout-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-masonry-layout-4/";}i:64;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Masonry Layout #3";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-masonry-layout-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-masonry-layout-3/";}i:65;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Masonry Layout #2";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-masonry-layout-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-masonry-layout-2/";}i:66;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Masonry Layout #1";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-masonry-layout-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-masonry-layout-1/";}i:67;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Justify Layout #5";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-justify-layout-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-justify-layout-5/";}i:68;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Justify Layout #4";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-justify-layout-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-justify-layout-4/";}i:69;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Justify Layout #3";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-justify-layout-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-justify-layout-3/";}i:70;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Justify Layout #2";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-justify-layout-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-justify-layout-2/";}i:71;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Images Justify Layout #1";s:9:"thumbnail";s:85:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-justify-layout-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:59:"http://jetelements.zemez.io/blocks/images-justify-layout-1/";}i:72;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:21:"Images Grid Layout #5";s:9:"thumbnail";s:82:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-grid-layout-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:56:"http://jetelements.zemez.io/blocks/images-grid-layout-5/";}i:73;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:21:"Images Grid Layout #4";s:9:"thumbnail";s:82:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-grid-layout-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:56:"http://jetelements.zemez.io/blocks/images-grid-layout-4/";}i:74;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:21:"Images Grid Layout #3";s:9:"thumbnail";s:82:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-grid-layout-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:56:"http://jetelements.zemez.io/blocks/images-grid-layout-3/";}i:75;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:21:"Images Grid Layout #2";s:9:"thumbnail";s:82:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-grid-layout-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:56:"http://jetelements.zemez.io/blocks/images-grid-layout-2/";}i:76;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:21:"Images Grid Layout #1";s:9:"thumbnail";s:82:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/images-grid-layout-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:56:"http://jetelements.zemez.io/blocks/images-grid-layout-1/";}i:77;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:19:"Image Comparison #3";s:9:"thumbnail";s:80:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/image-comparison-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:54:"http://jetelements.zemez.io/blocks/image-comparison-3/";}i:78;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:19:"Image Comparison #2";s:9:"thumbnail";s:80:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/image-comparison-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:54:"http://jetelements.zemez.io/blocks/image-comparison-2/";}i:79;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:19:"Image Comparison #1";s:9:"thumbnail";s:80:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/image-comparison-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:54:"http://jetelements.zemez.io/blocks/image-comparison-1/";}i:80;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Headline #7";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/headline-7.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/headline-7/";}i:81;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Headline #6";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/headline-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/headline-6/";}i:82;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Headline #5";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/headline-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/headline-5/";}i:83;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Headline #4";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/headline-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/headline-4/";}i:84;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Headline #3";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/headline-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/headline-3/";}i:85;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Headline #2";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/headline-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/headline-2/";}i:86;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:11:"Headline #1";s:9:"thumbnail";s:72:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/headline-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:46:"http://jetelements.zemez.io/blocks/headline-1/";}i:87;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Countdown Timer #6";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/countdown-timer-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/countdown-timer-6/";}i:88;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Countdown Timer #5";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/countdown-timer-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/countdown-timer-5/";}i:89;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Countdown Timer #4";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/countdown-timer-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/countdown-timer-4/";}i:90;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Countdown Timer #3";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/countdown-timer-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/countdown-timer-3/";}i:91;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Countdown Timer #2";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/countdown-timer-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/countdown-timer-2/";}i:92;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Countdown Timer #1";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/countdown-timer-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/countdown-timer-1/";}i:93;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Circle Progress #5";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/circle-progress-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/circle-progress-5/";}i:94;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Circle Progress #4";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/circle-progress-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/circle-progress-4/";}i:95;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Circle Progress #3";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/circle-progress-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/circle-progress-3/";}i:96;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Circle Progress #2";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/circle-progress-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/circle-progress-2/";}i:97;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:18:"Circle Progress #1";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/circle-progress-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:53:"http://jetelements.zemez.io/blocks/circle-progress-1/";}i:98;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Brands #5";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/brands-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/brands-5/";}i:99;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Brands #4";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/brands-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/brands-4/";}i:100;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Brands #3";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/brands-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/brands-3/";}i:101;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Brands #2";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/brands-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/brands-2/";}i:102;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Brands #1";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/brands-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/brands-1/";}i:103;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:10:"Banner #11";s:9:"thumbnail";s:71:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-11.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:45:"http://jetelements.zemez.io/blocks/banner-11/";}i:104;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:10:"Banner #10";s:9:"thumbnail";s:71:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-10.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:45:"http://jetelements.zemez.io/blocks/banner-10/";}i:105;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #9";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-9.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-9/";}i:106;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #8";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-8.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-8/";}i:107;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #7";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-7.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-7/";}i:108;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #6";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-6.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-6/";}i:109;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #5";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-5/";}i:110;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #4";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-4/";}i:111;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #3";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-3/";}i:112;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:9:"Banner #2";s:9:"thumbnail";s:70:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/banner-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:44:"http://jetelements.zemez.io/blocks/banner-2/";}i:113;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Animated Text #5";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-text-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/animated-text-5/";}i:114;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Animated Text #4";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-text-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/animated-text-4/";}i:115;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Animated Text #3";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-text-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/animated-text-3/";}i:116;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Animated Text #2";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-text-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/animated-text-2/";}i:117;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:16:"Animated Text #1";s:9:"thumbnail";s:77:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-text-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/blocks/animated-text-1/";}i:118;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Animated Box #4";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-box-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/animated-box-4/";}i:119;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Animated Box #3";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-box-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/animated-box-3/";}i:120;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Animated Box #2";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-box-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/animated-box-2/";}i:121;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Animated Box #1";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/animated-box-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/animated-box-1/";}i:122;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Advanced Map #5";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-map-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/advanced-map-5/";}i:123;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Advanced Map #4";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-map-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/advanced-map-4/";}i:124;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Advanced Map #3";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-map-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/advanced-map-3/";}i:125;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Advanced Map #2";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-map-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/advanced-map-2/";}i:126;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:15:"Advanced Map #1";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-map-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/blocks/advanced-map-1/";}i:127;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:20:"Advanced Carousel #5";s:9:"thumbnail";s:81:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-carousel-5.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:55:"http://jetelements.zemez.io/blocks/advanced-carousel-5/";}i:128;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:20:"Advanced Carousel #4";s:9:"thumbnail";s:81:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-carousel-4.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:55:"http://jetelements.zemez.io/blocks/advanced-carousel-4/";}i:129;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:20:"Advanced Carousel #3";s:9:"thumbnail";s:81:"http://jetelements.zemez.io/wp-content/uploads/jet-blocks/advanced-carousel-3.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:55:"http://jetelements.zemez.io/blocks/advanced-carousel-3/";}i:130;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:20:"Advanced Carousel #2";s:9:"thumbnail";s:78:"http://jetelements.zemez.io/wp-content/uploads/2018/03/advanced-carousel-2.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:55:"http://jetelements.zemez.io/blocks/advanced-carousel-2/";}i:131;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:20:"Advanced Carousel #1";s:9:"thumbnail";s:78:"http://jetelements.zemez.io/wp-content/uploads/2018/03/advanced-carousel-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:55:"http://jetelements.zemez.io/blocks/advanced-carousel-1/";}i:132;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:23:"Homepage – Consulting";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/2017/12/consulting-home.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/consulting-home-page/";}i:133;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:25:"Homepage – Beauty Salon";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/2017/12/beauty-homepage.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/beauty-salon-home-page/";}i:134;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:23:"Homepage – Car Repair";s:9:"thumbnail";s:79:"http://jetelements.zemez.io/wp-content/uploads/2017/12/cars-repair-homepage.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/car-repair-home-page/";}i:135;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:25:"Homepage – Photographer";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/2017/09/photographer-home.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/photographer-home-page/";}i:136;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:23:"Homepage – Restaurant";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/2017/09/restaurant-home.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:49:"http://jetelements.zemez.io/restaurant-home-page/";}i:137;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:24:"Homepage – Real Estate";s:9:"thumbnail";s:75:"http://jetelements.zemez.io/wp-content/uploads/2017/09/real-estate-home.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:50:"http://jetelements.zemez.io/real-estate-home-page/";}i:138;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:31:"Homepage – Photography Studio";s:9:"thumbnail";s:82:"http://jetelements.zemez.io/wp-content/uploads/2017/09/photography-studio-home.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:57:"http://jetelements.zemez.io/photography-studio-home-page/";}i:139;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:21:"Homepage – Business";s:9:"thumbnail";s:74:"http://jetelements.zemez.io/wp-content/uploads/2017/09/business-home-1.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:47:"http://jetelements.zemez.io/business-home-page/";}i:140;a:11:{s:2:"id";s:4:"jet_";s:6:"source";s:13:"jet-templates";s:5:"title";s:25:"Homepage – Construction";s:9:"thumbnail";s:76:"http://jetelements.zemez.io/wp-content/uploads/2017/09/construction-home.png";s:12:"tmpl_created";s:15:"January 1, 1970";s:6:"author";s:5:"Zemez";s:10:"categories";a:0:{}s:8:"keywords";a:0:{}s:6:"is_pro";b:0;s:17:"has_page_settings";b:0;s:3:"url";s:51:"http://jetelements.zemez.io/construction-home-page/";}}', 'no'),
 (2439, '_transient_timeout_feed_c8dc84948ab55424f034a4ced348e013', '1533583323', 'no'),
 (2440, '_transient_timeout_feed_mod_c8dc84948ab55424f034a4ced348e013', '1533583323', 'no'),
 (2441, '_transient_feed_mod_c8dc84948ab55424f034a4ced348e013', '1533540123', 'no'),
 (2442, '_transient_timeout_owp_feed_data_4160b56c6811147b535098f09e780ee9', '1533583323', 'no'),
 (2443, '_transient_owp_feed_data_4160b56c6811147b535098f09e780ee9', '<ul><li><a class=\'rsswidget\' href=\'https://oceanwp.org/7-ways-to-protect-wordpress-pdf-files/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>7 Ways to Protect WordPress PDF Files</a><div class="rssSummary">Nowadays, PDF has become a standard file format for many important documents. Many people have used PDF files to create and share their knowledge and stories with others across different&hellip;</div></li><li><a class=\'rsswidget\' href=\'https://oceanwp.org/create-dynamic-slides-smart-slider-3-oceanwp/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>How to Create Dynamic Slides with Smart Slider 3 in OceanWP?</a><div class="rssSummary">Adding a slider to your website can be a good choice because that makes the first impression for your visitors. But after you’ve decided that you want to add sliders&hellip;</div></li><li><a class=\'rsswidget\' href=\'https://oceanwp.org/generate-email-subscriptions-traffic-volume-beginners-guide-lead-magnets/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>How to Generate More Email Subscriptions With the Same Traffic Volume (A beginner’s Guide to Lead Magnets)</a><div class="rssSummary">You might be tired of hearing people tell you that you “need to build an email list”. But you see this advice so much for a reason. For any business,&hellip;</div></li><li><a class=\'rsswidget\' href=\'https://oceanwp.org/oceanwp-lightning-fast-cloudways/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>OceanWP is Lightning Fast on Cloudways [Stats Inside]</a><div class="rssSummary">When you think about WordPress website optimization, loading time is one of the top priorities since it is vital for ranking. Every millisecond of your website can help improve your&hellip;</div></li></ul>', 'no'),
 (2444, '_transient_timeout_feed_9437e8e02ec5af9028df4e5061705e72', '1533583325', 'no'),
 (2445, '_transient_feed_9437e8e02ec5af9028df4e5061705e72', 'a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:11:"WPDeveloper";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:23:"https://wpdeveloper.net";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:35:"Marketplace For WordPress Developer";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 03 Aug 2018 16:29:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:30:"https://wordpress.org/?v=4.9.8";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:75:"https://wpdeveloper.net/wp-content/uploads/2015/08/cropped-wpd-02-32x32.png";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:11:"WPDeveloper";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:23:"https://wpdeveloper.net";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:96:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:65:"Become A Creative Genius Together With These 10 Elementor Themes!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:89:"https://wpdeveloper.net/become-a-creative-genius-together-with-these-10-elementor-themes/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:97:"https://wpdeveloper.net/become-a-creative-genius-together-with-these-10-elementor-themes/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 02 Aug 2018 00:30:54 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:19:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:7:"Dezingo";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:9:"Digitalia";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:7:"Elegacy";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:19:"Elementor Templates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:16:"Elementor Themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:7;a:5:{s:4:"data";s:9:"Exibitico";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:8;a:5:{s:4:"data";s:8:"Flashing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:9;a:5:{s:4:"data";s:7:"FrameMe";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:10;a:5:{s:4:"data";s:6:"Pixate";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:11;a:5:{s:4:"data";s:9:"Roseworld";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:12;a:5:{s:4:"data";s:9:"Spellbind";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:13;a:5:{s:4:"data";s:8:"Visuelle";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:14;a:5:{s:4:"data";s:10:"web design";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:15;a:5:{s:4:"data";s:13:"Web Templates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:16;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:17;a:5:{s:4:"data";s:19:"WordPress Templates";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:18;a:5:{s:4:"data";s:16:"WordPress Themes";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=29704";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:608:"<p>Every person is creative in his or her own way. Someone is crazy about singing, someone adores writing, someone is good at drawing. In fact, a lot of people, who have something to do with creativity, want to inspire others and make them fall in love with their works. Nowadays each piece of creativity can [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/become-a-creative-genius-together-with-these-10-elementor-themes/">Become A Creative Genius Together With These 10 Elementor Themes!</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:17885:"<p>Every person is creative in his or her own way. Someone is crazy about singing, someone adores writing, someone is good at drawing. In fact, a lot of people, who have something to do with creativity, want to inspire others and make them fall in love with their works.</p>\n<p><span id="more-29704"></span></p>\n<p>Nowadays each piece of creativity can be represented on the Internet in the best possible light. And it’s completely possible for each writer, photographer, and designer to take advantage of eye-catching <a href="https://www.templatemonster.com/wordpress-themes.php?aff=AllaTaff" target="_blank" rel="noopener">WordPress themes</a> that come together with a wide range of powerful options.</p>\n<h3>Elementor Themes</h3>\n<p>In this collection, you will find 10 WordPress themes that we selected from a rich collection presented on <a href="https://www.templatemonster.com/elementor-marketplace/?aff=AllaTaff" target="_blank" rel="noopener">Elementor Marketplace</a>. They will make it easier for you to launch a professionally-looking website that will allow you to find your audience who will adore your works and their impressive online-presentation.</p>\n<h3 align="center">More Features, More Creativity with Elementor WordPress Themes</h3>\n<p>As you may already know, Elementor is a feature-rich website builder that assists people building in visually-attractive websites. And thanks to it, it became possible to build eye-catching layouts, modify their structure (play around with columns and sections), add widgets, and work with many other elements of your future online-project. Yet let us explain to you the most crucial reasons to opt for Elementor builder.</p>\n<ol>\n<li>If you possess minimal coding skills, Elementor is considered to be a great solution that makes it extra easy to create pages and add your unique content to them.</li>\n<li>Among these attractive ready-made solutions, you can find different topics &#8211; starting from powerful business templates and ending with fashionable <a href="https://www.templatemonster.com/category/design-photography-wordpress-themes/?aff=AllaTaff" target="_blank" rel="noopener">design &amp; photography WordPress themes</a>.</li>\n<li>You can also enrich a functionality of Elementor using a PRO version of this very plugin. With the help of it, you will get the opportunity to save templates of new pages, create header and footer styles, and do many other important things.</li>\n</ol>\n<p>Without a doubt, a mix of these vibrant templates with Elementor builder will meet all your needs. In such a way, you will strike a target and convince people of paying their attention to your website. Let’s try to find the most stylish template in this collection together&#8230;</p>\n<h3>Visuelle &#8211; Bright Design Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29710" src="https://wpdeveloper.net/wp-content/uploads/2018/08/70493-big.jpg" alt="" width="900" height="560" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/70493-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/70493-big-300x187.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/70493-big-768x478.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/visuelle-creative-mondrianism-elementor-wordpress-theme-70493.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/70493.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>Visuelle is a creative template that will make it possible to showcase any innovative concept in an attractive way. Furthermore, it includes lots of elegant and eye-catching pre-made pages that will allow you to present your projects and the wonderful team that executes amazing works. And you will also get a bunch of excellent bonus images that will make your website look even more exciting.</p>\n<h3>Elegacy &#8211; Impressive Creative Studio Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29715" src="https://wpdeveloper.net/wp-content/uploads/2018/08/69782-big.jpg" alt="" width="900" height="559" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/69782-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/69782-big-300x186.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/69782-big-768x477.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/elegacy-creative-elementor-wordpress-theme-69782.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/69782.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>Elegacy is a minimalist theme that comes together with an unusual design and collection of powerful options. And thanks to a feature-rich WordPress Live Customizer, it will be completely possible to make your website express your individuality and style by means of colors and typography. Furthermore, you will get a great range of Cherry Plugins that will assist you in showing off your creative studio.</p>\n<h3>Exibitico &#8211; Attractive Art Gallery Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29726" src="https://wpdeveloper.net/wp-content/uploads/2018/08/69575-big.jpg" alt="" width="900" height="560" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/69575-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/69575-big-300x187.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/69575-big-768x478.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/69575.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/69575.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>If you want to present your gallery as a magical world of art, you should certainly pay your attention to this bright template. And it comes alongside a stunning mega-menu that will allow you to divide your content into different categories that will guide your visitors through your online-project. Additionally, you will also get four blog layouts that will make your articles become even more eye-catching for your target audience.</p>\n<h3>Dezingo &#8211; Vibrant Startup Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29740" src="https://wpdeveloper.net/wp-content/uploads/2018/08/67899-big.jpg" alt="" width="900" height="560" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/67899-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/67899-big-300x187.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/67899-big-768x478.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/dezingo-creative-startup-wordpress-theme-67899.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/67899.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>Dezingo is a modern theme that will turn your start-up into a real attention-grabber for your potential readers. And, by means of the wide range of plugins, it will take you nothing to enrich a functional aspect of your future online-project. In addition to this, you will get an impressive collection of bonus images that will make your website look brighter.</p>\n<h3>Roseworld &#8211; Elegant Lifestyle Blog Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29753" src="https://wpdeveloper.net/wp-content/uploads/2018/08/67408-big.jpg" alt="" width="900" height="560" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/67408-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/67408-big-300x187.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/67408-big-768x478.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/roseworld-lifestyle-blog-wordpress-theme-67408.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/67408.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p align="left">Roseworld is a tender template that will assist you in building a stylish blog that will showcase your lifestyle in the best possible light. And with the help of various header and footer variations, it will be possible to create a unique look for your website. Moreover, you can pay your attention to a wide variety of Google Fonts, topical images, and blog layouts that will definitely capture the attention of each person on the web.</p>\n<h3>Flashing &#8211; Remarkable Photographer Portfolio Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29779" src="https://wpdeveloper.net/wp-content/uploads/2018/08/66465-big.jpg" alt="" width="900" height="559" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/66465-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/66465-big-300x186.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/66465-big-768x477.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/flashing-photographer-portfolio-wordpress-theme-66465.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/66465.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>Do you want to create a marvelous photographer portfolio in a flash and make people become interested in your online-project? It includes tons of eye-catching pages that will allow you to present all possible aspects of your photo services at their best. Additionally, you will be also happy to get a great mega-menu, fully-fledged WordPress Live Customizer, and stunning Cherry plugins.</p>\n<h3>FrameMe &#8211; Excellent Photography Studio Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29805" src="https://wpdeveloper.net/wp-content/uploads/2018/08/66179-big.jpg" alt="" width="900" height="559" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/66179-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/66179-big-300x186.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/66179-big-768x477.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/frameme-photography-studio-wordpress-theme-66179.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/66179.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>FrameMe is an eye-catching solution that will impress the imagination of your core audience with its wonderful design and functionality. Thanks to such exciting options as Cherry Plugins (that include Projects, Services, and Team Members), it will be possible to give people a full look at your services. Furthermore, you will get the opportunity to tweak colors and fonts of your website using an amazing WordPress Live Customizer.</p>\n<h3>Spellbind &#8211; Unusual Design Firm Elementor WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29824" src="https://wpdeveloper.net/wp-content/uploads/2018/08/64128-big.jpg" alt="" width="900" height="560" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/64128-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/64128-big-300x187.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/64128-big-768x478.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/64128.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/64128.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>If you want to breathe a new life into your website, you should certainly make use of this stylish theme. A wide range of background options and Google Fonts will make it possible to make your website look tailor-made. By the way, a wonderful contact form will give your visitors a wonderful chance to find out more about the design studio and ask your team some questions.</p>\n<h3>Digitalia &#8211; Amazing Marketing Company WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29848" src="https://wpdeveloper.net/wp-content/uploads/2018/08/64661-big.jpg" alt="" width="900" height="560" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/64661-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/64661-big-300x187.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/64661-big-768x478.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/64661.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/64661.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p>Digitalia is a powerful solution that has not only an impressive design but also a great collection of functional tricks. In order to let your readers share their thoughts on your marketing company, this template comes pre-loaded with a perfect commenting system. And, you will also get lots of social options that will allow you to spread the word about your business on the web.</p>\n<h3>Pixate &#8211; Modern Movie Studio WordPress Theme</h3>\n<p><img class="aligncenter size-full wp-image-29919" src="https://wpdeveloper.net/wp-content/uploads/2018/08/65159-big.jpg" alt="" width="900" height="560" srcset="https://wpdeveloper.net/wp-content/uploads/2018/08/65159-big.jpg 900w, https://wpdeveloper.net/wp-content/uploads/2018/08/65159-big-300x187.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/08/65159-big-768x478.jpg 768w" sizes="(max-width: 900px) 100vw, 900px" /></p>\n<p style="text-align: center;"><strong><a href="https://www.templatemonster.com/wordpress-themes/65159.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Details</a></strong> |  <strong><a href="https://www.templatemonster.com/demo/65159.html?aff=AllaTaff&amp;utm_campaign=blog_site_essential-addons&amp;utm_source=07.30.2018_guestpost&amp;utm_medium=elementor ">Demo</a></strong></p>\n<p align="left">Pixate is a wonderful theme that will make it possible to create a top-notch website regarding your professional movie studio. By means of various stylish pre-made pages, you will get the opportunity to showcase your services in the most reliable way ever. In addition to this, you will get an amazing WooCommerce package that will allow you to sell your services on the website.</p>\n<p align="left">We are completely sure that your creativity will become a center of attention on the Internet if you make use of one of these remarkable templates. In fact, they will allow you to be in the limelight and present your talent in the best possible light. But keep in mind that Elementor is always here to help you in launching a great website in a flash. In conclusion, we wish you to become a number one among others and thanks for reading! In the meantime here is a quick <a href="https://wpdeveloper.net/website-design-ideas-for-beginners/?preview_id=16860&amp;preview_nonce=5193416869&amp;post_format=standard&amp;_thumbnail_id=20442&amp;preview=true">blog on how to recreate website designs with Elementor. </a></p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/become-a-creative-genius-together-with-these-10-elementor-themes/">Become A Creative Genius Together With These 10 Elementor Themes!</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:94:"https://wpdeveloper.net/become-a-creative-genius-together-with-these-10-elementor-themes/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:66:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:45:"Quick Guide To Building A Single Page Website";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:44:"https://wpdeveloper.net/single-page-website/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:52:"https://wpdeveloper.net/single-page-website/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 28 Jul 2018 00:30:11 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:9:{i:0;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:16:"Essential Addons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:10:"Navigation";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:12:"Page-Builder";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:11:"Single Page";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:19:"Single Page Website";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:7;a:5:{s:4:"data";s:10:"web design";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:8;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=28606";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:529:"<p>The concept of One Page Website is, all of its content will be attached together on a single page. But only a specific part of it will be visible with each scroll. Your visitors will need to scroll down or up to navigate through all of your website\'s content. But, you can eliminate the need [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/single-page-website/">Quick Guide To Building A Single Page Website</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:10954:"<p>The concept of One Page Website is, all of its content will be attached together on a single page. But only a specific part of it will be visible with each scroll.</p>\n<p><span id="more-28606"></span></p>\n<p>Your visitors will need to scroll down or up to navigate through all of your website\'s content. But, you can eliminate the need for scrolling by placing a navigation bar. In this blog, I am going to build a vertical scrolling website and that too without any coding knowledge.</p>\n<h3>Single Page Scrolling Website Tutorial</h3>\n<p>For building a single page scrolling website we will use <a href="https://elementor.com/">Elementor</a> and <a href="https://essential-addons.com/elementor/docs/getting-started/installing-plugin/">Essential Addons.</a> Particularly we will be dealing with one element only-EA One Page Navigation.</p>\n<p>First, head over to your Elementor Side Panel and pick the <strong>EA One Page Navigation Element.</strong></p>\n<p><img class="aligncenter size-full wp-image-28609" src="https://wpdeveloper.net/wp-content/uploads/2018/07/02-2.png" alt="" width="1144" height="655" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/02-2.png 1144w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-2-300x172.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-2-768x440.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-2-1024x586.png 1024w" sizes="(max-width: 1144px) 100vw, 1144px" /></p>\n<p>Now head over to <strong>Content &gt; Navigation Dots.</strong>  You will see 3 Navigation Dot Cards by default and all of which will have a <strong>Section ID</strong> assigned to it. What\'s the use of this Section ID?</p>\n<p>Well, the Section ID goes into the<strong> CSS ID field</strong> of the elements/sections that you will be adding to your one-page website. You will see in the later parts of this blog how it is done!</p>\n<p><img class="aligncenter size-full wp-image-28611" src="https://wpdeveloper.net/wp-content/uploads/2018/07/01-1.png" alt="" width="317" height="661" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/01-1.png 317w, https://wpdeveloper.net/wp-content/uploads/2018/07/01-1-144x300.png 144w" sizes="(max-width: 317px) 100vw, 317px" /></p>\n<h3>Using Elementor Template</h3>\n<p>Let\'s assume, you will pick an Elementor Template for your Single Page Website. To do so, you need to click on the <strong>Add Template Button</strong> sitting at the middle-right part of the Elementor Interface. It will bring up a pop-up listing all the readily available templates.<img class="aligncenter size-full wp-image-28864" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Single-Page-Scrolling-2.png" alt="" width="963" height="600" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Single-Page-Scrolling-2.png 963w, https://wpdeveloper.net/wp-content/uploads/2018/07/Single-Page-Scrolling-2-300x187.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Single-Page-Scrolling-2-768x479.png 768w" sizes="(max-width: 963px) 100vw, 963px" /></p>\n<p>The Template that I have picked has 5 distinct parts. I am going to include all the 5 parts to the Navigation Dots bar. So if you have followed along, this means I need <strong>5 Navigation Dots Cards.</strong></p>\n<p>However, you might want to pick a different template from the Library. But remember, that should not be an issue. While working with any Elementor template, you should always ask yourself how many sections should be treated as distinct parts. Once you have figured that out, head back to the One Page Navigation element and adjust the number of Navigation Dot Cards.</p>\n<p><img class="aligncenter size-full wp-image-28866" src="https://wpdeveloper.net/wp-content/uploads/2018/07/single-page-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/single-page.gif" alt="" width="1280" height="720" /></p>\n<p>Let\'s see what the template that I have picked includes. The first one is kind of an introductory page, the second part is a services part, the third is for the APP, the fourth is a video, and the last one is the footer part including all the social profile links.</p>\n<p>So this means I have five distinct parts in the template. And I need to add 2 more Navigation Dot cards as by default the first three cards are already there.</p>\n<p><img class="aligncenter size-full wp-image-28870" src="https://wpdeveloper.net/wp-content/uploads/2018/07/03-3.png" alt="" width="350" height="659" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/03-3.png 350w, https://wpdeveloper.net/wp-content/uploads/2018/07/03-3-159x300.png 159w" sizes="(max-width: 350px) 100vw, 350px" /></p>\n<p>So how do you add new cards?</p>\n<ul>\n<li>You can either click on the duplicate button at the right side of each card.</li>\n<li>You can use the Add Item Button at the bottom of the tab.</li>\n<li>Use the cross button in case you need to remove any cards.</li>\n</ul>\n<p>This is how the <strong>Navigation Dots bar</strong> (Inside the rectangle) will look after you include the additional 2 cards.</p>\n<p><img class="aligncenter size-full wp-image-28869" src="https://wpdeveloper.net/wp-content/uploads/2018/07/single-page-naviagtion.png" alt="" width="1292" height="641" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/single-page-naviagtion.png 1292w, https://wpdeveloper.net/wp-content/uploads/2018/07/single-page-naviagtion-300x149.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/single-page-naviagtion-768x381.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/single-page-naviagtion-1024x508.png 1024w" sizes="(max-width: 1292px) 100vw, 1292px" /></p>\n<h3>Assigning The Section ID To Elements/Sections.</h3>\n<p>Now that you have identified sections for the One Page Website and also adjusted the Navigation Dot Cards, let\'s move on to the next step.</p>\n<p>Each Elementor Element has a <strong>CSS ID field</strong> to it as do all the Elementor sections and columns. You will find it by navigating to <strong>Advanced&gt;CSS ID. </strong></p>\n<p><img class="aligncenter size-full wp-image-28871" src="https://wpdeveloper.net/wp-content/uploads/2018/07/css-id-field.png" alt="" width="305" height="639" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/css-id-field.png 305w, https://wpdeveloper.net/wp-content/uploads/2018/07/css-id-field-143x300.png 143w" sizes="(max-width: 305px) 100vw, 305px" /></p>\n<p>Okay, so now we know where the Section-ID will go. Let\'s start by specifying the Section-ID for the first section.</p>\n<ul>\n<li>Click on the first icon &#8216;Edit Section.\'</li>\n<li>Head over to Advanced Tab.</li>\n<li>Paste the Section ID inside the CSS ID field.</li>\n</ul>\n<p><img class="aligncenter size-full wp-image-28872" src="https://wpdeveloper.net/wp-content/uploads/2018/07/first-section01.png" alt="" width="895" height="640" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/first-section01.png 895w, https://wpdeveloper.net/wp-content/uploads/2018/07/first-section01-300x215.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/first-section01-768x549.png 768w" sizes="(max-width: 895px) 100vw, 895px" /></p>\n<p>You will have to repeat this same process for the rest of the Four Sections of your One-Page Website.</p>\n<ul>\n<li>Click on the first icon &#8216;Edit Section.\'</li>\n<li>Head over to Advanced Tab.</li>\n<li>Paste the Section ID inside the CSS ID field.</li>\n</ul>\n<p><img class="aligncenter size-full wp-image-28873" src="https://wpdeveloper.net/wp-content/uploads/2018/07/first-section.png" alt="" width="891" height="640" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/first-section.png 891w, https://wpdeveloper.net/wp-content/uploads/2018/07/first-section-300x215.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/first-section-768x552.png 768w" sizes="(max-width: 891px) 100vw, 891px" /></p>\n<p>Time for a quick test!</p>\n<p>Once you are done assigning the Section ID to all the Section hit the <strong>Preview button</strong> from the Elementor Footer Panel.</p>\n<p><img class="aligncenter size-full wp-image-28879" src="https://wpdeveloper.net/wp-content/uploads/2018/07/done-navigation-dots-final-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/done-navigation-dots-final.gif" alt="" width="1280" height="720" /></p>\n<p>Works just fine! Good news for you, we are done with the Technical part. Now, let\'s dig into the styling part.</p>\n<h3>Add Styling to Your Navigation</h3>\n<p>Head over to the Style Tab. Play around with <a href="https://essential-addons.com/elementor/docs/creative-elements/one-page-navigation/">all the customization options</a> until you are happy with your creation.</p>\n<p><img class="aligncenter size-full wp-image-28883" src="https://wpdeveloper.net/wp-content/uploads/2018/07/06-2.png" alt="" width="305" height="661" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/06-2.png 305w, https://wpdeveloper.net/wp-content/uploads/2018/07/06-2-138x300.png 138w" sizes="(max-width: 305px) 100vw, 305px" /></p>\n<p>If you want o to customize the Navigation Dots, you will have to do it from the individual Navigation Dot Cards.<img class="aligncenter size-full wp-image-28884" src="https://wpdeveloper.net/wp-content/uploads/2018/07/icon-for-dots.png" alt="" width="275" height="639" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/icon-for-dots.png 275w, https://wpdeveloper.net/wp-content/uploads/2018/07/icon-for-dots-129x300.png 129w" sizes="(max-width: 275px) 100vw, 275px" /></p>\n<p>You can also take inspiration for your design from the <a href="https://essential-addons.com/elementor/one-page-nav/">Navigation Dot Demos.</a></p>\n<p><img class="aligncenter size-full wp-image-28878" src="https://wpdeveloper.net/wp-content/uploads/2018/07/final-after-styling-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/final-after-styling.gif" alt="" width="1280" height="720" /></p>\n<h3>Wrapping Up!</h3>\n<p>The only technical part in the process of building Single Page Scrolling Website with Elementor and Essential Addons is- specifying the number of Navigation Dot Cards and copying the Section-ID to the CSS ID fields.</p>\n<p>Once you have got the technical part done, the rest of the process is no big deal. The instructions illustrated above should give you enough material to work with for now.</p>\n<p>Do let us know if you find any part difficult to understand. We love hearing from you, leave a comment below and we will get back to you. In the meantime here is a quick blog on <a href="https://wpdeveloper.net/content-timeline-for-elementor/">how you can build Content Timeline using Elementor and Essential </a>Addons.</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/single-page-website/">Quick Guide To Building A Single Page Website</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:49:"https://wpdeveloper.net/single-page-website/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"Create A Countdown To Display Your Discount Offer With Style";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:48:"https://wpdeveloper.net/countdown-for-wordpress/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:56:"https://wpdeveloper.net/countdown-for-wordpress/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 24 Jul 2018 00:30:56 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:16:"Countdown Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:26:"Elementor Countdown Widget";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:19:"WordPress Countdown";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=27886";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:567:"<p>Every Online Store uses Discount Offers to attract new customers or retain existing ones. But how do you inform your customers about the offer? News-letters might not be the answer. It is better to use Countdown for WordPress websites. In fact, add a timer at the top of the product page itself which will keep [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/countdown-for-wordpress/">Create A Countdown To Display Your Discount Offer With Style</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:8271:"<p>Every Online Store uses Discount Offers to attract new customers or retain existing ones. But how do you inform your customers about the offer? News-letters might not be the answer. It is better to use Countdown for WordPress websites. In fact, add a timer at the top of the product page itself which will keep count of every second before your discount deal runs out.</p>\n<p><span id="more-27886"></span></p>\n<h3><img class="aligncenter wp-image-27913" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Create-Countdown-element.png" alt="" width="800" height="437" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Create-Countdown-element.png 644w, https://wpdeveloper.net/wp-content/uploads/2018/07/Create-Countdown-element-300x164.png 300w" sizes="(max-width: 800px) 100vw, 800px" /></h3>\n<h3>Countdown For WordPress</h3>\n<p>Imagine that its Christmas time and you want to offer a discount deal to your customers. Let\'s include a timer that reminds your buyers of the time remaining before the deal runs out.</p>\n<p>To add the timer you need <a href="https://wordpress.org/plugins/elementor/">Elementor</a> and <a href="https://wordpress.org/plugins/essential-addons-for-elementor-lite/">Essential Add-ons for Elementor. </a></p>\n<p>You can get clear documentation on how to add <a href="https://elementor.com/">Elementor</a> and <a href="https://essential-addons.com/">Essential Add-ons</a> to your WordPress website on their official website.</p>\n<h3>Create A Timer for Your Online Store</h3>\n<p><img class="aligncenter size-full wp-image-27891" src="https://wpdeveloper.net/wp-content/uploads/2018/07/01.png" alt="" width="1350" height="656" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/01.png 1350w, https://wpdeveloper.net/wp-content/uploads/2018/07/01-300x146.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/01-768x373.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/01-1024x498.png 1024w" sizes="(max-width: 1350px) 100vw, 1350px" /></p>\n<p>Open your WordPress Dashboard and enter the Elementor Builder Interface. From the side panel, select EA CountDown element.</p>\n<p><img class="aligncenter size-full wp-image-27892" src="https://wpdeveloper.net/wp-content/uploads/2018/07/02-1.png" alt="" width="985" height="659" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/02-1.png 985w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-1-300x201.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-1-768x514.png 768w" sizes="(max-width: 985px) 100vw, 985px" /></p>\n<p>Drop it inside the Blank Canvas area and the customization options will automatically appear in the side panel. But, if it doesn\'t appear, simply click over the EA CountDown element that you just dropped inside the Elementor interface.</p>\n<p>First, you need to specify the time until which you want to offer a discount. Head over to the<strong> side panel&gt;Content. </strong></p>\n<p><img class="aligncenter wp-image-27894" src="https://wpdeveloper.net/wp-content/uploads/2018/07/03-1.png" alt="" width="700" height="653" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/03-1.png 595w, https://wpdeveloper.net/wp-content/uploads/2018/07/03-1-300x280.png 300w" sizes="(max-width: 700px) 100vw, 700px" /></p>\n<p>Now, click on the<strong> Countdown Due Date</strong> field to open the pop-up that you see above.</p>\n<ol>\n<li>Use the middle and side arrows to specify a certain date. Pick a Month and a Year.</li>\n<li>Use the boxes to specify the exact hour, minute and second in time.</li>\n</ol>\n<p>As soon as you specify the date and time, it will be updated inside the Elementor Interface. Okay, so we are done with half of the work.</p>\n<p>Now head over to the<strong> Content Settings Tab. </strong>From the first option pick a Countdown style for the element. The EA Countdown uses separate areas to display Days, Hours, Minutes and Seconds. Inside the Content Settings Tab, you will see 4 toggle buttons to turn on/off any of the measurement units<img class="aligncenter size-full wp-image-27897" src="https://wpdeveloper.net/wp-content/uploads/2018/07/04-1.png" alt="" width="1349" height="657" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/04-1.png 1349w, https://wpdeveloper.net/wp-content/uploads/2018/07/04-1-300x146.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/04-1-768x374.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/04-1-1024x499.png 1024w" sizes="(max-width: 1349px) 100vw, 1349px" /></p>\n<h3>Change the Labels On The Timer</h3>\n<p>Similarly, under each toggle bar, you will see text fields. Use them to change the label of the Countdown. There are four labels-Days, Hours, Minutes and Seconds. The labels are given by default. But suppose you want to add the word &#8216;Remaining\' after every label text. Just click on the label text field and add the word Remaining.</p>\n<p><img class="aligncenter size-full wp-image-27898" src="https://wpdeveloper.net/wp-content/uploads/2018/07/05-1.png" alt="" width="1341" height="659" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/05-1.png 1341w, https://wpdeveloper.net/wp-content/uploads/2018/07/05-1-300x147.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/05-1-768x377.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/05-1-1024x503.png 1024w" sizes="(max-width: 1341px) 100vw, 1341px" /></p>\n<p>Now you might want to change the color and typography. Head over to the <strong>Style section&gt; Color and Typography.</strong></p>\n<p><img class="aligncenter wp-image-27901 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/06-1.png" alt="" width="788" height="658" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/06-1.png 788w, https://wpdeveloper.net/wp-content/uploads/2018/07/06-1-300x251.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/06-1-768x641.png 768w" sizes="(max-width: 788px) 100vw, 788px" />Once you are happy with the design of the Countdown box, hit Publish.</p>\n<p><img class="aligncenter size-full wp-image-27904" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Countdown-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/Countdown.gif" alt="" width="1280" height="720" /></p>\n<h3>Limitless Possibilities</h3>\n<p>Every Essential Addon element contains its customization options inside the same side panel as any other Elementor element. However, the difference lies in the slight difference between the available customization options.</p>\n<p><img class="aligncenter size-full wp-image-27907" src="https://wpdeveloper.net/wp-content/uploads/2018/07/07.png" alt="" width="1257" height="344" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/07.png 1257w, https://wpdeveloper.net/wp-content/uploads/2018/07/07-300x82.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/07-768x210.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/07-1024x280.png 1024w" sizes="(max-width: 1257px) 100vw, 1257px" /></p>\n<p>You can build jaw-dropping website designs without seeking help from your developer friend. In fact, after you have mastered Essential Addons for Elementor, your web design will become subject to the envy of your developer friends.</p>\n<p><img class="aligncenter size-full wp-image-27908" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Winter-is-coming-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/Winter-is-coming.gif" alt="" width="1256" height="380" /></p>\n<h3>Wrapping Up!</h3>\n<p>Are you new to Drag and Drop PAge Building for WordPress. Well, there is no need to worry. You can learn the tricks of using Elemntor and Essential Addons overnight. Do let us know if this blog helps you to add a timer to your WordPress website. And do drop a comment below for further queries.</p>\n<p>In the meantime here is a quick blog on how to <a href="https://wpdeveloper.net/table-with-varying-cell-size/">add a Content table inside your WordPress website.</a></p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/countdown-for-wordpress/">Create A Countdown To Display Your Discount Offer With Style</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wpdeveloper.net/countdown-for-wordpress/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:65:"Quick Way of Creating Tables For WordPress With Varying Cell Size";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:53:"https://wpdeveloper.net/table-with-varying-cell-size/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:61:"https://wpdeveloper.net/table-with-varying-cell-size/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 17 Jul 2018 00:30:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:10:"Data Table";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:16:"Essetnial Addons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:16:"Filterable Table";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=27065";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:575:"<p>How often do you have to create tables in WordPress blogs? At times, you will have no better option to present content without using a Table. But this might sound daunting to those who cannot write Code as WordPress Editor does not have a dedicated feature for adding Tables. WordPress Tables You do not need [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/table-with-varying-cell-size/">Quick Way of Creating Tables For WordPress With Varying Cell Size</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:18497:"<p>How often do you have to create tables in WordPress blogs? At times, you will have no better option to present content without using a Table. But this might sound daunting to those who cannot write Code as WordPress Editor does not have a dedicated feature for adding Tables.</p>\n<p><span id="more-27065"></span></p>\n<h3><img class="aligncenter wp-image-27077 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Table-With.png" alt="" width="644" height="352" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Table-With.png 644w, https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Table-With-300x164.png 300w" sizes="(max-width: 644px) 100vw, 644px" /></h3>\n<h3>WordPress Tables</h3>\n<p>You do not need to write codes in order to create a content table for your WordPress blog. In this tutorial blog, you are going to learn just that. I am going to use <a href="https://elementor.com/">Elementor</a> and <a href="https://essential-addons.com/elementor/">Essential Addons</a> and teach you how to create a<strong> Filterable Data Table</strong> with Varying Cell Size without having to write a single line of code.</p>\n<p><img class="aligncenter size-full wp-image-25803" src="https://wpdeveloper.net/wp-content/uploads/2018/07/DATA-Table-Demo-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/DATA-Table-Demo.gif" alt="Create Table in WordPress" width="852" height="528" /></p>\n<h3>Blog Tools</h3>\n<p>I have already mentioned the plugins you are going to need in order to create a Filterable Data Table. Both the plugins have free versions, so remember that testing the plugin once won\'t cost you a single penny.</p>\n<p>Below, you can see a simple table! Simple because I did not write a single code to create this table. Instead, I used the <strong>Drag and Drop Page Building</strong> features. If you are wondering why I have given the screenshot, here is the answer -we are going to try and recreate this table with <a href="https://docs.elementor.com/article/226-getting-started">Elementor</a> and <a href="https://essential-addons.com/elementor/docs/getting-started/installing-plugin/">Essential Add-ons.</a></p>\n<p>&nbsp;</p>\n<p><img class="aligncenter size-full wp-image-27230" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Demo-01.png" alt="" width="1340" height="654" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Demo-01.png 1340w, https://wpdeveloper.net/wp-content/uploads/2018/07/Demo-01-300x146.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Demo-01-768x375.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/Demo-01-1024x500.png 1024w" sizes="(max-width: 1340px) 100vw, 1340px" /></p>\n<h3>Table For WordPress</h3>\n<p>Let\'s straighten out what exactly we want to build? Imagine that you are a teacher of a first-grade class. And you have 12 students. Now you want to categorize your students according to three distinct metrics-Intelligent, Smart, and Friendly. Now there is no absolute rule that specifies that if someone is Smart they cannot be Tall!</p>\n<p>You can conjure up similar examples in your mind, can\'t you? While working on specific Data Sets you will have certain variables that fit in multiple <strong>Header Criteria</strong>. In this blog, you will learn how to present such a DataSet in a Table for your personal blog or office work.</p>\n<p>We are going to use the <strong>Data Table</strong> element of Essential Addons and recreate the table above. Before starting you can check out the Live Demo for this element.</p>\n<p><strong><a href="https://essential-addons.com/elementor/table/">Click Here to See Live Demo of Data Table!</a></strong></p>\n<h3>Create Tables In WordPress</h3>\n<p>We already have laid down what kind of Table we exactly want. Now let\'s go straight into it.</p>\n<p>We want to create a <strong>3by5</strong> Table.</p>\n<h3>First Step: Setting Up the Headers for the Table</h3>\n<p>Open The Elementor Interface. Place your mouse over the Side Panel Search Bar and type in <strong>EA Data Table. </strong>Drag the Element and drop it inside the Elementor Blank Canvas.</p>\n<p><img class="aligncenter wp-image-27079 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table.png" alt="" width="240" height="234" /></p>\n<p>Now, navigate to <strong>Content&gt;Header. </strong>By default, you will see 4 <strong>Header Cards</strong> all with the same label-<strong>Table Header. </strong><img class="aligncenter size-full wp-image-27080" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Headers.png" alt="" width="269" height="471" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Headers.png 269w, https://wpdeveloper.net/wp-content/uploads/2018/07/Headers-171x300.png 171w" sizes="(max-width: 269px) 100vw, 269px" /></p>\n<p>First, you want to remove one <strong>Header Card</strong>. Do it by clicking on the <strong>Cross Icon</strong> at the very right corner of the Header Card. As soon as you remove one Header Card, you will see one unnecessary row entry at the very right corner of the table. Don\'t panic, we are going to remove that extra cell entry in the next section.</p>\n<p>&nbsp;</p>\n<p><img class="aligncenter size-full wp-image-27231" src="https://wpdeveloper.net/wp-content/uploads/2018/07/02.png" alt="" width="1330" height="442" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/02.png 1330w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-300x100.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-768x255.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/02-1024x340.png 1024w" sizes="(max-width: 1330px) 100vw, 1330px" /></p>\n<p>Now we want to change the <strong>Heading Text</strong>. To do so, click on the Header Card.</p>\n<p><img class="aligncenter size-full wp-image-27081" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Header-Cards.png" alt="" width="270" height="495" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Header-Cards.png 270w, https://wpdeveloper.net/wp-content/uploads/2018/07/Header-Cards-164x300.png 164w" sizes="(max-width: 270px) 100vw, 270px" /></p>\n<p>Each Header Card has<strong> 3 customization fields.</strong> In the first field, you can specify a new <strong>label text</strong> for the Heading Cell. Additionally, you can add an icon and image for the Header Cell. But for this example, we are going to keep it simple.</p>\n<p>If you have followed the instruction correctly, you should have something like this.</p>\n<p><img class="aligncenter size-full wp-image-27087" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Unnecessary-Row-Entry.png" alt="" width="1024" height="148" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Unnecessary-Row-Entry.png 1024w, https://wpdeveloper.net/wp-content/uploads/2018/07/Unnecessary-Row-Entry-300x43.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Unnecessary-Row-Entry-768x111.png 768w" sizes="(max-width: 1024px) 100vw, 1024px" /></p>\n<h3>Second Step: Specify the Content Layout</h3>\n<p>Now, let\'s move onto the second customization option which is <strong>Content. </strong>Every Cell entry is represented as a separate card under this area.</p>\n<p><img class="aligncenter size-full wp-image-27082" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Content.png" alt="" width="272" height="542" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Content.png 272w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Content-151x300.png 151w" sizes="(max-width: 272px) 100vw, 272px" /></p>\n<p>But before anything else, let\'s remove the extra row entry that emerged as we removed one Header Entry in the previous part.</p>\n<p><img class="aligncenter size-full wp-image-27084" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Extra-Data-Table-Cell-Entry.png" alt="" width="267" height="475" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Extra-Data-Table-Cell-Entry.png 267w, https://wpdeveloper.net/wp-content/uploads/2018/07/Extra-Data-Table-Cell-Entry-169x300.png 169w" sizes="(max-width: 267px) 100vw, 267px" /></p>\n<p>Click on the little Cross Icon at the right corner of the Content Card and you will get something like this.</p>\n<p>&nbsp;</p>\n<p><img class="aligncenter size-full wp-image-27232" src="https://wpdeveloper.net/wp-content/uploads/2018/07/03.png" alt="" width="1336" height="437" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/03.png 1336w, https://wpdeveloper.net/wp-content/uploads/2018/07/03-300x98.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/03-768x251.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/03-1024x335.png 1024w" sizes="(max-width: 1336px) 100vw, 1336px" /></p>\n<p>Great! Now we need to add Four More Row entries. By default, you will have only one sequence of Table Content. If you have read our previous blog on<a href="https://wpdeveloper.net/filterable-data-table/"> how to create a simple Data Table</a>, you must say you already know how to add new Row Entries. But we are going to create a Varying Cell Size Data Table. This is why the process has a little extra step.</p>\n<p>Let\'s go step by step again. but for your convenience look at the table below, we want to recreate this exact table.</p>\n<p><img class="aligncenter size-full wp-image-27076" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Feature-image-02.png" alt="" width="899" height="367" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Feature-image-02.png 899w, https://wpdeveloper.net/wp-content/uploads/2018/07/Feature-image-02-300x122.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Feature-image-02-768x314.png 768w" sizes="(max-width: 899px) 100vw, 899px" /></p>\n<h3>Create the First Row</h3>\n<p>Our first row will have two cell entries, The first cell will have a<strong> cell span of 2</strong> and the other one will have a <strong>cell span of 1.</strong></p>\n<p>We already have the first row completed, but we need to remove one Row Entry. Pick the last Cell Cards and click on the little cross icon at the right corner of it.</p>\n<p><img class="aligncenter size-full wp-image-27088" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Table-First-Sequence.png" alt="" width="273" height="393" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Table-First-Sequence.png 273w, https://wpdeveloper.net/wp-content/uploads/2018/07/Table-First-Sequence-208x300.png 208w" sizes="(max-width: 273px) 100vw, 273px" /></p>\n<p>Okay, we have the first-row entry sequence ready. But there is one unused cell space. We want one of the cells to take up the space of the unused cell. In order to do so, we will specify the first cell to take up the empty cell area.</p>\n<p><img class="aligncenter size-full wp-image-27233" src="https://wpdeveloper.net/wp-content/uploads/2018/07/04.png" alt="" width="1325" height="611" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/04.png 1325w, https://wpdeveloper.net/wp-content/uploads/2018/07/04-300x138.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/04-768x354.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/04-1024x472.png 1024w" sizes="(max-width: 1325px) 100vw, 1325px" /></p>\n<p>&nbsp;</p>\n<p>To do so, click on the <strong>col</strong>:: <strong>Content Card</strong> for the first row cell.</p>\n<p><img class="aligncenter size-full wp-image-27090" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Content-Colspan.png" alt="" width="268" height="566" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Content-Colspan.png 268w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Content-Colspan-142x300.png 142w" sizes="(max-width: 268px) 100vw, 268px" /></p>\n<p>Scroll down at the very bottom of the card and you will find <strong>Colspan. By default, </strong>each Content Card will have a Colspan of 1. But for this specific example, we need to specify a Colspan of 2 for the first Content Card for the First Row. As you give a Colspan of 2, you will see the first Content Cell take up the unused space in the first row.</p>\n<p><img class="aligncenter size-full wp-image-27091" src="https://wpdeveloper.net/wp-content/uploads/2018/07/1st-row-colspan.png" alt="" width="1017" height="121" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/1st-row-colspan.png 1017w, https://wpdeveloper.net/wp-content/uploads/2018/07/1st-row-colspan-300x36.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/1st-row-colspan-768x91.png 768w" sizes="(max-width: 1017px) 100vw, 1017px" /></p>\n<p>Now lets quickly change the Content Card Texts.</p>\n<p><img class="aligncenter size-full wp-image-27092" src="https://wpdeveloper.net/wp-content/uploads/2018/07/1st-Row-Complete.png" alt="" width="1024" height="108" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/1st-Row-Complete.png 1024w, https://wpdeveloper.net/wp-content/uploads/2018/07/1st-Row-Complete-300x32.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/1st-Row-Complete-768x81.png 768w" sizes="(max-width: 1024px) 100vw, 1024px" /></p>\n<h3>Create the Second Row</h3>\n<p>Take a quick look at the table that we are hoping to recreate. See, for the Second Row, we don\'t have any cell that requires multiple Cell spans. That makes our tasks a little easier. So for the Second ,Row the Content Card Sequence will be something like this.</p>\n<p><img class="aligncenter size-full wp-image-27093" src="https://wpdeveloper.net/wp-content/uploads/2018/07/2nd-sequence-row.png" alt="" width="272" height="516" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/2nd-sequence-row.png 272w, https://wpdeveloper.net/wp-content/uploads/2018/07/2nd-sequence-row-158x300.png 158w" sizes="(max-width: 272px) 100vw, 272px" /></p>\n<p>I have changed the Content Card Texts as well. You already know how to change Card text. While you are at creating the second sequence does change their texts. Moving on!</p>\n<h3>Create the Third Row</h3>\n<p>Again, if you remember the table that we are trying to recreate, you might have noticed that the Third Row has two Content Entries. The empty cell is taken up by the last cell.</p>\n<p>So first, lets quickly create the sequence for the Third Row.</p>\n<p><strong>row:: Content</strong></p>\n<p><strong>col:: Jim</strong></p>\n<p><strong>col:: Tom</strong></p>\n<p><img class="aligncenter size-full wp-image-27094" src="https://wpdeveloper.net/wp-content/uploads/2018/07/3rd-sequence.png" alt="" width="272" height="546" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/3rd-sequence.png 272w, https://wpdeveloper.net/wp-content/uploads/2018/07/3rd-sequence-149x300.png 149w" sizes="(max-width: 272px) 100vw, 272px" /></p>\n<p>Now let\'s specify the Colspan for the entries. For this third row sequence, we want the last Content Cell Card to take up the unused cell space. <img class="aligncenter size-full wp-image-27095" src="https://wpdeveloper.net/wp-content/uploads/2018/07/3rd-sequence-colspan.png" alt="" width="269" height="330" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/3rd-sequence-colspan.png 269w, https://wpdeveloper.net/wp-content/uploads/2018/07/3rd-sequence-colspan-245x300.png 245w" sizes="(max-width: 269px) 100vw, 269px" /></p>\n<p>Click on the Card <strong>col:: Tom </strong>and specify its <strong>Colspan to 2.</strong></p>\n<h3>Create the Fourth Row</h3>\n<p>For the Fourth Row, we don\'t have any cell with multiple spans. So first, let\'s create the sequence for the Fourth Row. While I am at it, I will also change the Card Text.</p>\n<p>&nbsp;</p>\n<p><img class="aligncenter size-full wp-image-27234" src="https://wpdeveloper.net/wp-content/uploads/2018/07/05.png" alt="" width="278" height="661" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/05.png 278w, https://wpdeveloper.net/wp-content/uploads/2018/07/05-126x300.png 126w" sizes="(max-width: 278px) 100vw, 278px" /></p>\n<h3>Create the Fifth Row</h3>\n<p>Great! We made it to the last Row entry for our Data Table.</p>\n<p>Remember, the table we are recreating has the Fifth Row with two Cell Entries. One of which takes up the Colspan of two cells.</p>\n<p>First, let\'s create the sequence and change the Content Card Texts.</p>\n<p><img class="aligncenter size-full wp-image-27235" src="https://wpdeveloper.net/wp-content/uploads/2018/07/06.png" alt="" width="275" height="659" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/06.png 275w, https://wpdeveloper.net/wp-content/uploads/2018/07/06-125x300.png 125w" sizes="(max-width: 275px) 100vw, 275px" /></p>\n<p>&nbsp;</p>\n<p>Now, we want the last cell to take up the unused cell space.</p>\n<p><img class="aligncenter size-full wp-image-27097" src="https://wpdeveloper.net/wp-content/uploads/2018/07/5th-Colspan.png" alt="" width="272" height="429" /></p>\n<p>If you have followed my instructions correctly, you will be with something like this.<img class="aligncenter size-full wp-image-27100" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Final-Data-Table.png" alt="" width="1013" height="302" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Final-Data-Table.png 1013w, https://wpdeveloper.net/wp-content/uploads/2018/07/Final-Data-Table-300x89.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Final-Data-Table-768x229.png 768w" sizes="(max-width: 1013px) 100vw, 1013px" /></p>\n<h3>Wrapping Up!</h3>\n<p>All the customization options and the Interface itself is self-explanatory. I hope you can agree with this statement. <a href="https://elementor.com/?ref=docs">Elementor</a> and <a href="https://essential-addons.com/elementor/">Essential Addons</a> comes with enough Elements to create an entire website. Additionally, these two plugins have enough ready-made templates. You can either use them for your website without making any changes or simply use them for inspiration.</p>\n<p>In the meantime, here is a quick blog on how you can use Elementor and Essential Addons to recreate parts of some top-notch Websites on the internet. <a href="https://wpdeveloper.net/website-design-ideas-for-beginners/">Click here to read the full Blog!</a></p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/table-with-varying-cell-size/">Quick Way of Creating Tables For WordPress With Varying Cell Size</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:58:"https://wpdeveloper.net/table-with-varying-cell-size/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"How to Add a Filterable WooCommerce Product Gallery on your Website";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wpdeveloper.net/filterable-woocommerce-product-gallery/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wpdeveloper.net/filterable-woocommerce-product-gallery/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Sat, 14 Jul 2018 01:30:37 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:16:"Essential Addons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:11:"WooCommerce";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:27:"WooCommerce Product Gallery";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=26772";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:594:"<p>Do you have a WooCommerce Product Gallery on your website? Many people undermine its importance by adding dull static galleries. But did you ever wonder what would it take to build the Fancy Galleries you see on many big E-Commerce websites on your own? Don\'t worry! Today\'s post focuses on how you can easily reate [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/filterable-woocommerce-product-gallery/">How to Add a Filterable WooCommerce Product Gallery on your Website</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:10002:"<p>Do you have a WooCommerce Product Gallery on your website?</p>\n<p>Many people undermine its importance by adding dull static galleries. But did you ever wonder what would it take to build the Fancy Galleries you see on many big E-Commerce websites on your own?</p>\n<p>Don\'t worry! Today\'s post focuses on how you can easily reate filterable WooCommerce Product Gallery using Elementor and Essential Addons. Let\'s find out.</p>\n<p><span id="more-26772"></span></p>\n<h3><img class="aligncenter wp-image-26811 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/ResponsiveProduct-GAllery.png" alt="" width="644" height="352" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/ResponsiveProduct-GAllery.png 644w, https://wpdeveloper.net/wp-content/uploads/2018/07/ResponsiveProduct-GAllery-300x164.png 300w" sizes="(max-width: 644px) 100vw, 644px" /></h3>\n<h3>WooCommerce Product Gallery</h3>\n<p>For your WooCommerce website, you might want to include a general product image gallery. But what good will it be if it is not responsive and filterable?</p>\n<p><img class="aligncenter size-full wp-image-26792" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Gallery-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Gallery.gif" alt="" width="880" height="400" /></p>\n<h3>WooCommerce Responsive Gallery Plugin</h3>\n<p>To create a responsive Gallery for your WooCommerce site, you need <a href="https://docs.elementor.com/article/14-installation">Elementor</a>. Elementor is the best Drag and Drop page builder out there for WordPress. Along with Elementor you need <a href="https://essential-addons.com/elementor/docs/getting-started/installing-plugin/">Essential Add-ons</a> for Elementor. This elements library for Elementor offers 30+ additional top-notch elements.</p>\n<h3>WooCommerce Dynamic Gallery</h3>\n<p>After you have activated both the plugins, open your Elementor Dashboard and place your mouse on the Search Bar sitting at the top of the Side Panel. Then type in<strong> EA Filterable Gallery. </strong></p>\n<p><img class="aligncenter size-full wp-image-26780" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Element01.png" alt="" width="1132" height="660" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Element01.png 1132w, https://wpdeveloper.net/wp-content/uploads/2018/07/Element01-300x175.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Element01-768x448.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/Element01-1024x597.png 1024w" sizes="(max-width: 1132px) 100vw, 1132px" /></p>\n<p>Drag the element and drop it inside the Elementor blank canvas.</p>\n<h4>Content Settings</h4>\n<p>After you have added the element, it is ready to be customized. We shall start by adjusting the Content settings.</p>\n<ul>\n<li><strong>Filterable Gallery Settings</strong></li>\n</ul>\n<p>Under the <strong>Content</strong> Tab, you will find the basic adjustment options for the Gallery. By default, the Number of Columns is set to three which works perfectly for the gallery I am going to create. But know that every option under Content is adjustable.</p>\n<p><img class="aligncenter size-full wp-image-26781" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Gallery-Settings.png" alt="" width="303" height="598" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Gallery-Settings.png 303w, https://wpdeveloper.net/wp-content/uploads/2018/07/Filterable-Gallery-Settings-152x300.png 152w" sizes="(max-width: 303px) 100vw, 303px" /></p>\n<ul>\n<li><strong>Gallery Control Settings</strong></li>\n</ul>\n<p>The filterable Gallery will filter in response to the<strong> key-word(controller)</strong> you assign to each item on the gallery. It is advised to specify <strong>Category Names</strong> as the key-word for your items.</p>\n<p><img class="aligncenter size-full wp-image-26782" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Controller.png" alt="" width="957" height="499" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Controller.png 957w, https://wpdeveloper.net/wp-content/uploads/2018/07/Controller-300x156.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Controller-768x400.png 768w" sizes="(max-width: 957px) 100vw, 957px" /></p>\n<p>The Controller key-words will sit at the top of the gallery. And, each Category will be included in a separate card under <strong>Gallery Control Settings.</strong></p>\n<p><img class="aligncenter size-full wp-image-26783" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Controller-key-word.png" alt="" width="287" height="530" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Controller-key-word.png 287w, https://wpdeveloper.net/wp-content/uploads/2018/07/Controller-key-word-162x300.png 162w" sizes="(max-width: 287px) 100vw, 287px" /></p>\n<p>For my Gallery, I have used 4 Controller Key-Words which are nothing but the actual <strong>Category Names</strong> I have assigned to my Product Items.</p>\n<ol>\n<li>Click the cross icon to remove a card.</li>\n<li>Chick on ADD ITEM to add a new Controller Key-Word to the gallery.</li>\n</ol>\n<p>By default, there will always be an <strong>ALL Controller Key-Word</strong>. This Keyword is common to every item on the Gallery.</p>\n<ul>\n<li><strong>Gallery Item Settings</strong></li>\n</ul>\n<p>This is where you will have to spend most of your time. Every item you want to add to the gallery will be contained in a separate card under this tab. This is how the tab looks after I completed adding all the items to my gallery. But for your convenience, let\'s see from the start.</p>\n<p><img class="aligncenter size-full wp-image-26784" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item.png" alt="" width="270" height="659" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item.png 270w, https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item-123x300.png 123w" sizes="(max-width: 270px) 100vw, 270px" /></p>\n<p>This is how the tab will look after you add it inside the Elementor interface. You can see six cards already created. For my Gallery, I have added 19 items. You can add new item cards by clicking on the <strong>ADD ITEM</strong> button sitting at the very bottom of the Gallery Item Settings tab.</p>\n<p><img class="aligncenter size-full wp-image-26785" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item-setings.png" alt="" width="271" height="381" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item-setings.png 271w, https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item-setings-213x300.png 213w" sizes="(max-width: 271px) 100vw, 271px" /></p>\n<p>Now let\'s see what is actually inside the cards.</p>\n<p><img class="aligncenter size-full wp-image-26786" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item-Settings.png" alt="" width="264" height="588" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item-Settings.png 264w, https://wpdeveloper.net/wp-content/uploads/2018/07/Gallery-Item-Settings-135x300.png 135w" sizes="(max-width: 264px) 100vw, 264px" /></p>\n<p>&nbsp;</p>\n<ol>\n<li><strong>Item Name-</strong> Type in the product name in this field.</li>\n<li><strong>Item Content-</strong> Add Description of your Product.</li>\n<li><strong>Control Name-</strong> Add the Category Name of your Product.</li>\n<li><strong>Image-</strong> Upload your Product Image.</li>\n<li><strong>Gallery Link- </strong>Paste the link to your original Product Gallery Page.</li>\n</ol>\n<ul>\n<li><strong>Popup Settings</strong></li>\n</ul>\n<p>You will find two toggle bars inside this tab. First, decide whether you want to add a Popup feature to your gallery or not. If you want to add the feature, enable <strong>Show Popup</strong>. The second toggle bar lets the pop-up act like a gallery itself.</p>\n<h4>WooCommerce Product Gallery Slider</h4>\n<p>If you toggle on the <strong>Show Popup Gallery</strong>, your buyers can navigate through the product gallery from the pop-up box.</p>\n<h3>Product Description</h3>\n<p>Remember in the Gallery Item Settings you added a nice title and Description for your Gallery Items? To make the texts visible along with the Product Image head back to <strong>Content&gt;Filterable Gallery Settings&gt;Grid Style. </strong></p>\n<p><img class="aligncenter wp-image-26789 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Grid-Style.png" alt="" width="277" height="489" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Grid-Style.png 277w, https://wpdeveloper.net/wp-content/uploads/2018/07/Grid-Style-170x300.png 170w" sizes="(max-width: 277px) 100vw, 277px" /></p>\n<p>Select <strong>Cards</strong> from the Dropdown and you will get something like this.</p>\n<p><img class="aligncenter size-full wp-image-26790" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Grid-style-cards.png" alt="" width="765" height="537" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Grid-style-cards.png 765w, https://wpdeveloper.net/wp-content/uploads/2018/07/Grid-style-cards-300x211.png 300w" sizes="(max-width: 765px) 100vw, 765px" /></p>\n<h3>Wrapping Up!</h3>\n<p>The Elementor Interface is really easy. Additionally, all the Essential Addons elements are somewhat self-explanatory. But you can always check out our <a href="https://essential-addons.com/elementor/docs/">documentation page</a> to get a jump start. Please comment below if you have any further queries.</p>\n<p>In the meantime, here is a quick blog on how you can create <a href="https://wpdeveloper.net/content-timeline-for-elementor/">Amazing Content Timeline for your WordPress website.</a></p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/filterable-woocommerce-product-gallery/">How to Add a Filterable WooCommerce Product Gallery on your Website</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:68:"https://wpdeveloper.net/filterable-woocommerce-product-gallery/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:69:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:30:"WordPress User Roles Explained";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:55:"https://wpdeveloper.net/wordpress-user-roles-explained/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:63:"https://wpdeveloper.net/wordpress-user-roles-explained/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 12 Jul 2018 14:00:27 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:10:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:4:"News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:13:"Administrator";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:6:"Author";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:11:"contributor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:6:"Editor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:7;a:5:{s:4:"data";s:10:"Subscriber";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:8;a:5:{s:4:"data";s:10:"User Roles";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:9;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=25884";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:566:"<p>Every WordPress Website has a user role management system. Users can contribute to your Website according to the role you specify for them. For example, you can authorize your readers to make comments on your post only and nothing more. WordPress User Roles Explained Hierarchy is important for every Website. To run a Website there [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/wordpress-user-roles-explained/">WordPress User Roles Explained</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:4884:"<p>Every WordPress Website has a user role management system. Users can contribute to your Website according to the role you specify for them. For example, you can authorize your readers to make comments on your post only and nothing more.</p>\n<p><span id="more-25884"></span></p>\n<h3><img class="aligncenter wp-image-26434 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Administrator.png" alt="" width="644" height="352" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Administrator.png 644w, https://wpdeveloper.net/wp-content/uploads/2018/07/Administrator-300x164.png 300w" sizes="(max-width: 644px) 100vw, 644px" /></h3>\n<h3>WordPress User Roles Explained</h3>\n<p>Hierarchy is important for every Website. To run a Website there are different tasks that need to be performed. For example, for a blogging website, regular content creation is the primary task. But it is needless to say unless it is a personal blogging website, there will always be a feedback giving mechanism. Upon receiving the feedback the content writer can update his work.</p>\n<p>For this simple purpose, every WordPress website comes with distinct user roles. These different roles come with specific authority and permission to perform certain tasks across the Website.</p>\n<h3>Default WordPress User Roles</h3>\n<p>There are five user roles common to every WordPress Website.</p>\n<ol>\n<li>Administrator</li>\n<li>Editor</li>\n<li>Author</li>\n<li>Contributor</li>\n<li>Subscriber</li>\n</ol>\n<p>Before we go into further explanation, know that a specific user role can do everything that another role lower in the hierarchy can do. If you follow the list of user roles you will see an Administrator is the highest authority and the other user roles fill the subsequent spaces in the hierarchy.</p>\n<h3>Issues</h3>\n<p>Who can publish posts?</p>\n<p>Backend Access?</p>\n<p>Management of Website?</p>\n<p>Supervise?</p>\n<p>Power distribution.</p>\n<p>The by default WordPress User Roles are tailored to fit a real-life office hierarchy. These roles will naturally align with the different employee roles of an organization. But you can always customize WordPress User Roles. We are going to discuss it in the later parts of this blog. But for now, let\'s learn about them by default WordPress User Roles.</p>\n<h3>Administrator</h3>\n<p>Administrators are the most significant role for a WordPress Website. The dashboard of an Administrator includes all the functions available to a WordPress user. They can create any post, edit a post by others and delete them as required. Furthermore, they can add new plugins or remove existing ones. Administrator WordPress users can add new Administrators, invite new people as users.</p>\n<p>They sit at the top of the food chain of a WordPress Website. It is very likely that you will have multiple Administrator roles in your Website. But before you add a new Administrator, always ask yourself if the user needs full access to your Website.</p>\n<h3>Editor</h3>\n<p>Editors have the task of adding new posts, supervise posts by other contributors and delete them as required. In fact, Editors can supervise every comment and approve them.</p>\n<p>However, an Editor will never have access to themes, plugins or widgets.</p>\n<h3>Author</h3>\n<p>Authors can create their own posts, as well as delete them. They can edit comments made on their own blog posts. However, an Author cannot edit a post by another user.</p>\n<h3>Contributor</h3>\n<p>Contributors can create their own posts but not publish them. Interestingly, Contributors cannot add media files to their posts. contributors need to submit their posts for approval from the Author. And once their posts are published they cannot edit them any further.</p>\n<p>Contributor role is ideal for anyone who does not write regularly on your website. If you want to add a guest writer on your Website, assign him/her a Contributor role.</p>\n<h3>Subscriber</h3>\n<p>Subscribers can log into your WordPress Website and read any content. However, they do not have access to the backend of your Website. You can argue why do I need a Subscriber role given that anyone with an internet connection can read content on your website. Well, a Subscriber role is important if you have a subscription-based service for your readers.</p>\n<h3>Wrapping Up!</h3>\n<p>Please let us know if you have any further queries regarding this issue. In the meantime here is a quick blog on <a href="https://wpdeveloper.net/change-permalinks-wordpress/?preview_id=14873&amp;preview_nonce=9d39367e42&amp;post_format=standard&amp;_thumbnail_id=15983&amp;preview=true">how to add permalinks to your posts.</a></p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/wordpress-user-roles-explained/">WordPress User Roles Explained</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:60:"https://wpdeveloper.net/wordpress-user-roles-explained/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:50:"How to Add a Filterable Data Table on your Website";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:46:"https://wpdeveloper.net/filterable-data-table/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:54:"https://wpdeveloper.net/filterable-data-table/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 10 Jul 2018 00:30:07 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:6:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:10:"Data Table";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:16:"Essential Addons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=25777";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:387:"<p>Not all content is meant to be written down in long descriptive paras. Filterable Tables in WordPress will help you present data in a responsive manner.</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/filterable-data-table/">How to Add a Filterable Data Table on your Website</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:12060:"<p>Creating Tables for your WordPress website can be tricky, If you first build a table on a Word file and then paste it into the WordPress Editor, it will not work. It will have some unclear and unresponsive borderlines, that\'s not very useful.</p>\n<p><span id="more-25777"></span></p>\n<p><img class="aligncenter wp-image-26036 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Add-Filterable-Tables.png" alt="" width="644" height="352" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Add-Filterable-Tables.png 644w, https://wpdeveloper.net/wp-content/uploads/2018/07/Add-Filterable-Tables-300x164.png 300w" sizes="(max-width: 644px) 100vw, 644px" /></p>\n<p>Tables inside WordPress Pages/Posts is a great tool for presenting content. Furthermore, not all content is meant to be written down in long descriptive paragraphs. Some content is better presented in key points. And when the content is meant for online readers, the importance of to the point content is ten-fold.</p>\n<p>Additionally, Static Tables will help you present data, but they are not responsive. That is why a Filterable Data Tables is a much better solution.</p>\n<h3>Create Table in WordPress with Elementor and Essential Addons.</h3>\n<p>To create Table in WordPress you need <a href="https://docs.elementor.com/article/14-installation">Elementor-the best Page Builder Plugin for WordPress</a>. The Interface of Elementor is very intuitive. In fact, you can master this plugin overnight. You get 28+ elements with the Free version.</p>\n<p>For creating a Filterable Gallery for WordPress you will need to<a href="https://essential-addons.com/elementor/wp-admin/post.php?action=edit&amp;post=1996"> install Essential Addons for Elementor</a>. This addon comes with 30+ top-notch elements.</p>\n<h3>Elementor Interface</h3>\n<p>Open the Dashboard of your Website and navigate to <strong>Posts&gt;Add New. </strong>If you have properly installed Elementor you will see a blue button labeled <strong>Elementor</strong>. Click on it to open the Elementor Interface.</p>\n<p><img class="aligncenter size-full wp-image-25787" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Interface.png" alt="" width="1218" height="529" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Interface.png 1218w, https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Interface-300x130.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Interface-768x334.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Interface-1024x445.png 1024w" sizes="(max-width: 1218px) 100vw, 1218px" /></p>\n<p>&nbsp;</p>\n<p>The Elementor Interface has three distinct parts- side panel, footer panel and the blank canvas.</p>\n<p><img class="aligncenter size-full wp-image-14726" src="https://wpdeveloper.net/wp-content/uploads/2018/03/Elementor-Interface-Screenhsot.png" alt="Elementor vs Beaver Builder" width="1266" height="640" srcset="https://wpdeveloper.net/wp-content/uploads/2018/03/Elementor-Interface-Screenhsot.png 1266w, https://wpdeveloper.net/wp-content/uploads/2018/03/Elementor-Interface-Screenhsot-300x152.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/03/Elementor-Interface-Screenhsot-768x388.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/03/Elementor-Interface-Screenhsot-1024x518.png 1024w" sizes="(max-width: 1266px) 100vw, 1266px" /></p>\n<p><strong>Side Panel</strong>-It is divided into two columns. The first is <a href="https://docs.elementor.com/category/47-widgets"><b>Elements </b></a>and the second is <a href="https://docs.elementor.com/article/100-global"><b>Global</b></a>.</p>\n<p><strong>Footer Panel</strong>&#8211; Here you will see all the editing history. Additionally, you can check for responsiveness for your content. Click on the very left side icon to open the settings options.</p>\n<p><strong>Blank Canvas</strong>&#8211; The center part is mostly a blank canvas. You can either choose a template to jump-start your editing or use elements to build pages from scratch.</p>\n<p>Once you are inside the Elementor interface look for <a href="https://essential-addons.com/elementor/docs/content-elements/filterable-gallery/?preview_id=2019&amp;preview_nonce=af708d68d9&amp;_thumbnail_id=-1&amp;preview=true">EA Filterable Gallery</a>.</p>\n<h3>Create Filterable<span style="font-size: 16px;"> Table-Step by Step</span></h3>\n<p>First, go over to the side panel and search for EA Data Table. Drag and Drop the element inside the Elementor interface. <img class="aligncenter size-full wp-image-25792" src="https://wpdeveloper.net/wp-content/uploads/2018/07/data-table.png" alt="" width="1344" height="536" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/data-table.png 1344w, https://wpdeveloper.net/wp-content/uploads/2018/07/data-table-300x120.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/data-table-768x306.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/data-table-1024x408.png 1024w" sizes="(max-width: 1344px) 100vw, 1344px" /></p>\n<h3>Fixing the Layout for the Table</h3>\n<p>You should start by adjusting the layout of the table. By default, you will see 4 Columns and 1 Row. But we want to build a 3by4 table, which means the table will have 3 Columns and 4 Rows.</p>\n<p>To do so, first, go to <strong>Content&gt;Header</strong> and remove one column. You can do it by clicking on the little cross icon at the right corner of the Column Card.</p>\n<p><img class="aligncenter size-full wp-image-25794" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Data-Table-Column.png" alt="" width="1343" height="659" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Data-Table-Column.png 1343w, https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Data-Table-Column-300x147.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Data-Table-Column-768x377.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/Elementor-Data-Table-Column-1024x502.png 1024w" sizes="(max-width: 1343px) 100vw, 1343px" /></p>\n<p>&nbsp;</p>\n<p>Now we need to adjust the Row fields for the Data table. For this example, we are building a 3by4 Table. We have already reduced the column fields to 3, now we need to add three more row fields.</p>\n<p><img class="aligncenter size-full wp-image-25796" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Rows-1.png" alt="" width="1349" height="634" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Rows-1.png 1349w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Rows-1-300x141.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Rows-1-768x361.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Rows-1-1024x481.png 1024w" sizes="(max-width: 1349px) 100vw, 1349px" /></p>\n<p>Open the Content options. To remove a row field, click on the little cross icon beside the row field entries. Now focus on the part highlighted with a red box in the above screenshot. Look at the 5 cards and their label texts. The first card is labeled<strong> row:: Content.</strong> An entry like this marks the start of a row entry.</p>\n<p>And below it, you see 4 column entry fields which are labeled <strong>col:: Content</strong>. Remember, we are building a 3 column table, that is why we will remove the very last <strong>col:: Content</strong> card. Done!</p>\n<p>Now we need to add three more row entries.</p>\n<p>To add the remaining three rows of data, click on the Add Item button. Simply, add a new <strong>row:: Content</strong> card and place three <strong>column:: Conent</strong> cards below it, repeat it 2 more time and you are done.</p>\n<p>If you followed the instructions correctly you will have something like this.</p>\n<p><img class="aligncenter size-full wp-image-25799" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Sequence-1.png" alt="" width="1350" height="658" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Sequence-1.png 1350w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Sequence-1-300x146.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Sequence-1-768x374.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/Data-Table-Sequence-1-1024x499.png 1024w" sizes="(max-width: 1350px) 100vw, 1350px" /></p>\n<h3>Practice a differet layput</h3>\n<p>In the previous example, we built a 3by4 table. It had 3 columns and 4 rows of entry. But what about a table with 4 columns and 2 rows. Well, the steps for building such a table are very similar to those illustrated above.</p>\n<p>For a table with 4 columns and 2 rows of dat, the sequence of content cards will be<em> </em></p>\n<ul>\n<li><em>row:: content </em></li>\n<li><em>col::content </em></li>\n<li><em>col::content </em></li>\n<li><em>col:</em>: content</li>\n<li><em>col::content</em></li>\n</ul>\n<p>&nbsp;</p>\n<ul>\n<li><em>row:: content </em></li>\n<li><em>col::content </em></li>\n<li><em>col::content </em></li>\n<li><em>col::content </em></li>\n<li><em>col::content</em></li>\n</ul>\n<p><img class="aligncenter size-full wp-image-25800" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Essential-Addons-Elementor-Data-Table-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/Essential-Addons-Elementor-Data-Table.gif" alt="" width="1276" height="720" /></p>\n<p>Now let\'s finish building our 3by4 table.</p>\n<h3>Add Text to the Table Cards</h3>\n<p>Remember, every entry on the Table is presented as a separate card. Quikcly head over to the <strong>Header</strong> options again and click on a card. The Header Cards have three fields. <img class="aligncenter wp-image-25801 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/Header-text.png" alt="" width="241" height="482" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/Header-text.png 241w, https://wpdeveloper.net/wp-content/uploads/2018/07/Header-text-150x300.png 150w" sizes="(max-width: 241px) 100vw, 241px" /></p>\n<p>Similarly, go on and add row content.</p>\n<p><img class="aligncenter size-full wp-image-25802" src="https://wpdeveloper.net/wp-content/uploads/2018/07/row-entry.png" alt="" width="1351" height="657" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/row-entry.png 1351w, https://wpdeveloper.net/wp-content/uploads/2018/07/row-entry-300x146.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/row-entry-768x373.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/row-entry-1024x498.png 1024w" sizes="(max-width: 1351px) 100vw, 1351px" /></p>\n<h3>Add Styling</h3>\n<p>Every Essential Addons element have the same customization options as every other Elementor element. Head over to the Style section where you can adjust the General, content and Header style for your Data Table.</p>\n<h3>Filtering</h3>\n<p>It is always a great idea to test the table as you create it. To filter the table you will need to click on the little arrow button beside the Header entries. You can have both numeric and alphabetic entries in the table. In that case, the filtering will place alphabetic entries with accordance to their sequence and then place numeric ones.</p>\n<p><img class="aligncenter size-full wp-image-25803" src="https://wpdeveloper.net/wp-content/uploads/2018/07/DATA-Table-Demo-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/07/DATA-Table-Demo.gif" alt="" width="852" height="528" /></p>\n<h3>Wrapping Up!</h3>\n<p>Do comment below if you face any trouble while using EA Data Table element. In the meantime, here is a great blog where you will learn the use of <a href="https://wpdeveloper.net/website-design-ideas-for-beginners/">Elementor and Essential </a>Addons in recreating famous Website designs.</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/filterable-data-table/">How to Add a Filterable Data Table on your Website</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:51:"https://wpdeveloper.net/filterable-data-table/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:50:"How to Create Your Very Own Team Page in WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:72:"https://wpdeveloper.net/how-to-create-your-very-own-wordpress-team-page/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:80:"https://wpdeveloper.net/how-to-create-your-very-own-wordpress-team-page/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Wed, 04 Jul 2018 00:30:28 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"Tutorials";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:16:"Essential Addons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:13:"Meet the Team";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:9:"Team Page";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:22:"WordPress Team Members";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=25066";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:469:"<p>To show you how easily you can create team pages, we are here today with a simple piece of tutorial. Just follow the steps and you will see how easy it is to create your own meet the team page with WordPress.</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/how-to-create-your-very-own-wordpress-team-page/">How to Create Your Very Own Team Page in WordPress</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Kabir";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:13432:"<p>A website has several pages that build credibility and meet the team page is one of them. Many of the people who have their own websites, has the tendency to think that team pages are tough to build. However, that\'s not always the case.</p>\n<p>You can easily create meet the team page if you are using WordPress to power your website. You don\'t need any coding skill at all. Simply, drag and drop your page elements and voila, your WordPress team page is ready for going live!</p>\n<p>To show you how easily you can create team pages, we are here today with a simple piece of tutorial. Just follow the steps and you will see how easy it is to create your own meet the team page with WordPress.</p>\n<p><span id="more-25066"></span></p>\n<h2>Creating WordPress Team Page Using Elementor &amp; Essential Add-ons</h2>\n<p>As mentioned before, creating team page is very easy. All you will need is <a href="https://wordpress.org/plugins/elementor/" target="_blank" rel="noopener">Elementor</a>, the best page building plugin for WordPress. Install and activate this super friendly and easy to use plugin, on your WordPress site.</p>\n<p>Elementor has many free elements that make page building easy inside WordPress. To make things even more interesting and easier, you will need to install another <strong>FREE plugin</strong>. It\'s none other than <a href="https://wpdeveloper.net/plugins/essential-addons-elementor/" target="_blank" rel="noopener">Elementor Essential Add-ons</a>. You will find 28+ free stunning elements that you will surely make your website look awesome.</p>\n<p>Interestingly, you will find the Team Members element which is an exclusive one, for FREE with Elementor Essential Add-ons!</p>\n<p><iframe width="640" height="360" src="https://www.youtube.com/embed/8UiwMSfj6E0?feature=oembed" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe></p>\n<h3>Create A New Page Using Elementor</h3>\n<p>At first, create a new page your Admin Dashboard &gt; Pages. Add a title and fix the permalink. You can also choose the template you want from Page Attribute section on the right. Now, click on the Edit with Elementor button to get started.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-add-new-page.png"><img class="alignnone wp-image-25145 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-add-new-page.png" alt="" width="2178" height="1154" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-add-new-page.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-add-new-page-300x159.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-add-new-page-768x407.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-add-new-page-1024x543.png 1024w" sizes="(max-width: 2178px) 100vw, 2178px" /></a></p>\n<p>When the page loads, you will find a page builder with drag and drop features. You can create a new section by clicking on the button. Choose the layout you prefer. For a team page, two or the column layout is suitable.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-page-new-section.png"><img class="alignnone size-full wp-image-25146" src="https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-page-new-section.png" alt="" width="2000" height="1002" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-page-new-section.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-page-new-section-300x150.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-page-new-section-768x385.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/elementor-page-new-section-1024x513.png 1024w" sizes="(max-width: 2000px) 100vw, 2000px" /></a></p>\n<h3>Add Team Members Element to Your Page</h3>\n<p>Now, type &#8216;team\' in the elements search box. You will find the Essential Addons Team Member element. Simply drag the element and drop it on the section you have created.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element.png"><img class="alignnone wp-image-25147 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element.png" alt="" width="2498" height="1200" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-300x144.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-768x369.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-1024x492.png 1024w" sizes="(max-width: 2498px) 100vw, 2498px" /></a></p>\n<p>Here, we have created two column section and added the team element twice.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/creating-team-page-wordpress-elementor.png"><img class="alignnone size-full wp-image-25148" src="https://wpdeveloper.net/wp-content/uploads/2018/07/creating-team-page-wordpress-elementor.png" alt="" width="2000" height="1005" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/creating-team-page-wordpress-elementor.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/creating-team-page-wordpress-elementor-300x151.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/creating-team-page-wordpress-elementor-768x386.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/creating-team-page-wordpress-elementor-1024x515.png 1024w" sizes="(max-width: 2000px) 100vw, 2000px" /></a></p>\n<h3>Add Images of your Team Members</h3>\n<p>In this step, click on the element that you want to edit. The first option is to choose your team members images.</p>\n<p>Adding images is easy. When you click on the image field, you will be asked to choose an existing image or upload a new one. Click on the insert button and it will be added to your element.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/adding-team-member-images.png"><img class="alignnone size-full wp-image-25149" src="https://wpdeveloper.net/wp-content/uploads/2018/07/adding-team-member-images.png" alt="" width="2000" height="973" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/adding-team-member-images.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/adding-team-member-images-300x146.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/adding-team-member-images-768x374.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/adding-team-member-images-1024x498.png 1024w" sizes="(max-width: 2000px) 100vw, 2000px" /></a></p>\n<p>Add images for each of your team members and the process is similar.</p>\n<h3>Include Relevant Content (Description &amp; Social Profiles)</h3>\n<p>You can include details and social profiles of your team members easily using this element. Click on the Team Member Content and you will find necessary fields. Put the Name, Job Position and Description.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-content-description.png"><img class="alignnone size-full wp-image-25152" src="https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-content-description.png" alt="" width="2000" height="1083" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-content-description.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-content-description-300x163.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-content-description-768x416.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-content-description-1024x555.png 1024w" sizes="(max-width: 2000px) 100vw, 2000px" /></a></p>\n<p>You can also include social profile links. Click on the Social Profiles tab. You will find four default social profile link. However, you can modify them the way you want.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-social-profiles.png"><img class="alignnone size-full wp-image-25151" src="https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-social-profiles.png" alt="" width="2000" height="1012" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-social-profiles.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-social-profiles-300x152.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-social-profiles-768x389.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-member-social-profiles-1024x518.png 1024w" sizes="(max-width: 2000px) 100vw, 2000px" /></a></p>\n<h3>Customize the Style of Your Team Page</h3>\n<p>Elementor Essential Addons lets you customize the style of your team page. There are some intuitive styling options that you can modify according to your requirements.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/team-members-page-styling-options.png"><img class="alignnone size-full wp-image-25150" src="https://wpdeveloper.net/wp-content/uploads/2018/07/team-members-page-styling-options.png" alt="" width="2000" height="1031" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/team-members-page-styling-options.png 2000w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-members-page-styling-options-300x155.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-members-page-styling-options-768x396.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/team-members-page-styling-options-1024x528.png 1024w" sizes="(max-width: 2000px) 100vw, 2000px" /></a></p>\n<p>Here are some styling samples that you can create.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-members-element.png"><img class="aligncenter wp-image-25077 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-members-element.png" alt="" width="1886" height="1080" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-members-element.png 1886w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-members-element-300x172.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-members-element-768x440.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-members-element-1024x586.png 1024w" sizes="(max-width: 1886px) 100vw, 1886px" /></a></p>\n<p>You can also unleash your creativity to make unique ones.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-overlay.png"><img class="aligncenter wp-image-25076 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-overlay.png" alt="" width="1968" height="860" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-overlay.png 1968w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-overlay-300x131.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-overlay-768x336.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-element-overlay-1024x447.png 1024w" sizes="(max-width: 1968px) 100vw, 1968px" /></a></p>\n<p><button><a href="https://essential-addons.com/elementor/team-members/" target="_blank" rel="noopener">Check Live Demo of Team Members Using Elementor Essential Add-ons</a></button></p>\n<h2>Bonus: Team Members Carousel (Pro)</h2>\n<p>If you are looking for something more advanced and modern looking, then you can consider the team members carousel element. It is available with the <a href="https://essential-addons.com/elementor/#pricing" target="_blank" rel="noopener">Pro version of Essential Add-ons for Elementor</a>. It works just like the team members elements. Simply drag and drop the element on your page, add team member photos, social links, description etc.</p>\n<p><a href="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-member-carousel-2.png"><img class="aligncenter wp-image-25078 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-member-carousel-2.png" alt="" width="1918" height="976" srcset="https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-member-carousel-2.png 1918w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-member-carousel-2-300x153.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-member-carousel-2-768x391.png 768w, https://wpdeveloper.net/wp-content/uploads/2018/07/essential-addons-team-member-carousel-2-1024x521.png 1024w" sizes="(max-width: 1918px) 100vw, 1918px" /></a></p>\n<p><button><a href="https://essential-addons.com/elementor/team-member-carousel/" target="_blank" rel="noopener">Check Live Demo of Team Members Carousel</a></button></p>\n<p>Creating a team page for your WordPress site is very easy, thanks to Elementor and Essential Add-ons plugin. You can create various types of team pages using these tools and make sure your website looks interesting enough or your visitors and also your team.</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/how-to-create-your-very-own-wordpress-team-page/">How to Create Your Very Own Team Page in WordPress</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:77:"https://wpdeveloper.net/how-to-create-your-very-own-wordpress-team-page/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:75:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:66:"Benefits of A Website for Small Business &amp; Essential Web Pages";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:65:"https://wpdeveloper.net/benefits-of-a-website-for-small-business/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:73:"https://wpdeveloper.net/benefits-of-a-website-for-small-business/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 28 Jun 2018 00:30:00 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:12:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:4:"News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:8:"Facebook";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:6:"Google";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:9:"Instagram";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:8:"LinkedIn";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:9:"Pinterest";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:7;a:5:{s:4:"data";s:5:"Quora";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:8;a:5:{s:4:"data";s:6:"Tumblr";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:9;a:5:{s:4:"data";s:7:"Twitter";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:10;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:11;a:5:{s:4:"data";s:7:"Youtube";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=24211";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:627:"<p>Establishing Online Presence is becoming more and more easy by the day. Every business should make itself available through different online platforms. Of course, Social Media Accounts are important, but having a separate Business Website is more effective. Do you want to create a website for your Business? It might not take more than a couple [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/benefits-of-a-website-for-small-business/">Benefits of A Website for Small Business &#038; Essential Web Pages</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:13924:"<p>Establishing Online Presence is becoming more and more easy by the day. Every business should make itself available through different online platforms. Of course, Social Media Accounts are important, but having a separate Business Website is more effective.</p>\n<p><span id="more-24211"></span></p>\n<p><img class="aligncenter wp-image-24339 size-full" src="https://wpdeveloper.net/wp-content/uploads/2018/06/How_Many_Pages_Does_a_Website_Have.png" alt="" width="811" height="443" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/How_Many_Pages_Does_a_Website_Have.png 811w, https://wpdeveloper.net/wp-content/uploads/2018/06/How_Many_Pages_Does_a_Website_Have-300x164.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/How_Many_Pages_Does_a_Website_Have-768x420.png 768w" sizes="(max-width: 811px) 100vw, 811px" /></p>\n<p><a href="https://wpdeveloper.net/rookies-guide-to-building-professional-wordpress-site/?preview_id=5224&amp;preview_nonce=08c482370a&amp;post_format=standard&amp;_thumbnail_id=6349&amp;preview=true">Do you want to create a website for your Business</a>?</p>\n<p>It might not take more than a couple of hours before you can launch a complete website. Yes! It has become that easy with one-click install options and readily available website templates, you can launch a website overnight and without any coding knowledge. But before you launch your website it is also important to understand how it can benefit your business.</p>\n<h2>Separate Website vs Social Media Platforms</h2>\n<p>You should not confuse the effectiveness of Social Media Accounts with Business Websites. As a rule of thumb, Social Media Platforms are a great way to attract and reach out to a new audience and go for retention. On the other hand, Business Websites are a must for staying connected with your conventional customers.</p>\n<h4>Best Social Media Platforms for Business Marketing</h4>\n<p>Facebook, Twitter, LinkedIn, Google+, Youtube, Pinterest, Instagram, Tumblr, Quora are all great platforms for promoting your business. I can name dozen more such platforms. They are all successful because they combine different marketing tools to promote their products/services. You will never run out of new methods of promoting your business through different Social Media Platforms. But every platform thrives on completely different types of interaction between users, which makes it more difficult to manipulate the different variables.</p>\n<p><img class="aligncenter wp-image-24340 size-medium" src="https://wpdeveloper.net/wp-content/uploads/2018/06/social-300x300.png" alt="" width="300" height="300" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/social-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/social-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/social-100x100.png 100w, https://wpdeveloper.net/wp-content/uploads/2018/06/social.png 722w" sizes="(max-width: 300px) 100vw, 300px" /></p>\n<h4>Why Create a Website for your Business?</h4>\n<p>On the other hand, a business website lets you present your services in your own way. You cannot control what people say on social media, and where they mention your business name, but you can use a business website to manipulate public perception about your business.</p>\n<p>If you are planning on creating content on social media platforms, know that there will always be some limitations. For example, Twitter only lets you use 140 characters per tweet.  Youtube is a great platform for uploading videos, but you might fail to address certain customer issues through video content.  But if you are publishing content on your website you will never need to worry about what you can publish and in which manner.</p>\n<p>Interestingly, content published on your website can be a great tool for increasing your followers on Social Media Platforms. Your audience can share your content on Social Media, which gives them a meaningful purpose to interact with other users.</p>\n<p>According to a survey, 90% of customers said that online testimonials influence their buying decisions. You can take help from different listing websites to let your customers rate your service online. But you can also post testimonials on your Website, which is more effective.</p>\n<p>Lastly, don\'t think that only a high-end product/service company needs a business. Each and every contemporary customer have become accustomed to using the Internet and they have grown comfortable with it. Every business needs to act smart because they can expect their customers to do the same.</p>\n<p>Currently, Website design has become an art. You can visit the Official website of <a href="https://www.essential.com/">Essential Phones</a> to get the idea. You can learn more about different parts of a website and how you can <a href="https://wpdeveloper.net/website-design-ideas-for-beginners/?preview_id=16860&amp;preview_nonce=c4e4f21b3c&amp;post_format=standard&amp;_thumbnail_id=20442&amp;preview=true">recreate them with Essential Addons for Elementor.</a></p>\n<h3>Show up on Google!</h3>\n<p>Probably the most important reason for having a website is, it gives you a greater chance of showing up on Google Search results.</p>\n<p><img class="aligncenter wp-image-24362 size-large" src="https://wpdeveloper.net/wp-content/uploads/2018/06/google-search-mobile-redesign-cover-1024x351.jpg" alt="Benefits of a Website for Small Business" width="640" height="219" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/google-search-mobile-redesign-cover-1024x351.jpg 1024w, https://wpdeveloper.net/wp-content/uploads/2018/06/google-search-mobile-redesign-cover-300x103.jpg 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/google-search-mobile-redesign-cover-768x263.jpg 768w, https://wpdeveloper.net/wp-content/uploads/2018/06/google-search-mobile-redesign-cover.jpg 1050w" sizes="(max-width: 640px) 100vw, 640px" /></p>\n<p>&nbsp;</p>\n<p>Customers like to do research before buying any product. And like searching for other things, they use Google. Google is currently the most widely used Search Engine. Know that posting on social media platforms is not going to get you in search results. But having a website has a greater chance of making it to the search results.</p>\n<h3>Internal Use</h3>\n<p>Using websites help both internal and external stakeholders. Many businesses use their website to recruit new employees. They usually let potential individuals open an account on the website and upload their CVs with other information. This data is stored on an offline database. This helps the HR manager tackle recruitment urgencies more effectively.</p>\n<h2>Let\'s get down to Business</h2>\n<p>Now that you know why a Business Website is important, let\'s learn about the overall structure of website-the different types of Web pages.</p>\n<h4>Home Page</h4>\n<p><img class="alignleft wp-image-24342" src="https://wpdeveloper.net/wp-content/uploads/2018/06/750270-150x150.png" alt="" width="50" height="50" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/750270-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/750270-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/750270-100x100.png 100w, https://wpdeveloper.net/wp-content/uploads/2018/06/750270.png 512w" sizes="(max-width: 50px) 100vw, 50px" /></p>\n<p>This is the probably the very first page your visitors will see.</p>\n<p>There are a couple of things a Home Page must ensure- Fast Loading and Elegant Style are a good starting point. A Home Page can influence how many leave the website within 5 seconds of arrival. For this reason, Home Pages are a must.</p>\n<h4>About Page</h4>\n<p><img class="alignleft wp-image-24343" src="https://wpdeveloper.net/wp-content/uploads/2018/06/users-group.png" alt="" width="50" height="50" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/users-group.png 512w, https://wpdeveloper.net/wp-content/uploads/2018/06/users-group-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/users-group-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/users-group-100x100.png 100w" sizes="(max-width: 50px) 100vw, 50px" /></p>\n<p>Most probably, this is the page most of your visitors will visit first after landing on your website. You can include your contact information on this page along with details about the services you provide.</p>\n<p>If you have a single- author website, you should name it About Me. And if you have a business blog, name it About Us. You can quote some information from the Corporate Charter on this page, like missions, visions, and your goals.</p>\n<h3>Contact Page</h3>\n<p><img class="alignleft wp-image-24344" src="https://wpdeveloper.net/wp-content/uploads/2018/06/phone-contact.png" alt="" width="50" height="50" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/phone-contact.png 512w, https://wpdeveloper.net/wp-content/uploads/2018/06/phone-contact-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/phone-contact-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/phone-contact-100x100.png 100w" sizes="(max-width: 50px) 100vw, 50px" /></p>\n<p>You can include your contact information on About Page, or use a separate webpage for doing so. You can include all your contact information on Contact Page. A Contact Page helps your stakeholders easily learn how to connect with you.</p>\n<p>Contents of a Contact Page include contact forms, email-address, phone number, Business location maps, social media accpunts.</p>\n<h4>Privacy Policy Page</h4>\n<p><img class="alignleft wp-image-24345" src="https://wpdeveloper.net/wp-content/uploads/2018/06/shield-with-lock.png" alt="" width="50" height="50" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/shield-with-lock.png 512w, https://wpdeveloper.net/wp-content/uploads/2018/06/shield-with-lock-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/shield-with-lock-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/shield-with-lock-100x100.png 100w" sizes="(max-width: 50px) 100vw, 50px" /></p>\n<p>On this page, you need to describe what information you collect from your website and for what purpose they are used for. You might feel the need to use Google AdSense for your website, if this is the case, you must include a privacy policy page on your website.</p>\n<h4>Product/Service Page</h4>\n<p><img class="alignleft wp-image-24346" src="https://wpdeveloper.net/wp-content/uploads/2018/06/checklist.png" alt="" width="50" height="50" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/checklist.png 512w, https://wpdeveloper.net/wp-content/uploads/2018/06/checklist-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/checklist-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/checklist-100x100.png 100w" sizes="(max-width: 50px) 100vw, 50px" /></p>\n<p>If you are using an e-commerce website, you need a product page for listing your catalog. It helps your customers make their purchase decision more easily. If you use an e-commerce plugin like WooCommerce, the plugin will automatically create a listing page for you. But otherwise, you need to create one separately if needed.</p>\n<h4>FAQ Page</h4>\n<p><img class="alignleft wp-image-24347" src="https://wpdeveloper.net/wp-content/uploads/2018/06/discuss-issue.png" alt="" width="50" height="50" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/discuss-issue.png 512w, https://wpdeveloper.net/wp-content/uploads/2018/06/discuss-issue-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/discuss-issue-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/discuss-issue-100x100.png 100w" sizes="(max-width: 50px) 100vw, 50px" /></p>\n<p>No matter how detailed your website is, you can always expect a moderate number of your customers emailing you with a query. But it can kill a lot of productive hours. To solve this issue you can include an FAQ page on your website. this page will contain answers to all the possible queries your customers might seek answers to.</p>\n<h4>Blog Page</h4>\n<p><img class="alignleft wp-image-24349" src="https://wpdeveloper.net/wp-content/uploads/2018/06/post.png" alt="" width="50" height="50" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/post.png 512w, https://wpdeveloper.net/wp-content/uploads/2018/06/post-150x150.png 150w, https://wpdeveloper.net/wp-content/uploads/2018/06/post-300x300.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/post-100x100.png 100w" sizes="(max-width: 50px) 100vw, 50px" /></p>\n<p>Every website must post new blogs addressing different issues. A blog page is different from other pages of a website. It lists all the blogs on a website published. think of it as a catalog of blogs. Don\'t be relieved after launching a website. You should also ensure that you are posting new and relevant blog content on your website in order to drive more traffic to your website.</p>\n<h2>Wrapping Up!</h2>\n<p>Now that you know what are the essential pages for every Website, let me equip you with the tools to recreate such pages. Here is a blog that will help you recreate distict parts of a WebPage using <a href="https://elementor.com/">Elementor</a> and <a href="https://essential-addons.com/elementor/">Essential Addons for Elementor. </a></p>\n<ul>\n<li class="blog-title"><a href="https://wpdeveloper.net/essential-addons-creative-elements/">ESSENTIAL ADDONS-CREATIVE ELEMENTS</a></li>\n</ul>\n<p>That should be it! Please comment if you face any trouble or need answers to any query.</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/benefits-of-a-website-for-small-business/">Benefits of A Website for Small Business &#038; Essential Web Pages</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:70:"https://wpdeveloper.net/benefits-of-a-website-for-small-business/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:60:"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:42:"Essential Addons- Dynamic Content Elements";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"https://wpdeveloper.net/essential-addons-dynamic-content-elements/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:74:"https://wpdeveloper.net/essential-addons-dynamic-content-elements/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 21 Jun 2018 12:30:12 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:7:{i:0;a:5:{s:4:"data";s:4:"Blog";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"Elementor";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:4:"News";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:3;a:5:{s:4:"data";s:8:"Blogging";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:4;a:5:{s:4:"data";s:25:"Elementor Dynamic Content";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:5;a:5:{s:4:"data";s:16:"Essential Addons";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:6;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://wpdeveloper.net/?p=22312";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:631:"<p>Dynamic Elements for Elementor have various applications. Starting from presenting multiple blogs/posts in a grid layout, Stunning Layouts for Media Galleries, Google Maps to Grids for WooCommerce products, all can be done using Essential Addons Dynamic Elements. Dynamic Elements for Elementor Post Grid and Post Block Post Grid and Post Block places multiple post/blogs in [&#8230;]</p>\n<p>The post <a rel="nofollow" href="https://wpdeveloper.net/essential-addons-dynamic-content-elements/">Essential Addons- Dynamic Content Elements</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:5:"Akash";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:29801:"		<div class="elementor elementor-22312">\n			<div class="elementor-inner">\n				<div class="elementor-section-wrap">\n							<section data-id="e46f5d1" class="elementor-element elementor-element-e46f5d1 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="436ca0a" class="elementor-element elementor-element-436ca0a elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="d1a48ba" class="elementor-element elementor-element-d1a48ba elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>Dynamic Elements for Elementor have various applications. Starting from presenting multiple blogs/posts in a grid layout, Stunning Layouts for Media Galleries, Google Maps to Grids for WooCommerce products, all can be done using Essential Addons Dynamic Elements. </p></div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="05eddc1" class="elementor-element elementor-element-05eddc1 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="b6f3f8d" class="elementor-element elementor-element-b6f3f8d elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="58a20f1" class="elementor-element elementor-element-58a20f1 elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="350" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Dynamic-Elements.png" class="attachment-large size-large" alt="Dynamic Elements for Elementor" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/Dynamic-Elements.png 644w, https://wpdeveloper.net/wp-content/uploads/2018/06/Dynamic-Elements-300x164.png 300w" sizes="(max-width: 640px) 100vw, 640px" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="98620ac" class="elementor-element elementor-element-98620ac elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="797f289" class="elementor-element elementor-element-797f289 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="4e46e20" class="elementor-element elementor-element-4e46e20 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h1 class="elementor-heading-title elementor-size-default">Dynamic Elements for Elementor</h1>		</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="ad060c3" class="elementor-element elementor-element-ad060c3 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="70d3f64" class="elementor-element elementor-element-70d3f64 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="1f8370b" class="elementor-element elementor-element-1f8370b elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default">Post Grid and Post Block</h2>		</div>\n				</div>\n				<div data-id="64ab2e0" class="elementor-element elementor-element-64ab2e0 elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p><a href="https://essential-addons.com/elementor/post-grid/"><span style="font-weight: 400;">Post Grid</span></a><span style="font-weight: 400;"> and </span><a href="https://essential-addons.com/elementor/post-block/"><span style="font-weight: 400;">Post Block</span></a><span style="font-weight: 400;"> places multiple post/blogs in an aesthetic post grid.The purpose of this element is to let you organize and place your blogs/posts in one place. That way your visitors can choose posts that intrigue them. In essence, using these two elements you are giving multiple choices to your site-visitors without overwhelming them.</span></p><p><span style="font-weight: 400;">You can add image, title,excerpt and meta for any post type. Similarly, add information like, author name, publish date to help your visitors choose their pick. Post Grid also offers you the popular Masonry layout. Present your content in a easily digestible manner with these two high-end elements.</span></p></div>\n				</div>\n				</div>\n				<div data-id="c70abd5" class="elementor-element elementor-element-c70abd5 elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="420" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot.png" class="attachment-large size-large" alt="Dynamic Elements for Elementor" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot.png 845w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-300x197.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-768x504.png 768w" sizes="(max-width: 640px) 100vw, 640px" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="6b2fb3f" class="elementor-element elementor-element-6b2fb3f elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="30029f7" class="elementor-element elementor-element-30029f7 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="6c2f737" class="elementor-element elementor-element-6c2f737 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default">Post Timeline &amp; Content Timeline</h2>		</div>\n				</div>\n				<div data-id="c43271d" class="elementor-element elementor-element-c43271d elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p><span style="font-weight: 400;">As your website grows through the years you must find a better way to present your blogs to your visitors. Because as you publish new posts the older ones reach the bottom of the pile. And when a visitor wishes to read those old contents they have to dig very deep in your post catalog.</span></p><p><a href="https://essential-addons.com/elementor/post-timeline/"><span style="font-weight: 400;">Post Timeline</span></a><span style="font-weight: 400;"> and <a href="https://essential-addons.com/elementor/content-timeline/">Content Timeline</a> lets you build vertical timeline for your post and testimonials. This way your readers can navigate your website better. Combine this with strong visuals and you have a interactive visual representation of your content.</span></p></div>\n				</div>\n				</div>\n				<div data-id="6a4c0d6" class="elementor-element elementor-element-6a4c0d6 elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="572" height="465" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-1.png" class="attachment-large size-large" alt="Dynamic Elements for Elementor" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-1.png 572w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-1-300x244.png 300w" sizes="(max-width: 572px) 100vw, 572px" />											</div>\n				</div>\n				</div>\n				<div data-id="6efdf22" class="elementor-element elementor-element-6efdf22 elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>But if you are looking for something less dramatic, we have you covered with <a href="https://essential-addons.com/elementor/post-list/">Post List</a> element.</p></div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="8c85dce" class="elementor-element elementor-element-8c85dce elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="561aa6d" class="elementor-element elementor-element-561aa6d elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="fd36ba5" class="elementor-element elementor-element-fd36ba5 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default"><a href="https://essential-addons.com/elementor/instagram-feed/">Instagram Feed</a></h2>		</div>\n				</div>\n				<div data-id="043dbd9" class="elementor-element elementor-element-043dbd9 elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p><span style="font-weight: 400;">Include images uploaded into a public Instagram account and arrange them in an interactive way. The layout will look good on any screen size. In short, </span><a href="https://essential-addons.com/elementor/instagram-feed/"><span style="font-weight: 400;">Instagram Feed</span></a><span style="font-weight: 400;"> lets you create an online gallery of images.</span></p><p><span style="font-size: 1em;">Create an interactive image gallery with your Instagram posts. You can hand-pick the images you want to display. You are not restricted to choosing images from a certain timeline. Hand-pick images and arrange them in a simple gallery layout. Use the prominent Masonry layout. Also, you can add an overlay feature.</span></p></div>\n				</div>\n				</div>\n				<div data-id="d9790d0" class="elementor-element elementor-element-d9790d0 elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="338" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-2.png" class="attachment-large size-large" alt="Dynamic Elements for Elementor" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-2.png 890w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-2-300x158.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-2-768x406.png 768w" sizes="(max-width: 640px) 100vw, 640px" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="50ae9b1" class="elementor-element elementor-element-50ae9b1 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="11292f7" class="elementor-element elementor-element-11292f7 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="49dac2e" class="elementor-element elementor-element-49dac2e elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default"><a href="https://essential-addons.com/elementor/woo-product-grid/">Woo Product Grid </a></h2>		</div>\n				</div>\n				<div data-id="e12e0cc" class="elementor-element elementor-element-e12e0cc elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p><span style="font-weight: 400;">Do you own a WooCommerce-powered online store? Don’t worry! Essential Addons includes </span><a href="https://essential-addons.com/elementor/woo-product-grid/"><span style="font-weight: 400;">Woo Product Grid</span></a><span style="font-weight: 400;"> in its library. It helps you create interactive product grids for your WooCommerce online store. Your buyers can toggle between lists and find the product they need. Sometimes you need to offer a little more to convince your customers into making a purchase decision. Using this element you can gain that winning edge. </span></p></div>\n				</div>\n				</div>\n				<div data-id="9e6d357" class="elementor-element elementor-element-9e6d357 elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="325" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-3.png" class="attachment-large size-large" alt="Dynamic Elements for Elementor" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-3.png 873w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-3-300x153.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-3-768x391.png 768w" sizes="(max-width: 640px) 100vw, 640px" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="fdab5fe" class="elementor-element elementor-element-fdab5fe elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="1836d16" class="elementor-element elementor-element-1836d16 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="c9db7c6" class="elementor-element elementor-element-c9db7c6 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default"><a href="https://essential-addons.com/elementor/table">Data Table</a></h2>		</div>\n				</div>\n				<div data-id="ffa8570" class="elementor-element elementor-element-ffa8570 elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>Tables are a great way to present data about multiple objects across various criteria. It is better than plain text because it is less chaotic and lets include only the key points. But Essential Addons offers more than that. EA Data Table comes with advanced filtering capabilities.</p><p> </p></div>\n				</div>\n				</div>\n				<div data-id="2d2844d" class="elementor-element elementor-element-2d2844d elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="397" src="https://wpdeveloper.net/wp-content/uploads/2018/06/DATA-Table-Demo-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/06/DATA-Table-Demo.gif" class="attachment-large size-large" alt="Dynamic Elements for Elementor" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="fd15de5" class="elementor-element elementor-element-fd15de5 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="0d278ed" class="elementor-element elementor-element-0d278ed elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="51ae0b8" class="elementor-element elementor-element-51ae0b8 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default"><a href="https://essential-addons.com/elementor/filterable-gallery">Dynamic Filter Gallery </a></h2>		</div>\n				</div>\n				<div data-id="cb1f522" class="elementor-element elementor-element-cb1f522 elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>Essential Addons includes two elements, <a href="https://essential-addons.com/elementor/filterable-gallery">Filterable Gallery</a> &amp; <a href="https://essential-addons.com/elementor/filterable-gallery">Dynamic Filter Gallery</a>, that let you create advanced gallery for your WordPress website. These two elements are very useful for e-Commerce sites.</p></div>\n				</div>\n				</div>\n				<div data-id="0b94e4d" class="elementor-element elementor-element-0b94e4d elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="430" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Filterable-Gallery-Demo-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/06/Filterable-Gallery-Demo.gif" class="attachment-large size-large" alt="Dynamic Elements for Elementor" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="a6978a2" class="elementor-element elementor-element-a6978a2 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="cfcda7b" class="elementor-element elementor-element-cfcda7b elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="8ddd444" class="elementor-element elementor-element-8ddd444 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default"><a href="https://essential-addons.com/elementor/content-ticker">Content Ticker </a></h2>		</div>\n				</div>\n				<div data-id="5a512f6" class="elementor-element elementor-element-5a512f6 elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>This element is great for highlighting certain posts on a regular basis. If you have a blogging website, you don\'t want a heavy element for highlighting blogs that take up a big chunk of the screen. Content Ticker takes up only a small portion of your website.</p><p>You can fetch posts/pages for use with the Content ticker element according to their category. Furthermore, you can order these posts/pages according to their Post ID, Author, Comment Count, </p></div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="43f28e1" class="elementor-element elementor-element-43f28e1 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="b7704c3" class="elementor-element elementor-element-b7704c3 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="ee514f3" class="elementor-element elementor-element-ee514f3 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default"><a href="https://essential-addons.com/elementor/image-accordion">Image Accordion</a></h2>		</div>\n				</div>\n				<div data-id="fdd3f7b" class="elementor-element elementor-element-fdd3f7b elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>Image Accordion helps to present media files in a new manner. Multiple images are stacked into a frame, which has fixed width and height. And as your website visitors hover their mouse over one image or click on one the image gets bigger taking up a larger portion of the frame.</p><p> </p></div>\n				</div>\n				</div>\n				<div data-id="f2512df" class="elementor-element elementor-element-f2512df elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="279" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Image-Accordion-Demo-gap.jpg" data-gif="https://wpdeveloper.net/wp-content/uploads/2018/06/Image-Accordion-Demo.gif" class="attachment-large size-large" alt="Dynamic Elements for Elementor" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="9bfae9e" class="elementor-element elementor-element-9bfae9e elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="2bd4e4f" class="elementor-element elementor-element-2bd4e4f elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="6bfc7cf" class="elementor-element elementor-element-6bfc7cf elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default"><a href="https://essential-addons.com/elementor/advanced-google-map/">Advanced Google Maps</a></h2>		</div>\n				</div>\n				<div data-id="d7a8b8f" class="elementor-element elementor-element-d7a8b8f elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>Every Website needs to capitalize on every tool available to them for establishing strong online presence. Google Maps is such a tool. Well we all know what a map is good for. But embedding a map on your website has more benefits. With EA Advanced Google Maps you can add single markers, multiple markers, routes to your location or Panorama view of a location.</p></div>\n				</div>\n				</div>\n				<div data-id="77befaa" class="elementor-element elementor-element-77befaa elementor-widget elementor-widget-image" data-element_type="image.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-image">\n										<img width="640" height="290" src="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-4.png" class="attachment-large size-large" alt="Dynamic Elements for Elementor" srcset="https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-4.png 855w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-4-300x136.png 300w, https://wpdeveloper.net/wp-content/uploads/2018/06/Screenshot-4-768x349.png 768w" sizes="(max-width: 640px) 100vw, 640px" />											</div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="87263d2" class="elementor-element elementor-element-87263d2 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="5cb1e20" class="elementor-element elementor-element-5cb1e20 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="a05fc29" class="elementor-element elementor-element-a05fc29 elementor-widget elementor-widget-heading" data-element_type="heading.default">\n				<div class="elementor-widget-container">\n			<h2 class="elementor-heading-title elementor-size-default">Wrapping Up!</h2>		</div>\n				</div>\n				<div data-id="8046890" class="elementor-element elementor-element-8046890 elementor-widget elementor-widget-text-editor" data-element_type="text-editor.default">\n				<div class="elementor-widget-container">\n					<div class="elementor-text-editor elementor-clearfix"><p>Essential Addons includes other specialized elements in its bundles, and there are 5 of them. There is no need to feel overwhelmed by the versatile use of the elements as they are self-explanatory. If you still have any doubts, make sure to check the documentation pages.<br />But before you make a purchase, make sure to check the Official Website of Essential Addons for more insight. </p></div>\n				</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n				<section data-id="f008ec3" class="elementor-element elementor-element-f008ec3 elementor-section-boxed elementor-section-height-default elementor-section-height-default elementor-section elementor-top-section" data-element_type="section">\n						<div class="elementor-container elementor-column-gap-default">\n				<div class="elementor-row">\n				<div data-id="b53fdb9" class="elementor-element elementor-element-b53fdb9 elementor-column elementor-col-100 elementor-top-column" data-element_type="column">\n			<div class="elementor-column-wrap elementor-element-populated">\n					<div class="elementor-widget-wrap">\n				<div data-id="d62b05d" class="elementor-element elementor-element-d62b05d elementor-widget elementor-widget-eael-creative-button" data-element_type="eael-creative-button.default">\n				<div class="elementor-widget-container">\n			\n<div class="eael-creative-button-wrapper">\n	<a class="eael-creative-button eael-creative-button--wayra"\n		href="##"    data-text="Go!">\n		<span>\n			\n			Try Elementor Essential Add-ons Now!\n							<i class="fa fa-arrow-circle-o-right eael-creative-button-icon-right" aria-hidden="true"></i> \n					</span>\n	</a>\n</div>\n			</div>\n				</div>\n						</div>\n			</div>\n		</div>\n						</div>\n			</div>\n		</section>\n						</div>\n			</div>\n		</div>\n		<p>The post <a rel="nofollow" href="https://wpdeveloper.net/essential-addons-dynamic-content-elements/">Essential Addons- Dynamic Content Elements</a> appeared first on <a rel="nofollow" href="https://wpdeveloper.net">WPDeveloper</a>.</p>\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"https://wpdeveloper.net/essential-addons-dynamic-content-elements/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:29:"https://wpdeveloper.net/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:6:"hourly";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:42:"Requests_Utility_CaseInsensitiveDictionary":1:{s:7:"\0*\0data";a:13:{s:6:"server";s:5:"nginx";s:4:"date";s:29:"Mon, 06 Aug 2018 07:22:05 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:4:"vary";s:15:"Accept-Encoding";s:13:"last-modified";s:29:"Fri, 03 Aug 2018 16:29:28 GMT";s:4:"etag";s:36:"W/"a6f71c9bc2f3069889ee7d0005141477"";s:10:"set-cookie";s:291:"edd_user_history=%5B%7B%22url%22%3A%22https%3A%5C%2F%5C%2Fwpdeveloper.net%5C%2Ffeed%5C%2F%22%2C%22time%22%3A1533540125%7D%2C%7B%22url%22%3A%22https%3A%5C%2F%5C%2Fwpdeveloper.net%5C%2Ffeed%5C%2F%22%2C%22time%22%3A1533540125%7D%5D; expires=Mon, 13-Aug-2018 07:22:05 GMT; Max-Age=604800; path=/";s:12:"x-robots-tag";s:15:"noindex, follow";s:4:"link";s:60:"<https://wpdeveloper.net/wp-json/>; rel="https://api.w.org/"";s:12:"x-powered-by";s:16:"EasyEngine 3.7.4";s:16:"rt-fastcgi-cache";s:6:"BYPASS";s:25:"strict-transport-security";s:35:"max-age=31536000; includeSubDomains";s:16:"content-encoding";s:4:"gzip";}}s:5:"build";s:14:"20180621115444";}', 'no'),
 (934, 'icon_widget_settings', 'a:1:{s:4:"font";s:12:"font-awesome";}', 'yes'),
 (935, 'widget_icon-widget', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (2426, '_site_transient_timeout_theme_roots', '1533541616', 'no'),
 (2427, '_site_transient_theme_roots', 'a:2:{s:26:"oceanwp-child-theme-master";s:7:"/themes";s:7:"oceanwp";s:7:"/themes";}', 'no'),
 (1223, 'widget_ocean_social_share', 'a:1:{s:12:"_multiwidget";i:1;}', 'yes'),
 (1624, 'auto_core_update_notified', 'a:4:{s:4:"type";s:7:"success";s:5:"email";s:16:"admin@tyco.co.il";s:7:"version";s:5:"4.9.8";s:9:"timestamp";i:1533248720;}', 'no'),
 (996, 'duplicator_settings', 'a:10:{s:7:"version";s:6:"1.2.40";s:18:"uninstall_settings";b:1;s:15:"uninstall_files";b:1;s:16:"uninstall_tables";b:1;s:13:"package_debug";b:0;s:17:"package_mysqldump";b:1;s:22:"package_mysqldump_path";s:0:"";s:24:"package_phpdump_qrylimit";s:3:"100";s:17:"package_zip_flush";b:0;s:20:"storage_htaccess_off";b:0;}', 'yes'),
 (997, 'duplicator_version_plugin', '1.2.40', 'yes'),
 (1000, 'duplicator_ui_view_state', 'a:6:{s:22:"dup-pack-storage-panel";s:1:"0";s:22:"dup-pack-archive-panel";s:1:"1";s:24:"dup-pack-installer-panel";s:1:"0";s:19:"dup-pack-build-try2";s:1:"1";s:19:"dup-pack-build-try3";s:1:"1";s:19:"dup-pack-build-try1";s:1:"1";}', 'yes'),
 (1001, 'duplicator_package_active', 'O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:20:16";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";N;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"b235e645ff2d28802189180621142016";s:8:"NameHash";s:47:"20180621_agura_b235e645ff2d28802189180621142016";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:53:"/home/agurainc/public_html/wordpress/wp-snapshots/tmp";s:8:"StoreURL";s:47:"http://www.agurainc.com/wordpress/wp-snapshots/";s:8:"ScanFile";s:57:"20180621_agura_b235e645ff2d28802189180621142016_scan.json";s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";N;s:7:"Archive";O:11:"DUP_Archive":19:{s:10:"FilterDirs";s:0:"";s:11:"FilterFiles";s:0:"";s:10:"FilterExts";s:0:"";s:13:"FilterDirsAll";a:0:{}s:14:"FilterFilesAll";a:0:{}s:13:"FilterExtsAll";a:0:{}s:8:"FilterOn";i:0;s:12:"ExportOnlyDB";i:0;s:4:"File";N;s:6:"Format";s:3:"ZIP";s:7:"PackDir";s:26:"/home/agurainc/public_html";s:4:"Size";i:0;s:4:"Dirs";a:0:{}s:5:"Files";a:0:{}s:10:"FilterInfo";O:23:"DUP_Archive_Filter_Info":8:{s:4:"Dirs";O:34:"DUP_Archive_Filter_Scope_Directory":4:{s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:5:"Files";O:29:"DUP_Archive_Filter_Scope_File":5:{s:4:"Size";a:0:{}s:7:"Warning";a:0:{}s:10:"Unreadable";a:0:{}s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:4:"Exts";O:29:"DUP_Archive_Filter_Scope_Base":2:{s:4:"Core";a:0:{}s:8:"Instance";a:0:{}}s:9:"UDirCount";i:0;s:10:"UFileCount";i:0;s:9:"UExtCount";i:0;s:8:"TreeSize";a:0:{}s:11:"TreeWarning";a:0:{}}s:14:"RecursiveLinks";a:0:{}s:10:"\0*\0Package";O:11:"DUP_Package":23:{s:7:"Created";s:19:"2018-06-21 14:20:16";s:7:"Version";s:6:"1.2.40";s:9:"VersionWP";s:5:"4.9.6";s:9:"VersionDB";s:6:"5.5.59";s:10:"VersionPHP";s:6:"5.6.36";s:9:"VersionOS";s:5:"Linux";s:2:"ID";N;s:4:"Name";s:14:"20180621_agura";s:4:"Hash";s:32:"b235e645ff2d28802189180621142016";s:8:"NameHash";s:47:"20180621_agura_b235e645ff2d28802189180621142016";s:4:"Type";i:0;s:5:"Notes";s:0:"";s:9:"StorePath";s:43:"/home/agurainc/public_html/wp-snapshots/tmp";s:8:"StoreURL";s:44:"http://agurainc.jet.tyco.co.il/wp-snapshots/";s:8:"ScanFile";N;s:7:"Runtime";N;s:7:"ExeSize";N;s:7:"ZipSize";N;s:6:"Status";N;s:6:"WPUser";N;s:7:"Archive";r:22;s:9:"Installer";O:13:"DUP_Installer":7:{s:4:"File";N;s:4:"Size";i:0;s:10:"OptsDBHost";s:0:"";s:10:"OptsDBPort";s:0:"";s:10:"OptsDBName";s:0:"";s:10:"OptsDBUser";s:0:"";s:10:"\0*\0Package";r:58;}s:8:"Database";O:12:"DUP_Database":13:{s:4:"Type";s:5:"MySQL";s:4:"Size";N;s:4:"File";N;s:4:"Path";N;s:12:"FilterTables";s:0:"";s:8:"FilterOn";i:0;s:4:"Name";N;s:10:"Compatible";s:0:"";s:8:"Comments";s:28:"MySQL Community Server (GPL)";s:10:"\0*\0Package";r:58;s:25:"\0DUP_Database\0dbStorePath";N;s:23:"\0DUP_Database\0EOFMarker";s:0:"";s:26:"\0DUP_Database\0networkFlush";b:0;}}s:29:"\0DUP_Archive\0tmpFilterDirsAll";a:0:{}s:24:"\0DUP_Archive\0wpCorePaths";a:6:{i:0;s:35:"/home/agurainc/public_html/wp-admin";i:1;s:45:"/home/agurainc/public_html/wp-content/uploads";i:2;s:47:"/home/agurainc/public_html/wp-content/languages";i:3;s:45:"/home/agurainc/public_html/wp-content/plugins";i:4;s:44:"/home/agurainc/public_html/wp-content/themes";i:5;s:38:"/home/agurainc/public_html/wp-includes";}}s:9:"Installer";r:80;s:8:"Database";r:88;}', 'yes'),
 (1003, '_site_transient_backups_per_page', '20', 'no'),
 (1895, 'elementor_addon_widgets_logger_flag', 'no', 'yes'),
 (1969, '7238c9070c32ed98a38810e053129a9a', 'a:2:{s:7:"timeout";i:1531785105;s:5:"value";a:12:{s:11:"new_version";s:6:"2.0.16";s:14:"stable_version";s:6:"2.0.16";s:4:"name";s:13:"Elementor Pro";s:4:"slug";s:13:"elementor-pro";s:3:"url";s:36:"https://elementor.com/pro/changelog/";s:12:"last_updated";s:19:"2018-07-16 10:51:52";s:8:"homepage";s:26:"https://elementor.com/pro/";s:7:"package";s:200:"http://my.elementor.com/edd-sl/package_download/MTUzMTgyODMwNTpjNjZiZmQ4OTY0NWVhNWQyZjY4NWIwMTJiYzczYmY5YToxOjAyOTQzMmQxOGJlY2ZhYzU1MTI4NmM1MDE0ODUyOTM3Omh0dHBALy93d3cuYWd1cmFpbmMuY29tL3dvcmRwcmVzczow";s:13:"download_link";s:200:"http://my.elementor.com/edd-sl/package_download/MTUzMTgyODMwNTpjNjZiZmQ4OTY0NWVhNWQyZjY4NWIwMTJiYzczYmY5YToxOjAyOTQzMmQxOGJlY2ZhYzU1MTI4NmM1MDE0ODUyOTM3Omh0dHBALy93d3cuYWd1cmFpbmMuY29tL3dvcmRwcmVzczow";s:8:"sections";s:37805:"a:2:{s:11:"description";s:161:"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.";s:9:"changelog";s:37583:"<h4>2.0.16 - 2018-07-16</h4>\n<ul>\n<li>Tweak: CSS Filter Control module is now included in Elementor</li>\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0</code> (<a href="https://github.com/pojome/elementor/issues/5077">#5077</a>)</li>\n<li>Fix: Restore current query after get Global Widget data</li>\n<li>Fix: Add action item in History on unlink Global widget</li>\n</ul>\n<h4>2.0.15 - 2018-07-10</h4>\n<ul>\n<li>Fix: Dropdown menu items collapsing when activated (<a href="https://github.com/pojome/elementor/issues/4996">#4996</a>)</li>\n<li>Fix: GMT offset in Countdown widget (<a href="https://github.com/pojome/elementor/issues/4997">#4997</a>)</li>\n</ul>\n<h4>2.0.14 - 2018-07-08</h4>\n<ul>\n<li>Tweak: Added set method to form record for developers (<a href="https://github.com/pojome/elementor/issues/4983">#4983</a>)</li>\n<li>Fix: Autoplay option for Carousels</li>\n<li>Fix: Close mobile menu on item click in the Nav Menu widget</li>\n</ul>\n<h4>2.0.13 - 2018-07-03</h4>\n<ul>\n<li>Tweak: Added compatibility for Elementor v2.1</li>\n</ul>\n<h4>2.0.12 - 2018-07-02</h4>\n<ul>\n<li>Fix: Global widget PHP notices</li>\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs</li>\n<li>Fix: Form select field send all selected values on multiple selection</li>\n<li>Fix: Validate time field only if it\'s not empty</li>\n<li>Fix: ConvertKit API not saving name field</li>\n</ul>\n<h4>2.0.11 - 2018-06-12</h4>\n<ul>\n<li>Fix: Theme Builder <code>author</code> archive condition (<a href="https://github.com/pojome/elementor/issues/4593">#4593</a>)</li>\n<li>Fix: Respect password protected posts in Post Content widget</li>\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.</li>\n</ul>\n<h4>2.0.10 - 2018-06-05</h4>\n<ul>\n<li>Tweak: Added <code>elementor/theme/get_location_templates/template_id</code> filter hook for multi-language plugins</li>\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)</li>\n<li>Fix: Fields shortcode missing after removing a field in Form widget</li>\n<li>Deprecated: <code>get_theme_templates_by_location</code> is replaced by <code>get_location_templates</code></li>\n</ul>\n<h4>2.0.9 - 2018-05-28</h4>\n<ul>\n<li>Fix: Compatibility for PHP version 5.4</li>\n</ul>\n<h4>2.0.8 - 2018-05-28</h4>\n<ul>\n<li>Tweak: Added Active state for Nav Menu dropdown</li>\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget</li>\n<li>Tweak: Removed caption control in Site Logo widget</li>\n<li>Tweak: Added option to position currency symbol before/after In Price Table widget</li>\n<li>Fix: Query control manual selection does not show more than 10 items (<a href="https://github.com/pojome/elementor/issues/4479">#4479</a>)</li>\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href="https://github.com/pojome/elementor/issues/4342">#4342</a>)</li>\n<li>Fix: Sub terms missing in Query control in edge cases (<a href="https://github.com/pojome/elementor/issues/4527">#4527</a>)</li>\n<li>Fix: Avoid rendering a template if it\'s not published</li>\n<li>Fix: 404 Page style not working</li>\n<li>Fix: Price Table button with hover animation not working in editor</li>\n<li>Fix: Styling conflict in Call to Action widget</li>\n<li>Fix: Global Widget tab translation</li>\n<li>Fix: Adding parent wrapper class to Site Title widget</li>\n</ul>\n<h4>2.0.7 - 2018-05-16</h4>\n<ul>\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;</li>\n<li>Fix: Open 404 template library for 404 page</li>\n<li>Tweak: Added CSS prefix for dev files</li>\n<li>Tweak: Removed product post type from display conditions</li>\n</ul>\n<h4>2.0.6 - 2018-05-15</h4>\n<ul>\n<li>Tweak: Set type on create new single template</li>\n<li>Tweak: Always show the conditions dialog in the Draft status</li>\n<li>Tweak: Added document type <code>widget</code></li>\n<li>Tweak: Added Post Custom Field tag to URL category</li>\n<li>Fix: When ACF Field Groups are Empty (<a href="https://github.com/pojome/elementor/issues/4428">#4428</a>)</li>\n<li>Fix: Links inside carousel in edge cases</li>\n<li>Fix: Responsive issue in My Templates area</li>\n<li>Fix: Image alignment for post content with text alignment</li>\n<li>Fix: Post Content widget when preview post is missing</li>\n<li>Fix: Global Widget tab translation</li>\n<li>Fix: Style settings for Post / Archive Title widgets</li>\n</ul>\n<h4>2.0.5 - 2018-05-08</h4>\n<ul>\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href="https://github.com/pojome/elementor/issues/4203">#4203</a>)</li>\n<li>Fix: Added support for new version of reCAPTCHA</li>\n<li>Fix: Added fallback for controls after <code>post_status</code></li>\n<li>Fix: Required field in forms widget</li>\n<li>Fix: Media Carousel in the Coverflow skin</li>\n<li>Fix: 404 Page show wrong template in edge cases</li>\n<li>Fix: Save the default menu in the Nav Menu widget</li>\n</ul>\n<h4>2.0.4 - 2018-05-02</h4>\n<ul>\n<li>Tweak: Added parent\'s class for extended widgets</li>\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions</li>\n<li>Tweak: Initialize global model when it\'s needed</li>\n<li>Tweak: Removed some duplicate strings</li>\n<li>Tweak: Query control now includes empty terms</li>\n<li>Tweak: Design polish for conditions dialog</li>\n<li>Tweak: Decreasing <code>minimumInputLength</code> to 1 of select2</li>\n<li>Fix: Editor not loading for single templates in edge cases</li>\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href="https://github.com/pojome/elementor/issues/4310">#4310</a>)</li>\n<li>Fix: Slides per view not working for some effects</li>\n<li>Fix: New slides not showing in the editor</li>\n<li>Fix: Editor for section without a defined location, defaults to content area</li>\n</ul>\n<h4>2.0.3 - 2018-04-24</h4>\n<ul>\n<li>Tweak: Optimize CSS for Post Info widget (<a href="https://github.com/pojome/elementor/issues/4214">#4214</a>, <a href="https://github.com/pojome/elementor/issues/4216">#4216</a>, <a href="https://github.com/pojome/elementor/issues/4225">#4225</a>)</li>\n<li>Fix: Double render on frontend view in core locations</li>\n<li>Fix: Masonry not working in edge cases</li>\n<li>Fix: Added default setting for Author Info tag</li>\n</ul>\n<h4>2.0.2 - 2018-04-18</h4>\n<ul>\n<li>Fix: Regenerate conditions to include all templates</li>\n</ul>\n<h4>2.0.1 - 2018-04-17</h4>\n<ul>\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href="https://github.com/pojome/elementor/issues/4136">#4136</a>)</li>\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href="https://github.com/pojome/elementor/issues/4127">#4127</a>)</li>\n<li>Tweak: Added Divider control for Post Info widget</li>\n<li>Fix: Update admin links in Yoast Breadcrumbs widget</li>\n<li>Fix: Sticky element conflict with clearfix CSS</li>\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below</li>\n<li>Fix: Avoid running <code>wp_head</code> hooks twice</li>\n</ul>\n<h4>2.0.0 - 2018-04-16</h4>\n<ul>\n<li>New: Introducing Theme Builder - <a href="https://elementor.com/introducing-theme-builder/">Release Post</a> (<a href="https://github.com/pojome/elementor/issues/417">#417</a>)</li>\n<li>New: Introducing Locations API to inject custom location templates</li>\n<li>New: Introducing Display Conditions for all dynamic templates</li>\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design</li>\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href="https://github.com/pojome/elementor/issues/483">#483</a>, <a href="https://github.com/pojome/elementor/issues/653">#653</a>, <a href="https://github.com/pojome/elementor/issues/885">#885</a>)</li>\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href="https://github.com/pojome/elementor/issues/543">#543</a>)</li>\n<li>New: Introducing Developers area with guides and API documentation - <a href="https://elementor.com/introducing-elementor-developer-api/">Release Post</a> (<a href="https://github.com/pojome/elementor/issues/451">#451</a>)</li>\n<li>New: Introducing <a href="https://github.com/pojome/elementor-hello-theme">Elementor Hello Theme</a> - A demonstration theme for developers</li>\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href="https://github.com/pojome/elementor/issues/2761">#2761</a>, <a href="https://github.com/pojome/elementor/issues/2623">#2623</a>, <a href="https://github.com/pojome/elementor/issues/2109">#2109</a>, <a href="https://github.com/pojome/elementor/issues/2061">#2061</a>, <a href="https://github.com/pojome/elementor/issues/2439">#2439</a>)</li>\n<li>New: Design 404 page with Single template (<a href="https://github.com/pojome/elementor/issues/1558">#1558</a>)</li>\n<li>New: Design Search Results with Archive template (<a href="https://github.com/pojome/elementor/issues/3196">#3196</a>, <a href="https://github.com/pojome/elementor/issues/2590">#2590</a>)</li>\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element</em> per device (<a href="https://github.com/pojome/elementor/issues/2412">#2412</a>)</li>\n<li>New: Integration with Custom Fields (<a href="https://github.com/pojome/elementor/issues/2054">#2054</a>)</li>\n<li>New: Partial support for Toolset integration (<a href="https://github.com/pojome/elementor/issues/2949">#2949</a>)</li>\n<li>New: Partial support for Pods integration (<a href="https://github.com/pojome/elementor/issues/2169">#2169</a>)</li>\n<li>New: Partial support for ACF integration (<a href="https://github.com/pojome/elementor/issues/2041">#2041</a>, <a href="https://github.com/pojome/elementor/issues/2059">#2059</a>)</li>\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href="https://github.com/pojome/elementor/issues/3531">#3531</a>)</li>\n<li>Tweak: Allow brackets in Forms Tel field</li>\n<li>Tweak: Added currency format control for Price Table widget</li>\n<li>Tweak: Reduced API request for some servers</li>\n<li>Fix: Dropdown <code>border-radius</code> in Nav Menu widget</li>\n<li>Fix: Price List widget layout breaks in edge cases</li>\n<li>Note: This version requires Elementor v2.0.6</li>\n</ul>\n<h4>1.15.6 - 2018-03-28</h4>\n<ul>\n<li>Fix: Removed duplicate Custom CSS section (<a href="https://github.com/pojome/elementor/issues/3938">#3938</a>)</li>\n<li>Fix: <code>box-shadow</code> issue with cards skin (<a href="https://github.com/pojome/elementor/issues/3940">#3940</a>)</li>\n</ul>\n<h4>1.15.5 - 2018-03-27</h4>\n<ul>\n<li>Fix: Added global widget compatibility for Elementor v2.0</li>\n<li>Fix: Reduced API request for some servers</li>\n</ul>\n<h4>1.15.4 - 2018-03-26</h4>\n<ul>\n<li>Tweak: Allow brackets in phone field</li>\n<li>Tweak: Added compatibility with Yoast 7.0.+</li>\n<li>Tweak: Added compatibility for the future release of Elementor v2.0</li>\n<li>Fix: Support for multiple carousel setting in editor</li>\n<li>Fix: <code>on_export</code> issue in forms widget (<a href="https://github.com/pojome/elementor/issues/3890">#3890</a>)</li>\n</ul>\n<h4>1.15.3 - 2018-03-07</h4>\n<ul>\n<li>Tweak: Added unique class to field group div (<a href="https://github.com/pojome/elementor/issues/3595">#3595</a>)</li>\n<li>Fix: Screen Options missing when Pro is active (<a href="https://github.com/pojome/elementor/issues/3622">#3622</a>)</li>\n<li>Fix: Allow label styling even when <code>show labels</code> is set hide (<a href="https://github.com/pojome/elementor/issues/3544">#3544</a>)</li>\n<li>Fix: Typography control not working in edge cases</li>\n<li>Fix: Safari compatibility for Search widget</li>\n</ul>\n<h4>1.15.2 - 2018-02-27</h4>\n<ul>\n<li>Fix: Only add support mine-type if needed (<a href="https://github.com/pojome/elementor/issues/3543">#3543</a>)</li>\n<li>Fix: Better support for Old Typekit kits</li>\n</ul>\n<h4>1.15.1 - 2018-02-21</h4>\n<ul>\n<li>Tweak: Custom font title placeholder is not <code>enter font family</code></li>\n<li>Tweak: Custom font title set as required</li>\n<li>Fix: Custom font, <code>font-face</code> enqueued only once if used in global (<a href="https://github.com/pojome/elementor/issues/3513">#3513</a>)</li>\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.</li>\n</ul>\n<h4>1.15.0 - 2018-02-19</h4>\n<ul>\n<li>New: Added custom fonts manager for self hosted fonts (<a href="https://github.com/pojome/elementor/issues/852">#852</a>)</li>\n<li>New: Integration with Adobe TypeKit fonts (<a href="https://github.com/pojome/elementor/issues/631">#631</a>)</li>\n<li>Tweak: Clear menu from Nav Menu widget on template export</li>\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle</code></li>\n</ul>\n<h4>1.14.2 - 2018-02-13</h4>\n<ul>\n<li>Fix: Global widget content that got affected by previous update</li>\n</ul>\n<h4>1.14.1 - 2018-02-13</h4>\n<ul>\n<li>Tweak: Added <code>none</code> option to content animation in CTA widget</li>\n<li>Tweak: Added <code>form_id</code> to ActiveCampaign integration (<a href="https://github.com/pojome/elementor/issues/3422">#3422</a>)</li>\n<li>Fix: Page crashed when Global widget not found.</li>\n</ul>\n<h4>1.14.0 - 2018-02-12</h4>\n<ul>\n<li>New: Added Call to Action widget</li>\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded</li>\n<li>Tweak: Added compatibility for the future release of Elementor v2.0</li>\n<li>Fix: Allow zero (0) to be accepted as a field value</li>\n<li>Fix: Login form when custom login URL is set</li>\n<li>Fix: Added Day of cycle control to GetResponse integration</li>\n</ul>\n<h4>1.13.2 - 2018-01-23</h4>\n<ul>\n<li>Tweak: Added placeholder to Password field</li>\n<li>Tweak: Removed <code>subscriber_already_exists_message</code> control to prevent potential data leakage</li>\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet</li>\n<li>Fix: Changed <code>imagesLoaded()</code> to Vanilla JS to avoid compatibility issues with some themes</li>\n<li>Fix: Only validate Tel field if not empty</li>\n<li>Fix: Stop slider while editing</li>\n</ul>\n<h4>1.13.1 - 2018-01-16</h4>\n<ul>\n<li>Fix: Added compatibility with old PHP versions</li>\n</ul>\n<h4>1.13.0 - 2018-01-16</h4>\n<ul>\n<li>New: Added File Upload field for Forms widget (<a href="https://github.com/pojome/elementor/issues/1482">#1482</a>, <a href="https://github.com/pojome/elementor/issues/2974">#2974</a>)</li>\n<li>New: Added Acceptance field for Forms widget (<a href="https://github.com/pojome/elementor/issues/1693">#1693</a>, <a href="https://github.com/pojome/elementor/issues/2974">#2974</a>)</li>\n<li>New: Added Date field for Forms widget (<a href="https://github.com/pojome/elementor/issues/1868">#1868</a>)</li>\n<li>New: Added Time field for Forms widget</li>\n<li>New: Added Password field for Forms widget (<a href="https://github.com/pojome/elementor/issues/2164">#2164</a>)</li>\n<li>New: Added HTML field for Forms widget (<a href="https://github.com/pojome/elementor/issues/1500">#1500</a>)</li>\n<li>Tweak: Added characters validation for Tel field</li>\n<li>Tweak: Added min &amp; max validation for Number field</li>\n<li>Tweak: Added multiple selection for Select field</li>\n<li>Tweak: Added donReach integration for Share Buttons widget</li>\n</ul>\n<h4>1.12.3 - 2018-01-09</h4>\n<ul>\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget</li>\n<li>Fix: Apply <code>url-encoding</code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text</li>\n<li>Fix: Removed My Account link from dashboard widget</li>\n</ul>\n<h4>1.12.2 - 2018-01-03</h4>\n<ul>\n<li>Tweak: Added animation none for Nav Menu widget (<a href="https://github.com/pojome/elementor/issues/2964">#2964</a>)</li>\n<li>Fix: Active license button style</li>\n</ul>\n<h4>1.12.1 - 2018-01-02</h4>\n<ul>\n<li>Tweak: Removed theme-element widgets from plain content</li>\n<li>Tweak: Set all theme-element widgets to extend same widget Base</li>\n<li>Tweak: Removed credit URL in forms meta data</li>\n<li>Tweak: Added compatibility for the future release of Elementor v1.9</li>\n<li>Fix: Validate Get response Error as real error</li>\n<li>Fix: Removed responsive height control from Facebook Page widget</li>\n</ul>\n<h4>1.12.0 - 2017-12-20</h4>\n<ul>\n<li>New: Added Drip integration to Forms</li>\n<li>New: Added ActiveCampaign integration to Forms</li>\n<li>New: Added ConverKit integration to Forms</li>\n<li>New: Added GetResponse integration to Forms</li>\n<li>New: Added form <code>id</code>, <code>name</code> attributes to handle integration with auto collectors like HubSpot</li>\n<li>New: Added Global API key for MailChimp to improve the workflow</li>\n<li>Tweak: Better error handling and message display for Forms</li>\n<li>Fix: PHP notice Undefined variable <code>$cc_header</code> (<a href="https://github.com/pojome/elementor/issues/2934">#2934</a>)</li>\n</ul>\n<h4>1.11.0 - 2017-12-11</h4>\n<ul>\n<li>New: Added a native Comments widget (<a href="https://github.com/pojome/elementor/issues/543">#543</a>)</li>\n<li>New: Added an Author Box widget</li>\n<li>New: Added a Post Navigation widget</li>\n<li>New: Added a Yoast Breadcrumbs widget (<a href="https://github.com/pojome/elementor/issues/2749">#2749</a>)</li>\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href="https://github.com/pojome/elementor/issues/2762">#2762</a>)</li>\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric</li>\n<li>Fix: Edge cases when the nav menu is empty in a stretched section</li>\n<li>Fix: Added fallback when you remove the <code>space-between</code> on Swiper carousel</li>\n</ul>\n<h4>1.10.2 - 2017-12-03</h4>\n<ul>\n<li>Fix: Missing save widget icon (<a href="https://github.com/pojome/elementor/issues/2878">#2878</a>)</li>\n<li>Fix: Global widgets not saving edits (<a href="https://github.com/pojome/elementor/issues/2874">#2874</a>)</li>\n<li>Fix: Removed <code>white-space: nowrap;</code> property from vertical menu in Nav Menu widget (<a href="https://github.com/pojome/elementor/issues/2815">#2815</a>)</li>\n</ul>\n<h4>1.10.1 - 2017-11-30</h4>\n<ul>\n<li>Tweak: Added default value for search form</li>\n<li>Tweak: Order template list A-Z in the library widget</li>\n<li>Tweak: get_users/authors query is now done using AJAX only, for better performance in Query Control (<a href="https://github.com/pojome/elementor/issues/2865">#2865</a>)</li>\n<li>Fix: When adding <code>.00</code> it is not displayed on the front</li>\n<li>Fix: Make sure space between is numeric for carousel control</li>\n<li>Fix: Added space for radio &amp; checkbox fields in form widget</li>\n</ul>\n<h4>1.10.0 - 2017-11-15</h4>\n<ul>\n<li>New: Added native Search form widget (<a href="https://github.com/pojome/elementor/issues/2576">#2576</a>)</li>\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets</li>\n<li>Tweak: Added Inline editing to Blockquote widget</li>\n<li>Fix: Animated Headline color bug (<a href="https://github.com/pojome/elementor/issues/2516">#2516</a>)</li>\n<li>Fix: Animated Headline with Rotating skin</li>\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations</li>\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href="https://github.com/pojome/elementor/issues/2662">#2662</a>)</li>\n<li>Fix: Custom CSS gone after reloading the editor</li>\n</ul>\n<h4>1.9.5 - 2017-10-27</h4>\n<ul>\n<li>Fix: Broken Global widget with JS (<a href="https://github.com/pojome/elementor/issues/2639">#2639</a>)</li>\n</ul>\n<h4>1.9.4 - 2017-10-24</h4>\n<ul>\n<li>Tweak: Improved UI for notices and license page</li>\n<li>Fix: Update system conflict with other EDD plugins</li>\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href="https://github.com/pojome/elementor/issues/2577">#2577</a>)</li>\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href="https://github.com/pojome/elementor/issues/2496">#2496</a>)</li>\n<li>Fix: Increased submenu max-width (<a href="https://github.com/pojome/elementor/issues/2558">#2558</a>)</li>\n<li>Fix: Save global templates without their defaults</li>\n<li>Fix: Horizontal scrolling issue with posts grid</li>\n</ul>\n<h4>1.9.3 - 2017-10-03</h4>\n<ul>\n<li>Fix: Condition slide style that got affected by previous update</li>\n</ul>\n<h4>1.9.2 - 2017-10-02</h4>\n<ul>\n<li>New: Added integration with MailPoet 3 for Forms actions</li>\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode</li>\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel</li>\n<li>Fix: Added condition for slides style section in skin bubble mode</li>\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel</li>\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows</li>\n</ul>\n<h4>1.9.1 - 2017-09-28</h4>\n<ul>\n<li>Fix: Slides per view for slideshow carousel</li>\n<li>Fix: Final polish for the new Testimonial Carousel widget</li>\n<li>Fix: Don\'t play video if slide type is not video</li>\n<li>Fix: Removed slides style section condition (<a href="https://github.com/pojome/elementor/issues/2497">#2497</a>)</li>\n<li>Fix: Set cursor as pointer for slideshow thumbnails</li>\n</ul>\n<h4>1.9.0 - 2017-09-26</h4>\n<ul>\n<li>New: Added Media Carousel widget (<a href="https://github.com/pojome/elementor/issues/216">#216</a>, <a href="https://github.com/pojome/elementor/issues/347">#347</a>, <a href="https://github.com/pojome/elementor/issues/2209">#2209</a>)</li>\n<li>New: Added Testimonial Carousel widget (<a href="https://github.com/pojome/elementor/issues/715">#715</a>)</li>\n</ul>\n<h4>1.8.3 - 2017-09-24</h4>\n<ul>\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6</li>\n<li>Fix: Remove slashes from Form sent data</li>\n</ul>\n<h4>1.8.2 - 2017-09-19</h4>\n<ul>\n<li>Tweak: Added target URL for the tweet message in Blockquote widget</li>\n<li>Tweak: Render the slide height before the slider is finished loading</li>\n<li>Fix: Space between words for Animated Headline widget</li>\n<li>Fix: RTL compatibility for Animated Headline widget</li>\n<li>Fix: Italic font style for Animated Headline widget</li>\n<li>Fix: Excluded Menu widget from the WP Editor text rendering</li>\n</ul>\n<h4>1.8.1 - 2017-09-18</h4>\n<ul>\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href="https://github.com/pojome/elementor/issues/2391">#2391</a>)</li>\n<li>Fix: Print the main menu only when is necessary in Menu widget</li>\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href="https://github.com/pojome/elementor/issues/2381">#2381</a>)</li>\n</ul>\n<h4>1.8.0 - 2017-09-12</h4>\n<ul>\n<li>New: Added Nav Menu widget (<a href="https://github.com/pojome/elementor/issues/1406">#1406</a>)</li>\n<li>Fix: Field ID for checkbox control in Form widget (<a href="https://github.com/pojome/elementor/issues/2279">#2279</a>)</li>\n<li>Fix: Style for Blockquote widget included</li>\n</ul>\n<h4>1.7.2 - 2017-09-07</h4>\n<ul>\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins</li>\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href="https://github.com/pojome/elementor/issues/2340">#2340</a>)</li>\n</ul>\n<h4>1.7.1 - 2017-09-05</h4>\n<ul>\n<li>Fix: Facebook SDK version</li>\n</ul>\n<h4>1.7.0 - 2017-09-05</h4>\n<ul>\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow</li>\n<li>New: Added Facebook Embed widget for Post, Video and Comment</li>\n<li>New: Added Facebook Comments widget</li>\n<li>New: Added Facebook Page widget (Previously known as Like Box)</li>\n<li>New: Added Blockquote widget with Tweet button</li>\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets</li>\n<li>Fix: Animated headline rotating with long words</li>\n</ul>\n<h4>1.6.1 - 2017-08-28</h4>\n<ul>\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set</li>\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser</li>\n<li>Fix: Animated headline with more than 1-word per rotation</li>\n<li>Fix: Animated Headline in two lines</li>\n<li>Fix: Some errors in Global widget</li>\n</ul>\n<h4>1.6.0 - 2017-08-22</h4>\n<ul>\n<li>New: Added Animated Headline widget</li>\n<li>New: Added Hidden field for Forms widget (<a href="https://github.com/pojome/elementor/issues/2038">#2038</a>)</li>\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher</li>\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts</li>\n</ul>\n<h4>1.5.9 - 2017-08-16</h4>\n<ul>\n<li>Tweak: Added compatibility for the future release of Elementor v1.7</li>\n<li>Fix: Portfolio compatibility for GeneratePress theme</li>\n<li>Fix: Portfolio filter compatibility for RTL</li>\n<li>Fix: Pagination apply for all posts widget in the page</li>\n<li>Fix: Global form widget with MailChimp integration not saving</li>\n</ul>\n<h4>1.5.8 - 2017-07-25</h4>\n<ul>\n<li>Tweak: Added compatibility for the future release of Elementor v1.6</li>\n<li>Fix: Improved backward compatibility for query control rename</li>\n</ul>\n<h4>1.5.7 - 2017-07-24</h4>\n<ul>\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file</li>\n<li>Tweak: Display the label in the reCAPTCHA field for better experience</li>\n<li>Tweak: Rename <code>panel-posts-control</code> to <code>query-control</code> and added fallback support</li>\n<li>Tweak: Added compatibility for the future release of Elementor with history feature</li>\n<li>Fix: reCAPTCHA preview on the editor</li>\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href="https://github.com/pojome/elementor/issues/2000">#2000</a>)</li>\n<li>Fix: Added condition for icon size control in Share Buttons widget</li>\n</ul>\n<h4>1.5.6 - 2017-07-12</h4>\n<ul>\n<li>Fix: Query Control correction for taxonomies (<a href="https://github.com/pojome/elementor/issues/1963">#1963</a>)</li>\n<li>Fix: Custom CSS override scheme color in the editor</li>\n<li>Fix: Added order by Menu Order for Query Control in WC widget</li>\n<li>Fix: Glitch with Flip Box background overlay</li>\n</ul>\n<h4>1.5.5 - 2017-07-03</h4>\n<ul>\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist</li>\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999</li>\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed</li>\n<li>Fix: Sorted items in filter bar by A-Z</li>\n<li>Fix: Editor glitch with Elementor v1.5 (<a href="https://github.com/pojome/elementor/issues/1927">#1927</a>)</li>\n</ul>\n<h4>1.5.4 - 2017-06-22</h4>\n<ul>\n<li>Tweak: Improved compatibility for Elementor v1.5</li>\n<li>Fix: URL default for Add To Cart widget</li>\n<li>Fix: Allowed <code>date</code> and <code>birthday</code> fields as text for MailChimp integration</li>\n</ul>\n<h4>1.5.3 - 2017-06-19</h4>\n<ul>\n<li>Tweak: Make flip-box height responsive control</li>\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href="https://github.com/pojome/elementor/issues/1829">#1829</a>)</li>\n<li>Fix: Global form widget with MailChimp integration not saving</li>\n</ul>\n<h4>1.5.2 - 2017-06-13</h4>\n<ul>\n<li>Fix: Custom CSS panel location compatibility for the old versions</li>\n</ul>\n<h4>1.5.1 - 2017-06-12</h4>\n<ul>\n<li>Fix: MailChimp update existing user registration</li>\n<li>Fix: Global widget with JS in the editor mode</li>\n<li>Fix: Label section condition in Login widget</li>\n<li>Fix: Changes to unlinked global widget do not appear in the editor</li>\n</ul>\n<h4>1.5.0 - 2017-05-23</h4>\n<ul>\n<li>New: Added Cards, a new skin for Posts widget</li>\n<li>New: Added Exclude option to post query control group</li>\n<li>Tweak: Added <code>post_class()</code> for each post in the loop</li>\n<li>Tweak: Added <code>.elementor-posts-masonry</code> class when Masonry layout is enabled</li>\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0</li>\n<li>Tweak: CSS <code>autoprefixer</code> now supports last 5 versions of browsers</li>\n<li>Tweak: Added <code>imageLoaded</code> library for Posts &amp; Portfolio widgets</li>\n</ul>\n<h4>1.4.4 - 2017-05-18</h4>\n<ul>\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href="https://github.com/pojome/elementor/issues/1683">#1683</a>)</li>\n<li>Fix: Added <code>.elementor-form</code> class to Login form to fix style glitch</li>\n</ul>\n<h4>1.4.3 - 2017-05-14</h4>\n<ul>\n<li>Tweak: Added Redirect After Login option to Login widget</li>\n<li>Tweak: Stay in the current page after logout in Login widget</li>\n<li>Tweak: Preparation for Elementor settings tabs in future version</li>\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone</li>\n<li>Fix: Bug with <code>active</code> class in portfolio filter item</li>\n<li>Fix: Higher specific list-style-type <code>none</code> for filter items to override some theme style</li>\n</ul>\n<h4>1.4.2 - 2017-05-06</h4>\n<ul>\n<li>Fix: Temporary patch for form field shortcode in some servers</li>\n</ul>\n<h4>1.4.1 - 2017-05-03</h4>\n<ul>\n<li>Fix: Bug with custom success message in form widget</li>\n<li>Fix: Bug with meta data in email action</li>\n</ul>\n<h4>1.4.0 - 2017-05-03</h4>\n<ul>\n<li>New: Forms: integration with MailChimp</li>\n<li>New: Forms: integration with MailPoet</li>\n<li>New: Forms: Added Email 2 action for email confirmation</li>\n<li>New: Forms: Added shortcodes for fields</li>\n<li>New: Forms: Added custom ID for fields</li>\n<li>New: Forms: Added option to edit email HTML template (<a href="https://github.com/pojome/elementor/issues/1180">#1180</a>)</li>\n<li>New: Added Login widget</li>\n<li>Tweak: Move <code>send_html</code> control to <code>email_content_type</code></li>\n<li>Fix: Email still sent even if validation failed in form widget</li>\n</ul>\n<h4>1.3.2 - 2017-05-01</h4>\n<ul>\n<li>New: Added action <code>elementor_pro/init</code> for better integration with Elementor Pro</li>\n<li>Fix: Posts without featured image in Posts widget (<a href="https://github.com/pojome/elementor/issues/1234">#1234</a>, <a href="https://github.com/pojome/elementor/issues/1382">#1382</a>)</li>\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method</li>\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser</li>\n<li>Fix: Border radius glitch on hover in Share Buttons</li>\n</ul>\n<h4>1.3.1 - 2017-04-25</h4>\n<ul>\n<li>Fix: Conflict update with revision history module</li>\n</ul>\n<h4>1.3.0 - 2017-04-25</h4>\n<ul>\n<li>New: Added Share Buttons widget (<a href="https://wordpress.org/support/topic/social-sharing-buttons-is-it-possible/">Topic</a>)</li>\n<li>New: Added Custom CSS for Page Settings</li>\n<li>New: Added Masonry layout for Portfolio widget</li>\n<li>New: Added Cc &amp; Bcc options to email action (<a href="https://github.com/pojome/elementor/issues/1181">#1181</a>)</li>\n<li>New: Introduced <code>ElementorPro\\Modules\\Forms\\Classes\\Action_Base</code> class for better 3rd party integration for forms</li>\n<li>Tweak: Debugger module now also shows errors from Pro</li>\n<li>Tweak: Added options for Elementor Library</li>\n<li>Tweak: New base posts module for optimized performance</li>\n<li>Tweak: Adjusting Posts / Portfolio to the new structure</li>\n<li>Fix: Export for posts / portfolio</li>\n<li>Fix: Duplicate repeater field with switcher control (<a href="https://github.com/pojome/elementor/issues/1442">#1442</a>)</li>\n<li>Fix: Post per Page in the query control</li>\n<li>Fix: Metadata does not come through on form emails (<a href="https://github.com/pojome/elementor/issues/1566">#1566</a>)</li>\n</ul>\n<h4>1.2.6 - 2017-04-19</h4>\n<ul>\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets</li>\n</ul>\n<h4>1.2.5 - 2017-04-18</h4>\n<ul>\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)</li>\n</ul>\n<h4>1.2.4 - 2017-03-21</h4>\n<ul>\n<li>Tweak: Added Indian Rupee sign to Price Table widget</li>\n<li>Fix: Portfolio grid for IE11</li>\n<li>Fix: Link target blank in Price List widget</li>\n<li>Fix: Active item for filter bar in Portfolio widget</li>\n</ul>\n<h4>1.2.3 - 2017-03-06</h4>\n<ul>\n<li>Tweak: Fully compatible with Elementor v1.3.0</li>\n<li>Tweak: Added trigger for after form submission in Forms widget</li>\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms</li>\n<li>Fix: Portfolio filter syntax in Non-Latin languages</li>\n<li>Fix: Added <code>no-repeat</code> property for slide with <code>background-size:contain</code></li>\n<li>Fix: Condition control &amp; Import value in Posts widgets</li>\n<li>Fix: Offset and Pagination in WordPress (<a href="https://codex.wordpress.org/Making_Custom_Queries_using_Offset_and_Pagination">More Info</a>)</li>\n<li>Fix: Submit handler bubbling for custom events in Forms widget</li>\n</ul>\n<h4>1.2.2 - 2017-02-23</h4>\n<ul>\n<li>Tweak: Change name from Side A/B to Front and Back in Flip Box widget</li>\n<li>Fix: Error when saving third party widgets in the global widget</li>\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)</li>\n<li>Fix: Hide the pagination when there are no links</li>\n</ul>\n<h4>1.2.1 - 2017-02-21</h4>\n<ul>\n<li>Fix: Firefox Flip Box 3D compatibility</li>\n</ul>\n<h4>1.2.0 - 2017-02-21</h4>\n<ul>\n<li>New: Added Flip Box widget</li>\n<li>New: Added Ken Burns effect for slides</li>\n<li>New: Added Masonry layout for Posts widget</li>\n<li>New: Added Pagination option for Posts widget</li>\n<li>Tweak: Added background size contain to slides</li>\n<li>Tweak: Improve Query control by preload items</li>\n<li>Fix: Text color for Checkbox and Radio fields</li>\n</ul>\n<h4>1.1.2 - 2017-02-05</h4>\n<ul>\n<li>Tweak: Added <code>aria-required</code> for better accessibility in forms widget</li>\n<li>Fix: Conflict Call to <code>undefined</code> method in Posts &amp; Portfolio widgets (<a href="https://github.com/pojome/elementor/issues/1271">#1271</a>, <a href="https://github.com/pojome/elementor/issues/1266">#1266</a>)</li>\n<li>Fix: Submit button HTML after error sending</li>\n<li>Fix: Success message for <code>skip_email</code> function</li>\n<li>Notice: Elementor 1.2.0 or later now required</li>\n</ul>\n<h4>1.1.1 - 2017-01-24</h4>\n<ul>\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG</code> is <code>true</code></li>\n<li>Fix: Undefined variable in WC widgets</li>\n<li>Fix: Removed duplicate strings</li>\n</ul>\n<h4>1.1.0 - 2017-01-24</h4>\n<ul>\n<li>New: Price Table widget (<a href="https://github.com/pojome/elementor/issues/102">#102</a>)</li>\n<li>New: WooCommerce Add to Cart widget</li>\n<li>New: WooCommerce Categories widget</li>\n<li>New: WooCommerce Elements widget</li>\n<li>New: Honeypot field for Forms widgets</li>\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items</li>\n<li>Tweak: Added Required Mark for fields in Forms widget</li>\n<li>Fix: CSS selectors priority in Slides widget</li>\n<li>Fix: CSS bug in Price List widget</li>\n<li>Fix: Update all Post CSS files that includes specific Global Widget</li>\n</ul>\n<h4>1.0.9 - 2017-01-18</h4>\n<ul>\n<li>Fix: Auto complete bug in query controls</li>\n<li>Fix: Render template with escaping slashes</li>\n<li>Fix: Reply-to field in Forms widget</li>\n</ul>\n<h4>1.0.8 - 2017-01-11</h4>\n<ul>\n<li>Tweak: Code adjustments for Elementor API</li>\n<li>Fix: Removed go pro link from plugins page in admin</li>\n</ul>\n<h4>1.0.7 - 2017-01-05</h4>\n<ul>\n<li>Tweak: Added filter by featured / sale for WC Products widget</li>\n<li>Tweak: Added author control in Portfolio widget</li>\n<li>Tweak: Code adjustments for Elementor API</li>\n<li>Fix: Added support for empty image ratio</li>\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself</li>\n</ul>\n<h4>1.0.6 - 2017-01-01</h4>\n<ul>\n<li>Tweak: Added Auto-updates for local translation files</li>\n<li>Fix: Custom CSS for Global widgets</li>\n<li>Fix: Remove <code>nonce</code> field (Fix some cache plugins)</li>\n</ul>\n<h4>1.0.5 - 2016-12-27</h4>\n<ul>\n<li>Fix: Slide element bug fix - \'Link apply on\' logic</li>\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href="https://github.com/pojome/elementor/issues/1086">#1086</a>)</li>\n</ul>\n<h4>1.0.4 - 2016-12-21</h4>\n<ul>\n<li>Tweak: Mobile Editing for fields in the form widget</li>\n<li>Tweak: Mobile Editing for posts</li>\n<li>Tweak: Allow send form as HTML</li>\n<li>Tweak: Improved auto upgrades for Multisite installation</li>\n<li>Tweak: Improve editor rendering experience for Portfolio widget</li>\n<li>Fix: Posts widget check if image exist</li>\n<li>Fix: Changed the clone method for global widget (<a href="https://github.com/pojome/elementor/issues/1042">#1042</a>)</li>\n<li>Fix: Bug slides in RTL (removed direction control)</li>\n<li>Fix: Slides with no height jumps when changing slides</li>\n</ul>\n<h4>1.0.3 - 2016-12-13</h4>\n<ul>\n<li>Fix: Added escape placeholder for HTML Entities in form widget</li>\n<li>Fix: Countdown widget RTL bug</li>\n<li>Fix: Remove redundant #elementor selector for control style</li>\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget</li>\n</ul>\n<h4>1.0.2 - 2016-12-12</h4>\n<ul>\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form</li>\n</ul>\n<h4>1.0.1 - 2016-12-12</h4>\n<ul>\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active</li>\n</ul>\n<h4>1.0.0 - 2016-12-12</h4>\n<ul>\n<li>Initial release</li>\n</ul>";}";s:7:"banners";s:41:"a:2:{s:4:"high";s:0:"";s:3:"low";s:0:"";}";s:5:"icons";a:1:{s:3:"svg";s:42:"https://ps.w.org/elementor/assets/icon.svg";}}}', 'no'),
 (1942, 'EWD_UFAQ_Highlight_Search_Term', 'No', 'yes'),
 (1943, 'FAQ_Auto_Complete_Titles', 'Yes', 'yes'),
 (1925, '_transient_timeout_elementor_addon_widgets_123versions', '1534333769', 'no'),
 (1926, '_transient_elementor_addon_widgets_123versions', 'a:15:{i:0;a:2:{s:7:"version";s:5:"1.0.2";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.0.2.zip";}i:1;a:2:{s:7:"version";s:5:"1.0.3";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.0.3.zip";}i:2;a:2:{s:7:"version";s:5:"1.0.4";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.0.4.zip";}i:3;a:2:{s:7:"version";s:5:"1.1.0";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.0.zip";}i:4;a:2:{s:7:"version";s:5:"1.1.1";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.1.zip";}i:5;a:2:{s:7:"version";s:5:"1.1.2";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.2.zip";}i:6;a:2:{s:7:"version";s:5:"1.1.3";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.3.zip";}i:7;a:2:{s:7:"version";s:5:"1.1.4";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.4.zip";}i:8;a:2:{s:7:"version";s:5:"1.1.5";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.5.zip";}i:9;a:2:{s:7:"version";s:5:"1.1.6";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.6.zip";}i:10;a:2:{s:7:"version";s:5:"1.1.7";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.1.7.zip";}i:11;a:2:{s:7:"version";s:5:"1.2.0";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.2.0.zip";}i:12;a:2:{s:7:"version";s:5:"1.2.1";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.2.1.zip";}i:13;a:2:{s:7:"version";s:5:"1.2.2";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.2.2.zip";}i:14;a:2:{s:7:"version";s:5:"1.2.3";s:3:"url";s:72:"https://downloads.wordpress.org/plugin/elementor-addon-widgets.1.2.3.zip";}}', 'no'),
 (1914, 'elementor_upgrades', 'a:1:{s:5:"2.1.0";b:1;}', 'yes'),
 (1973, '_elementor_global_css', 'a:4:{s:4:"time";i:1531742076;s:5:"fonts";a:3:{i:0;s:10:"Montserrat";i:1;s:6:"Roboto";i:12;s:11:"Roboto Slab";}s:6:"status";s:4:"file";i:0;b:0;}', 'yes'),
 (1039, 'active_plugins', 'a:31:{i:0;s:70:"addon-elements-for-elementor-page-builder/elementor-addon-elements.php";i:2;s:51:"all-in-one-wp-migration/all-in-one-wp-migration.php";i:3;s:23:"backup-wd/backup-wd.php";i:4;s:36:"contact-form-7/wp-contact-form-7.php";i:5;s:33:"duplicate-post/duplicate-post.php";i:6;s:25:"duplicator/duplicator.php";i:7;s:51:"elementor-addon-widgets/elementor-addon-widgets.php";i:8;s:31:"elementor-pro/elementor-pro.php";i:9;s:23:"elementor/elementor.php";i:10;s:65:"essential-addons-for-elementor-lite/essential_adons_elementor.php";i:11;s:60:"extended-buttons-for-elementor/elementor-button-extended.php";i:12;s:17:"faq-wd/faq_wd.php";i:13;s:21:"flamingo/flamingo.php";i:14;s:53:"flexible-elementor-panel/flexible-elementor-panel.php";i:15;s:27:"icon-widget/icon-widget.php";i:16;s:29:"jet-elements/jet-elements.php";i:17;s:43:"modal-for-elementor/modal-for-elementor.php";i:18;s:45:"ocean-custom-sidebar/ocean-custom-sidebar.php";i:19;s:51:"ocean-elementor-widgets/ocean-elementor-widgets.php";i:20;s:27:"ocean-extra/ocean-extra.php";i:21;s:45:"ocean-footer-callout/ocean-footer-callout.php";i:22;s:43:"ocean-sticky-header/ocean-sticky-header.php";i:23;s:33:"rotatingtweets/rotatingtweets.php";i:24;s:23:"simple-qa/qa-plugin.php";i:25;s:18:"spider-faq/faq.php";i:26;s:27:"svg-support/svg-support.php";i:27;s:41:"twitter-cards-meta/twitter-cards-meta.php";i:28;s:22:"ultimate-faqs/Main.php";i:29;s:51:"widgetkit-for-elementor/widgetkit-for-elementor.php";i:30;s:41:"wp-google-maps-pro/wp-google-maps-pro.php";i:31;s:23:"wp-rocket/wp-rocket.php";}', 'yes'),
 (1040, 'template', 'oceanwp', 'yes'),
 (1041, 'stylesheet', 'oceanwp-child-theme-master', 'yes'),
 (1042, 'ai1wm_status', 'a:3:{s:4:"type";s:4:"done";s:5:"title";s:41:"Your data has been imported successfully!";s:7:"message";s:531:"You need to perform two more steps:<br /><strong>1. You must save your permalinks structure twice. <a class="ai1wm-no-underline" href="http://www.agurainc.com/wordpress/wp-admin/options-permalink.php#submit" target="_blank">Permalinks Settings</a></strong> <small>(opens a new window)</small><br /><strong>2. <a class="ai1wm-no-underline" href="https://wordpress.org/support/view/plugin-reviews/all-in-one-wp-migration?rate=5#postform" target="_blank">Optionally, review the plugin</a>.</strong> <small>(opens a new window)</small>";}', 'yes'),
 (1051, 'jet-elements-db-version', '1.10.0', 'yes'),
 (1088, '_site_transient_timeout_community-events-e32ef9791b6f042961592702a5d7eeb0', '1529682453', 'no'),
 (1108, 'themeisle_sdk_active_notification', 'a:2:{s:3:"key";s:52:"elementor_addon_widgetsThemeIsle_SDK_Feedback_Review";s:4:"time";i:1531741829;}', 'yes');


DROP TABLE IF EXISTS `wp_post_right_content`;
CREATE TABLE `wp_post_right_content` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `like` int(11) NOT NULL,
  `unlike` int(11) NOT NULL,
  `hits` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_postmeta`;
CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6874 DEFAULT CHARSET=utf8;

 
INSERT INTO `wp_postmeta` VALUES (36, 17, '_email', 'admin@tyco.co.il'),
 (37, 17, '_name', 'ba6YKlmcFA'),
 (38, 17, '_props', 'a:2:{s:10:"first_name";s:0:"";s:9:"last_name";s:0:"";}'),
 (39, 17, '_last_contacted', '2018-05-16 07:05:19'),
 (40, 18, '_email', 'wapuu@wordpress.example'),
 (41, 18, '_name', 'A WordPress Commenter'),
 (42, 18, '_props', 'a:0:{}'),
 (43, 18, '_last_contacted', '2018-05-16 07:05:19'),
 (46, 20, '_form', '<label> Your Name (required)\n    [text* your-name] </label>\n\n<label> Your Email (required)\n    [email* your-email] </label>\n\n<label> Subject\n    [text your-subject] </label>\n\n<label> Your Message\n    [textarea your-message] </label>\n\n[submit "Send"]'),
 (47, 20, '_mail', 'a:8:{s:7:"subject";s:37:"My WordPress Website "[your-subject]"";s:6:"sender";s:40:"[your-name] <wordpress@www.agurainc.com>";s:4:"body";s:192:"From: [your-name] <[your-email]>\nSubject: [your-subject]\n\nMessage Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on My WordPress Website (http://www.agurainc.com/wordpress)";s:9:"recipient";s:16:"admin@tyco.co.il";s:18:"additional_headers";s:22:"Reply-To: [your-email]";s:11:"attachments";s:0:"";s:8:"use_html";i:0;s:13:"exclude_blank";i:0;}'),
 (48, 20, '_mail_2', 'a:9:{s:6:"active";b:0;s:7:"subject";s:37:"My WordPress Website "[your-subject]"";s:6:"sender";s:49:"My WordPress Website <wordpress@www.agurainc.com>";s:4:"body";s:134:"Message Body:\n[your-message]\n\n-- \nThis e-mail was sent from a contact form on My WordPress Website (http://www.agurainc.com/wordpress)";s:9:"recipient";s:12:"[your-email]";s:18:"additional_headers";s:26:"Reply-To: admin@tyco.co.il";s:11:"attachments";s:0:"";s:8:"use_html";i:0;s:13:"exclude_blank";i:0;}'),
 (49, 20, '_messages', 'a:8:{s:12:"mail_sent_ok";s:45:"Thank you for your message. It has been sent.";s:12:"mail_sent_ng";s:71:"There was an error trying to send your message. Please try again later.";s:16:"validation_error";s:61:"One or more fields have an error. Please check and try again.";s:4:"spam";s:71:"There was an error trying to send your message. Please try again later.";s:12:"accept_terms";s:69:"You must accept the terms and conditions before sending your message.";s:16:"invalid_required";s:22:"The field is required.";s:16:"invalid_too_long";s:22:"The field is too long.";s:17:"invalid_too_short";s:23:"The field is too short.";}'),
 (50, 20, '_additional_settings', NULL),
 (51, 20, '_locale', 'en_US'),
 (54, 22, '_edit_last', '2'),
 (55, 22, '_edit_lock', '1533220361:2'),
 (56, 22, '_wp_page_template', 'default'),
 (57, 22, 'inline_featured_image', '0'),
 (58, 22, 'ocean_post_layout', 'full-screen'),
 (59, 22, 'ocean_sidebar', '0'),
 (60, 22, 'ocean_second_sidebar', '0'),
 (61, 22, 'ocean_disable_margins', 'on'),
 (62, 22, 'ocean_display_top_bar', 'default'),
 (63, 22, 'ocean_display_header', 'default'),
 (64, 22, 'ocean_center_header_left_menu', '0'),
 (65, 22, 'ocean_custom_header_template', '0'),
 (66, 22, 'ocean_header_custom_menu', '0'),
 (67, 22, 'ocean_disable_title', 'on'),
 (68, 22, 'ocean_disable_heading', 'default'),
 (69, 22, 'ocean_disable_breadcrumbs', 'off'),
 (70, 22, 'ocean_display_footer_widgets', 'off'),
 (71, 22, 'ocean_display_footer_bottom', 'off'),
 (77, 22, '_elementor_edit_mode', 'builder'),
 (88, 31, 'inline_featured_image', '0'),
 (89, 31, '_edit_last', '1'),
 (90, 31, '_edit_lock', '1526458211:1'),
 (91, 31, '_wp_page_template', 'default'),
 (92, 31, 'ocean_post_layout', 'full-screen'),
 (93, 31, 'ocean_sidebar', '0'),
 (94, 31, 'ocean_second_sidebar', '0'),
 (95, 31, 'ocean_disable_margins', 'enable'),
 (96, 31, 'ocean_display_top_bar', 'off'),
 (97, 31, 'ocean_display_header', 'off'),
 (98, 31, 'ocean_center_header_left_menu', '0'),
 (99, 31, 'ocean_custom_header_template', '0'),
 (100, 31, 'ocean_header_custom_menu', '0'),
 (101, 31, 'ocean_disable_title', 'on'),
 (102, 31, 'ocean_disable_heading', 'default'),
 (103, 31, 'ocean_disable_breadcrumbs', 'off'),
 (104, 31, 'ocean_display_footer_widgets', 'off'),
 (105, 31, 'ocean_display_footer_bottom', 'off'),
 (106, 31, 'ofc_meta_disable_footer_callout', 'on'),
 (107, 31, '_elementor_edit_mode', 'builder'),
 (114, 35, '_email', 'tal@tyco.co.il'),
 (115, 35, '_name', 'tyco'),
 (116, 35, '_props', 'a:2:{s:10:"first_name";s:0:"";s:9:"last_name";s:0:"";}'),
 (117, 35, '_last_contacted', '2018-06-18 07:10:44'),
 (6858, 51, '_elementor_css', 'a:4:{s:4:"time";i:1532399819;s:5:"fonts";a:0:{}s:6:"status";s:4:"file";i:0;s:0:"";}'),
 (122, 38, '_wp_attached_file', '2018/06/logo@3x.png'),
 (123, 38, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:587;s:6:"height";i:150;s:4:"file";s:19:"2018/06/logo@3x.png";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:19:"logo@3x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:18:"logo@3x-300x77.png";s:5:"width";i:300;s:6:"height";i:77;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (124, 39, '_wp_attached_file', '2018/06/cropped-logo@3x.png'),
 (125, 39, '_wp_attachment_context', 'site-icon'),
 (126, 39, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:512;s:6:"height";i:512;s:4:"file";s:27:"2018/06/cropped-logo@3x.png";s:5:"sizes";a:6:{s:9:"thumbnail";a:4:{s:4:"file";s:27:"cropped-logo@3x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:27:"cropped-logo@3x-300x300.png";s:5:"width";i:300;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:13:"site_icon-270";a:4:{s:4:"file";s:27:"cropped-logo@3x-270x270.png";s:5:"width";i:270;s:6:"height";i:270;s:9:"mime-type";s:9:"image/png";}s:13:"site_icon-192";a:4:{s:4:"file";s:27:"cropped-logo@3x-192x192.png";s:5:"width";i:192;s:6:"height";i:192;s:9:"mime-type";s:9:"image/png";}s:13:"site_icon-180";a:4:{s:4:"file";s:27:"cropped-logo@3x-180x180.png";s:5:"width";i:180;s:6:"height";i:180;s:9:"mime-type";s:9:"image/png";}s:12:"site_icon-32";a:4:{s:4:"file";s:25:"cropped-logo@3x-32x32.png";s:5:"width";i:32;s:6:"height";i:32;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (136, 22, 'ocean_menu_typo_font_family', '0'),
 (137, 22, 'ofc_meta_disable_footer_callout', 'on'),
 (138, 43, 'inline_featured_image', '0'),
 (139, 43, '_wp_page_template', 'default'),
 (140, 43, 'inline_featured_image', '0'),
 (141, 43, 'ocean_post_layout', 'full-screen'),
 (142, 43, 'ocean_sidebar', '0'),
 (143, 43, 'ocean_second_sidebar', '0'),
 (144, 43, 'ocean_disable_margins', 'on'),
 (145, 43, 'ocean_display_top_bar', 'default'),
 (146, 43, 'ocean_display_header', 'default'),
 (147, 43, 'ocean_center_header_left_menu', '0'),
 (148, 43, 'ocean_custom_header_template', '0'),
 (149, 43, 'ocean_header_custom_menu', '0'),
 (150, 43, 'ocean_disable_title', 'on'),
 (151, 43, 'ocean_disable_heading', 'default'),
 (152, 43, 'ocean_disable_breadcrumbs', 'off'),
 (153, 43, 'ocean_display_footer_widgets', 'off'),
 (154, 43, 'ocean_display_footer_bottom', 'off'),
 (155, 43, '_elementor_edit_mode', 'builder'),
 (157, 43, 'ocean_menu_typo_font_family', '0'),
 (158, 43, 'ofc_meta_disable_footer_callout', 'on'),
 (159, 43, '_dp_original', '22'),
 (160, 44, 'inline_featured_image', '0'),
 (161, 44, '_wp_page_template', 'default'),
 (162, 44, 'inline_featured_image', '0'),
 (163, 44, 'ocean_post_layout', 'full-screen'),
 (164, 44, 'ocean_sidebar', '0'),
 (165, 44, 'ocean_second_sidebar', '0'),
 (166, 44, 'ocean_disable_margins', 'on'),
 (167, 44, 'ocean_display_top_bar', 'off'),
 (168, 44, 'ocean_display_header', 'default'),
 (169, 44, 'ocean_center_header_left_menu', '0'),
 (170, 44, 'ocean_custom_header_template', '0'),
 (171, 44, 'ocean_header_custom_menu', '0'),
 (172, 44, 'ocean_disable_title', 'on'),
 (173, 44, 'ocean_disable_heading', 'default'),
 (174, 44, 'ocean_disable_breadcrumbs', 'off'),
 (175, 44, 'ocean_display_footer_widgets', 'off'),
 (176, 44, 'ocean_display_footer_bottom', 'off'),
 (177, 44, '_elementor_edit_mode', 'builder'),
 (179, 44, 'ocean_menu_typo_font_family', '0'),
 (180, 44, 'ofc_meta_disable_footer_callout', 'on'),
 (181, 44, '_dp_original', '22'),
 (182, 43, '_edit_lock', '1531838823:2'),
 (183, 45, 'inline_featured_image', '0'),
 (184, 45, '_wp_page_template', 'default'),
 (185, 45, 'inline_featured_image', '0'),
 (186, 45, 'ocean_post_layout', 'full-screen'),
 (187, 45, 'ocean_sidebar', '0'),
 (188, 45, 'ocean_second_sidebar', '0'),
 (189, 45, 'ocean_disable_margins', 'on'),
 (190, 45, 'ocean_display_top_bar', 'off'),
 (191, 45, 'ocean_display_header', 'default'),
 (192, 45, 'ocean_center_header_left_menu', '0'),
 (193, 45, 'ocean_custom_header_template', '0'),
 (194, 45, 'ocean_header_custom_menu', '0'),
 (195, 45, 'ocean_disable_title', 'on'),
 (196, 45, 'ocean_disable_heading', 'default'),
 (197, 45, 'ocean_disable_breadcrumbs', 'off'),
 (198, 45, 'ocean_display_footer_widgets', 'off'),
 (199, 45, 'ocean_display_footer_bottom', 'off'),
 (200, 45, '_elementor_edit_mode', 'builder'),
 (202, 45, 'ocean_menu_typo_font_family', '0'),
 (203, 45, 'ofc_meta_disable_footer_callout', 'on'),
 (204, 45, '_dp_original', '22'),
 (205, 44, '_edit_lock', '1531837081:2'),
 (206, 46, 'inline_featured_image', '0'),
 (207, 46, '_wp_page_template', 'default'),
 (208, 46, 'inline_featured_image', '0'),
 (209, 46, 'ocean_post_layout', 'full-screen'),
 (210, 46, 'ocean_sidebar', '0'),
 (211, 46, 'ocean_second_sidebar', '0'),
 (212, 46, 'ocean_disable_margins', 'on'),
 (213, 46, 'ocean_display_top_bar', 'off'),
 (214, 46, 'ocean_display_header', 'default'),
 (215, 46, 'ocean_center_header_left_menu', '0'),
 (216, 46, 'ocean_custom_header_template', '0'),
 (217, 46, 'ocean_header_custom_menu', '0'),
 (218, 46, 'ocean_disable_title', 'on'),
 (219, 46, 'ocean_disable_heading', 'default'),
 (220, 46, 'ocean_disable_breadcrumbs', 'off'),
 (221, 46, 'ocean_display_footer_widgets', 'off'),
 (222, 46, 'ocean_display_footer_bottom', 'off'),
 (223, 46, '_elementor_edit_mode', 'builder'),
 (225, 46, 'ocean_menu_typo_font_family', '0'),
 (226, 46, 'ofc_meta_disable_footer_callout', 'on'),
 (227, 46, '_dp_original', '22'),
 (228, 45, '_edit_lock', '1529508981:2'),
 (229, 47, 'inline_featured_image', '0'),
 (230, 47, '_wp_page_template', 'default'),
 (231, 47, 'inline_featured_image', '0'),
 (232, 47, 'ocean_post_layout', 'full-screen'),
 (233, 47, 'ocean_sidebar', '0'),
 (234, 47, 'ocean_second_sidebar', '0'),
 (235, 47, 'ocean_disable_margins', 'on'),
 (236, 47, 'ocean_display_top_bar', 'off'),
 (237, 47, 'ocean_display_header', 'default'),
 (238, 47, 'ocean_center_header_left_menu', '0'),
 (239, 47, 'ocean_custom_header_template', '0'),
 (240, 47, 'ocean_header_custom_menu', '0'),
 (241, 47, 'ocean_disable_title', 'on'),
 (242, 47, 'ocean_disable_heading', 'default'),
 (243, 47, 'ocean_disable_breadcrumbs', 'off'),
 (244, 47, 'ocean_display_footer_widgets', 'off'),
 (245, 47, 'ocean_display_footer_bottom', 'off'),
 (246, 47, '_elementor_edit_mode', 'builder'),
 (248, 47, 'ocean_menu_typo_font_family', '0'),
 (249, 47, 'ofc_meta_disable_footer_callout', 'on'),
 (250, 47, '_dp_original', '22'),
 (251, 46, '_edit_lock', '1529509091:2'),
 (252, 47, '_edit_lock', '1529829764:2'),
 (253, 48, 'inline_featured_image', '0'),
 (254, 48, '_wp_page_template', 'default'),
 (255, 48, 'inline_featured_image', '0'),
 (256, 48, 'ocean_post_layout', 'full-screen'),
 (257, 48, 'ocean_sidebar', '0'),
 (258, 48, 'ocean_second_sidebar', '0'),
 (259, 48, 'ocean_disable_margins', 'on'),
 (260, 48, 'ocean_display_top_bar', 'off'),
 (261, 48, 'ocean_display_header', 'default'),
 (262, 48, 'ocean_center_header_left_menu', '0'),
 (263, 48, 'ocean_custom_header_template', '0'),
 (264, 48, 'ocean_header_custom_menu', '0'),
 (265, 48, 'ocean_disable_title', 'on'),
 (266, 48, 'ocean_disable_heading', 'default'),
 (267, 48, 'ocean_disable_breadcrumbs', 'off'),
 (268, 48, 'ocean_display_footer_widgets', 'off'),
 (269, 48, 'ocean_display_footer_bottom', 'off'),
 (270, 48, '_elementor_edit_mode', 'builder'),
 (272, 48, 'ocean_menu_typo_font_family', '0'),
 (273, 48, 'ofc_meta_disable_footer_callout', 'on'),
 (274, 48, '_dp_original', '22'),
 (275, 43, '_edit_last', '2'),
 (276, 48, '_edit_lock', '1529506910:2'),
 (277, 49, 'inline_featured_image', '0'),
 (278, 49, '_wp_page_template', 'default'),
 (279, 49, 'inline_featured_image', '0'),
 (280, 49, 'ocean_post_layout', 'full-screen'),
 (281, 49, 'ocean_sidebar', '0'),
 (282, 49, 'ocean_second_sidebar', '0'),
 (283, 49, 'ocean_disable_margins', 'on'),
 (284, 49, 'ocean_display_top_bar', 'off'),
 (285, 49, 'ocean_display_header', 'default'),
 (286, 49, 'ocean_center_header_left_menu', '0'),
 (287, 49, 'ocean_custom_header_template', '0'),
 (288, 49, 'ocean_header_custom_menu', '0'),
 (289, 49, 'ocean_disable_title', 'on'),
 (290, 49, 'ocean_disable_heading', 'default'),
 (291, 49, 'ocean_disable_breadcrumbs', 'off'),
 (292, 49, 'ocean_display_footer_widgets', 'off'),
 (293, 49, 'ocean_display_footer_bottom', 'off'),
 (294, 49, '_elementor_edit_mode', 'builder'),
 (296, 49, 'ocean_menu_typo_font_family', '0'),
 (297, 49, 'ofc_meta_disable_footer_callout', 'on'),
 (298, 49, '_dp_original', '22'),
 (299, 49, '_edit_lock', '1531838824:2'),
 (300, 50, 'inline_featured_image', '0'),
 (301, 50, '_wp_page_template', 'default'),
 (302, 50, 'inline_featured_image', '0'),
 (303, 50, 'ocean_post_layout', 'full-screen'),
 (304, 50, 'ocean_sidebar', '0'),
 (305, 50, 'ocean_second_sidebar', '0'),
 (306, 50, 'ocean_disable_margins', 'on'),
 (307, 50, 'ocean_display_top_bar', 'off'),
 (308, 50, 'ocean_display_header', 'default'),
 (309, 50, 'ocean_center_header_left_menu', '0'),
 (310, 50, 'ocean_custom_header_template', '0'),
 (311, 50, 'ocean_header_custom_menu', '0'),
 (312, 50, 'ocean_disable_title', 'on'),
 (313, 50, 'ocean_disable_heading', 'default'),
 (314, 50, 'ocean_disable_breadcrumbs', 'off'),
 (315, 50, 'ocean_display_footer_widgets', 'off'),
 (316, 50, 'ocean_display_footer_bottom', 'off'),
 (317, 50, '_elementor_edit_mode', 'builder'),
 (319, 50, 'ocean_menu_typo_font_family', '0'),
 (320, 50, 'ofc_meta_disable_footer_callout', 'on'),
 (321, 50, '_dp_original', '22'),
 (322, 51, 'inline_featured_image', '0'),
 (323, 51, '_wp_page_template', 'default'),
 (324, 51, 'inline_featured_image', '0'),
 (325, 51, 'ocean_post_layout', 'full-screen'),
 (326, 51, 'ocean_sidebar', '0'),
 (327, 51, 'ocean_second_sidebar', '0'),
 (328, 51, 'ocean_disable_margins', 'on'),
 (329, 51, 'ocean_display_top_bar', 'off'),
 (330, 51, 'ocean_display_header', 'default'),
 (331, 51, 'ocean_center_header_left_menu', '0'),
 (332, 51, 'ocean_custom_header_template', '0'),
 (333, 51, 'ocean_header_custom_menu', '0'),
 (334, 51, 'ocean_disable_title', 'on'),
 (335, 51, 'ocean_disable_heading', 'default'),
 (336, 51, 'ocean_disable_breadcrumbs', 'off'),
 (337, 51, 'ocean_display_footer_widgets', 'off'),
 (338, 51, 'ocean_display_footer_bottom', 'off'),
 (339, 51, '_elementor_edit_mode', 'builder'),
 (341, 51, 'ocean_menu_typo_font_family', '0'),
 (342, 51, 'ofc_meta_disable_footer_callout', 'on'),
 (343, 51, '_dp_original', '22'),
 (344, 52, '_wp_page_template', 'default'),
 (345, 52, '_elementor_edit_mode', 'builder'),
 (347, 50, '_edit_lock', '1529847630:2'),
 (348, 53, 'inline_featured_image', '0'),
 (349, 53, '_wp_page_template', 'default'),
 (350, 53, 'inline_featured_image', '0'),
 (351, 53, 'ocean_post_layout', 'full-screen'),
 (352, 53, 'ocean_sidebar', '0'),
 (353, 53, 'ocean_second_sidebar', '0'),
 (354, 53, 'ocean_disable_margins', 'on'),
 (355, 53, 'ocean_display_top_bar', 'off'),
 (356, 53, 'ocean_display_header', 'default'),
 (357, 53, 'ocean_center_header_left_menu', '0'),
 (358, 53, 'ocean_custom_header_template', '0'),
 (359, 53, 'ocean_header_custom_menu', '0'),
 (360, 53, 'ocean_disable_title', 'on'),
 (361, 53, 'ocean_disable_heading', 'default'),
 (362, 53, 'ocean_disable_breadcrumbs', 'off'),
 (363, 53, 'ocean_display_footer_widgets', 'off'),
 (364, 53, 'ocean_display_footer_bottom', 'off'),
 (365, 53, '_elementor_edit_mode', 'builder'),
 (367, 53, 'ocean_menu_typo_font_family', '0'),
 (368, 53, 'ofc_meta_disable_footer_callout', 'on'),
 (369, 53, '_dp_original', '22'),
 (370, 51, '_edit_lock', '1531837425:2'),
 (371, 54, 'inline_featured_image', '0'),
 (372, 54, '_wp_page_template', 'default'),
 (373, 54, 'inline_featured_image', '0'),
 (374, 54, 'ocean_post_layout', 'full-screen'),
 (375, 54, 'ocean_sidebar', '0'),
 (376, 54, 'ocean_second_sidebar', '0'),
 (377, 54, 'ocean_disable_margins', 'on'),
 (378, 54, 'ocean_display_top_bar', 'off'),
 (379, 54, 'ocean_display_header', 'default'),
 (380, 54, 'ocean_center_header_left_menu', '0'),
 (381, 54, 'ocean_custom_header_template', '0'),
 (382, 54, 'ocean_header_custom_menu', '0'),
 (383, 54, 'ocean_disable_title', 'on'),
 (384, 54, 'ocean_disable_heading', 'default'),
 (385, 54, 'ocean_disable_breadcrumbs', 'off'),
 (386, 54, 'ocean_display_footer_widgets', 'off'),
 (387, 54, 'ocean_display_footer_bottom', 'off'),
 (388, 54, '_elementor_edit_mode', 'builder'),
 (390, 54, 'ocean_menu_typo_font_family', '0'),
 (391, 54, 'ofc_meta_disable_footer_callout', 'on'),
 (392, 54, '_dp_original', '22'),
 (393, 53, '_edit_lock', '1531837425:2'),
 (394, 55, 'inline_featured_image', '0'),
 (395, 55, '_wp_page_template', 'default'),
 (396, 55, 'inline_featured_image', '0'),
 (397, 55, 'ocean_post_layout', 'full-screen'),
 (398, 55, 'ocean_sidebar', '0'),
 (399, 55, 'ocean_second_sidebar', '0'),
 (400, 55, 'ocean_disable_margins', 'on'),
 (401, 55, 'ocean_display_top_bar', 'off'),
 (402, 55, 'ocean_display_header', 'default'),
 (403, 55, 'ocean_center_header_left_menu', '0'),
 (404, 55, 'ocean_custom_header_template', '0'),
 (405, 55, 'ocean_header_custom_menu', '0'),
 (406, 55, 'ocean_disable_title', 'on'),
 (407, 55, 'ocean_disable_heading', 'default'),
 (408, 55, 'ocean_disable_breadcrumbs', 'off'),
 (409, 55, 'ocean_display_footer_widgets', 'off'),
 (410, 55, 'ocean_display_footer_bottom', 'off'),
 (411, 55, '_elementor_edit_mode', 'builder'),
 (413, 55, 'ocean_menu_typo_font_family', '0'),
 (414, 55, 'ofc_meta_disable_footer_callout', 'on'),
 (415, 55, '_dp_original', '22'),
 (416, 56, 'inline_featured_image', '0'),
 (417, 56, '_wp_page_template', 'default'),
 (418, 56, 'inline_featured_image', '0'),
 (419, 56, 'ocean_post_layout', 'full-screen'),
 (420, 56, 'ocean_sidebar', '0'),
 (421, 56, 'ocean_second_sidebar', '0'),
 (422, 56, 'ocean_disable_margins', 'on'),
 (423, 56, 'ocean_display_top_bar', 'off'),
 (424, 56, 'ocean_display_header', 'default'),
 (425, 56, 'ocean_center_header_left_menu', '0'),
 (426, 56, 'ocean_custom_header_template', '0'),
 (427, 56, 'ocean_header_custom_menu', '0'),
 (428, 56, 'ocean_disable_title', 'on'),
 (429, 56, 'ocean_disable_heading', 'default'),
 (430, 56, 'ocean_disable_breadcrumbs', 'off'),
 (431, 56, 'ocean_display_footer_widgets', 'off'),
 (432, 56, 'ocean_display_footer_bottom', 'off'),
 (433, 56, '_elementor_edit_mode', 'builder'),
 (435, 56, 'ocean_menu_typo_font_family', '0'),
 (436, 56, 'ofc_meta_disable_footer_callout', 'on'),
 (437, 56, '_dp_original', '22'),
 (438, 57, 'inline_featured_image', '0'),
 (439, 57, '_wp_page_template', 'default'),
 (440, 57, 'inline_featured_image', '0'),
 (441, 57, 'ocean_post_layout', 'full-screen'),
 (442, 57, 'ocean_sidebar', '0'),
 (443, 57, 'ocean_second_sidebar', '0'),
 (444, 57, 'ocean_disable_margins', 'on'),
 (445, 57, 'ocean_display_top_bar', 'off'),
 (446, 57, 'ocean_display_header', 'default'),
 (447, 57, 'ocean_center_header_left_menu', '0'),
 (448, 57, 'ocean_custom_header_template', '0'),
 (449, 57, 'ocean_header_custom_menu', '0'),
 (450, 57, 'ocean_disable_title', 'on'),
 (451, 57, 'ocean_disable_heading', 'default'),
 (452, 57, 'ocean_disable_breadcrumbs', 'off'),
 (453, 57, 'ocean_display_footer_widgets', 'off'),
 (454, 57, 'ocean_display_footer_bottom', 'off'),
 (455, 57, '_elementor_edit_mode', 'builder'),
 (457, 57, 'ocean_menu_typo_font_family', '0'),
 (458, 57, 'ofc_meta_disable_footer_callout', 'on'),
 (459, 57, '_dp_original', '22'),
 (460, 58, 'inline_featured_image', '0'),
 (461, 58, '_wp_page_template', 'default'),
 (462, 58, 'inline_featured_image', '0'),
 (463, 58, 'ocean_post_layout', 'full-screen'),
 (464, 58, 'ocean_sidebar', '0'),
 (465, 58, 'ocean_second_sidebar', '0'),
 (466, 58, 'ocean_disable_margins', 'on'),
 (467, 58, 'ocean_display_top_bar', 'off'),
 (468, 58, 'ocean_display_header', 'default'),
 (469, 58, 'ocean_center_header_left_menu', '0'),
 (470, 58, 'ocean_custom_header_template', '0'),
 (471, 58, 'ocean_header_custom_menu', '0'),
 (472, 58, 'ocean_disable_title', 'on'),
 (473, 58, 'ocean_disable_heading', 'default'),
 (474, 58, 'ocean_disable_breadcrumbs', 'off'),
 (475, 58, 'ocean_display_footer_widgets', 'off'),
 (476, 58, 'ocean_display_footer_bottom', 'off'),
 (477, 58, '_elementor_edit_mode', 'builder'),
 (479, 58, 'ocean_menu_typo_font_family', '0'),
 (480, 58, 'ofc_meta_disable_footer_callout', 'on'),
 (481, 58, '_dp_original', '22'),
 (482, 59, 'inline_featured_image', '0'),
 (483, 59, '_wp_page_template', 'default'),
 (484, 59, 'inline_featured_image', '0'),
 (485, 59, 'ocean_post_layout', 'full-screen'),
 (486, 59, 'ocean_sidebar', '0'),
 (487, 59, 'ocean_second_sidebar', '0'),
 (488, 59, 'ocean_disable_margins', 'on'),
 (489, 59, 'ocean_display_top_bar', 'off'),
 (490, 59, 'ocean_display_header', 'default'),
 (491, 59, 'ocean_center_header_left_menu', '0'),
 (492, 59, 'ocean_custom_header_template', '0'),
 (493, 59, 'ocean_header_custom_menu', '0'),
 (494, 59, 'ocean_disable_title', 'on'),
 (495, 59, 'ocean_disable_heading', 'default'),
 (496, 59, 'ocean_disable_breadcrumbs', 'off'),
 (497, 59, 'ocean_display_footer_widgets', 'off'),
 (498, 59, 'ocean_display_footer_bottom', 'off'),
 (499, 59, '_elementor_edit_mode', 'builder'),
 (501, 59, 'ocean_menu_typo_font_family', '0'),
 (502, 59, 'ofc_meta_disable_footer_callout', 'on'),
 (503, 59, '_dp_original', '22'),
 (504, 54, '_edit_lock', '1529506987:2'),
 (505, 55, '_edit_lock', '1531837427:2'),
 (506, 56, '_edit_lock', '1532833575:2'),
 (507, 44, '_edit_last', '2'),
 (508, 60, '_wp_page_template', 'default'),
 (509, 60, '_elementor_edit_mode', 'builder'),
 (511, 58, '_edit_lock', '1531837423:2'),
 (512, 59, '_edit_lock', '1530417996:2'),
 (513, 57, '_edit_lock', '1529507000:2'),
 (514, 45, '_edit_last', '2'),
 (515, 61, '_wp_page_template', 'default'),
 (516, 61, '_elementor_edit_mode', 'builder'),
 (518, 46, '_edit_last', '2'),
 (519, 62, '_wp_page_template', 'default'),
 (520, 62, '_elementor_edit_mode', 'builder'),
 (522, 47, '_edit_last', '2'),
 (523, 63, '_wp_page_template', 'default'),
 (524, 63, '_elementor_edit_mode', 'builder'),
 (526, 48, '_edit_last', '2'),
 (527, 64, '_wp_page_template', 'default'),
 (528, 64, '_elementor_edit_mode', 'builder'),
 (530, 49, '_edit_last', '2'),
 (531, 65, '_wp_page_template', 'default'),
 (532, 65, '_elementor_edit_mode', 'builder'),
 (534, 50, '_edit_last', '2'),
 (535, 66, '_wp_page_template', 'default'),
 (536, 66, '_elementor_edit_mode', 'builder'),
 (538, 51, '_edit_last', '2'),
 (539, 67, '_wp_page_template', 'default'),
 (540, 67, '_elementor_edit_mode', 'builder'),
 (542, 53, '_edit_last', '2'),
 (543, 68, '_wp_page_template', 'default'),
 (544, 68, '_elementor_edit_mode', 'builder'),
 (546, 54, '_edit_last', '2'),
 (547, 69, '_wp_page_template', 'default'),
 (548, 69, '_elementor_edit_mode', 'builder'),
 (550, 57, '_edit_last', '2'),
 (551, 70, '_wp_page_template', 'default'),
 (552, 70, '_elementor_edit_mode', 'builder'),
 (554, 55, '_edit_last', '2'),
 (555, 71, '_wp_page_template', 'default'),
 (556, 71, '_elementor_edit_mode', 'builder'),
 (558, 58, '_edit_last', '2'),
 (559, 72, '_wp_page_template', 'default'),
 (560, 72, '_elementor_edit_mode', 'builder'),
 (562, 56, '_edit_last', '2'),
 (563, 73, '_wp_page_template', 'default'),
 (564, 73, '_elementor_edit_mode', 'builder'),
 (566, 59, '_edit_last', '2'),
 (567, 74, '_wp_page_template', 'default'),
 (568, 74, '_elementor_edit_mode', 'builder'),
 (589, 77, '_menu_item_type', 'post_type'),
 (590, 77, '_menu_item_menu_item_parent', '928'),
 (591, 77, '_menu_item_object_id', '59'),
 (592, 77, '_menu_item_object', 'page'),
 (593, 77, '_menu_item_target', ''),
 (594, 77, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (595, 77, '_menu_item_xfn', ''),
 (596, 77, '_menu_item_url', ''),
 (597, 77, '_menu_item_template', ''),
 (598, 77, '_menu_item_mega_template', '0'),
 (599, 77, '_menu_item_nolink', ''),
 (600, 77, '_menu_item_category_post', ''),
 (601, 77, '_menu_item_megamenu', ''),
 (602, 77, '_menu_item_megamenu_auto_width', ''),
 (603, 77, '_menu_item_megamenu_col', ''),
 (604, 77, '_menu_item_megamenu_heading', ''),
 (605, 77, '_menu_item_megamenu_widgetarea', '0'),
 (606, 77, '_menu_item_icon', ''),
 (607, 78, '_menu_item_type', 'post_type'),
 (608, 78, '_menu_item_menu_item_parent', '1039'),
 (609, 78, '_menu_item_object_id', '56'),
 (610, 78, '_menu_item_object', 'page'),
 (611, 78, '_menu_item_target', ''),
 (612, 78, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (613, 78, '_menu_item_xfn', ''),
 (614, 78, '_menu_item_url', ''),
 (615, 78, '_menu_item_template', ''),
 (616, 78, '_menu_item_mega_template', '0'),
 (617, 78, '_menu_item_nolink', ''),
 (618, 78, '_menu_item_category_post', ''),
 (619, 78, '_menu_item_megamenu', ''),
 (620, 78, '_menu_item_megamenu_auto_width', ''),
 (621, 78, '_menu_item_megamenu_col', ''),
 (622, 78, '_menu_item_megamenu_heading', ''),
 (623, 78, '_menu_item_megamenu_widgetarea', '0'),
 (624, 78, '_menu_item_icon', ''),
 (625, 79, '_menu_item_type', 'post_type'),
 (626, 79, '_menu_item_menu_item_parent', '1039'),
 (627, 79, '_menu_item_object_id', '58'),
 (628, 79, '_menu_item_object', 'page'),
 (629, 79, '_menu_item_target', ''),
 (630, 79, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (631, 79, '_menu_item_xfn', ''),
 (632, 79, '_menu_item_url', ''),
 (633, 79, '_menu_item_template', ''),
 (634, 79, '_menu_item_mega_template', '0'),
 (635, 79, '_menu_item_nolink', ''),
 (636, 79, '_menu_item_category_post', ''),
 (637, 79, '_menu_item_megamenu', ''),
 (638, 79, '_menu_item_megamenu_auto_width', ''),
 (639, 79, '_menu_item_megamenu_col', ''),
 (640, 79, '_menu_item_megamenu_heading', ''),
 (641, 79, '_menu_item_megamenu_widgetarea', '0'),
 (642, 79, '_menu_item_icon', ''),
 (643, 80, '_menu_item_type', 'post_type'),
 (644, 80, '_menu_item_menu_item_parent', '1039'),
 (645, 80, '_menu_item_object_id', '55'),
 (646, 80, '_menu_item_object', 'page'),
 (647, 80, '_menu_item_target', ''),
 (648, 80, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (649, 80, '_menu_item_xfn', ''),
 (650, 80, '_menu_item_url', ''),
 (651, 80, '_menu_item_template', ''),
 (652, 80, '_menu_item_mega_template', '0'),
 (653, 80, '_menu_item_nolink', ''),
 (654, 80, '_menu_item_category_post', ''),
 (655, 80, '_menu_item_megamenu', ''),
 (656, 80, '_menu_item_megamenu_auto_width', ''),
 (657, 80, '_menu_item_megamenu_col', ''),
 (658, 80, '_menu_item_megamenu_heading', ''),
 (659, 80, '_menu_item_megamenu_widgetarea', '0'),
 (660, 80, '_menu_item_icon', ''),
 (5420, 920, '_elementor_data', '[{"id":"bd5bec4","elType":"section","settings":{"content_position":"middle","background_background":"classic","background_color":"#2e3233","margin":{"unit":"px","top":"","right":0,"bottom":"","left":0,"isLinked":true},"padding":{"unit":"px","top":"23","right":"0","bottom":"21","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"50","right":"20","bottom":"20","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"15","bottom":"20","left":"15","isLinked":false},"background_gradient_angle":{"unit":"deg","size":360},"border_width":{"unit":"px","top":"10","right":"0","bottom":"0","left":"0","isLinked":false},"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"9b28989","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"7ab9a430","elType":"column","settings":{"_column_size":100,"_inline_size":null,"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_mobile":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"5ab994f7","elType":"section","settings":{"structure":"40","content_width":{"unit":"px","size":1088},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"db671c2","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"697cfd85","elType":"column","settings":{"_column_size":25,"_inline_size":19.669,"_inline_size_tablet":33,"_inline_size_mobile":100,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"6a81d6b3","elType":"widget","settings":{"title":"Products & Services","title_color":"#fffcfc","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"600","typography_text_transform":"none","header_size":"h4"},"elements":[],"widgetType":"heading"},{"id":"4e41efd6","elType":"widget","settings":{"icon_list":[{"text":"- Security","icon":"","_id":"a3a66d7","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/security\\/","is_external":"on","nofollow":""}},{"text":"- Wallets","icon":"","_id":"7c66e1f","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wallets\\/","is_external":"on","nofollow":""}},{"text":"- Custom Software","icon":"","_id":"9827a56","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/custom-software\\/","is_external":"on","nofollow":""}},{"text":"- Coins & Tokens","icon":"","_id":"b89f0ea","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/coins-and-tokens\\/","is_external":"on","nofollow":""}},{"text":"- Currency Custodian","icon":"","_id":"f8cf142","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/currency-custodian\\/","is_external":"on","nofollow":""}},{"text":"- White Label Exchange","icon":"","_id":"582ed3a","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/white-label-exchange\\/","is_external":"on","nofollow":""}},{"text":"- Hosting","icon":"","_id":"6bb7b1b","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/hosting\\/","is_external":"on","nofollow":""}}],"space_between":{"unit":"px","size":2},"icon_size":{"unit":"px","size":6},"text_color":"#ffffff","text_indent":{"unit":"px","size":0},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14},"icon_typography_font_weight":"300","icon_typography_font_size_tablet":{"unit":"px","size":13},"icon_typography_text_transform":"none"},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"175779a0","elType":"column","settings":{"_column_size":25,"_inline_size":20.331,"_inline_size_tablet":33,"_inline_size_mobile":100,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"24394dcc","elType":"widget","settings":{"title":"Help","title_color":"#fffcfc","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"600","typography_text_transform":"none","header_size":"h4"},"elements":[],"widgetType":"heading"},{"id":"64dd4e57","elType":"widget","settings":{"icon_list":[{"text":"- Q&A","icon":"","_id":"a3a66d7","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/qa\\/","is_external":"on","nofollow":""}}],"space_between":{"unit":"px","size":2},"icon_size":{"unit":"px","size":6},"text_color":"#ffffff","text_indent":{"unit":"px","size":0},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14},"icon_typography_font_weight":"300","icon_typography_font_size_tablet":{"unit":"px","size":13}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"29711022","elType":"column","settings":{"_column_size":25,"_inline_size":20.037,"_inline_size_tablet":33,"_inline_size_mobile":100,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"15","isLinked":false}},"elements":[{"id":"66a32571","elType":"widget","settings":{"title":"More info","title_color":"#fffcfc","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"600","typography_text_transform":"none","header_size":"h4"},"elements":[],"widgetType":"heading"},{"id":"1bb6821c","elType":"widget","settings":{"icon_list":[{"text":"- About","icon":"","_id":"a3a66d7","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/about\\/","is_external":"on","nofollow":""}},{"text":"- Our vision & Strengths","icon":"","_id":"7c66e1f","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/our-vision-strengths\\/","is_external":"on","nofollow":""}},{"text":"- News","icon":"","_id":"db2aada","link":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/news\\/","is_external":"on","nofollow":""}}],"space_between":{"unit":"px","size":2},"icon_size":{"unit":"px","size":6},"text_color":"#ffffff","text_indent":{"unit":"px","size":0},"icon_typography_typography":"custom","icon_typography_font_size":{"unit":"px","size":14},"icon_typography_font_weight":"300","icon_typography_font_size_tablet":{"unit":"px","size":13}},"elements":[],"widgetType":"icon-list"}],"isInner":true},{"id":"3e2889b0","elType":"column","settings":{"_column_size":25,"_inline_size":39.963,"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"%","top":"0","right":"20","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"10","left":"15","isLinked":false},"_inline_size_mobile":100},"elements":[{"id":"18f603d","elType":"widget","settings":{"title":"Newsletter","title_color":"#fffcfc","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"600","typography_text_transform":"none","header_size":"h4","align_tablet":"center","align_mobile":"left"},"elements":[],"widgetType":"heading"},{"id":"29e7f4ea","elType":"widget","settings":{"editor":"<p>Subscribe to our newsletter and always be the<br \\/>first to find out about our latest product releases<br \\/>and updates.<\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","align_tablet":"center","align_mobile":"left"},"elements":[],"widgetType":"text-editor"},{"id":"443fcbd8","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"_id":"email","field_type":"email","required":"true","field_label":"Email","placeholder":"Your email address here","width":"66","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"60","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""}],"show_labels":"","button_text":"Subscribe","button_width":"33","email_content":"[all-fields]","email_content_2":"[all-fields]","success_message":"The form was sent successfully!","error_message":"Please fill in the required fields.","required_field_message":"Required","invalid_message":"There\'s something wrong. The form is invalid.","column_gap":{"unit":"px","size":0},"row_gap":{"unit":"px","size":0},"label_color":"#ffffff","label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":12},"field_text_color":"#a2a2a2","field_typography_typography":"custom","field_typography_font_size":{"unit":"px","size":14},"field_typography_font_weight":"300","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"field_border_radius":{"unit":"px","top":"10","right":"0","bottom":"0","left":"10","isLinked":false},"button_background_color":"#00d8fc","button_text_color":"#ffffff","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":14},"button_typography_font_weight":"600","button_typography_text_transform":"none","button_border_radius":{"unit":"px","top":"0","right":"10","bottom":"10","left":"0","isLinked":false},"button_background_hover_color":"#00d8fc","button_hover_color":"#ffffff","button_width_mobile":"25","button_align_mobile":"start","email_to":"tal@tyco.co.il","email_subject":"New message from \\"AGURA\\"","email_from":"email@www.agurainc.com","email_from_name":"AGURA","email_to_2":"admin@tyco.co.il","email_subject_2":"New message from \\"AGURA\\"","email_from_2":"email@www.agurainc.com","email_from_name_2":"AGURA","email_reply_to_2":"admin@tyco.co.il","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"form"},{"id":"bd550be","elType":"widget","settings":{"html":"\\r\\n<a href=\\"#\\" rel=\\"nofollow\\" class=\\"footer-social\\">\\r\\n<svg xmlns=\\"http:\\/\\/www.w3.org\\/2000\\/svg\\" viewBox=\\"0 0 30 30\\">\\r\\n    <defs>\\r\\n        <style>\\r\\n            .cls-1{fill:#889399}\\r\\n        <\\/style>\\r\\n    <\\/defs>\\r\\n    <path id=\\"soc_fb\\" d=\\"M15 2.5A12.5 12.5 0 1 1 2.5 15 12.537 12.537 0 0 1 15 2.5zM15 0a15 15 0 1 0 15 15A15.044 15.044 0 0 0 15 0zm-2.5 12.5H10V15h2.5v7.5h3.75V15h2.25l.25-2.5h-2.5v-1c0-.625.125-.875.75-.875h1.75V7.5h-3c-2.25 0-3.25 1-3.25 2.875z\\" class=\\"cls-1\\"\\/>\\r\\n<\\/svg>\\r\\n\\r\\n\\r\\n<\\/a>\\r\\n\\r\\n<a href=\\"#\\" rel=\\"nofollow\\" class=\\"footer-social\\">\\r\\n<svg xmlns=\\"http:\\/\\/www.w3.org\\/2000\\/svg\\" viewBox=\\"0 0 30 30\\">\\r\\n    <defs>\\r\\n        <style>\\r\\n            .cls-1{fill:#889399}\\r\\n        <\\/style>\\r\\n    <\\/defs>\\r\\n    <path id=\\"soc_youtube\\" d=\\"M20.25 8.875c-2.5-.125-8.125-.125-10.625 0C7 9 6.625 10.75 6.625 15s.375 6 3 6.125c2.5.125 8.125.125 10.625 0 2.75-.125 3-1.875 3-6.125s-.25-6-3-6.125zM12.5 17.75v-5.5l6 2.75zM15 2.5A12.5 12.5 0 1 1 2.5 15 12.537 12.537 0 0 1 15 2.5zM15 0a15 15 0 1 0 15 15A15.044 15.044 0 0 0 15 0z\\" class=\\"cls-1\\"\\/>\\r\\n<\\/svg>\\r\\n\\r\\n<\\/a>\\r\\n\\r\\n\\r\\n\\r\\n<a href=\\"#\\" rel=\\"nofollow\\" class=\\"footer-social\\">\\r\\n<svg xmlns=\\"http:\\/\\/www.w3.org\\/2000\\/svg\\" viewBox=\\"0 0 30 30\\">\\r\\n    <defs>\\r\\n        <style>\\r\\n            .cls-1{fill:#889399}\\r\\n        <\\/style>\\r\\n    <\\/defs>\\r\\n    <path id=\\"soc_linkedin\\" d=\\"M15 2.5A12.5 12.5 0 1 1 2.5 15 12.537 12.537 0 0 1 15 2.5zM15 0a15 15 0 1 0 15 15A15.044 15.044 0 0 0 15 0zm-2.5 10a1.181 1.181 0 0 1-1.25 1.25A1.181 1.181 0 0 1 10 10a1.181 1.181 0 0 1 1.25-1.25A1.181 1.181 0 0 1 12.5 10zm0 2.5H10V20h2.5zm3.75 0h-2.5V20h2.5v-3.625c0-2.125 2.5-2.375 2.5 0V20h2.5v-4.25c0-4.125-3.875-4-5-1.875z\\" class=\\"cls-1\\"\\/>\\r\\n<\\/svg>\\r\\n\\r\\n<\\/a>\\r\\n\\r\\n","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":".footer-social:not(:last-child){\\n    margin-right: 1rem;\\n}\\n.footer-social svg{\\n    width: 30px;\\n    height: 30px;\\n}\\n\\n.footer-social:hover svg{\\n    width: 30px;\\n    height: 30px;\\n}"},"elements":[],"widgetType":"html"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"f4d006c","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"structure":"20","background_background":"classic","background_color":"#393e40","margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"18","right":"0","bottom":"17","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"20","right":"20","bottom":"20","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"10","right":"10","bottom":"10","left":"15","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"cfff946","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"7dc5917","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":100,"content_position":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"5","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[{"id":"294f211","elType":"widget","settings":{"title":"\\u00a9 2018 Agura Inc. All rights reserved","align_mobile":"left","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":12},"typography_font_weight":"400"},"elements":[],"widgetType":"heading"}],"isInner":false},{"id":"f343fe0","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":100,"content_position":"center","margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"5","right":"0","bottom":"5","left":"0","isLinked":false}},"elements":[{"id":"2052c75","elType":"widget","settings":{"title":"Terms & Conditions  |  Privacy Policy","align":"right","align_mobile":"left","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":12},"typography_font_weight":"400"},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false}]'),
 (5419, 920, '_wp_page_template', 'default'),
 (697, 83, '_menu_item_type', 'post_type'),
 (698, 83, '_menu_item_menu_item_parent', '1039'),
 (699, 83, '_menu_item_object_id', '53'),
 (700, 83, '_menu_item_object', 'page'),
 (701, 83, '_menu_item_target', ''),
 (702, 83, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (703, 83, '_menu_item_xfn', ''),
 (704, 83, '_menu_item_url', ''),
 (705, 83, '_menu_item_template', ''),
 (706, 83, '_menu_item_mega_template', '0'),
 (707, 83, '_menu_item_nolink', ''),
 (708, 83, '_menu_item_category_post', ''),
 (709, 83, '_menu_item_megamenu', ''),
 (710, 83, '_menu_item_megamenu_auto_width', ''),
 (711, 83, '_menu_item_megamenu_col', ''),
 (712, 83, '_menu_item_megamenu_heading', ''),
 (713, 83, '_menu_item_megamenu_widgetarea', '0'),
 (714, 83, '_menu_item_icon', ''),
 (715, 84, '_menu_item_type', 'post_type'),
 (716, 84, '_menu_item_menu_item_parent', '1039'),
 (717, 84, '_menu_item_object_id', '51'),
 (718, 84, '_menu_item_object', 'page'),
 (719, 84, '_menu_item_target', ''),
 (720, 84, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (721, 84, '_menu_item_xfn', ''),
 (722, 84, '_menu_item_url', ''),
 (723, 84, '_menu_item_template', ''),
 (724, 84, '_menu_item_mega_template', '0'),
 (725, 84, '_menu_item_nolink', ''),
 (726, 84, '_menu_item_category_post', ''),
 (727, 84, '_menu_item_megamenu', ''),
 (728, 84, '_menu_item_megamenu_auto_width', ''),
 (729, 84, '_menu_item_megamenu_col', ''),
 (730, 84, '_menu_item_megamenu_heading', ''),
 (731, 84, '_menu_item_megamenu_widgetarea', '0'),
 (732, 84, '_menu_item_icon', ''),
 (733, 85, '_menu_item_type', 'post_type'),
 (734, 85, '_menu_item_menu_item_parent', '928'),
 (735, 85, '_menu_item_object_id', '50'),
 (736, 85, '_menu_item_object', 'page'),
 (737, 85, '_menu_item_target', ''),
 (738, 85, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (739, 85, '_menu_item_xfn', ''),
 (740, 85, '_menu_item_url', ''),
 (741, 85, '_menu_item_template', ''),
 (742, 85, '_menu_item_mega_template', '0'),
 (743, 85, '_menu_item_nolink', ''),
 (744, 85, '_menu_item_category_post', ''),
 (745, 85, '_menu_item_megamenu', ''),
 (746, 85, '_menu_item_megamenu_auto_width', ''),
 (747, 85, '_menu_item_megamenu_col', ''),
 (748, 85, '_menu_item_megamenu_heading', ''),
 (749, 85, '_menu_item_megamenu_widgetarea', '0'),
 (750, 85, '_menu_item_icon', ''),
 (751, 86, '_menu_item_type', 'post_type'),
 (752, 86, '_menu_item_menu_item_parent', '1069'),
 (753, 86, '_menu_item_object_id', '43'),
 (754, 86, '_menu_item_object', 'page'),
 (755, 86, '_menu_item_target', ''),
 (756, 86, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (757, 86, '_menu_item_xfn', ''),
 (758, 86, '_menu_item_url', ''),
 (759, 86, '_menu_item_template', ''),
 (760, 86, '_menu_item_mega_template', '0'),
 (761, 86, '_menu_item_nolink', ''),
 (762, 86, '_menu_item_category_post', ''),
 (763, 86, '_menu_item_megamenu', ''),
 (764, 86, '_menu_item_megamenu_auto_width', ''),
 (765, 86, '_menu_item_megamenu_col', ''),
 (766, 86, '_menu_item_megamenu_heading', ''),
 (767, 86, '_menu_item_megamenu_widgetarea', '0'),
 (768, 86, '_menu_item_icon', ''),
 (769, 87, '_menu_item_type', 'post_type'),
 (770, 87, '_menu_item_menu_item_parent', '1069'),
 (771, 87, '_menu_item_object_id', '49'),
 (772, 87, '_menu_item_object', 'page'),
 (773, 87, '_menu_item_target', ''),
 (774, 87, '_menu_item_classes', 'a:1:{i:0;s:0:"";}'),
 (775, 87, '_menu_item_xfn', ''),
 (776, 87, '_menu_item_url', ''),
 (777, 87, '_menu_item_template', ''),
 (778, 87, '_menu_item_mega_template', '0'),
 (779, 87, '_menu_item_nolink', ''),
 (780, 87, '_menu_item_category_post', ''),
 (781, 87, '_menu_item_megamenu', ''),
 (782, 87, '_menu_item_megamenu_auto_width', ''),
 (783, 87, '_menu_item_megamenu_col', ''),
 (784, 87, '_menu_item_megamenu_heading', ''),
 (785, 87, '_menu_item_megamenu_widgetarea', '0'),
 (786, 87, '_menu_item_icon', ''),
 (5418, 920, '_elementor_conditions', 'a:1:{i:0;s:15:"include/general";}'),
 (5417, 920, '_elementor_edit_mode', 'builder'),
 (5416, 920, '_elementor_template_type', 'footer'),
 (5630, 947, '_elementor_template_type', 'footer'),
 (5631, 947, '_elementor_edit_mode', 'builder'),
 (6294, 1030, '_elementor_template_type', 'footer'),
 (6295, 1030, '_elementor_edit_mode', 'builder'),
 (6296, 1030, '_elementor_conditions', 'a:1:{i:0;s:15:"include/general";}'),
 (805, 89, '_menu_item_type', 'post_type'),
 (806, 89, '_menu_item_menu_item_parent', '0'),
 (807, 89, '_menu_item_object_id', '47'),
 (808, 89, '_menu_item_object', 'page'),
 (809, 89, '_menu_item_target', ''),
 (810, 89, '_menu_item_classes', 'a:1:{i:0;s:3:"btn";}'),
 (811, 89, '_menu_item_xfn', ''),
 (812, 89, '_menu_item_url', ''),
 (813, 89, '_menu_item_template', ''),
 (814, 89, '_menu_item_mega_template', '0'),
 (815, 89, '_menu_item_nolink', ''),
 (816, 89, '_menu_item_category_post', ''),
 (817, 89, '_menu_item_megamenu', ''),
 (818, 89, '_menu_item_megamenu_auto_width', ''),
 (819, 89, '_menu_item_megamenu_col', ''),
 (820, 89, '_menu_item_megamenu_heading', ''),
 (821, 89, '_menu_item_megamenu_widgetarea', '0'),
 (822, 89, '_menu_item_icon', ''),
 (5522, 930, '_elementor_version', '0.4'),
 (5545, 934, '_elementor_edit_mode', 'builder'),
 (5524, 931, '_wp_page_template', 'default'),
 (5521, 930, '_elementor_data', '[{"id":"63b968a","elType":"section","settings":{"stretch_section":"section-stretched","custom_height":{"unit":"px","size":800},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/banner_mobile@2x.png","id":120},"background_repeat":"no-repeat","background_size":"cover","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"185","right":"0","bottom":"353","left":"0","isLinked":false},"background_position":"center center","margin_tablet":{"unit":"px","top":"-150","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"-100","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"200","right":"0","bottom":"250","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"99","right":"0","bottom":"99","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"1699629","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"12ab807","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"238af9f","elType":"widget","settings":{"title":"Imagine a platform which provides you a technological tool-box using Blockchain Economy","title_color":"#ffffff","typography_typography":"custom","typography_font_family":"Montserrat","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3},"typography_font_size_mobile":{"unit":"px","size":34},"typography_line_height_mobile":{"unit":"px","size":35},"align_mobile":"left","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"c49c18a","elType":"widget","settings":{"editor":"<p>We solve more than <strong>one problem at a time<\\/strong>, Blockchain technology ecosystem which uses high level of <strong>Security and Customized Projects<\\/strong><\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3},"typography_font_size_mobile":{"unit":"px","size":21}},"elements":[],"widgetType":"text-editor"},{"id":"12aa04e","elType":"widget","settings":{"button_type":"warning","button_text":"Request a demo","ga_track_event":"PopBox Button Clicked","close_size":{"unit":"px","size":70},"close_padding":{"unit":"px","top":"90","right":"150","bottom":"0","left":"0","isLinked":false},"close_typography_typography":"custom","close_typography_font_weight":"300","modal_content_max_width":{"unit":"px","size":1920},"modal_bgcolor_background":"classic","modal_bgcolor_color":"rgba(255,252,252,0.85)","modal_window_bg_background":"classic","modal_window_bg_color":"rgba(255,252,252,0.85)","button_close_text_color":"#2e3133","modal_content_width":{"unit":"%","size":100},"modal_content_top":{"unit":"%","size":0},"custom_css":" .fa-close:before, .fa-remove:before, .fa-times:before {\\r\\n    content: \\" \\" !important;\\r\\n    background-image: url(http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/x_desktop@2x.png);\\r\\n    position: absolute;\\r\\n     width: 99px;\\r\\n     height: 99px;\\r\\n }\\r\\n \\r\\n @media only screen and (max-width: 1200px){.fa-close:before, .fa-remove:before, .fa-times:before {\\r\\n    content: \\" \\" !important;\\r\\n    background-image: url(http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/x_mobile@2x.png);\\r\\n         background-repeat: no-repeat;\\r\\n    position: absolute;\\r\\n     width: 49px;\\r\\n     height: 49px;\\r\\n       margin-top: -90px !important;\\r\\n    padding-right: 30px !important;\\r\\n }\\r\\n }\\r\\n ","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":22},"button_typography_font_weight":"400","border_radius":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"background_color":"#00d8fc","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"015","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":3},"elements":[],"widgetType":"popup"},{"id":"4200900","elType":"widget","settings":{"button_options_select":"modal","button_modal_hover_effect":"default","modal_text":"Request a demo","modal_tile":"","modal_shortcode":"[elementor-template id=\\"628\\"]","modal_video":"&lt;iframe width=&quot;560&quot; height=&quot;315&quot; src=&quot;https:\\/\\/www.youtube.com\\/embed\\/GqiST256XPA&quot; frameborder=&quot;0&quot; gesture=&quot;media&quot; allow=&quot;encrypted-media&quot; allowfullscreen&gt;&lt;\\/iframe&gt;","modal_typography_typography":"custom","modal_typography_font_size":{"unit":"px","size":22},"modal_typography_font_weight":"400","modal_button_text_color":"#ffffff","modal_background_color":"#00d8fc","modal_border_border":"solid","modal_border_color":"rgba(0,0,0,0)","modal_button_background_hover_color":"#00d8fc","modal_button_hover_border_color":"rgba(5,109,220,0)","custom_css":".elementor-22 .elementor-element.elementor-element-4200900 .modal-container .click-btn button, .elementor-22 .elementor-element.elementor-element-4200900 .modal-container .click-btn .button-normal, .elementor-22 .elementor-element.elementor-element-4200900 .modal-container .btn-line a {\\r\\n    background-color: #00d8fc;\\r\\n    width: 220px;\\r\\n    height: 50px;\\r\\n    border-radius: 10px;\\r\\n    line-height: 0;\\r\\n    padding: 0px;\\r\\n}\\r\\n\\r\\n","_css_classes":"btn_popup","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[],"widgetType":"widgetkit-for-elementor-button"}],"isInner":false}],"isInner":false},{"id":"0aa5ea4","elType":"section","settings":{"stretch_section":"section-stretched","custom_height":{"unit":"px","size":800},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/banner_desktop@2x.png","id":97},"background_repeat":"no-repeat","background_size":"cover","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"-100","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"185","right":"0","bottom":"353","left":"0","isLinked":false},"background_position":"center center","margin_tablet":{"unit":"px","top":"-150","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"180","right":"0","bottom":"250","left":"0","isLinked":false},"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"71f41c6","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"dfe26b6","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"e7f5537","elType":"widget","settings":{"title":"Cutting-edge<br>\\nblockchain technology","title_color":"#ffffff","typography_typography":"custom","typography_font_family":"Montserrat","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3}},"elements":[],"widgetType":"heading"},{"id":"c37c815","elType":"widget","settings":{"editor":"<p>We use <strong>high-level security<\\/strong> and<br \\/>manage <strong>customized projects<\\/strong><\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3}},"elements":[],"widgetType":"text-editor"},{"id":"e931fb5","elType":"widget","settings":{"button_options_select":"modal","button_modal_hover_effect":"default","modal_text":"Request a demo","modal_tile":"","modal_shortcode":"[elementor-template id=\\"628\\"]","modal_video":"&lt;iframe width=&quot;560&quot; height=&quot;315&quot; src=&quot;https:\\/\\/www.youtube.com\\/embed\\/GqiST256XPA&quot; frameborder=&quot;0&quot; gesture=&quot;media&quot; allow=&quot;encrypted-media&quot; allowfullscreen&gt;&lt;\\/iframe&gt;","modal_typography_typography":"custom","modal_typography_font_size":{"unit":"px","size":22},"modal_typography_font_weight":"400","modal_button_text_color":"#ffffff","modal_background_color":"#00d8fc","modal_border_border":"solid","modal_border_color":"rgba(0,0,0,0)","modal_button_background_hover_color":"#00d8fc","modal_button_hover_border_color":"rgba(5,109,220,0)","custom_css":".elementor-element.elementor-element-e931fb5 .modal-container .click-btn button, .elementor-22 .elementor-element.elementor-element-e931fb5 .modal-container .click-btn .button-normal, .elementor-22 .elementor-element.elementor-element-e931fb5 .modal-container .btn-line a {\\r\\n    background-color: #00d8fc;\\r\\n    width: 220px;\\r\\n    height: 50px;\\r\\n    border-radius: 10px;\\r\\n    line-height: 0;\\r\\n    padding: 0px;\\r\\n}\\r\\n\\r\\n","_css_classes":"btn_popup"},"elements":[],"widgetType":"widgetkit-for-elementor-button"}],"isInner":false}],"isInner":false},{"id":"4e859f5","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"structure":"20","margin":{"unit":"px","top":"169","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_mobile":"hidden-phone","margin_tablet":{"unit":"px","top":"40","right":0,"bottom":"60","left":0,"isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"8cf2a9f","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"68893a1","elType":"column","settings":{"_column_size":50,"_inline_size":33.732,"background_background":"classic","background_repeat":"no-repeat","background_size":"cover","margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":40,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"b0298b5","elType":"widget","settings":{"title":"Why Agura?","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":35},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"40","right":"0","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"8fd46d5","elType":"widget","settings":{"editor":"<p>Agura is a world leader of<br \\/>customized software for the<br \\/>Blockchain realm, using top-level<br \\/>security methods. As a customer of<br \\/>Agura you\\u2019ll enjoy the following<br \\/>services, and more<\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":18},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":16},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"text-editor"},{"id":"319fe87","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/services@2x.png","id":94},"_margin":{"unit":"px","top":"-311","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-320","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"e972b0b","elType":"column","settings":{"_column_size":50,"_inline_size":66.268,"_inline_size_tablet":60,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"25","right":"0","bottom":"0","left":"154","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"30","isLinked":false}},"elements":[{"id":"28047ac","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serSecurity@2x.png","id":143},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"01 \\u2014<br><span> Security<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_space_mobile":{"unit":"px","size":0},"image_size":{"unit":"%","size":""},"text_align":"left","text_align_mobile":"left","content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":10},"title_bottom_space_mobile":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"89a2896","elType":"widget","settings":{"tabs":[{"tab_title":"Agura adheres to the highest level of<br> technical security in the Blockchain & digital <br>currency space","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"edb2d90","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWL@2x.png","id":141},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"02 \\u2014<br><span> White Label Exchange<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_size":{"unit":"%","size":""},"text_align":"left","title_bottom_space":{"unit":"px","size":10},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"3645b8e","elType":"widget","settings":{"tabs":[{"tab_title":"Setup your own exchange","tab_content":"<p>Setup your own exchange with a secured hosting cloud &amp; liquidity<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"0a193f0","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serProj@2x.png","id":142},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"03 \\u2014<br><span>Customized Projects<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_size":{"unit":"%","size":""},"text_align":"left","title_bottom_space":{"unit":"px","size":10},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"d9bd25a","elType":"widget","settings":{"tabs":[{"tab_title":"Every project can be a Customized project","tab_content":"<p>We specialize in customized blockchain solutions and giving you full control over every aspect<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"f9d70d8","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWallet@2x.png","id":144},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"04 \\u2014<br><span>Wallet<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_size":{"unit":"%","size":""},"text_align":"left","title_bottom_space":{"unit":"px","size":10},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"094da20","elType":"widget","settings":{"tabs":[{"tab_title":"Let\\u2019s do a Wallet","tab_content":"<p><span style=\\"font-weight: 400;\\">Multi-currency &amp; Currency exchange management including Anonymous Security System<\\/span><\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"}],"isInner":false}],"isInner":false},{"id":"81a16dd","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"structure":"20","margin":{"unit":"px","top":"169","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"layout":"full_width","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"25","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"edc5952","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"33500ed","elType":"column","settings":{"_column_size":50,"_inline_size":33.732,"background_background":"classic","background_repeat":"no-repeat","background_size":"cover","margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":40,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_mobile":100,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f66f8cb","elType":"widget","settings":{"title":"Why Agura?","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":35},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"40","right":"0","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"91e2045","elType":"widget","settings":{"editor":"<p>Agura is a world leader of<br \\/>customized software for the<br \\/>Blockchain realm, using top-level<br \\/>security methods. As a customer of<br \\/>Agura you\\u2019ll enjoy the following<br \\/>services, and more<\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":18},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":16},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"text-editor"},{"id":"6ecfc5d","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/services_bg@2x-1.png","id":169},"_margin":{"unit":"px","top":"-311","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-280","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"-283","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"7cc766c","elType":"column","settings":{"_column_size":50,"_inline_size":66.268,"_inline_size_tablet":60,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"25","right":"0","bottom":"0","left":"154","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"20","bottom":"0","left":"30","isLinked":false}},"elements":[{"id":"4aa24f0","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"270b254","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"f81dd3c","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"1eb5f09","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serSecurity@2x.png","id":143},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"1cfa752","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9a0ec1c","elType":"widget","settings":{"title":"01 \\u2014<br><span> Security<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"d503fac","elType":"widget","settings":{"tabs":[{"tab_title":"Agura adheres to the highest level of<br> technical security in the Blockchain & digital <br>currency space","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"a1e4dd6","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"d15d7a7","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"01253e0","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"cfeaf92","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWL@2x.png","id":141},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"a191552","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"be9ea7a","elType":"widget","settings":{"title":"02 \\u2014<br><span> White Label Exchange<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"4d0f36c","elType":"widget","settings":{"tabs":[{"tab_title":"Setup your own exchange with a secured<br> hosting cloud","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"fe87ef4","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"25a5cac","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"098eec7","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"077f6bf","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serProj@2x.png","id":142},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"ac26fc9","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"898d823","elType":"widget","settings":{"title":"03 \\u2014<br><span>Customized Projects<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"4c28563","elType":"widget","settings":{"tabs":[{"tab_title":"We specialize in customized blockchain<br> solutions and giving you full control over <br>every aspect","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"3171009","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"3928dfa","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"f338b71","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"20459b3","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWallet@2x.png","id":144},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"81ead4c","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3a639a4","elType":"widget","settings":{"title":"04 \\u2014<br><span>Wallet<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"7fe2231","elType":"widget","settings":{"tabs":[{"tab_title":"Multi-currency & Currency exchange<br> management including Anonymous<br> Security System","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"}],"isInner":false}],"isInner":false},{"id":"56d9f2f","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"78","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"c02debe","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"bd61090","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"d598eab","elType":"widget","settings":{"title":"About our process","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35}},"elements":[],"widgetType":"heading"},{"id":"27181dc","elType":"widget","settings":{"title":"How to create a Blockchain economy with us?\\u200b","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":22},"typography_font_weight":"400","typography_font_size_tablet":{"unit":"px","size":18}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"f9bf2dc","elType":"section","settings":{"stretch_section":"section-stretched","layout":"full_width","custom_height":{"unit":"px","size":420},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"9eb9ada","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}],"margin":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"8097333","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"471156d","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/1-01.png","id":848},"image_size":"full"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"29c761e","elType":"section","settings":{"stretch_section":"section-stretched","layout":"full_width","custom_height":{"unit":"px","size":420},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"9eb9ada","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}],"margin":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_mobile":"hidden-phone"},"elements":[{"id":"78079d9","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"920fc98","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/1-02.png","id":849},"image_size":"full","width":{"unit":"%","size":10},"width_tablet":{"unit":"%","size":100},"space":{"unit":"%","size":10},"space_tablet":{"unit":"%","size":100}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"e5cbe65","elType":"section","settings":{"stretch_section":"section-stretched","layout":"full_width","custom_height":{"unit":"px","size":420},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"9eb9ada","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}],"margin":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[{"id":"ca4de73","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9b01c56","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/1-03.png","id":847},"image_size":"full","width":{"unit":"%","size":10},"width_mobile":{"unit":"%","size":100},"space":{"unit":"%","size":10},"space_mobile":{"unit":"%","size":100},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"b2ab9e5","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"87","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"z_index":1,"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"858f032","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"f7980b5","elType":"column","settings":{"_column_size":100,"_inline_size":null,"background_background":"classic","background_position":"bottom center","background_repeat":"no-repeat","background_size":"contain","margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"7d8b31a","elType":"widget","settings":{"title":"Global Network\\n","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_mobile":{"unit":"px","size":30},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"415a887","elType":"widget","settings":{"title":"We\\u2019re always growing and increasing our software activity","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":24},"typography_font_size_mobile":{"unit":"px","size":18},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5831bb1","elType":"section","settings":{"structure":"40","margin":{"unit":"px","top":"73","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"82a0848","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"3c5129a","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"2d40740","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netYears@2x.png","id":223},"title_text":"14","description_text":"years of<br>\\nexperience","image_space":{"unit":"px","size":""},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"59d063a","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a8ca8d5","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netClients@2x.png","id":224},"title_text":"200","description_text":"clients around<br>\\nthe world","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"c82e2f4","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"13a8a61","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netTeam@2x.png","id":226},"title_text":"45","description_text":"team<br>\\nmembers","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"5","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image-box"},{"id":"7a5fac7","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netCont@2x.png","id":225},"title_text":"4505","description_text":"contributors<br>\\nin the community","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"d2e1622","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"47afd4c","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netUpdate@2x.png","id":227},"title_text":"3h","description_text":"since<br>\\nlast update","image_space":{"unit":"px","size":""},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image-box"}],"isInner":true}],"isInner":true},{"id":"1d033af","elType":"section","settings":{"structure":"40","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"52","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"73a43c5","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"e910af8","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"558f708","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netUpdate@2x.png","id":227},"title_text":"3h","description_text":"since<br>\\nlast update","image_space":{"unit":"px","size":""},"image_size":{"unit":"%","size":20},"text_align":"justify","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"78e6e0b","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"229b087","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netCont@2x.png","id":225},"title_text":"4505","description_text":"contributors<br>\\nin the community","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"text_align":"justify","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"bb73cc6","elType":"column","settings":{"_column_size":25,"_inline_size":null},"elements":[],"isInner":true},{"id":"9efc6a1","elType":"column","settings":{"_column_size":25,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"6acd650","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"height":"min-height","custom_height":{"unit":"px","size":555},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/network_bg@2x.png","id":98},"background_position":"center center","background_repeat":"no-repeat","background_size":"contain","margin":{"unit":"px","top":"-330","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"348a45b","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"c0a4838","elType":"column","settings":{"_column_size":100},"elements":[],"isInner":false}],"isInner":false},{"id":"3f7a727","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"62","right":"0","bottom":"64","left":"0","isLinked":false},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/news_bg@2x.png","id":99},"background_position":"center center","background_repeat":"no-repeat","background_size":"cover","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"50","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"06be9cc","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"d5621be","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"535dd02","elType":"widget","settings":{"title":"Read Our Latest News","align":"center","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300"},"elements":[],"widgetType":"heading"},{"id":"2f060b9","elType":"section","settings":{"structure":"30","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"a44baab","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"4daed78","elType":"column","settings":{"_column_size":33,"_inline_size":null},"elements":[{"id":"0cae620","elType":"widget","settings":{"wp":{"title":"","width":"340","height":"","tweet-limit":"1","username":"@CNN","chrome":["nofooter","noborders","transparent"],"link-color":"#f96e5b","border-color":"#1da1f2","theme":"light"},"custom_css":".u-inlineBlock{\\n    display: none !important;\\n}\\n\\n"},"elements":[],"widgetType":"wp-widget-ocean_twitter"}],"isInner":true},{"id":"c9230fa","elType":"column","settings":{"_column_size":33,"_inline_size":null},"elements":[{"id":"d91b6a5","elType":"widget","settings":{"wp":{"title":"","width":"340","height":"","tweet-limit":"1","username":"@CNN","chrome":["nofooter","noborders","transparent"],"link-color":"#f96e5b","border-color":"#1da1f2","theme":"light"},"hide_mobile":"hidden-phone","custom_css":".u-inlineBlock{\\n    display: none !important;\\n}\\n\\n"},"elements":[],"widgetType":"wp-widget-ocean_twitter"}],"isInner":true},{"id":"493c5a3","elType":"column","settings":{"_column_size":33,"_inline_size":null},"elements":[{"id":"7eed6b2","elType":"widget","settings":{"wp":{"title":"","width":"340","height":"","tweet-limit":"1","username":"@CNN","chrome":["nofooter","noborders","transparent"],"link-color":"#f96e5b","border-color":"#1da1f2","theme":"light"},"hide_mobile":"hidden-phone","custom_css":".u-inlineBlock{\\n    display: none !important;\\n}\\n\\n"},"elements":[],"widgetType":"wp-widget-ocean_twitter"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"65f3cb5e","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"background_background":"classic","background_color":"rgba(0,182,224,0)","margin":{"unit":"px","top":"67","right":0,"bottom":"80","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"b1bcfbd","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"2dc64351","elType":"column","settings":{"_column_size":100,"_inline_size":null,"_inline_size_tablet":100,"_inline_size_mobile":100,"background_background":"classic","background_color":"#00b6e0","margin":{"unit":"px","top":"0","right":"135","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"90","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"27","bottom":"80","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"30","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"423eac42","elType":"widget","settings":{"title":"Our Partners","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"58","right":"20","bottom":"0","left":"20","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"99069ac","elType":"widget","settings":{"title":"Some of the companies we proudly work with","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_size_tablet":{"unit":"px","size":18},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"14","right":"50","bottom":"0","left":"20","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"ba125f7","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"54","right":0,"bottom":"0","left":0,"isLinked":false},"z_index":1,"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"35b45b3","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"3dd27af","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"011bc89","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"537029e","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9943bf0","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"8eaadde","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"6572e8d","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"2e8495f","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[],"isInner":true},{"id":"d2349f1","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"ee35f0f","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"30","right":0,"bottom":"30","left":0,"isLinked":false},"z_index":1,"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"dba5db8","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"501acfa","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"bd844b9","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"7194aff","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"c817e24","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"086c74d","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"acbbf94","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"79e49bb","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true},{"id":"11423d8","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"5d724c6e","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/partners_img@2x.png","id":100},"image_size":"custom","image_custom_dimension":{"width":"398","height":"300"},"align":"right","align_tablet":"right","align_mobile":"center","width_tablet":{"unit":"%","size":40},"width_mobile":{"unit":"%","size":150},"_margin":{"unit":"px","top":"-320","right":"-160","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-230","right":"-90","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":0,"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"cdb30d7","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"background_background":"classic","background_color":"rgba(0,182,224,0)","margin":{"unit":"px","top":"67","right":0,"bottom":"80","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"100","left":"0","isLinked":false},"layout":"full_width","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"38e36e9","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"26e906a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"_inline_size_tablet":100,"_inline_size_mobile":100,"background_background":"classic","background_color":"#00b6e0","margin":{"unit":"px","top":"0","right":"135","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"90","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"27","bottom":"80","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"30","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"70dc643","elType":"widget","settings":{"title":"Our Partners","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"58","right":"20","bottom":"0","left":"30","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"15312a7","elType":"widget","settings":{"title":"Some of the companies we proudly work with","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_size_tablet":{"unit":"px","size":18},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"14","right":"50","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"30bbef2","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"54","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"30","bottom":"60","left":"30","isLinked":false},"z_index":1,"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"a43ad79","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"0ece27e","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"3743fd9","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"ff0b09a","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a330004","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"3dbe584","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"d73be89","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"d791b38","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"a90a5e9","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"a4a5f19","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"c50605e","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"30","right":0,"bottom":"30","left":0,"isLinked":false},"z_index":1,"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"92df713","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"ca68159","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"1a8dca0","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"c12e390","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"4785f3b","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"219f3db","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"9d4c977","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"13cf90d","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true},{"id":"ab439f6","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"4ec0bc4","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/partners_img@2x.png","id":100},"image_size":"custom","image_custom_dimension":{"width":"398","height":"300"},"align":"right","align_tablet":"right","align_mobile":"center","width_tablet":{"unit":"%","size":40},"width_mobile":{"unit":"%","size":150},"_margin":{"unit":"px","top":"-320","right":"-160","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-230","right":"-90","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":0,"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"35c6d7b","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"20","right":"0","bottom":"200","left":"0","isLinked":false},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/contact_bg@2x.png","id":281},"background_size":"cover","margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"60","right":"20","bottom":"150","left":"20","isLinked":false},"hide_mobile":"hidden-phone","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"b5369b3","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"a76a73f","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"7588d84","elType":"widget","settings":{"title":"Get in Touch","align":"center","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35}},"elements":[],"widgetType":"heading"},{"id":"9c5c8bb","elType":"section","settings":{"structure":"20","margin":{"unit":"px","top":"68","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"c39940b","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"0758e9a","elType":"column","settings":{"_column_size":50,"_inline_size":65.169,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a678dcc","elType":"widget","settings":{"editor":"<p>Boost your business by dropping us a <br \\/>message and we\\u2019ll get back to you shortly<\\/p>","text_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":24},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":18}},"elements":[],"widgetType":"text-editor"}],"isInner":true},{"id":"364b229","elType":"column","settings":{"_column_size":50,"_inline_size":34.831,"_inline_size_mobile":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"588bb93","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"_id":"name","field_type":"text","field_label":"","placeholder":"Name","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"email","field_type":"email","required":"true","field_label":"","placeholder":"Email","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"65216b9","field_type":"tel","required":"true","field_label":"","placeholder":"Phone","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"message","field_type":"textarea","field_label":"","placeholder":"Message","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":1,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""}],"button_text":"Submit","button_size":"xs","button_width":"40","email_to":"admin@tyco.co.il","email_subject":"New message from \\"AGURA\\"","email_content":"[all-fields]","email_from":"email@www.agurainc.com","email_from_name":"AGURA","email_to_2":"admin@tyco.co.il","email_subject_2":"New message from \\"AGURA\\"","email_content_2":"[all-fields]","email_from_2":"email@www.agurainc.com","email_from_name_2":"AGURA","email_reply_to_2":"admin@tyco.co.il","success_message":"The form was sent successfully.","error_message":"An errors occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","column_gap":{"unit":"px","size":0},"row_gap":{"unit":"px","size":13},"label_spacing":{"unit":"px","size":""},"label_color":"#999999","label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":16},"field_text_color":"#999999","field_typography_typography":"custom","field_typography_font_size":{"unit":"px","size":16},"field_typography_font_weight":"300","field_background_color":"rgba(255,255,255,0)","field_border_color":"#cccccc","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"button_background_color":"#00d8fc","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":16},"button_typography_font_weight":"400","button_typography_text_transform":"none","button_border_radius":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"form"}],"isInner":true}],"isInner":true},{"id":"1a07c9f","elType":"section","settings":{"structure":"30","content_width":{"unit":"px","size":500},"margin":{"unit":"px","top":"-145","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"-160","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"560","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"270","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"dfb2552","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"319735b","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a92e3ed","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conAddress@2x.png","id":286},"align":"left","space":{"unit":"%","size":20}},"elements":[],"widgetType":"image"},{"id":"3e70ed5","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"938b250","elType":"widget","settings":{"title":"Agura, Inc.<br>\\n1, HaBniya st.<br>\\nHaifa<br>\\nIsrael<br>","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"615bee3","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a60cf4e","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conPhone@2x.png","id":285},"align":"left","space":{"unit":"%","size":20}},"elements":[],"widgetType":"image"},{"id":"51f85a1","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"0cf43b6","elType":"widget","settings":{"title":"+972.74.7300000<br>\\next. 1312","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"3f6d638","elType":"column","settings":{"_column_size":33,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"2b020b3","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conEmail@2x.png","id":287},"align":"left","space":{"unit":"%","size":20}},"elements":[],"widgetType":"image"},{"id":"b0c1f17","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"35e455d","elType":"widget","settings":{"title":"info@agurainc.com","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"4eef26f","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"62","right":"0","bottom":"226","left":"0","isLinked":false},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/contact_bg@2x.png","id":281},"layout":"full_width","background_position":"center center","background_repeat":"no-repeat","background_size":"cover","margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"60","right":"20","bottom":"150","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"20","bottom":"80","left":"20","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"92e9df7","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"c034d73","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4e1b554","elType":"widget","settings":{"title":"Get in Touch","align":"center","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35}},"elements":[],"widgetType":"heading"},{"id":"df5a782","elType":"section","settings":{"layout":"full_width","structure":"20","margin":{"unit":"px","top":"68","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"08fc4ed","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"e3a4225","elType":"column","settings":{"_column_size":50,"_inline_size":65.169,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"36ae868","elType":"widget","settings":{"editor":"<p>Boost your business by dropping us a <br \\/>message and we\\u2019ll get back to you shortly<\\/p>","text_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":24},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":18}},"elements":[],"widgetType":"text-editor"},{"id":"6d1d675","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conAddress@2x.png","id":286},"align":"left","align_mobile":"center","space":{"unit":"%","size":20},"space_mobile":{"unit":"%","size":15}},"elements":[],"widgetType":"image"},{"id":"9b864f9","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"width_mobile":{"unit":"%","size":25},"align_mobile":"center","gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"f943929","elType":"widget","settings":{"title":"Agura, Inc.\\n1, HaBniya st.\\nHaifa\\nIsrael","align_mobile":"center","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"heading"},{"id":"413c88b","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conPhone@2x.png","id":285},"align":"left","align_mobile":"center","space":{"unit":"%","size":20},"space_mobile":{"unit":"%","size":15},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"dc1fb1a","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"width_mobile":{"unit":"%","size":25},"align_mobile":"center","gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"1eb2f30","elType":"widget","settings":{"title":"+972.74.7300000\\next. 1312","align_mobile":"center","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"heading"},{"id":"51ec832","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conEmail@2x.png","id":287},"align":"left","align_mobile":"center","space":{"unit":"%","size":20},"space_mobile":{"unit":"%","size":15},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"7dc4fc6","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"width_mobile":{"unit":"%","size":25},"align_mobile":"center","gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"5cda15a","elType":"widget","settings":{"title":"info@agurainc.com","align_mobile":"center","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"ecafe4f","elType":"column","settings":{"_column_size":50,"_inline_size":34.831,"_inline_size_mobile":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d81db1c","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"_id":"name","field_type":"text","field_label":"","placeholder":"Name","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"email","field_type":"email","required":"true","field_label":"","placeholder":"Email","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"65216b9","field_type":"tel","required":"true","field_label":"","placeholder":"Phone","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"message","field_type":"textarea","field_label":"","placeholder":"Message","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":1,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""}],"button_text":"Submit","button_size":"xs","button_width":"40","button_width_mobile":"50","email_to":"admin@tyco.co.il","email_subject":"New message from \\"AGURA\\"","email_content":"[all-fields]","email_from":"email@www.agurainc.com","email_from_name":"AGURA","email_to_2":"admin@tyco.co.il","email_subject_2":"New message from \\"AGURA\\"","email_content_2":"[all-fields]","email_from_2":"email@www.agurainc.com","email_from_name_2":"AGURA","email_reply_to_2":"admin@tyco.co.il","success_message":"The form was sent successfully.","error_message":"An errors occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","column_gap":{"unit":"px","size":0},"row_gap":{"unit":"px","size":13},"label_spacing":{"unit":"px","size":""},"label_color":"#999999","label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":16},"field_text_color":"#3f3f3f","field_typography_typography":"custom","field_typography_font_size":{"unit":"px","size":16},"field_typography_font_weight":"300","field_background_color":"rgba(255,255,255,0)","field_border_color":"#a5a5a5","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"button_background_color":"#00d8fc","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":16},"button_typography_font_weight":"400","button_typography_text_transform":"none","button_border_radius":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"80","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"form"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false}]'),
 (862, 93, '_wp_attached_file', '2018/06/cropped-logo@3x-1.png'),
 (863, 93, '_wp_attachment_context', 'custom-logo'),
 (864, 93, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:587;s:6:"height";i:150;s:4:"file";s:29:"2018/06/cropped-logo@3x-1.png";s:5:"sizes";a:2:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"cropped-logo@3x-1-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:28:"cropped-logo@3x-1-300x77.png";s:5:"width";i:300;s:6:"height";i:77;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (867, 94, '_wp_attached_file', '2018/06/services@2x.png'),
 (868, 94, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:796;s:6:"height";i:1312;s:4:"file";s:23:"2018/06/services@2x.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:23:"services@2x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:23:"services@2x-182x300.png";s:5:"width";i:182;s:6:"height";i:300;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:24:"services@2x-768x1266.png";s:5:"width";i:768;s:6:"height";i:1266;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:24:"services@2x-621x1024.png";s:5:"width";i:621;s:6:"height";i:1024;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (869, 95, '_wp_attached_file', '2018/06/success_bg@2x.png'),
 (870, 95, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:2732;s:6:"height";i:1200;s:4:"file";s:25:"2018/06/success_bg@2x.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"success_bg@2x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"success_bg@2x-300x132.png";s:5:"width";i:300;s:6:"height";i:132;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:25:"success_bg@2x-768x337.png";s:5:"width";i:768;s:6:"height";i:337;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"success_bg@2x-1024x450.png";s:5:"width";i:1024;s:6:"height";i:450;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (871, 96, '_wp_attached_file', '2018/06/success_img@2x.png'),
 (872, 96, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:796;s:6:"height";i:600;s:4:"file";s:26:"2018/06/success_img@2x.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:26:"success_img@2x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:26:"success_img@2x-300x226.png";s:5:"width";i:300;s:6:"height";i:226;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:26:"success_img@2x-768x579.png";s:5:"width";i:768;s:6:"height";i:579;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (873, 97, '_wp_attached_file', '2018/06/banner_desktop@2x.png'),
 (874, 97, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:3840;s:6:"height";i:1600;s:4:"file";s:29:"2018/06/banner_desktop@2x.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:29:"banner_desktop@2x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:29:"banner_desktop@2x-300x125.png";s:5:"width";i:300;s:6:"height";i:125;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:29:"banner_desktop@2x-768x320.png";s:5:"width";i:768;s:6:"height";i:320;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:30:"banner_desktop@2x-1024x427.png";s:5:"width";i:1024;s:6:"height";i:427;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (875, 98, '_wp_attached_file', '2018/06/network_bg@2x.png'),
 (876, 98, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:1762;s:6:"height";i:1110;s:4:"file";s:25:"2018/06/network_bg@2x.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:25:"network_bg@2x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:25:"network_bg@2x-300x189.png";s:5:"width";i:300;s:6:"height";i:189;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:25:"network_bg@2x-768x484.png";s:5:"width";i:768;s:6:"height";i:484;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:26:"network_bg@2x-1024x645.png";s:5:"width";i:1024;s:6:"height";i:645;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (877, 99, '_wp_attached_file', '2018/06/news_bg@2x.png'),
 (878, 99, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:3840;s:6:"height";i:840;s:4:"file";s:22:"2018/06/news_bg@2x.png";s:5:"sizes";a:4:{s:9:"thumbnail";a:4:{s:4:"file";s:22:"news_bg@2x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:21:"news_bg@2x-300x66.png";s:5:"width";i:300;s:6:"height";i:66;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:22:"news_bg@2x-768x168.png";s:5:"width";i:768;s:6:"height";i:168;s:9:"mime-type";s:9:"image/png";}s:5:"large";a:4:{s:4:"file";s:23:"news_bg@2x-1024x224.png";s:5:"width";i:1024;s:6:"height";i:224;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (879, 100, '_wp_attached_file', '2018/06/partners_img@2x.png'),
 (880, 100, '_wp_attachment_metadata', 'a:5:{s:5:"width";i:796;s:6:"height";i:640;s:4:"file";s:27:"2018/06/partners_img@2x.png";s:5:"sizes";a:3:{s:9:"thumbnail";a:4:{s:4:"file";s:27:"partners_img@2x-150x150.png";s:5:"width";i:150;s:6:"height";i:150;s:9:"mime-type";s:9:"image/png";}s:6:"medium";a:4:{s:4:"file";s:27:"partners_img@2x-300x241.png";s:5:"width";i:300;s:6:"height";i:241;s:9:"mime-type";s:9:"image/png";}s:12:"medium_large";a:4:{s:4:"file";s:27:"partners_img@2x-768x617.png";s:5:"width";i:768;s:6:"height";i:617;s:9:"mime-type";s:9:"image/png";}}s:10:"image_meta";a:12:{s:8:"aperture";s:1:"0";s:6:"credit";s:0:"";s:6:"camera";s:0:"";s:7:"caption";s:0:"";s:17:"created_timestamp";s:1:"0";s:9:"copyright";s:0:"";s:12:"focal_length";s:1:"0";s:3:"iso";s:1:"0";s:13:"shutter_speed";s:1:"0";s:5:"title";s:0:"";s:11:"orientation";s:1:"0";s:8:"keywords";a:0:{}}}'),
 (881, 22, '_elementor_template_type', 'post'),
 (884, 22, '_elementor_data', '[{"id":"63b968a","elType":"section","settings":{"stretch_section":"section-stretched","custom_height":{"unit":"px","size":800},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/banner_mobile@2x.png","id":120},"background_repeat":"no-repeat","background_size":"cover","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"185","right":"0","bottom":"353","left":"0","isLinked":false},"background_position":"center center","margin_tablet":{"unit":"px","top":"-150","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"-100","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"200","right":"0","bottom":"250","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"99","right":"0","bottom":"99","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"1699629","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"12ab807","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"238af9f","elType":"widget","settings":{"title":"Imagine a platform which provides you a technological tool-box using Blockchain Economy","title_color":"#ffffff","typography_typography":"custom","typography_font_family":"Montserrat","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3},"typography_font_size_mobile":{"unit":"px","size":34},"typography_line_height_mobile":{"unit":"px","size":35},"align_mobile":"left","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"c49c18a","elType":"widget","settings":{"editor":"<p>We solve more than <strong>one problem at a time<\\/strong>, Blockchain technology ecosystem which uses high level of <strong>Security and Customized Projects<\\/strong><\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3},"typography_font_size_mobile":{"unit":"px","size":21}},"elements":[],"widgetType":"text-editor"},{"id":"12aa04e","elType":"widget","settings":{"button_type":"warning","button_text":"Request a demo","ga_track_event":"PopBox Button Clicked","close_size":{"unit":"px","size":70},"close_padding":{"unit":"px","top":"90","right":"150","bottom":"0","left":"0","isLinked":false},"close_typography_typography":"custom","close_typography_font_weight":"300","modal_content_max_width":{"unit":"px","size":1920},"modal_bgcolor_background":"classic","modal_bgcolor_color":"rgba(255,252,252,0.85)","modal_window_bg_background":"classic","modal_window_bg_color":"rgba(255,252,252,0.85)","button_close_text_color":"#2e3133","modal_content_width":{"unit":"%","size":100},"modal_content_top":{"unit":"%","size":0},"custom_css":" .fa-close:before, .fa-remove:before, .fa-times:before {\\r\\n    content: \\" \\" !important;\\r\\n    background-image: url(http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/x_desktop@2x.png);\\r\\n    position: absolute;\\r\\n     width: 99px;\\r\\n     height: 99px;\\r\\n }\\r\\n \\r\\n @media only screen and (max-width: 1200px){.fa-close:before, .fa-remove:before, .fa-times:before {\\r\\n    content: \\" \\" !important;\\r\\n    background-image: url(http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/x_mobile@2x.png);\\r\\n         background-repeat: no-repeat;\\r\\n    position: absolute;\\r\\n     width: 49px;\\r\\n     height: 49px;\\r\\n       margin-top: -90px !important;\\r\\n    padding-right: 30px !important;\\r\\n }\\r\\n }\\r\\n ","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":22},"button_typography_font_weight":"400","border_radius":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"background_color":"#00d8fc","_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"015","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":3},"elements":[],"widgetType":"popup"},{"id":"4200900","elType":"widget","settings":{"button_options_select":"modal","button_modal_hover_effect":"default","modal_text":"Request a demo","modal_tile":"","modal_shortcode":"[elementor-template id=\\"628\\"]","modal_video":"&lt;iframe width=&quot;560&quot; height=&quot;315&quot; src=&quot;https:\\/\\/www.youtube.com\\/embed\\/GqiST256XPA&quot; frameborder=&quot;0&quot; gesture=&quot;media&quot; allow=&quot;encrypted-media&quot; allowfullscreen&gt;&lt;\\/iframe&gt;","modal_typography_typography":"custom","modal_typography_font_size":{"unit":"px","size":22},"modal_typography_font_weight":"400","modal_button_text_color":"#ffffff","modal_background_color":"#00d8fc","modal_border_border":"solid","modal_border_color":"rgba(0,0,0,0)","modal_button_background_hover_color":"#00d8fc","modal_button_hover_border_color":"rgba(5,109,220,0)","custom_css":".elementor-22 .elementor-element.elementor-element-4200900 .modal-container .click-btn button, .elementor-22 .elementor-element.elementor-element-4200900 .modal-container .click-btn .button-normal, .elementor-22 .elementor-element.elementor-element-4200900 .modal-container .btn-line a {\\r\\n    background-color: #00d8fc;\\r\\n    width: 220px;\\r\\n    height: 50px;\\r\\n    border-radius: 10px;\\r\\n    line-height: 0;\\r\\n    padding: 0px;\\r\\n}\\r\\n\\r\\n","_css_classes":"btn_popup","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[],"widgetType":"widgetkit-for-elementor-button"}],"isInner":false}],"isInner":false},{"id":"0aa5ea4","elType":"section","settings":{"stretch_section":"section-stretched","custom_height":{"unit":"px","size":800},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/banner_desktop@2x.png","id":97},"background_repeat":"no-repeat","background_size":"cover","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"-100","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"185","right":"0","bottom":"353","left":"0","isLinked":false},"background_position":"center center","margin_tablet":{"unit":"px","top":"-150","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"180","right":"0","bottom":"250","left":"0","isLinked":false},"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"71f41c6","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"dfe26b6","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":100,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"e7f5537","elType":"widget","settings":{"title":"We provide a turnkey<br>solution,\\nBlockchain platform<br>for your existing business","title_color":"#ffffff","typography_typography":"custom","typography_font_family":"Montserrat","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3}},"elements":[],"widgetType":"heading"},{"id":"c37c815","elType":"widget","settings":{"editor":"We solve more than <strong>one problem at a time<\\/strong>,<br\\/> Blockchain technology ecosystem which uses <br\\/> high level of <strong>Security and Customized Projects<\\/strong>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.3}},"elements":[],"widgetType":"text-editor"},{"id":"e931fb5","elType":"widget","settings":{"button_options_select":"modal","button_modal_hover_effect":"default","modal_text":"Request a demo","modal_tile":"","modal_shortcode":"[elementor-template id=\\"628\\"]","modal_video":"&lt;iframe width=&quot;560&quot; height=&quot;315&quot; src=&quot;https:\\/\\/www.youtube.com\\/embed\\/GqiST256XPA&quot; frameborder=&quot;0&quot; gesture=&quot;media&quot; allow=&quot;encrypted-media&quot; allowfullscreen&gt;&lt;\\/iframe&gt;","modal_typography_typography":"custom","modal_typography_font_size":{"unit":"px","size":22},"modal_typography_font_weight":"400","modal_button_text_color":"#ffffff","modal_background_color":"#00d8fc","modal_border_border":"solid","modal_border_color":"rgba(0,0,0,0)","modal_button_background_hover_color":"#00d8fc","modal_button_hover_border_color":"rgba(5,109,220,0)","custom_css":".elementor-element.elementor-element-e931fb5 .modal-container .click-btn button, .elementor-22 .elementor-element.elementor-element-e931fb5 .modal-container .click-btn .button-normal, .elementor-22 .elementor-element.elementor-element-e931fb5 .modal-container .btn-line a {\\r\\n    background-color: #00d8fc;\\r\\n    width: 220px;\\r\\n    height: 50px;\\r\\n    border-radius: 10px;\\r\\n    line-height: 0;\\r\\n    padding: 0px;\\r\\n}\\r\\n\\r\\n","_css_classes":"btn_popup"},"elements":[],"widgetType":"widgetkit-for-elementor-button"}],"isInner":false}],"isInner":false},{"id":"4e859f5","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"structure":"20","margin":{"unit":"px","top":"169","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_mobile":"hidden-phone","margin_tablet":{"unit":"px","top":"40","right":0,"bottom":"60","left":0,"isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"8cf2a9f","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"68893a1","elType":"column","settings":{"_column_size":50,"_inline_size":33.732,"background_background":"classic","background_repeat":"no-repeat","background_size":"cover","margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_inline_size_tablet":40,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"b0298b5","elType":"widget","settings":{"title":"Why Agura?","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":35},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"8fd46d5","elType":"widget","settings":{"editor":"<p>Agura provides the infrastructure and systems that businesses and organizations need to operate in the Blockchain economy.<\\/p><p>As a customer of Agura you\\u2019ll enjoy the following services, and more<\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":18},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":16},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"8","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"text-editor"},{"id":"319fe87","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/services@2x.png","id":94},"_margin":{"unit":"px","top":"-331","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-320","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"e972b0b","elType":"column","settings":{"_column_size":50,"_inline_size":66.268,"_inline_size_tablet":60,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"25","right":"0","bottom":"0","left":"154","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"30","isLinked":false}},"elements":[{"id":"28047ac","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serSecurity@2x.png","id":143},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"01 \\u2014<br><span> Security<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_space_mobile":{"unit":"px","size":0},"image_size":{"unit":"%","size":""},"text_align":"left","text_align_mobile":"left","content_vertical_alignment":"middle","title_bottom_space":{"unit":"px","size":10},"title_bottom_space_mobile":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"89a2896","elType":"widget","settings":{"tabs":[{"tab_title":"Agura adheres to the highest level of<br> technical security in the Blockchain & digital <br>currency space","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"edb2d90","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWL@2x.png","id":141},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"02 \\u2014<br><span> White Label Exchange<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_size":{"unit":"%","size":""},"text_align":"left","title_bottom_space":{"unit":"px","size":10},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"3645b8e","elType":"widget","settings":{"tabs":[{"tab_title":"Setup your own exchange","tab_content":"<p>Setup your own exchange with a secured hosting cloud &amp; liquidity<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"0a193f0","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serProj@2x.png","id":142},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"03 \\u2014<br><span>Customized Projects<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_size":{"unit":"%","size":""},"text_align":"left","title_bottom_space":{"unit":"px","size":10},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"d9bd25a","elType":"widget","settings":{"tabs":[{"tab_title":"Every project can be a Customized project","tab_content":"<p>We specialize in customized blockchain solutions and giving you full control over every aspect<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"f9d70d8","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWallet@2x.png","id":144},"thumbnail_size":"custom","thumbnail_custom_dimension":{"width":"60","height":"60"},"title_text":"04 \\u2014<br><span>Wallet<\\/span>","description_text":"","position":"left","image_space":{"unit":"px","size":20},"image_size":{"unit":"%","size":""},"text_align":"left","title_bottom_space":{"unit":"px","size":10},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_weight":"400","description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 24px\\n}"},"elements":[],"widgetType":"image-box"},{"id":"094da20","elType":"widget","settings":{"tabs":[{"tab_title":"Agura\\u2019s wallet supports all known Blockchain technologies","tab_content":"<p>Multi-currency &amp; Currency exchange management including Anonymous Security System<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false}},"elements":[],"widgetType":"toggle"}],"isInner":false}],"isInner":false},{"id":"81a16dd","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"structure":"20","margin":{"unit":"px","top":"169","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"layout":"full_width","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"25","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"edc5952","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"33500ed","elType":"column","settings":{"_column_size":50,"_inline_size":33.732,"background_background":"classic","background_repeat":"no-repeat","background_size":"cover","margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_tablet":40,"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_inline_size_mobile":100,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"f66f8cb","elType":"widget","settings":{"title":"Why Agura?","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":35},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"40","right":"0","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"91e2045","elType":"widget","settings":{"editor":"<p>Agura provides the infrastructure and systems that businesses and organizations need to operate in the Blockchain economy.<\\/p><p>As a customer of Agura you\\u2019ll enjoy the following<br \\/>services, and more<\\/p>","text_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":18},"typography_font_weight":"300","typography_font_size_tablet":{"unit":"px","size":16},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"text-editor"},{"id":"6ecfc5d","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/services_bg@2x-1.png","id":169},"_margin":{"unit":"px","top":"-311","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-280","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"-283","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false},{"id":"7cc766c","elType":"column","settings":{"_column_size":50,"_inline_size":66.268,"_inline_size_tablet":60,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"25","right":"0","bottom":"0","left":"154","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"30","bottom":"0","left":"20","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"20","bottom":"0","left":"30","isLinked":false}},"elements":[{"id":"4aa24f0","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"270b254","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"f81dd3c","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"1eb5f09","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serSecurity@2x.png","id":143},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"1cfa752","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9a0ec1c","elType":"widget","settings":{"title":"01 \\u2014<br><span> Security<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"d503fac","elType":"widget","settings":{"tabs":[{"tab_title":"Agura adheres to the highest level of<br> technical security in the Blockchain & digital <br>currency space","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"20","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"a1e4dd6","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"d15d7a7","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"01253e0","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"cfeaf92","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWL@2x.png","id":141},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"a191552","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"be9ea7a","elType":"widget","settings":{"title":"02 \\u2014<br><span> White Label Exchange<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"4d0f36c","elType":"widget","settings":{"tabs":[{"tab_title":"Setup your own exchange with a secured<br> hosting cloud","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"20","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"fe87ef4","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"25a5cac","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"098eec7","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"077f6bf","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serProj@2x.png","id":142},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"ac26fc9","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"898d823","elType":"widget","settings":{"title":"03 \\u2014<br><span>Customized Projects<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"4c28563","elType":"widget","settings":{"tabs":[{"tab_title":"We specialize in customized blockchain<br> solutions and giving you full control over <br>every aspect","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"20","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"},{"id":"3171009","elType":"section","settings":{"structure":"20","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"3928dfa","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"f338b71","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"20459b3","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/serWallet@2x.png","id":144},"align_mobile":"left","space":{"unit":"%","size":60},"space_mobile":{"unit":"%","size":34}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"81ead4c","elType":"column","settings":{"_column_size":50,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"3a639a4","elType":"widget","settings":{"title":"04 \\u2014<br><span>Wallet<\\/span>","title_color":"#ef3c70","typography_typography":"custom","typography_font_size":{"unit":"px","size":16},"typography_font_weight":"400","typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"-75","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"custom_css":"selector span{\\n    color: #007cbf;\\n    font-size: 19px\\n}"},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true},{"id":"7fe2231","elType":"widget","settings":{"tabs":[{"tab_title":"Multi-currency & Currency exchange<br> management including Anonymous<br> Security System","tab_content":"<p>We\\u2019re focused on giving you:<br \\/>- Secured Blockchain;<br \\/>- Fraud proof (e.g. double draw);<br \\/>- Reset of an Agura Wallet, without<br \\/>losing it value (Exclusive to Agura)<\\/p>","_id":"4baddf5"}],"title_html_tag":"h1","icon":"fa fa-plus-circle","icon_active":"fa fa-minus-circle","border_width":{"unit":"px","size":0},"space_between":{"unit":"px","size":0},"title_color":"#2e3133","tab_active_color":"#2e3133","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":16},"title_typography_font_size_tablet":{"unit":"px","size":16},"title_typography_line_height":{"unit":"em","size":1.7},"title_typography_line_height_tablet":{"unit":"px","size":20},"title_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"icon_align":"right","icon_color":"#707070","icon_active_color":"#707070","icon_space":{"unit":"px","size":0},"content_color":"#2e3133","content_typography_typography":"custom","content_typography_font_size":{"unit":"px","size":18},"content_typography_font_weight":"300","content_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"60","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"40","isLinked":false},"title_typography_font_size_mobile":{"unit":"px","size":16},"title_typography_line_height_mobile":{"unit":"px","size":25},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"20","left":"72","isLinked":false}},"elements":[],"widgetType":"toggle"}],"isInner":false}],"isInner":false},{"id":"56d9f2f","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"78","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"c02debe","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"bd61090","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"d598eab","elType":"widget","settings":{"title":"About our process","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35}},"elements":[],"widgetType":"heading"},{"id":"27181dc","elType":"widget","settings":{"title":"How to create a Blockchain economy with us?\\u200b","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":22},"typography_font_weight":"400","typography_font_size_tablet":{"unit":"px","size":18}},"elements":[],"widgetType":"heading"}],"isInner":false}],"isInner":false},{"id":"f9bf2dc","elType":"section","settings":{"stretch_section":"section-stretched","layout":"full_width","custom_height":{"unit":"px","size":420},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"9eb9ada","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}],"margin":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_tablet":"hidden-tablet","hide_mobile":"hidden-phone"},"elements":[{"id":"8097333","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"471156d","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/1-01.png","id":848},"image_size":"full"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"29c761e","elType":"section","settings":{"stretch_section":"section-stretched","layout":"full_width","custom_height":{"unit":"px","size":420},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"9eb9ada","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}],"margin":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_mobile":"hidden-phone"},"elements":[{"id":"78079d9","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"920fc98","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/1-02.png","id":849},"image_size":"full","width":{"unit":"%","size":10},"width_tablet":{"unit":"%","size":100},"space":{"unit":"%","size":10},"space_tablet":{"unit":"%","size":100}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"e5cbe65","elType":"section","settings":{"stretch_section":"section-stretched","layout":"full_width","custom_height":{"unit":"px","size":420},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"9eb9ada","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}],"margin":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"34","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[{"id":"ca4de73","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9b01c56","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/1-03.png","id":847},"image_size":"full","width":{"unit":"%","size":10},"width_mobile":{"unit":"%","size":100},"space":{"unit":"%","size":10},"space_mobile":{"unit":"%","size":100},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"b2ab9e5","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"87","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"40","right":"0","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"z_index":1,"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"858f032","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"f7980b5","elType":"column","settings":{"_column_size":100,"_inline_size":null,"background_background":"classic","background_position":"bottom center","background_repeat":"no-repeat","background_size":"contain","margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[{"id":"7d8b31a","elType":"widget","settings":{"title":"Global Network\\n","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_mobile":{"unit":"px","size":30},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"415a887","elType":"widget","settings":{"title":"We\\u2019re always growing and increasing our software activity","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":24},"typography_font_size_mobile":{"unit":"px","size":18},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"5831bb1","elType":"section","settings":{"structure":"40","margin":{"unit":"px","top":"73","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"82a0848","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"3c5129a","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"2d40740","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netYears@2x.png","id":223},"title_text":"5","description_text":"years of<br>\\nexperience","image_space":{"unit":"px","size":""},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"59d063a","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a8ca8d5","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netClients@2x.png","id":224},"title_text":"30","description_text":"clients around<br>\\nthe world","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"c82e2f4","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"13a8a61","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netTeam@2x.png","id":226},"title_text":"45","description_text":"team<br>\\nmembers","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"5","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image-box"},{"id":"7a5fac7","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netCont@2x.png","id":225},"title_text":"4505","description_text":"contributors<br>\\nin the community","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"d2e1622","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"47afd4c","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netUpdate@2x.png","id":227},"title_text":"3h","description_text":"since<br>\\nlast update","image_space":{"unit":"px","size":""},"image_size":{"unit":"%","size":20},"image_size_mobile":{"unit":"%","size":30},"text_align":"justify","text_align_mobile":"center","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"40","right":"0","bottom":"0","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image-box"}],"isInner":true}],"isInner":true},{"id":"1d033af","elType":"section","settings":{"structure":"40","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"52","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"73a43c5","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"e910af8","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"558f708","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netUpdate@2x.png","id":227},"title_text":"3h","description_text":"since<br>\\nlast update","image_space":{"unit":"px","size":""},"image_size":{"unit":"%","size":20},"text_align":"justify","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"78e6e0b","elType":"column","settings":{"_column_size":25,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"229b087","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/netCont@2x.png","id":225},"title_text":"4505","description_text":"contributors<br>\\nin the community","image_space":{"unit":"px","size":0},"image_size":{"unit":"%","size":20},"text_align":"justify","title_bottom_space":{"unit":"px","size":0},"title_color":"#e8008f","title_typography_typography":"custom","title_typography_font_size":{"unit":"px","size":48},"description_color":"#2e3133","description_typography_typography":"custom","description_typography_font_size":{"unit":"px","size":18},"description_typography_font_weight":"300","description_typography_line_height":{"unit":"em","size":1.5}},"elements":[],"widgetType":"image-box"}],"isInner":true},{"id":"bb73cc6","elType":"column","settings":{"_column_size":25,"_inline_size":null},"elements":[],"isInner":true},{"id":"9efc6a1","elType":"column","settings":{"_column_size":25,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"6acd650","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"height":"min-height","custom_height":{"unit":"px","size":555},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/network_bg@2x.png","id":98},"background_position":"center center","background_repeat":"no-repeat","background_size":"contain","margin":{"unit":"px","top":"-330","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"348a45b","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"c0a4838","elType":"column","settings":{"_column_size":100},"elements":[],"isInner":false}],"isInner":false},{"id":"65f3cb5e","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"background_background":"classic","background_color":"rgba(0,182,224,0)","margin":{"unit":"px","top":"67","right":0,"bottom":"80","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"b1bcfbd","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"2dc64351","elType":"column","settings":{"_column_size":100,"_inline_size":null,"_inline_size_tablet":100,"_inline_size_mobile":100,"background_background":"classic","background_color":"#00b6e0","margin":{"unit":"px","top":"0","right":"135","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"90","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"27","bottom":"80","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"30","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"423eac42","elType":"widget","settings":{"title":"Our Partners","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"58","right":"20","bottom":"0","left":"20","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"99069ac","elType":"widget","settings":{"title":"Some of the companies we proudly work with","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_size_tablet":{"unit":"px","size":18},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"14","right":"50","bottom":"0","left":"20","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"ba125f7","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"54","right":0,"bottom":"0","left":0,"isLinked":false},"z_index":1,"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"35b45b3","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"3dd27af","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"011bc89","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/nxp.png","id":1008}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"537029e","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"9943bf0","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/dash.png","id":1009}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"8eaadde","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"6572e8d","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/Isologo_Jerus_web.png","id":1010}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"2e8495f","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[],"isInner":true},{"id":"d2349f1","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"ee35f0f","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"30","right":0,"bottom":"30","left":0,"isLinked":false},"z_index":1,"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"dba5db8","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"501acfa","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"bd844b9","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/reliant-color.png","id":1011}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"086c74d","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true},{"id":"64ce81a","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true},{"id":"79e49bb","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true},{"id":"11423d8","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"5d724c6e","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/partners_img@2x.png","id":100},"image_size":"custom","image_custom_dimension":{"width":"398","height":"300"},"align":"right","align_tablet":"right","align_mobile":"center","width_tablet":{"unit":"%","size":40},"width_mobile":{"unit":"%","size":150},"_margin":{"unit":"px","top":"-320","right":"-160","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-230","right":"-90","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":0,"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"cdb30d7","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"background_background":"classic","background_color":"rgba(0,182,224,0)","margin":{"unit":"px","top":"67","right":0,"bottom":"80","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"60","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"60","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"100","left":"0","isLinked":false},"layout":"full_width","hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"38e36e9","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"26e906a","elType":"column","settings":{"_column_size":100,"_inline_size":null,"_inline_size_tablet":100,"_inline_size_mobile":100,"background_background":"classic","background_color":"#00b6e0","margin":{"unit":"px","top":"0","right":"135","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"90","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"80","right":"27","bottom":"80","left":"40","isLinked":false},"padding_tablet":{"unit":"px","top":"30","right":"30","bottom":"30","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"70dc643","elType":"widget","settings":{"title":"Our Partners","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35},"typography_font_weight":"300","_margin_mobile":{"unit":"px","top":"58","right":"20","bottom":"0","left":"30","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"15312a7","elType":"widget","settings":{"title":"Some of the companies we proudly work with","title_color":"#ffffff","typography_typography":"custom","typography_font_size":{"unit":"px","size":21},"typography_font_size_tablet":{"unit":"px","size":18},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"14","right":"50","bottom":"0","left":"30","isLinked":false},"_z_index":1},"elements":[],"widgetType":"heading"},{"id":"30bbef2","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"54","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"30","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"30","bottom":"60","left":"30","isLinked":false},"z_index":1,"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"a43ad79","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"0ece27e","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"3743fd9","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/nxp.png","id":1008}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"ff0b09a","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a330004","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/dash.png","id":1009}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"3dbe584","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"d73be89","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/Isologo_Jerus_web.png","id":1010}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"d791b38","elType":"column","settings":{"_column_size":20,"_inline_size":null,"_inline_size_mobile":50},"elements":[{"id":"a90a5e9","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/reliant-color.png","id":1011},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet"},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"a4a5f19","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"c50605e","elType":"section","settings":{"structure":"50","margin":{"unit":"px","top":"30","right":0,"bottom":"30","left":0,"isLinked":false},"z_index":1,"hide_mobile":"hidden-phone","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"92df713","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"ca68159","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"1a8dca0","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"c12e390","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"4785f3b","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"219f3db","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[{"id":"9d4c977","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/logo-Copy.png","id":253}},"elements":[],"widgetType":"image"}],"isInner":true},{"id":"13cf90d","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true},{"id":"ab439f6","elType":"column","settings":{"_column_size":20,"_inline_size":null},"elements":[],"isInner":true}],"isInner":true},{"id":"4ec0bc4","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/partners_img@2x.png","id":100},"image_size":"custom","image_custom_dimension":{"width":"398","height":"300"},"align":"right","align_tablet":"right","align_mobile":"center","width_tablet":{"unit":"%","size":40},"width_mobile":{"unit":"%","size":150},"_margin":{"unit":"px","top":"-320","right":"-160","bottom":"0","left":"0","isLinked":false},"_margin_tablet":{"unit":"px","top":"-230","right":"-90","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":0,"hide_mobile":"hidden-phone"},"elements":[],"widgetType":"image"}],"isInner":false}],"isInner":false},{"id":"35c6d7b","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"20","right":"0","bottom":"200","left":"0","isLinked":false},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/contact_bg@2x.png","id":281},"background_size":"cover","margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"60","right":"20","bottom":"150","left":"20","isLinked":false},"hide_mobile":"hidden-phone","margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"b5369b3","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"a76a73f","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"30","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"7588d84","elType":"widget","settings":{"title":"Get in Touch","align":"center","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35}},"elements":[],"widgetType":"heading"},{"id":"9c5c8bb","elType":"section","settings":{"structure":"20","margin":{"unit":"px","top":"68","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"c39940b","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"0758e9a","elType":"column","settings":{"_column_size":50,"_inline_size":65.169,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a678dcc","elType":"widget","settings":{"editor":"<p>Boost your business by dropping us a <br \\/>message and we\\u2019ll get back to you shortly<\\/p>","text_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":24},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":18}},"elements":[],"widgetType":"text-editor"}],"isInner":true},{"id":"364b229","elType":"column","settings":{"_column_size":50,"_inline_size":34.831,"_inline_size_mobile":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"588bb93","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"_id":"name","field_type":"text","field_label":"","placeholder":"Name","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"email","field_type":"email","required":"true","field_label":"","placeholder":"Email","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"65216b9","field_type":"tel","required":"true","field_label":"","placeholder":"Phone","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"message","field_type":"textarea","field_label":"","placeholder":"Message","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":1,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""}],"button_text":"Submit","button_size":"xs","button_width":"40","email_to":"asi@agura.tech","email_subject":"New message from \\"AGURA\\"","email_content":"[all-fields]","email_from":"email@www.agurainc.com","email_from_name":"AGURA","email_to_2":"admin@tyco.co.il","email_subject_2":"New message from \\"AGURA\\"","email_content_2":"[all-fields]","email_from_2":"email@www.agurainc.com","email_from_name_2":"AGURA","email_reply_to_2":"admin@tyco.co.il","success_message":"The form was sent successfully.","error_message":"An errors occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","column_gap":{"unit":"px","size":0},"row_gap":{"unit":"px","size":13},"label_spacing":{"unit":"px","size":""},"label_color":"#999999","label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":16},"field_text_color":"#999999","field_typography_typography":"custom","field_typography_font_size":{"unit":"px","size":16},"field_typography_font_weight":"300","field_background_color":"rgba(255,255,255,0)","field_border_color":"#cccccc","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"button_background_color":"#00d8fc","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":16},"button_typography_font_weight":"400","button_typography_text_transform":"none","button_border_radius":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_z_index":3},"elements":[],"widgetType":"form"}],"isInner":true}],"isInner":true},{"id":"1a07c9f","elType":"section","settings":{"structure":"20","content_width":{"unit":"px","size":500},"margin":{"unit":"px","top":"-145","right":0,"bottom":"0","left":0,"isLinked":false},"margin_tablet":{"unit":"px","top":"-160","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"560","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"270","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"dfb2552","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"615bee3","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"a60cf4e","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conPhone@2x.png","id":285},"align":"left","space":{"unit":"%","size":20},"link_to":"custom","link":{"url":"tel:+972.74.7300000","is_external":"","nofollow":""}},"elements":[],"widgetType":"image"},{"id":"51f85a1","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"0cf43b6","elType":"widget","settings":{"title":"<img src=\\"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/07\\/israel.png\\" height=\\"20\\" width=\\"20\\"><b> IL:<\\/b> +972.74.7300000<br>\\next. 1312<br>\\n<img src=\\"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/07\\/united-kingdom-flag-round-xs.png\\" height=\\"20\\" width=\\"20\\"><b> UK:<\\/b> + 44 (870) 4798224<br>\\n<img src=\\"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/07\\/united-states-of-america.png\\" height=\\"20\\" width=\\"20\\"><b> US:<\\/b> +  1 (844) 6211704\\n","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"link":{"url":"tel:+972.74.7300000","is_external":"","nofollow":""}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"3f6d638","elType":"column","settings":{"_column_size":50,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"2b020b3","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conEmail@2x.png","id":287},"align":"left","space":{"unit":"%","size":20},"link_to":"custom","link":{"url":"milto:info@agurainc.com","is_external":"on","nofollow":""}},"elements":[],"widgetType":"image"},{"id":"b0c1f17","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"35e455d","elType":"widget","settings":{"title":"info@agurainc.com","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"link":{"url":"milto:info@agurainc.com","is_external":"on","nofollow":""}},"elements":[],"widgetType":"heading"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false},{"id":"4eef26f","elType":"section","settings":{"stretch_section":"section-stretched","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"62","right":"0","bottom":"226","left":"0","isLinked":false},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/contact_bg@2x.png","id":281},"layout":"full_width","background_position":"center center","background_repeat":"no-repeat","background_size":"cover","margin_tablet":{"unit":"px","top":"60","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"60","right":"20","bottom":"150","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"30","right":"20","bottom":"80","left":"20","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"92e9df7","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"c034d73","elType":"column","settings":{"_column_size":100,"_inline_size":null,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"4e1b554","elType":"widget","settings":{"title":"Get in Touch","align":"center","title_color":"#007cbf","typography_typography":"custom","typography_font_size":{"unit":"px","size":40},"typography_font_size_tablet":{"unit":"px","size":35}},"elements":[],"widgetType":"heading"},{"id":"df5a782","elType":"section","settings":{"layout":"full_width","structure":"20","margin":{"unit":"px","top":"68","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"08fc4ed","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"e3a4225","elType":"column","settings":{"_column_size":50,"_inline_size":65.169,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"20","isLinked":false},"padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"36ae868","elType":"widget","settings":{"editor":"<p>Boost your business by dropping us a <br \\/>message and we\\u2019ll get back to you shortly<\\/p>","text_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":24},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"align_mobile":"center","typography_font_size_tablet":{"unit":"px","size":18}},"elements":[],"widgetType":"text-editor"},{"id":"6d1d675","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conAddress@2x.png","id":286},"align":"left","align_mobile":"center","space":{"unit":"%","size":20},"space_mobile":{"unit":"%","size":15},"link_to":"custom","link":{"url":"https:\\/\\/goo.gl\\/maps\\/BnsDBcQZwES2","is_external":"on","nofollow":""},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"image"},{"id":"9b864f9","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"width_mobile":{"unit":"%","size":25},"align_mobile":"center","gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"f943929","elType":"widget","settings":{"title":"Agura, Inc.\\n1, HaBniya st.\\nHaifa\\nIsrael","align_mobile":"center","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"link":{"url":"https:\\/\\/goo.gl\\/maps\\/BnsDBcQZwES2","is_external":"on","nofollow":""},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"413c88b","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conPhone@2x.png","id":285},"align":"left","align_mobile":"center","space":{"unit":"%","size":20},"space_mobile":{"unit":"%","size":15},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false},"link_to":"custom","link":{"url":"tel:+972.74.7300000","is_external":"","nofollow":""}},"elements":[],"widgetType":"image"},{"id":"dc1fb1a","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"width_mobile":{"unit":"%","size":25},"align_mobile":"center","gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"1eb2f30","elType":"widget","settings":{"title":"+972.74.7300000\\next. 1312","align_mobile":"center","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"link":{"url":"tel:+972.74.7300000","is_external":"","nofollow":""},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"},{"id":"51ec832","elType":"widget","settings":{"image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/conEmail@2x.png","id":287},"align":"left","align_mobile":"center","space":{"unit":"%","size":20},"space_mobile":{"unit":"%","size":15},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"30","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"15","right":"0","bottom":"0","left":"0","isLinked":false},"link_to":"custom","link":{"url":"milto:info@agurainc.com","is_external":"on","nofollow":""}},"elements":[],"widgetType":"image"},{"id":"7dc4fc6","elType":"widget","settings":{"weight":{"unit":"px","size":2},"color":"#007cbf","width":{"unit":"%","size":30},"width_mobile":{"unit":"%","size":25},"align_mobile":"center","gap":{"unit":"px","size":""}},"elements":[],"widgetType":"divider"},{"id":"5cda15a","elType":"widget","settings":{"title":"info@agurainc.com","align_mobile":"center","title_color":"#2e3133","typography_typography":"custom","typography_font_size":{"unit":"px","size":14},"typography_font_weight":"300","typography_line_height":{"unit":"em","size":1.5},"link":{"url":"milto:info@agurainc.com","is_external":"on","nofollow":""},"_margin_mobile":{"unit":"px","top":"30","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"heading"}],"isInner":true},{"id":"ecafe4f","elType":"column","settings":{"_column_size":50,"_inline_size":34.831,"_inline_size_mobile":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_tablet":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"padding_tablet":{"unit":"px","top":"0","right":"20","bottom":"0","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"50","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[{"id":"d81db1c","elType":"widget","settings":{"form_name":"New Form","form_fields":[{"_id":"name","field_type":"text","field_label":"","placeholder":"Name","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"email","field_type":"email","required":"true","field_label":"","placeholder":"Email","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"65216b9","field_type":"tel","required":"true","field_label":"","placeholder":"Phone","width":"","field_value":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":4,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""},{"_id":"message","field_type":"textarea","field_label":"","placeholder":"Message","width":"","field_value":"","required":"","file_sizes":"","file_types":"","allow_multiple_upload":"","max_files":"","acceptance_text":"","checked_by_default":"","field_min":"","field_max":"","min_date":"","max_date":"","use_native_date":"","use_native_time":"","field_options":"","allow_multiple":"","select_size":"","inline_list":"","field_html":"","width_tablet":"","width_mobile":"","rows":1,"recaptcha_size":"normal","recaptcha_style":"light","css_classes":""}],"button_text":"Submit","button_size":"xs","button_width":"40","button_width_mobile":"50","email_to":"info@agurainc.com","email_subject":"New message from \\"AGURA\\"","email_content":"[all-fields]","email_from":"email@www.agurainc.com","email_from_name":"AGURA","email_to_2":"admin@tyco.co.il","email_subject_2":"New message from \\"AGURA\\"","email_content_2":"[all-fields]","email_from_2":"email@www.agurainc.com","email_from_name_2":"AGURA","email_reply_to_2":"admin@tyco.co.il","success_message":"The form was sent successfully.","error_message":"An errors occurred.","required_field_message":"This field is required.","invalid_message":"There\'s something wrong. The form is invalid.","column_gap":{"unit":"px","size":0},"row_gap":{"unit":"px","size":13},"label_spacing":{"unit":"px","size":""},"label_color":"#999999","label_typography_typography":"custom","label_typography_font_size":{"unit":"px","size":16},"field_text_color":"#3f3f3f","field_typography_typography":"custom","field_typography_font_size":{"unit":"px","size":16},"field_typography_font_weight":"300","field_background_color":"rgba(255,255,255,0)","field_border_color":"#a5a5a5","field_border_width":{"unit":"px","top":"0","right":"0","bottom":"1","left":"0","isLinked":false},"button_background_color":"#00d8fc","button_typography_typography":"custom","button_typography_font_size":{"unit":"px","size":16},"button_typography_font_weight":"400","button_typography_text_transform":"none","button_border_radius":{"unit":"px","top":"10","right":"10","bottom":"10","left":"10","isLinked":true},"_margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_margin_mobile":{"unit":"px","top":"0","right":"0","bottom":"30","left":"0","isLinked":false},"_padding":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false},"_padding_mobile":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLinked":false}},"elements":[],"widgetType":"form"}],"isInner":true}],"isInner":true}],"isInner":false}],"isInner":false}]'),
 (5378, 914, '_wp_page_template', 'default'),
 (5379, 914, '_elementor_edit_mode', 'builder'),
 (5380, 914, '_elementor_template_type', 'post'),
 (5381, 914, '_elementor_data', '[{"id":"63b968a","elType":"section","settings":{"stretch_section":"section-stretched","custom_height":{"unit":"px","size":800},"background_background":"classic","background_image":{"url":"http:\\/\\/www.agurainc.com\\/wordpress\\/wp-content\\/uploads\\/2018\\/06\\/banner_mobile@2x.png","id":120},"background_repeat":"no-repeat","background_size":"cover","content_width":{"unit":"px","size":1088},"margin":{"unit":"px","top":"0","right":0,"bottom":"0","left":0,"isLinked":false},"padding":{"unit":"px","top":"185","right":"0","bottom":"353","left":"0","isLinked":false},"background_position":"center center","margin_tablet":{"unit":"px","top":"-150","right":0,"bottom":"0","left":0,"isLinked":false},"margin_mobile":{"unit":"px","top":"-100","right":0,"bottom":"0","left":0,"isLinked":false},"padding_tablet":{"unit":"px","top":"200","right":"0","bottom":"250","left":"0","isLinked":false},"padding_mobile":{"unit":"px","top":"99","right":"0","bottom":"99","left":"0","isLinked":false},"hide_desktop":"hidden-desktop","hide_tablet":"hidden-tablet","jet_parallax_layout_list":[{"jet_parallax_layout_image":{"url":""},"_id":"1699629","jet_parallax_layout_speed":{"unit":"%","size":50},"jet_parallax_layout_type":"scroll","jet_parallax_layout_z_index":"","jet_parallax_layout_bg_x":50,"jet_parallax_layout_bg_y":50,"jet_parallax_layout_bg_size":"auto","jet_parallax_layout_animation_prop":"transform","jet_parallax_layout_on":["desktop","tablet"]}]},"elements":[{"id":"12ab807","elType":"column","settings":{"_column_size":100,"margin":{"unit":"px","top":"0","right":"0","bottom":"0","left":"0","isLi