<?php
// This file was auto-generated from sdk-root/src/data/ssm/2014-11-06/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2014-11-06', 'endpointPrefix' => 'ssm', 'jsonVersion' => '1.1', 'serviceAbbreviation' => 'Amazon SSM', 'serviceFullName' => 'Amazon Simple Systems Management Service', 'signatureVersion' => 'v4', 'targetPrefix' => 'AmazonSSM', 'protocol' => 'json', ], 'operations' => [ 'CancelCommand' => [ 'name' => 'CancelCommand', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CancelCommandRequest', ], 'output' => [ 'shape' => 'CancelCommandResult', ], 'errors' => [ [ 'shape' => 'InvalidCommandId', 'error' => [ 'code' => 'InvalidCommandId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'DuplicateInstanceId', 'error' => [ 'code' => 'DuplicateInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], ], ], 'CreateAssociation' => [ 'name' => 'CreateAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateAssociationRequest', ], 'output' => [ 'shape' => 'CreateAssociationResult', ], 'errors' => [ [ 'shape' => 'AssociationAlreadyExists', 'error' => [ 'code' => 'AssociationAlreadyExists', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'AssociationLimitExceeded', 'error' => [ 'code' => 'AssociationLimitExceeded', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'UnsupportedPlatformType', 'error' => [ 'code' => 'UnsupportedPlatformType', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidParameters', 'error' => [ 'code' => 'InvalidParameters', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'CreateAssociationBatch' => [ 'name' => 'CreateAssociationBatch', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateAssociationBatchRequest', ], 'output' => [ 'shape' => 'CreateAssociationBatchResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidParameters', 'error' => [ 'code' => 'InvalidParameters', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'DuplicateInstanceId', 'error' => [ 'code' => 'DuplicateInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'AssociationLimitExceeded', 'error' => [ 'code' => 'AssociationLimitExceeded', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'UnsupportedPlatformType', 'error' => [ 'code' => 'UnsupportedPlatformType', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'CreateDocument' => [ 'name' => 'CreateDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateDocumentRequest', ], 'output' => [ 'shape' => 'CreateDocumentResult', ], 'errors' => [ [ 'shape' => 'DocumentAlreadyExists', 'error' => [ 'code' => 'DocumentAlreadyExists', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'MaxDocumentSizeExceeded', 'error' => [ 'code' => 'MaxDocumentSizeExceeded', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocumentContent', 'error' => [ 'code' => 'InvalidDocumentContent', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'DocumentLimitExceeded', 'error' => [ 'code' => 'DocumentLimitExceeded', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'DeleteAssociation' => [ 'name' => 'DeleteAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteAssociationRequest', ], 'output' => [ 'shape' => 'DeleteAssociationResult', ], 'errors' => [ [ 'shape' => 'AssociationDoesNotExist', 'error' => [ 'code' => 'AssociationDoesNotExist', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'TooManyUpdates', 'error' => [ 'code' => 'TooManyUpdates', 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], ], ], 'DeleteDocument' => [ 'name' => 'DeleteDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteDocumentRequest', ], 'output' => [ 'shape' => 'DeleteDocumentResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'AssociatedInstances', 'error' => [ 'code' => 'AssociatedInstances', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'DescribeAssociation' => [ 'name' => 'DescribeAssociation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAssociationRequest', ], 'output' => [ 'shape' => 'DescribeAssociationResult', ], 'errors' => [ [ 'shape' => 'AssociationDoesNotExist', 'error' => [ 'code' => 'AssociationDoesNotExist', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], ], ], 'DescribeDocument' => [ 'name' => 'DescribeDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeDocumentRequest', ], 'output' => [ 'shape' => 'DescribeDocumentResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], ], ], 'DescribeInstanceInformation' => [ 'name' => 'DescribeInstanceInformation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeInstanceInformationRequest', ], 'output' => [ 'shape' => 'DescribeInstanceInformationResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidNextToken', 'error' => [ 'code' => 'InvalidNextToken', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceInformationFilterValue', 'error' => [ 'code' => 'InvalidInstanceInformationFilterValue', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidFilterKey', 'error' => [ 'code' => 'InvalidFilterKey', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'GetDocument' => [ 'name' => 'GetDocument', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetDocumentRequest', ], 'output' => [ 'shape' => 'GetDocumentResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], ], ], 'ListAssociations' => [ 'name' => 'ListAssociations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListAssociationsRequest', ], 'output' => [ 'shape' => 'ListAssociationsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidNextToken', 'error' => [ 'code' => 'InvalidNextToken', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'ListCommandInvocations' => [ 'name' => 'ListCommandInvocations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCommandInvocationsRequest', ], 'output' => [ 'shape' => 'ListCommandInvocationsResult', ], 'errors' => [ [ 'shape' => 'InvalidCommandId', 'error' => [ 'code' => 'InvalidCommandId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidFilterKey', 'error' => [ 'code' => 'InvalidFilterKey', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidNextToken', 'error' => [ 'code' => 'InvalidNextToken', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'ListCommands' => [ 'name' => 'ListCommands', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCommandsRequest', ], 'output' => [ 'shape' => 'ListCommandsResult', ], 'errors' => [ [ 'shape' => 'InvalidCommandId', 'error' => [ 'code' => 'InvalidCommandId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidFilterKey', 'error' => [ 'code' => 'InvalidFilterKey', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidNextToken', 'error' => [ 'code' => 'InvalidNextToken', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'ListDocuments' => [ 'name' => 'ListDocuments', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListDocumentsRequest', ], 'output' => [ 'shape' => 'ListDocumentsResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidNextToken', 'error' => [ 'code' => 'InvalidNextToken', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidFilterKey', 'error' => [ 'code' => 'InvalidFilterKey', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'SendCommand' => [ 'name' => 'SendCommand', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'SendCommandRequest', ], 'output' => [ 'shape' => 'SendCommandResult', ], 'errors' => [ [ 'shape' => 'DuplicateInstanceId', 'error' => [ 'code' => 'DuplicateInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidOutputFolder', 'error' => [ 'code' => 'InvalidOutputFolder', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidParameters', 'error' => [ 'code' => 'InvalidParameters', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'UnsupportedPlatformType', 'error' => [ 'code' => 'UnsupportedPlatformType', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], ], ], 'UpdateAssociationStatus' => [ 'name' => 'UpdateAssociationStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateAssociationStatusRequest', ], 'output' => [ 'shape' => 'UpdateAssociationStatusResult', ], 'errors' => [ [ 'shape' => 'InternalServerError', 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], [ 'shape' => 'InvalidInstanceId', 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'InvalidDocument', 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'AssociationDoesNotExist', 'error' => [ 'code' => 'AssociationDoesNotExist', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'StatusUnchanged', 'error' => [ 'code' => 'StatusUnchanged', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], [ 'shape' => 'TooManyUpdates', 'error' => [ 'code' => 'TooManyUpdates', 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], ], ], ], 'shapes' => [ 'AssociatedInstances' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'AssociatedInstances', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'Association' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], ], ], 'AssociationAlreadyExists' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'AssociationAlreadyExists', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'AssociationDescription' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Date' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'AssociationStatus', ], 'Parameters' => [ 'shape' => 'Parameters', ], ], ], 'AssociationDescriptionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssociationDescription', 'locationName' => 'AssociationDescription', ], ], 'AssociationDoesNotExist' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'AssociationDoesNotExist', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'AssociationFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'AssociationFilterKey', ], 'value' => [ 'shape' => 'AssociationFilterValue', ], ], ], 'AssociationFilterKey' => [ 'type' => 'string', 'enum' => [ 'InstanceId', 'Name', ], ], 'AssociationFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AssociationFilter', 'locationName' => 'AssociationFilter', ], 'min' => 1, ], 'AssociationFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'AssociationLimitExceeded' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'AssociationLimitExceeded', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'AssociationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Association', 'locationName' => 'Association', ], ], 'AssociationStatus' => [ 'type' => 'structure', 'required' => [ 'Date', 'Name', 'Message', ], 'members' => [ 'Date' => [ 'shape' => 'DateTime', ], 'Name' => [ 'shape' => 'AssociationStatusName', ], 'Message' => [ 'shape' => 'StatusMessage', ], 'AdditionalInfo' => [ 'shape' => 'StatusAdditionalInfo', ], ], ], 'AssociationStatusName' => [ 'type' => 'string', 'enum' => [ 'Pending', 'Success', 'Failed', ], ], 'BatchErrorMessage' => [ 'type' => 'string', ], 'Boolean' => [ 'type' => 'boolean', ], 'CancelCommandRequest' => [ 'type' => 'structure', 'required' => [ 'CommandId', ], 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceIds' => [ 'shape' => 'InstanceIdList', ], ], ], 'CancelCommandResult' => [ 'type' => 'structure', 'members' => [], ], 'Command' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'Comment' => [ 'shape' => 'Comment', ], 'ExpiresAfter' => [ 'shape' => 'DateTime', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'InstanceIds' => [ 'shape' => 'InstanceIdList', ], 'RequestedDateTime' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'CommandStatus', ], 'OutputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'OutputS3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], ], ], 'CommandFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'CommandFilterKey', ], 'value' => [ 'shape' => 'CommandFilterValue', ], ], ], 'CommandFilterKey' => [ 'type' => 'string', 'enum' => [ 'InvokedAfter', 'InvokedBefore', 'Status', ], ], 'CommandFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandFilter', ], 'min' => 1, 'max' => 3, ], 'CommandFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'CommandId' => [ 'type' => 'string', 'min' => 36, 'max' => 36, ], 'CommandInvocation' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Comment' => [ 'shape' => 'Comment', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'RequestedDateTime' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'CommandInvocationStatus', ], 'TraceOutput' => [ 'shape' => 'InvocationTraceOutput', ], 'CommandPlugins' => [ 'shape' => 'CommandPluginList', ], ], ], 'CommandInvocationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandInvocation', ], ], 'CommandInvocationStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InProgress', 'Cancelling', 'Success', 'TimedOut', 'Cancelled', 'Failed', ], ], 'CommandList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Command', ], ], 'CommandMaxResults' => [ 'type' => 'integer', 'min' => 1, 'max' => 50, ], 'CommandPlugin' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'CommandPluginName', ], 'Status' => [ 'shape' => 'CommandPluginStatus', ], 'ResponseCode' => [ 'shape' => 'ResponseCode', ], 'ResponseStartDateTime' => [ 'shape' => 'DateTime', ], 'ResponseFinishDateTime' => [ 'shape' => 'DateTime', ], 'Output' => [ 'shape' => 'CommandPluginOutput', ], 'OutputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'OutputS3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], ], ], 'CommandPluginList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandPlugin', ], ], 'CommandPluginName' => [ 'type' => 'string', 'min' => 4, ], 'CommandPluginOutput' => [ 'type' => 'string', 'max' => 2500, ], 'CommandPluginStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InProgress', 'Success', 'TimedOut', 'Cancelled', 'Failed', ], ], 'CommandStatus' => [ 'type' => 'string', 'enum' => [ 'Pending', 'InProgress', 'Cancelling', 'Success', 'TimedOut', 'Cancelled', 'Failed', ], ], 'Comment' => [ 'type' => 'string', 'max' => 100, ], 'CreateAssociationBatchRequest' => [ 'type' => 'structure', 'required' => [ 'Entries', ], 'members' => [ 'Entries' => [ 'shape' => 'CreateAssociationBatchRequestEntries', ], ], ], 'CreateAssociationBatchRequestEntries' => [ 'type' => 'list', 'member' => [ 'shape' => 'CreateAssociationBatchRequestEntry', 'locationName' => 'entries', ], ], 'CreateAssociationBatchRequestEntry' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Parameters' => [ 'shape' => 'Parameters', ], ], ], 'CreateAssociationBatchResult' => [ 'type' => 'structure', 'members' => [ 'Successful' => [ 'shape' => 'AssociationDescriptionList', ], 'Failed' => [ 'shape' => 'FailedCreateAssociationList', ], ], ], 'CreateAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'InstanceId', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'Parameters' => [ 'shape' => 'Parameters', ], ], ], 'CreateAssociationResult' => [ 'type' => 'structure', 'members' => [ 'AssociationDescription' => [ 'shape' => 'AssociationDescription', ], ], ], 'CreateDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Content', 'Name', ], 'members' => [ 'Content' => [ 'shape' => 'DocumentContent', ], 'Name' => [ 'shape' => 'DocumentName', ], ], ], 'CreateDocumentResult' => [ 'type' => 'structure', 'members' => [ 'DocumentDescription' => [ 'shape' => 'DocumentDescription', ], ], ], 'DateTime' => [ 'type' => 'timestamp', ], 'DeleteAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'InstanceId', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], ], ], 'DeleteAssociationResult' => [ 'type' => 'structure', 'members' => [], ], 'DeleteDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], ], ], 'DeleteDocumentResult' => [ 'type' => 'structure', 'members' => [], ], 'DescribeAssociationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'InstanceId', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], ], ], 'DescribeAssociationResult' => [ 'type' => 'structure', 'members' => [ 'AssociationDescription' => [ 'shape' => 'AssociationDescription', ], ], ], 'DescribeDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], ], ], 'DescribeDocumentResult' => [ 'type' => 'structure', 'members' => [ 'Document' => [ 'shape' => 'DocumentDescription', ], ], ], 'DescribeInstanceInformationRequest' => [ 'type' => 'structure', 'members' => [ 'InstanceInformationFilterList' => [ 'shape' => 'InstanceInformationFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResultsEC2Compatible', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeInstanceInformationResult' => [ 'type' => 'structure', 'members' => [ 'InstanceInformationList' => [ 'shape' => 'InstanceInformationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescriptionInDocument' => [ 'type' => 'string', ], 'DocumentAlreadyExists' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'DocumentAlreadyExists', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'DocumentContent' => [ 'type' => 'string', 'min' => 1, ], 'DocumentDescription' => [ 'type' => 'structure', 'members' => [ 'Sha1' => [ 'shape' => 'DocumentSha1', ], 'Name' => [ 'shape' => 'DocumentName', ], 'CreatedDate' => [ 'shape' => 'DateTime', ], 'Status' => [ 'shape' => 'DocumentStatus', ], 'Description' => [ 'shape' => 'DescriptionInDocument', ], 'Parameters' => [ 'shape' => 'DocumentParameterList', ], 'PlatformTypes' => [ 'shape' => 'PlatformTypeList', ], ], ], 'DocumentFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'DocumentFilterKey', ], 'value' => [ 'shape' => 'DocumentFilterValue', ], ], ], 'DocumentFilterKey' => [ 'type' => 'string', 'enum' => [ 'Name', 'Owner', 'PlatformTypes', ], ], 'DocumentFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentFilter', 'locationName' => 'DocumentFilter', ], 'min' => 1, ], 'DocumentFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'DocumentIdentifier' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'PlatformTypes' => [ 'shape' => 'PlatformTypeList', ], ], ], 'DocumentIdentifierList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentIdentifier', 'locationName' => 'DocumentIdentifier', ], ], 'DocumentLimitExceeded' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'DocumentLimitExceeded', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'DocumentName' => [ 'type' => 'string', 'pattern' => '^[a-zA-Z0-9_\\-.]{3,128}$', ], 'DocumentParameter' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentParameterName', ], 'Type' => [ 'shape' => 'DocumentParameterType', ], 'Description' => [ 'shape' => 'DocumentParameterDescrption', ], 'DefaultValue' => [ 'shape' => 'DocumentParameterDefaultValue', ], ], ], 'DocumentParameterDefaultValue' => [ 'type' => 'string', ], 'DocumentParameterDescrption' => [ 'type' => 'string', ], 'DocumentParameterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DocumentParameter', 'locationName' => 'DocumentParameter', ], ], 'DocumentParameterName' => [ 'type' => 'string', ], 'DocumentParameterType' => [ 'type' => 'string', 'enum' => [ 'String', 'StringList', ], ], 'DocumentSha1' => [ 'type' => 'string', ], 'DocumentStatus' => [ 'type' => 'string', 'enum' => [ 'Creating', 'Active', 'Deleting', ], ], 'DuplicateInstanceId' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'DuplicateInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'FailedCreateAssociation' => [ 'type' => 'structure', 'members' => [ 'Entry' => [ 'shape' => 'CreateAssociationBatchRequestEntry', ], 'Message' => [ 'shape' => 'BatchErrorMessage', ], 'Fault' => [ 'shape' => 'Fault', ], ], ], 'FailedCreateAssociationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FailedCreateAssociation', 'locationName' => 'FailedCreateAssociationEntry', ], ], 'Fault' => [ 'type' => 'string', 'enum' => [ 'Client', 'Server', 'Unknown', ], ], 'GetDocumentRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], ], ], 'GetDocumentResult' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'Content' => [ 'shape' => 'DocumentContent', ], ], ], 'InstanceId' => [ 'type' => 'string', 'min' => 10, 'max' => 10, 'pattern' => '^(?=.{10}$](i-(\\w]{8}]', ], 'InstanceIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceId', ], 'min' => 1, 'max' => 50, ], 'InstanceInformation' => [ 'type' => 'structure', 'members' => [ 'InstanceId' => [ 'shape' => 'InstanceId', ], 'PingStatus' => [ 'shape' => 'PingStatus', ], 'LastPingDateTime' => [ 'shape' => 'DateTime', 'box' => true, ], 'AgentVersion' => [ 'shape' => 'Version', ], 'IsLatestVersion' => [ 'shape' => 'Boolean', 'box' => true, ], 'PlatformType' => [ 'shape' => 'PlatformType', ], 'PlatformName' => [ 'shape' => 'String', ], 'PlatformVersion' => [ 'shape' => 'String', ], ], ], 'InstanceInformationFilter' => [ 'type' => 'structure', 'required' => [ 'key', 'valueSet', ], 'members' => [ 'key' => [ 'shape' => 'InstanceInformationFilterKey', ], 'valueSet' => [ 'shape' => 'InstanceInformationFilterValueSet', ], ], ], 'InstanceInformationFilterKey' => [ 'type' => 'string', 'enum' => [ 'InstanceIds', 'AgentVersion', 'PingStatus', 'PlatformTypes', ], ], 'InstanceInformationFilterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceInformationFilter', 'locationName' => 'InstanceInformationFilter', ], 'min' => 1, ], 'InstanceInformationFilterValue' => [ 'type' => 'string', 'min' => 1, ], 'InstanceInformationFilterValueSet' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceInformationFilterValue', 'locationName' => 'InstanceInformationFilterValue', ], 'min' => 1, 'max' => 100, ], 'InstanceInformationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceInformation', 'locationName' => 'InstanceInformation', ], ], 'InternalServerError' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'code' => 'InternalServerError', 'httpStatusCode' => 500, ], 'exception' => true, ], 'InvalidCommandId' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidCommandId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'InvalidDocument' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'code' => 'InvalidDocument', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'InvalidDocumentContent' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'code' => 'InvalidDocumentContent', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidFilterKey' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidFilterKey', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidInstanceId' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidInstanceId', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'InvalidInstanceInformationFilterValue' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'code' => 'InvalidInstanceInformationFilterValue', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidNextToken' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidNextToken', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidOutputFolder' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidOutputFolder', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidParameters' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'code' => 'InvalidParameters', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvocationTraceOutput' => [ 'type' => 'string', 'max' => 2500, ], 'ListAssociationsRequest' => [ 'type' => 'structure', 'required' => [ 'AssociationFilterList', ], 'members' => [ 'AssociationFilterList' => [ 'shape' => 'AssociationFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListAssociationsResult' => [ 'type' => 'structure', 'members' => [ 'Associations' => [ 'shape' => 'AssociationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCommandInvocationsRequest' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'MaxResults' => [ 'shape' => 'CommandMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], 'Filters' => [ 'shape' => 'CommandFilterList', ], 'Details' => [ 'shape' => 'Boolean', ], ], ], 'ListCommandInvocationsResult' => [ 'type' => 'structure', 'members' => [ 'CommandInvocations' => [ 'shape' => 'CommandInvocationList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListCommandsRequest' => [ 'type' => 'structure', 'members' => [ 'CommandId' => [ 'shape' => 'CommandId', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'MaxResults' => [ 'shape' => 'CommandMaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], 'Filters' => [ 'shape' => 'CommandFilterList', ], ], ], 'ListCommandsResult' => [ 'type' => 'structure', 'members' => [ 'Commands' => [ 'shape' => 'CommandList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDocumentsRequest' => [ 'type' => 'structure', 'members' => [ 'DocumentFilterList' => [ 'shape' => 'DocumentFilterList', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'box' => true, ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDocumentsResult' => [ 'type' => 'structure', 'members' => [ 'DocumentIdentifiers' => [ 'shape' => 'DocumentIdentifierList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'MaxDocumentSizeExceeded' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'MaxDocumentSizeExceeded', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'MaxResults' => [ 'type' => 'integer', 'min' => 1, 'max' => 25, ], 'MaxResultsEC2Compatible' => [ 'type' => 'integer', 'min' => 5, 'max' => 50, ], 'NextToken' => [ 'type' => 'string', ], 'ParameterName' => [ 'type' => 'string', ], 'ParameterValue' => [ 'type' => 'string', ], 'ParameterValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParameterValue', ], ], 'Parameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'ParameterName', ], 'value' => [ 'shape' => 'ParameterValueList', ], ], 'PingStatus' => [ 'type' => 'string', 'enum' => [ 'Online', 'ConnectionLost', 'Inactive', ], ], 'PlatformType' => [ 'type' => 'string', 'enum' => [ 'Windows', 'Linux', ], ], 'PlatformTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PlatformType', 'locationName' => 'PlatformType', ], ], 'ResponseCode' => [ 'type' => 'integer', ], 'S3BucketName' => [ 'type' => 'string', 'min' => 3, 'max' => 63, ], 'S3KeyPrefix' => [ 'type' => 'string', 'max' => 500, ], 'SendCommandRequest' => [ 'type' => 'structure', 'required' => [ 'InstanceIds', 'DocumentName', ], 'members' => [ 'InstanceIds' => [ 'shape' => 'InstanceIdList', ], 'DocumentName' => [ 'shape' => 'DocumentName', ], 'TimeoutSeconds' => [ 'shape' => 'TimeoutSeconds', 'box' => true, ], 'Comment' => [ 'shape' => 'Comment', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'OutputS3BucketName' => [ 'shape' => 'S3BucketName', ], 'OutputS3KeyPrefix' => [ 'shape' => 'S3KeyPrefix', ], ], ], 'SendCommandResult' => [ 'type' => 'structure', 'members' => [ 'Command' => [ 'shape' => 'Command', ], ], ], 'StatusAdditionalInfo' => [ 'type' => 'string', 'max' => 1024, ], 'StatusMessage' => [ 'type' => 'string', 'max' => 1024, ], 'StatusUnchanged' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'StatusUnchanged', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'String' => [ 'type' => 'string', ], 'TimeoutSeconds' => [ 'type' => 'integer', 'min' => 30, 'max' => 2592000, ], 'TooManyUpdates' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'TooManyUpdates', 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'UnsupportedPlatformType' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'error' => [ 'code' => 'UnsupportedPlatformType', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'UpdateAssociationStatusRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'InstanceId', 'AssociationStatus', ], 'members' => [ 'Name' => [ 'shape' => 'DocumentName', ], 'InstanceId' => [ 'shape' => 'InstanceId', ], 'AssociationStatus' => [ 'shape' => 'AssociationStatus', ], ], ], 'UpdateAssociationStatusResult' => [ 'type' => 'structure', 'members' => [ 'AssociationDescription' => [ 'shape' => 'AssociationDescription', ], ], ], 'Version' => [ 'type' => 'string', 'pattern' => '^[0-9]{1,6}(\\.[0-9]{1,6}]{2,3}$', ], ],];
