<?php

/**
 * LICENSE: The MIT License (the "License")
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * https://github.com/azure/azure-storage-php/LICENSE
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * PHP version 5
 *
 * @category  Microsoft
 * @package   MicrosoftAzure\Storage\Tests\Unit\Blob\Models
 * @author    Azure Storage PHP SDK <dmsh@microsoft.com>
 * @copyright 2016 Microsoft Corporation
 * @license   https://github.com/azure/azure-storage-php/LICENSE
 * @link      https://github.com/azure/azure-storage-php
 */

namespace MicrosoftAzure\Storage\Tests\Unit\Blob\Models;

use MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult;
use MicrosoftAzure\Storage\Common\Internal\Utilities;
use MicrosoftAzure\Storage\Tests\Framework\TestResources;

/**
 * Unit tests for class GetContainerPropertiesResult
 *
 * @category  Microsoft
 * @package   MicrosoftAzure\Storage\Tests\Unit\Blob\Models
 * @author    Azure Storage PHP SDK <dmsh@microsoft.com>
 * @copyright 2016 Microsoft Corporation
 * @license   https://github.com/azure/azure-storage-php/LICENSE
 * @link      https://github.com/azure/azure-storage-php
 */
class GetContainerPropertiesResultTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @covers MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult::create
     * @covers MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult::setLastModified
     * @covers MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult::getLastModified
     * @covers MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult::setETag
     * @covers MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult::getETag
     * @covers MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult::setMetadata
     * @covers MicrosoftAzure\Storage\Blob\Models\GetContainerPropertiesResult::getMetadata
     */
    public function testCreate()
    {
        // Setup
        $sample = TestResources::listBlobsOneEntry();
        $expectedProperties = $sample['Blobs']['Blob']['Properties'];
        $expectedDate = Utilities::rfc1123ToDateTime($expectedProperties['Last-Modified']);
        $expectedProperties['x-ms-meta-'] = $sample['Blobs']['Blob']['Metadata'];
        
        // Test
        $result = GetContainerPropertiesResult::create($expectedProperties);
        
        // Assert
        $this->assertEquals(array('' => $expectedProperties['x-ms-meta-']), $result->getMetadata());
        $this->assertEquals($expectedDate, $result->getLastModified());
        $this->assertEquals($expectedProperties['Etag'], $result->getETag());
    }
}
