<?php

namespace FEP\Settings;

use Elementor\Core\Settings\Base\Model as BaseModel;
use Elementor\Controls_Manager;
use Elementor\Settings;
use Elementor\Scheme_Color;

class Model extends BaseModel
{
    public function get_name()
    {
        // TODO: Implement get_name() method.
    }

    public function get_css_wrapper_selector()
    {
        // TODO: Implement get_css_wrapper_selector() method.
    }

    public function get_panel_page_settings()
    {
        // TODO: Implement get_panel_page_settings() method.

        return [
            'title' => __( 'FEP Settings', 'elementor-fep' ),
            'menu' => [
                'icon' => 'fa fa-arrows-alt cws-logo-icon-settings',
                'beforeItem' => 'elementor-settings',
            ],
        ];
    }

    public static function get_controls_list() {

        return [

            Controls_Manager::TAB_SETTINGS => [
                'settings'  => [
                    'label'     => __('Settings', 'fep'),
                    'controls'  => [
//                        'enable_fep'  => [
//                            'label' => __('Enable Flexible Panel'),
//                            'type'  => Controls_Manager::CHOOSE,
//                            'options' => [
//                                'yes' => [
//                                    'title' => __( 'Yes', 'ae-pro' ),
//                                    'icon' => 'fa fa-check',
//                                ],
//                                'no' => [
//                                    'title' => __( 'No', 'ae-pro' ),
//                                    'icon' => 'fa fa-ban',
//                                ]
//                            ],
//                            'label_on' => __( 'Show', 'ae-pro' ),
//                            'label_off' => __( 'Hide', 'ae-pro' )
//                        ],
                        'editor_skin' =>
                        [
                            'label' => __('Editor Skins', 'fep'),
                            'type'  => Controls_Manager::SELECT,
                            'options'   => [
                                'dark'    =>     __('Dark', 'fep'),
                                'light'   =>     __('Light', 'fep')
                            ]
                        ],
                        'dashboard_link_heading' =>
                        [
                            'label' => __('Exit To Dashboard Link', 'fep'),
                            'type'  => Controls_Manager::HEADING
                        ],
                        'dashboard_link_point' =>
	                        [
		                        'label' => __('Exit point', 'fep'),
		                        'type'  => Controls_Manager::SELECT,
		                        'options'   => [
			                        'page_edit'         =>      __('Page edit', 'fep'),
			                        'page_list'         =>      __('Page list', 'fep'),
			                        'admin_dashboard'   =>      __('Admin dashboard', 'fep')
		                        ]
	                        ],
                        'dashboard_link_new_tab' =>
                        [
                            'label' => __('Open in new tab', 'fep'),
                            'type'  => Controls_Manager::SWITCHER,
                            'label_on' => __('On', 'ae-pro'),
                            'label_off' => __('Off', 'ae-pro'),
                            'return_value' => 'yes',
                        ],
                        'accordion_heading' =>
	                    [
		                        'label' => __('Accordion options', 'fep'),
		                        'type'  => Controls_Manager::HEADING
	                    ],
                        'accordion_options' =>
	                    [
		                        'label' => __('First tab closed', 'fep'),
		                        'type'  => Controls_Manager::SWITCHER,
		                        'label_on' => __('On', 'ae-pro'),
		                        'label_off' => __('Off', 'ae-pro'),
		                        'return_value' => 'yes',
	                    ]
                    ]
                ]
            ]
        ];

    }

    protected function _register_controls() {

        $controls_list = self::get_controls_list();

        foreach ( $controls_list as $tab_name => $sections ) {

            foreach ( $sections as $section_name => $section_data ) {

                $this->start_controls_section(
                    $section_name, [
                        'label' => $section_data['label'],
                        'tab' => $tab_name,
                    ]
                );

                foreach ( $section_data['controls'] as $control_name => $control_data ) {
                    $this->add_control( $control_name, $control_data );
                }

                $this->end_controls_section();
            }
        }
    }
}

Controls_Manager::add_tab( 'settings', __( 'Settings', 'elementor-extras' ) );

